/*!!
 * Matomo - free/libre analytics platform
 *
 * Matomo Tag Manager
 *
 * @link https://matomo.org
 * @source https://github.com/matomo-org/tag-manager/blob/master/js/piwik.js
 * @license https://matomo.org/free-software/bsd/ BSD-3 Clause (also in js/LICENSE.txt)
 */
(function(){var b=document;var a=window;
var ignoreGtmDataLayer = false; var activelySyncGtmDataLayer = false;
;
function htmlToElement(content)
{
    var div = document.createElement('div');
    div.innerHTML = content;
    return div.firstChild;
}

function createDebugFrame()
{
    var iframeClass = stickToTop() ? 'mtmStickyTop' : 'mtmStickyBottom';
    return htmlToElement('<iframe class="'+ iframeClass +'" id="mtmDebugFrame" src="about:blank" frameborder="0" style="cursor: row-resize !important; background-color:#edecec !important; clip: initial !important; display: inline !important; height: ' + getHeight() + '; opacity: 1 !important; visibility:visible !important; padding:0 !important; margin:0 !important; position:fixed !important; left:0 !important; width:100% !important; z-index:999999999 !important;"></iframe>');
}

function hasCookie(cookie) {
    return document.cookie.indexOf(cookie) > -1;
}

function stickToTop() {
    return hasCookie( 'mtmPreviewPosition=top' );
}

function getSize() {
    if (hasCookie('mtmPreviewHeight')) {
        var values = /mtmPreviewHeight=([\d.]+)/.exec(document.cookie);
        if (values !== null && values.length === 2) {
            return parseFloat( values[1] );
        }
    }

    return 0.33;
}

function getHeight() {
    return getSize() * 100 + '% !important';
}

function setHeight( size ) {
    var date = new Date();
    var sevenDays = 7 * 60 * 60 * 24 * 1000;
    date.setTime(date.getTime() + sevenDays); // 7 days

    document.cookie = 'mtmPreviewHeight=' + size + '; expires=' + date.toUTCString() + '; path=/';
}

function makeResizable(previewFrame) {
    function mouseDownListener(e) {
        e.preventDefault();
        if(e.pointerId !== undefined) {
          previewFrame.setPointerCapture(e.pointerId);
        } else if(typeof previewFrame.setCapture === 'function') {
          previewFrame.setCapture(true);
        }

        var pointerEvents = previewFrame.style.pointerEvents;
        var invert = !stickToTop();
        var ratio;

        previewFrame.style.pointerEvents = 'none';

        function moveListener(e) {
            var y = e.clientY;
            ratio = Math.max(.1, Math.min(.9, (y / window.innerHeight).toFixed(2)));
            if (invert) {
              ratio = (1 - ratio);
            }

            previewFrame.style.height = ratio * 100 + '%';
        }

        var pointerCaptureSupported = typeof previewFrame.setPointerCapture === 'function';
        var eventPrefix = pointerCaptureSupported ? 'pointer' : 'mouse';
        var moveEventName = `${eventPrefix}move`;
        var upEventName = `${eventPrefix}up`;

        function mouseUpListener() {
            setHeight(ratio);
            previewFrame.style.pointerEvents = pointerEvents;
            var htmlElement = document.querySelector('html');
            htmlElement.removeEventListener(moveEventName, moveListener, {passive: true});
            htmlElement.removeEventListener(upEventName, mouseUpListener, {passive: true});
        }

        var htmlElement = document.querySelector('html');
        htmlElement.addEventListener(moveEventName, moveListener, {passive: true});
        htmlElement.addEventListener(upEventName, mouseUpListener, {passive: true});
        return false;
    }

    previewFrame.addEventListener('mousedown', mouseDownListener);
}

function renderPreviewFrame(theContent)
{
    if (window.mtmPreviewWindow) {
        return;
    }

    if (!document.body) {
        document.addEventListener('DOMContentLoaded', function () {
          renderPreviewFrame(theContent);
        });
        return;
    }

    var previewFrame = document.getElementById('mtmDebugFrame');

    if (!previewFrame) {
        // might already exist when embedding multiple containers
        previewFrame = createDebugFrame();
        var sheet = document.createElement('style');
        sheet.innerHTML = ".mtmStickyBottom { bottom: 0 !important;  border:0 !important; border-top: 6px solid #f3f3f3 !important; } .mtmStickyTop { top: 0 !important; border:0 !important; border-bottom: 6px solid #f3f3f3 !important; }";
        document.body.prepend(sheet);
        document.body.prepend(previewFrame);

        var theDoc = previewFrame.contentDocument || previewFrame.contentWindow.document;

        theDoc.open('text/html', 'replace');
        theDoc.write(theContent);
        theDoc.close();

        makeResizable(previewFrame);
    }

  if (previewFrame && previewFrame.contentWindow) {
      window.mtmPreviewWindow = previewFrame.contentWindow;
  }
}

renderPreviewFrame("<!DOCTYPE html>\n<html id=\"ng-app\" ng-app=\"piwikApp\">\n<head>\n    <title>Debug Matomo Tag Manager<\/title>\n    <base href=\"https&#x3A;&#x2F;&#x2F;analytics.sistematlan.com&#x2F;\" >\n    <meta charset=\"utf-8\">\n    <meta http-equiv=\"X-UA-Compatible\" content=\"IE=EDGE,chrome=1\"\/>\n    <meta name=\"viewport\" content=\"initial-scale=1.0\"\/>\n    <meta name=\"robots\" content=\"noindex,nofollow\">\n    <style>\n        .nav-wrapper .brand-logo {\n            position: relative;\n            pointer-events: none;\n        }\n        .home h2, .home h3 {\n            margin-top: 0;\n        }\n\n        .tm-icon {\n            display: inline-block;\n            color: #444444;\n            width: 1em;\n            height: 1em;\n            fill: currentColor;\n        }\n\n        .tm-icon-checkmark {\n            color: green;\n            position: relative;\n            top: 2px;\n        }\n\n        #mtmCloseDebug {\n            padding-right: 2rem;\n        }\n\n        .tm-icon-close {\n            color: white;\n            font-size: 0.8rem;\n        }\n\n        .lbl-onlyfiredTags {\n            color: black;\n        }\n\n        .onlyFiredTags-chk {\n            position: relative !important;\n            opacity: 1 !important;\n            pointer-events: all !important;\n            top: 2px;\n        }\n        .brand-logo {\n            padding-top: unset !important;\n            top: 0.8rem;\n            width: 14rem;\n        }\n    <\/style>\n    <script>\n        var piwik_translations = {};\n    <\/script>\n    <script type=\"text\/javascript\">\n        window.piwik = window.piwik || {};\n        window.piwik.isPagesComparisonApiDisabled = true; \/\/ Disable API.getPagesComparisonsDisabledFor call\n        window.mtmDbgData = {\n            mtmEvents: [],\n            mtmLogs: []\n        };\n        window.mtmEvents = {\n            push: function (event) {\n                var events = window.mtmDbgData.mtmEvents;\n                if (event) {\n                    event.index0 = events.length;\n                    event.index = events.length + 1;\n                }\n                events.push(event);\n            }\n        };\n        window.mtmLogs = {\n            push: function (log) {\n                window.mtmDbgData.mtmLogs.push(log);\n            }\n        };\n    <\/script>\n<\/head>\n<body ng-app=\"app\" >\n    <div id=\"root\" vue-entry=\"TagManager.Debugging\">\n        <template v-slot:logo><span id=\"logo\" class=\"logo brand-logo \">\n        <a href=\"index.php\" tabindex=\"3\"\n       title=\"Impulsado por Matomo\"\n    >\n                <img src='https:\/\/analytics.sistematlan.com\/misc\/user\/logo-header.png?matomo' alt=\"Impulsado por Matomo\" \/>\n                <\/a>\n    <\/span>\n<\/template>\n    <\/div>\n        <link rel=\"stylesheet\" type=\"text\/css\" href=\"index.php?module=Proxy&amp;action=getCss&amp;cb=142f9cf234078f5d9b99f25aad53745b\" \/>\n\n    <script type=\"text\/javascript\">\nvar translations = {\"CorePluginsAdmin_NoZipFileSelected\":\"Por favor selecciona un archivo ZIP.\",\"CorePluginsAdmin_FileExceedsUploadLimit\":\"El archivo seleccionado excede el l\\u00edmite de carga de su servidor.\",\"CorePluginsAdmin_NoPluginSettings\":\"No hay ajustes para este complemento que puedan ser configurados\",\"CoreAdminHome_PluginSettingsIntro\":\"Aqu\\u00ed puede cambiar la configuraci\\u00f3n de los siguientes complementos de terceros:\",\"CoreAdminHome_PluginSettingsSaveSuccess\":\"Ajustes del complemento actualizado.\",\"General_Save\":\"Guardar\",\"CorePluginsAdmin_Activate\":\"Activar\",\"CorePluginsAdmin_Deactivate\":\"Desactivar\",\"CorePluginsAdmin_PluginsExtendPiwik\":\"Los complementos extienden y ampl\\u00edan las funcionalidades de Matomo.\",\"CorePluginsAdmin_OncePluginIsInstalledYouMayActivateHere\":\"Una vez que el complemento est\\u00e1 instalado, puede activarlo o desactivarlo desde aqu\\u00ed.\",\"CorePluginsAdmin_TeaserExtendPiwikByPlugin\":\"Ampl\\u00ede Matomo %1$s instalando complementos desde el Marketplace %2$s o %3$s c\\u00e1rguelo en formato .zip%4$s.\",\"CorePluginsAdmin_DoMoreContactPiwikAdmins\":\"Para instalar un nuevo complemento o un nuevo tema, p\\u00f3ngase en contacto con sus administradores de Matomo.\",\"CorePluginsAdmin_ChangeLookByManageThemes\":\"Puede cambiar la apariencia de Matomo %1$sgestionando los temas%2$s.\",\"CorePluginsAdmin_InfoPluginUpdateIsRecommended\":\"Actualice sus complementos y aproveche de los \\u00faltimos mejoramientos.\",\"CorePluginsAdmin_UpdateSelected\":\"Actualizaci\\u00f3n seleccionada\",\"General_Plugin\":\"Complemento\",\"CorePluginsAdmin_Version\":\"Versi\\u00f3n\",\"General_Description\":\"Descripci\\u00f3n\",\"CorePluginsAdmin_Status\":\"Estado\",\"CorePluginsAdmin_Changelog\":\"Registro de cambios\",\"CorePluginsAdmin_Active\":\"Activo\",\"CorePluginsAdmin_Inactive\":\"Inactivo\",\"CorePluginsAdmin_PluginNotDownloadable\":\"Este complemento no es descargable.\",\"CorePluginsAdmin_PluginNotDownloadablePaidReason\":\"Las posibles razones son: la licencia ha expirado o se ha sobre excedido.\",\"CorePluginsAdmin_NotDownloadable\":\"No es descargable\",\"General_Download\":\"Descargar\",\"CoreUpdater_UpdateTitle\":\"Actualizar\",\"CorePluginsAdmin_InstalledPlugins\":\"Complementos instalados\",\"CorePluginsAdmin_Origin\":\"Origen\",\"CorePluginsAdmin_OriginCore\":\"Core\",\"CorePluginsAdmin_OriginOfficial\":\"Oficial\",\"CorePluginsAdmin_OriginThirdParty\":\"De terceros\",\"CorePluginsAdmin_UninstallConfirm\":\"Est\\u00e1s a punto de desinstalar un plugin %s. El plugin y todos los datos que ha recopilado se eliminar\\u00e1n completamente de tu plataforma y no se podr\\u00e1n recuperar. \\u00bfEst\\u00e1s seguro de que quieres hacerlo?\",\"CorePluginsAdmin_Theme\":\"Tema\",\"CorePluginsAdmin_CorePluginTooltip\":\"Los complementos centrales no tienen versi\\u00f3n, puesto que han sido distribuidos por Matomo.\",\"General_Settings\":\"Configuraci\\u00f3n\",\"CorePluginsAdmin_PluginHomepage\":\"P\\u00e1gina de internet del complemento\",\"CorePluginsAdmin_LikeThisPlugin\":\"\\u00bfSatisfecho con este complemento?\",\"CorePluginsAdmin_ConsiderDonating\":\"Considere una donaci\\u00f3n\",\"CorePluginsAdmin_CommunityContributedPlugin\":\"Este es un complemento gratuito gracias a la contribuci\\u00f3n de la comunidad de desarrolladores Matomo.\",\"CorePluginsAdmin_ConsiderDonatingCreatorOf\":\"Por favor considere realizar una donaci\\u00f3n al creador de %s\",\"General_Close\":\"Cerrar\",\"CorePluginsAdmin_LicenseHomepage\":\"P\\u00e1gina de la licencia\",\"CorePluginsAdmin_AuthorHomepage\":\"P\\u00e1gina de internet del autor\",\"CorePluginsAdmin_ActionUninstall\":\"Desinstalar\",\"CorePluginsAdmin_InstallNewThemes\":\"Instalar nuevos temas\",\"CorePluginsAdmin_InstallNewPlugins\":\"Instalar nuevos complementos\",\"CorePluginsAdmin_AlwaysActivatedPluginsList\":\"Los siguientes complementos siempre est\\u00e1n activados y no pueden ser desactivados: %s\",\"CorePluginsAdmin_PluginsManagement\":\"Administraci\\u00f3n de complementos\",\"CorePluginsAdmin_ThemesDescription\":\"Los temas pueden cambiar la apariencia de la interfaz de usuario Matomo, y ofrecer una nueva experiencia visual para disfrutar sus informes de an\\u00e1lisis.\",\"CorePluginsAdmin_TeaserExtendPiwikByTheme\":\"Disfrute de otra apariencia al %1$sInstalar un nuevo tema%2$s.\",\"CorePluginsAdmin_InfoThemeIsUsedByOtherUsersAsWell\":\"Nota: los otros usuarios de %1$s registrados en esta instalaci\\u00f3n Matomo tambi\\u00e9n est\\u00e1n utilizando el tema %2$s.\",\"CorePluginsAdmin_ThemesManagement\":\"Gestionar Temas\",\"CorePluginsAdmin_NUpdatesAvailable\":\"%1$s Actualizaci\\u00f3n(es) disponible(s)\",\"CorePluginsAdmin_PluginFreeTrialStarted\":\"%1$sSu prueba gratuita de 30 d\\u00edas ha comenzado%2$s para %3$s.\",\"CorePluginsAdmin_PluginFreeTrialStartedAccountCreatedMessage\":\"Hemos a\\u00f1adido su clave de licencia, iniciando una prueba gratuita de 30 d\\u00edas para %1$s. D\\u00e9 el siguiente paso instalando y activando su plugin.\",\"CorePluginsAdmin_PluginFreeTrialStartedAccountCreatedTitle\":\"Su cuenta ha sido creada\",\"General_Confirm\":\"Confirmar\",\"General_Cancel\":\"Cancelar\",\"UsersManager_ConfirmThisChange\":\"Please confirm this change.\",\"UsersManager_ConfirmWithPassword\":\"Introduzca su contrase\\u00f1a para confirmar este cambio.\",\"UsersManager_ConfirmWithReAuthentication\":\"Please re-authenticate to confirm this change.\",\"UsersManager_YourCurrentPassword\":\"Su actual contrase\\u00f1a\",\"PrivacyManager_PolicyControlledSetting\":\"A privacy compliance policy overrides this settings, so changing it has no effect right now.\",\"PrivacyManager_ViewPrivacyComplianceOverview\":\"View privacy compliance overview\",\"CoreAdminHome_ProtocolNotDetectedCorrectly\":\"Actualmente est\\u00e1 viendo Matomo a trav\\u00e9s de una conexi\\u00f3n SSL segura (usando HTTPS), pero Matomo solo pudo detectar una conexi\\u00f3n no segura en el servidor.\",\"CoreAdminHome_ProtocolNotDetectedCorrectlySolution\":\"Para asegurarse que Matomo peticiona y satisface de manera segura su contenido a trav\\u00e9s de HTTPS, puede modificar su archivo %1$s o configurar los datos de su proxy o puede agregar la siguiente l\\u00ednea %2$s bajo la secci\\u00f3n %3$s. %4$sAprenda m\\u00e1s%5$s\",\"CoreAdminHome_SettingsSaveSuccess\":\"Ajustes actualizados.\",\"UserCountryMap_None\":\"Ninguno\",\"Actions_ColumnPageURL\":\"URL de la p\\u00e1gina\",\"General_Date\":\"Fecha\",\"General_Measurable\":\"Medible\",\"General_Action\":\"Acci\\u00f3n\",\"General_Delete\":\"Borrar\",\"General_Id\":\"Id\",\"CoreHome_ClickToSeeFullInformation\":\"Haz clic para ver la informaci\\u00f3n completa\",\"CoreAdminHome_LearnMore\":\"Aprender m\\u00e1s\",\"CoreAdminHome_ConfirmDeleteAllTrackingFailures\":\"Est\\u00e1 seguro que desea eliminar todos los fallos de seguimiento?\",\"CoreAdminHome_ConfirmDeleteThisTrackingFailure\":\"\\u00bfEst\\u00e1 seguro que desea eliminar este fallo de seguimiento?\",\"CoreAdminHome_DeleteAllFailures\":\"Eliminar todos los fallos\",\"CoreAdminHome_NTrackingFailures\":\"%s fallos de seguimiento\",\"CoreAdminHome_Problem\":\"Problema\",\"CoreAdminHome_Solution\":\"Soluci\\u00f3n\",\"CoreAdminHome_TrackingFailures\":\"Fallos de seguimiento\",\"CoreAdminHome_TrackingFailuresIntroduction\":\"Esta p\\u00e1gina enumera los fallos de seguimiento que se produjeron durante los \\u00faltimos %s d\\u00edas. Tenga en cuenta que s\\u00f3lo los fallos m\\u00e1s comunes de seguimiento se registran, pero no todos.\",\"CoreAdminHome_TrackingURL\":\"URL de seguimiento\",\"CoreAdminHome_NoKnownFailures\":\"No existen fallos conocidos en el seguimiento.\",\"CoreAdminHome_JSTracking_CodeNoteBeforeClosingHead\":\"Haga clic en el bot\\u00f3n para copiar el fragmento de c\\u00f3digo y p\\u00e9guelo inmediatamente antes de la etiqueta de cierre %1$s (recomendado)\",\"CoreAdminHome_JSTracking_CodeNoteBeforeClosingHeadEmail\":\"Aseg\\u00farate de que este c\\u00f3digo es insertado con un elemento script en cada p\\u00e1gina de su sitio web. Recomendamos pegarlo justo antes de cerrar la etiqueta de cabecera.\",\"SitesManager_InstallationGuides\":\"Installation Guides\",\"CoreAdminHome_ArchivingSettings\":\"Configuraci\\u00f3n de archivado\",\"General_AllowPiwikArchivingToTriggerBrowser\":\"Archivar los informes cuando sean requeridos desde el navegador\",\"General_ReportsContainingTodayWillBeProcessedAtMostEvery\":\"Archivar informes a lo sumo cada X segundos\",\"General_ArchivingTriggerDescription\":\"Recomendado para grandes instalaciones de Matomo, necesitas %1$sconfigurar una tarea de cron %2$s para procesar los reportes autom\\u00e1ticamente.\",\"General_ArchivingTriggerSegment\":\"El uso de segmentos personalizados seguir\\u00e1 activando el procesamiento de archivos.\",\"General_SeeTheOfficialDocumentationForMoreInformation\":\"Vea la %1$sdocumentaci\\u00f3n oficial%2$s para mayor informaci\\u00f3n.\",\"General_SmallTrafficYouCanLeaveDefault\":\"Para sitios web de poco tr\\u00e1fico, puede dejar los %s segundos por defecto, y acceder a todos los informes en tiempo real.\",\"General_MediumToHighTrafficItIsRecommendedTo\":\"Para sitios web de medio o alto tr\\u00e1fico, recomendamos procesar los informes de hoy cada media hora (%1$s segundos) o cada hora (%2$s segundos).\",\"General_RearchiveTimeIntervalOnlyForTodayReports\":\"Esto afecto solo los informes de hoy (o cualquier otro rango de fecha incluyendo el actual)\",\"General_ArchivingInlineHelp\":\"Para sitios web de medio o alto tr\\u00e1fico, se recomienda deshabilitar el archivado de Matomo para que se active al acceder con el navegador. En su lugar, le recomendamos que configure una tarea cron para procesar los informes de Matomo cada hora.\",\"General_NewReportsWillBeProcessedByCron\":\"Cuando el archivado de Matomo no es activado por el navegador, los nuevos informes ser\\u00e1n procesados por el crontab.\",\"General_ReportsWillBeProcessedAtMostEveryHour\":\"Los informes ser\\u00e1n procesados al menos cada hora.\",\"General_IfArchivingIsFastYouCanSetupCronRunMoreOften\":\"Asumiendo que el archivado es m\\u00e1s r\\u00e1pido para su configuraci\\u00f3n, puede configurar el crontab para ejecutarse m\\u00e1s frecuentemente.\",\"CoreAdminHome_BrandingSettings\":\"Configuraci\\u00f3n del Branding\",\"CoreAdminHome_CustomLogoHelpText\":\"Puede personalizar el logo de Matomo que ser\\u00e1 mostrado en la interfaz de usuario y los informes por correo electr\\u00f3nico.\",\"CoreAdminHome_UseCustomLogo\":\"Usar un logo personalizado\",\"CoreAdminHome_LogoUpload\":\"Seleccione un logo para subir\",\"CoreAdminHome_FaviconUpload\":\"Selecciona un Favicon para subir\",\"CoreAdminHome_LogoUploadHelp\":\"Sube un archivo en formato %1$s con una altura m\\u00ednima de %2$s p\\u00edxeles.\",\"CoreAdminHome_LogoUploadFailed\":\"El fichero no ha podido subirse de forma correcta. Por favor, comprueba si el fichero tiene un formato correcto.\",\"CoreAdminHome_FileUploadDisabled\":\"La carga de archivos no est\\u00e1 habilitada en su configuraci\\u00f3n de PHP. Para cargar su logotipo personalizado, introduzca %s en el php.ini y reinicie su servidor web.\",\"CoreAdminHome_LogoNotWriteableInstruction\":\"Para utilizar su logo personalizado en lugar del logo est\\u00e1ndar de Matomo puede conceder permisos de escritura a este directorio: %1$s Matomo necesita el permiso de escritura para sus logos guardados en los archivos %2$s.\",\"General_GiveUsYourFeedback\":\"\\u00a1Env\\u00edanos tus comentarios!\",\"CoreAdminHome_CustomLogoFeedbackInfo\":\"Si personaliza el logo de Matomo, puede que tambi\\u00e9n est\\u00e9 interesado en ocultar el %1$s enlace en el men\\u00fa superior. Para hacerlo, puede deshabilitar el complemento Feedback en la p\\u00e1gina de %2$sAdministraci\\u00f3n de complementos%3$s.\",\"CoreAdminHome_EmailServerSettings\":\"Configuraci\\u00f3n del servidor de correo electr\\u00f3nico\",\"General_UseSMTPServerForEmail\":\"Use el servidor SMTP para el correo electr\\u00f3nico\",\"General_SelectYesIfYouWantToSendEmailsViaServer\":\"Seleccione \\\"Si\\\" si desea o tiene que enviar un correo electr\\u00f3nico a trav\\u00e9s de un servidor remoto en vez de la funci\\u00f3n correo local\",\"General_SmtpServerAddress\":\"Direcci\\u00f3n del servidor SMTP\",\"General_SmtpPort\":\"Puerto SMTP\",\"General_OptionalSmtpPort\":\"Opcional. Por defecto 25 para SMTP sin encriptaci\\u00f3n y TLS, y 465 para SSL SMTP.\",\"General_AuthenticationMethodSmtp\":\"M\\u00e9todo de autenticaci\\u00f3n SMTP\",\"General_OnlyUsedIfUserPwdIsSet\":\"S\\u00f3lo se utiliza si se establece un nombre de usuario\\\/contrase\\u00f1a, pregunte a su proveedor si no est\\u00e1 seguro que m\\u00e9todo utilizar.\",\"General_SmtpUsername\":\"Nombre de usuario SMTP\",\"General_OnlyEnterIfRequired\":\"Introduzca un nombre de usuario s\\u00f3lo si el servidor SMTP lo requiere.\",\"General_Plugins\":\"Complementos\",\"General_SmtpPassword\":\"Contrase\\u00f1a SMTP\",\"General_SmtpFromAddress\":\"SMTP de la direcci\\u00f3n\",\"General_SmtpFromEmailHelp\":\"El valor predeterminado es noreply @ {DOMAIN}, donde {DOMAIN} ser\\u00e1 reemplazado por su dominio Matomo \\\"%1$s\\\".<br> Si el env\\u00edo de correos no funciona para usted, es posible que deba configurar esta direcci\\u00f3n para que coincida con su nombre de usuario SMTP.\",\"General_SmtpFromName\":\"SMTP del nombre\",\"General_NameShownInTheSenderColumn\":\"El nombre que se muestra en la columna del remitente\",\"General_SmtpEncryption\":\"Encriptaci\\u00f3n SMTP\",\"General_EncryptedSmtpTransport\":\"Introduzca el tipo de cifrado requerido por el servidor SMTP.\",\"General_OnlyEnterIfRequiredPassword\":\"Introduzca la contrase\\u00f1a s\\u00f3lo si el servidor SMTP la requiere.\",\"General_WarningPasswordStored\":\"%1$sWarning:%2$s Esta contrase\\u00f1a se almacenar\\u00e1 en el archivo de configuraci\\u00f3n visible a todo el que pueda acceder a \\u00e9l.\",\"CoreAdminHome_ImageTracking\":\"Monitoreo mediante imagen\",\"CoreAdminHome_TrackAGoal\":\"Seguimiento de un objetivo\",\"CoreAdminHome_WithOptionalRevenue\":\"con una facturaci\\u00f3n opcional\",\"CoreAdminHome_ImageTrackingLink\":\"Enlace de monitoreo por imagen\",\"CoreAdminHome_ImageTrackingIntro1\":\"Cuando un visitante ha deshabilitado JavaScript o cuando no puede utilizarse, puede usar un enlace de imagen como v\\u00ednculo de seguimiento para monitorear visitantes.\",\"CoreAdminHome_ImageTrackingIntro2\":\"Generar el enlace de abajo y copiar y pegar el c\\u00f3digo HTML generado en la p\\u00e1gina. Si lo est\\u00e1 utilizando como una alternativa para el seguimiento v\\u00eda JavaScript, puede envolverlo en %1$s identificaciones.\",\"CoreAdminHome_ImageTrackingIntro3\":\"Para la lista completa de opciones que puede utilizar con un v\\u00ednculo de seguimiento de imagen, consulte la %1$sDocumentaci\\u00f3n API de rastreo%2$s.\",\"CoreAdminHome_JavaScriptTracking\":\"Seguimiento con JavaScript\",\"CoreAdminHome_JSTrackingIntro1\":\"Puedes rastrear visitantes hacia su sitio web de muchas maneras. La forma recomendada de hacerlo es con JavaScript. Para usar este m\\u00e9todo solo debe asegurarse de que cada p\\u00e1gina de su sitio de internet tenga cierto c\\u00f3digo JavaScript, el cual puede generar aqu\\u00ed.\",\"CoreAdminHome_JSTrackingIntro2\":\"Una vez que tenga el c\\u00f3digo de seguimiento JavaScript para su sitio web, c\\u00f3pielo y p\\u00e9guelo en todas las p\\u00e1ginas que desee rastrear con Matomo.\",\"CoreAdminHome_JSTrackingIntro3b\":\"Si no existe ning\\u00fan plugin, puede editar las plantillas de su sitio web y a\\u00f1adir el c\\u00f3digo de seguimiento JavaScript a la etiqueta &lt;\\\/head&gt; que suele estar definida en un archivo de plantilla 'header.php', 'header.tpl' o similar.\",\"General_JsTrackingTag\":\"C\\u00f3digo de monitoreo JavaScript\",\"SitesManager_EmailInstructionsButton\":\"Env\\u00eda por correo estas instrucciones\",\"CoreAdminHome_JSTracking_MergeSubdomains\":\"Rastrear visitantes a trav\\u00e9s de todos los subdominios de\",\"CoreAdminHome_JSTracking_GroupPageTitlesByDomainDesc1\":\"De esta manera si alguien visita la p\\u00e1gina 'About' del blog %1$s se registrar\\u00e1 como 'blog\\\/About'. Esta es la forma m\\u00e1s f\\u00e1cil de conseguir un resumen del tr\\u00e1fico de acuerdo a los subdominios.\",\"CoreAdminHome_JSTracking_GroupPageTitlesByDomain\":\"Anteponer el dominio del sitio al t\\u00edtulo de la p\\u00e1gina a rastrear\",\"CoreAdminHome_JSTracking_MergeAliasesDesc\":\"De esta forma los clics que han recibido los enlaces de los alias de URL (por ej. %s) no ser\\u00e1n contados como \\\"Outlink\\\".\",\"CoreAdminHome_JSTracking_MergeAliases\":\"En el informe *Enlaces salientes\\\" puede ocultar los clics a los alias URL conocidos de\",\"CoreAdminHome_JSTracking_TrackNoScript\":\"Rastrear usuarios que tengan JavaScript deshabilitado\",\"Mobile_Advanced\":\"Avanzado\",\"CoreAdminHome_JSTracking_VisitorCustomVars\":\"Rastrear variables personalizadas para este visitante\",\"CoreAdminHome_JSTracking_VisitorCustomVarsDesc\":\"Por ejemplo, con el nombre de variable \\\"Tipo\\\" y el valor \\\"Cliente\\\".\",\"CoreAdminHome_JSTracking_CrossDomain\":\"Por defecto, el ID de visitante que identifica a un \\u00fanico visitante se almacena en las cookies de origen del navegador, a las que s\\u00f3lo pueden acceder las p\\u00e1ginas del mismo dominio. Habilitar el enlace entre dominios le permite rastrear todas las acciones y p\\u00e1ginas vistas de un visitante espec\\u00edfico en la misma visita, incluso cuando ven p\\u00e1ginas en varios dominios. Cada vez que un usuario haga clic en un enlace a una de las URL de alias de su sitio web, se a\\u00f1adir\\u00e1 un par\\u00e1metro de URL pk_vid que remitir\\u00e1 el ID del visitante.\",\"CoreAdminHome_JSTracking_CrossDomain_NeedsMultipleDomains\":\"Nota: Para usar enlaces cruzados de dominio, debe especificar m\\u00e1s de un nombre de dominio (URLs) para su sitio web.\",\"CoreAdminHome_JSTracking_EnableCrossDomainLinking\":\"Permitir la vinculaci\\u00f3n entre dominios\",\"CoreAdminHome_JSTracking_EnableDoNotTrackDesc\":\"De esta manera las solicitudes de seguimiento no ser\\u00e1 enviada si el visitante no desea ser seguido.\",\"CoreAdminHome_JSTracking_EnableDoNotTrack_AlreadyEnabled\":\"Nota: Soporte del lado del servidor para DoNotTrack ha sido activado, por lo que esta opci\\u00f3n no tendr\\u00e1 ning\\u00fan efecto.\",\"CoreAdminHome_JSTracking_EnableDoNotTrack\":\"Habilitar detecci\\u00f3n por parte del cliente de DoNotTrack\",\"CoreAdminHome_JSTracking_DisableCookies\":\"Desactivar todas las cookies de rastreo\",\"CoreAdminHome_JSTracking_DisableCookiesDesc\":\"Deshabilite todas las cookies propias. Las cookies de Matomo existentes para este sitio web se eliminar\\u00e1n en las pr\\u00f3ximas visitas a la p\\u00e1gina.\",\"CoreAdminHome_JSTracking_CustomCampaignQueryParam\":\"Utilizar nombres de par\\u00e1metros de consulta personalizados para el nombre de la campa\\u00f1a y la palabra clave\",\"CoreAdminHome_JSTracking_CampaignNameParam\":\"Par\\u00e1metro Nombre de la campa\\u00f1a\",\"CoreAdminHome_JSTracking_CampaignKwdParam\":\"Par\\u00e1metro palabra clave de la campa\\u00f1a\",\"SitesManager_EmailInstructionsSubject\":\"C\\u00f3digo de rastreo de anal\\u00edticas de Matomo\",\"SitesManager_JsTrackingTagHelp\":\"Aqu\\u00ed est\\u00e1 el c\\u00f3digo de rastreo JavaScript a incluir en todas sus p\\u00e1ginas\",\"CoreAdminHome_JSTrackingIntro3a\":\"En la mayor\\u00eda de sitos web, blogs, CMS, etc. puede utilizar plugins precodificados para que realicen el trabajo t\\u00e9cnico por usted. (Vea nuestra %1$slista de plugins para integrar Matomo%2$s.)\",\"CoreAdminHome_JSTrackingIntro4\":\"Si no desea utilizar JavaScript para rastrear visitantes, %1$sgenere un enlace de imagen de rastreo%2$s.\",\"CoreAdminHome_JSTrackingIntro5\":\"Si desea hacer m\\u00e1s que rastrear vistas de p\\u00e1ginas, revise la %1$sDocumentaci\\u00f3n de Javascript de Matomo%2$s acerca de las funciones disponibles. Estas puede rastrear objetivos, variables personalizadas, \\u00f3rdenes de comercio electr\\u00f3nico, carritos abandonados y m\\u00e1s.\",\"General_Options\":\"Opciones\",\"General_Value\":\"Valor\",\"Actions_ColumnPageName\":\"Nombre de p\\u00e1gina\",\"CoreAdminHome_JSTracking_MergeSubdomainsDesc\":\"Entonces si un visitante visita %1$s y %2$s, \\u00e9stos ser\\u00e1n contados como un \\u00fanico visitante.\",\"CoreAdminHome_JSTracking_CustomCampaignQueryParamDesc\":\"Nota: %1$sMatomo detectar\\u00e1 autom\\u00e1ticamente los par\\u00e1metros de Google Analytics.%2$s\",\"CoreAdminHome_SinglePageApplicationDescription\":\"Si est\\u00e1 siguiendo una aplicaci\\u00f3n de una sola p\\u00e1gina (SPA) o una aplicaci\\u00f3n web progresiva (PWA), consulte %1$sesta gu\\u00eda%2$s.\",\"CoreAdminHome_CloudflareDescription\":\"Si su p\\u00e1gina web est\\u00e1 alojado en Cloudflare, consulte %1$sesta gu\\u00eda%2$s.\",\"CoreAdminHome_SecurityNotificationUserAcceptInviteBody\":\"El usuario (inicio de sesi\\u00f3n: %s) acept\\u00f3 la invitaci\\u00f3n.\",\"CoreAdminHome_SecurityNotificationUserDeclinedInviteBody\":\"El usuario (inicio de sesi\\u00f3n: %s) rechaz\\u00f3 la invitaci\\u00f3n.\",\"CoreAdminHome_JSTracking_ConsentManagerDetected\":\"Se detect\\u00f3 %1$s administrador de consentimiento en su sitio. Para obtener informaci\\u00f3n sobre c\\u00f3mo configurar Matomo para que funcione con %1$s, visite %2$s\",\"CoreAdminHome_JSTracking_ConsentManagerConnected\":\"Parece que %1$s ya est\\u00e1 configurado para funcionar con Matomo.\",\"CoreAdminHome_GoogleTagManagerDescription\":\"Si su p\\u00e1gina web utiliza Google Tag Manager, consulte %1$sesta gu\\u00eda%2$s.\",\"CoreAdminHome_WordpressDescription\":\"Si su p\\u00e1gina web utiliza Wordpress, consulte %1$sesta gu\\u00eda%2$s.\",\"CoreAdminHome_VueDescription\":\"Si su p\\u00e1gina web utiliza Vue.js, consulte %1$sesta gu\\u00eda%2$s.\",\"CoreAdminHome_ShowAdvancedOptions\":\"Mostrar opciones avanzadas\",\"CoreAdminHome_HideAdvancedOptions\":\"Ocultar opciones avanzadas\",\"CoreAdminHome_JSTrackingDocumentationHelp\":\"Para un acceso f\\u00e1cil, las opciones avanzadas m\\u00e1s populares est\\u00e1n disponibles a continuaci\\u00f3n. Para obtener a\\u00fan m\\u00e1s opciones (incluyendo c\\u00f3mo rastrear objetivos, variables personalizadas, pedidos de comercio electr\\u00f3nico y carritos abandonados), consulte la %1$sdocumentaci\\u00f3n de seguimiento de Javascript de Matomo%2$s.\",\"CoreAdminHome_ReactDescription\":\"Si su p\\u00e1gina web utiliza React, consulte %1$sesta gu\\u00eda%2$s.\",\"CoreAdminHome_JsTrackingCodeAdvancedOptionsStep\":\"Opcional: utiliza las opciones avanzadas para personalizar tu c\\u00f3digo de seguimiento.\",\"CoreAdminHome_JSTracking_DisableCampaignParameters\":\"Deshabilitar el seguimiento de par\\u00e1metros de la campa\\u00f1a\",\"CoreAdminHome_JSTracking_DisableCampaignParametersDesc\":\"Cuando esta opci\\u00f3n est\\u00e1 marcada, Matomo no rastrear\\u00e1 los par\\u00e1metros de la campa\\u00f1a y ser\\u00e1n eliminados de las URLs rastreadas.\",\"General_Export\":\"Exportar\",\"General_InvalidDateRange\":\"Rango de fecha inv\\u00e1lido, por favor int\\u00e9ntelo nuevamente\",\"General_Loading\":\"Cargando\\u2026\",\"General_Show\":\"mostrar\",\"General_Remove\":\"Quitar\",\"General_Hide\":\"ocultar\",\"General_Website\":\"Sitio de internet\",\"General_Pagination\":\"%1$s\\u2013%2$s de %3$s\",\"General_RowsToDisplay\":\"Filas a mostrar\",\"Intl_Year_Short\":\"a\",\"General_MultiSitesSummary\":\"Todos los sitios web\",\"General_SearchNoResults\":\"Sin resultados\",\"CoreHome_ChooseX\":\"Elige %1$s\",\"CoreHome_YouAreUsingTheLatestVersion\":\"\\u00a1Est\\u00e1 utilizando la \\u00faltima versi\\u00f3n de Matomo!\",\"CoreHome_IncludeRowsWithLowPopulation\":\"Las filas con baja poblaci\\u00f3n est\\u00e1n ocultas %s Mostrar todas las filas\",\"CoreHome_ExcludeRowsWithLowPopulation\":\"Mostrar todas las filas %s Excluir baja poblaci\\u00f3n\",\"CoreHome_DataTableIncludeAggregateRows\":\"Filas agregadas est\\u00e1n ocultas %s Mostrarlas\",\"CoreHome_DataTableExcludeAggregateRows\":\"Mostrar filas acumuladas %s Ocultarlas\",\"CoreHome_DataTableCombineDimensions\":\"Dimensiones est\\u00e1n mostradas separadamente %s Mostrarlas de manera combinada\",\"CoreHome_DataTableShowDimensions\":\"Dimensiones est\\u00e1n combinadas %s Mostrarlas separadamente\",\"CoreHome_Default\":\"predeterminado\",\"CoreHome_FormatMetrics\":\"Formato de m\\u00e9tricas\",\"CoreHome_ShowExportUrl\":\"Mostrar URL de exportaci\\u00f3n\",\"CoreHome_HideExportUrl\":\"Ocultar URL de exportaci\\u00f3n\",\"CoreHome_FlattenDataTable\":\"Este reporte es jer\\u00e1rquico %s Hazlo plano\",\"CoreHome_UnFlattenDataTable\":\"Este informe es plano %s Hazlo jer\\u00e1rquico\",\"CoreHome_ExternalHelp\":\"Ayuda (se abre en una nueva pesta\\u00f1a)\",\"CoreHome_ClickToEditX\":\"Clic para editar %s\",\"CoreHome_Menu\":\"Men\\u00fa\",\"CoreHome_AddTotalsRowDataTable\":\"El informe no est\\u00e1 mostrando la fila de totales %s Mostrar fila de totales\",\"CoreHome_RemoveTotalsRowDataTable\":\"El informe est\\u00e1 mostrando la fila de totales %s Eliminar fila de totales\",\"CoreHome_PeriodHasOnlyRawData\":\"Parece que los informes para este periodo a\\u00fan no han sido procesados. \\u00bfQuiere ver lo que est\\u00e1 sucediendo ahora? Consulte aqu\\u00ed %1$s, registro de visitas %2$s o elija un periodo distinto hasta que los informes se hayan generado.\",\"CoreHome_PeriodHasOnlyRawDataNoVisitsLog\":\"Parece que los informes correspondientes a este periodo a\\u00fan no se han procesado, pero estar\\u00e1n disponibles en unas horas. Podr\\u00eda elegir un periodo de fechas diferente hasta que se generen los informes.\",\"SitesManager_NotFound\":\"Ning\\u00fan sitio de internet encontrado\",\"Annotations_ViewAndAddAnnotations\":\"Ver y a\\u00f1adir anotaciones para %s\\u2026\",\"General_RowEvolutionRowActionTooltipTitle\":\"Abrir fila Evoluci\\u00f3n\",\"General_RowEvolutionRowActionTooltip\":\"Observa c\\u00f3mo las m\\u00e9tricas de esta fila se modificaron en el tiempo\",\"Annotations_IconDesc\":\"Ver las notas en este rango de fechas.\",\"Annotations_IconDescHideNotes\":\"Ocultar las notas en este rango de fechas.\",\"Annotations_HideAnnotationsFor\":\"Ocultar anotaciones para %s\\u2026\",\"General_LoadingPopover\":\"Cargando %s\\u2026\",\"General_LoadingPopoverFor\":\"Cargando %s por\",\"Intl_Month_Short_StandAlone_1\":\"ene\",\"Intl_Month_Short_StandAlone_2\":\"feb\",\"Intl_Month_Short_StandAlone_3\":\"mar\",\"Intl_Month_Short_StandAlone_4\":\"abr\",\"Intl_Month_Short_StandAlone_5\":\"may\",\"Intl_Month_Short_StandAlone_6\":\"jun\",\"Intl_Month_Short_StandAlone_7\":\"jul\",\"Intl_Month_Short_StandAlone_8\":\"ago\",\"Intl_Month_Short_StandAlone_9\":\"sept\",\"Intl_Month_Short_StandAlone_10\":\"oct\",\"Intl_Month_Short_StandAlone_11\":\"nov\",\"Intl_Month_Short_StandAlone_12\":\"dic\",\"Intl_Month_Long_StandAlone_1\":\"enero\",\"Intl_Month_Long_StandAlone_2\":\"febrero\",\"Intl_Month_Long_StandAlone_3\":\"marzo\",\"Intl_Month_Long_StandAlone_4\":\"abril\",\"Intl_Month_Long_StandAlone_5\":\"mayo\",\"Intl_Month_Long_StandAlone_6\":\"junio\",\"Intl_Month_Long_StandAlone_7\":\"julio\",\"Intl_Month_Long_StandAlone_8\":\"agosto\",\"Intl_Month_Long_StandAlone_9\":\"septiembre\",\"Intl_Month_Long_StandAlone_10\":\"octubre\",\"Intl_Month_Long_StandAlone_11\":\"noviembre\",\"Intl_Month_Long_StandAlone_12\":\"diciembre\",\"Intl_Day_Short_StandAlone_1\":\"lun\",\"Intl_Day_Short_StandAlone_2\":\"mar\",\"Intl_Day_Short_StandAlone_3\":\"mi\\u00e9\",\"Intl_Day_Short_StandAlone_4\":\"jue\",\"Intl_Day_Short_StandAlone_5\":\"vie\",\"Intl_Day_Short_StandAlone_6\":\"s\\u00e1b\",\"Intl_Day_Short_StandAlone_7\":\"dom\",\"Intl_Day_Long_StandAlone_1\":\"lunes\",\"Intl_Day_Long_StandAlone_2\":\"martes\",\"Intl_Day_Long_StandAlone_3\":\"mi\\u00e9rcoles\",\"Intl_Day_Long_StandAlone_4\":\"jueves\",\"Intl_Day_Long_StandAlone_5\":\"viernes\",\"Intl_Day_Long_StandAlone_6\":\"s\\u00e1bado\",\"Intl_Day_Long_StandAlone_7\":\"domingo\",\"Intl_Day_Min_StandAlone_1\":\"LU\",\"Intl_Day_Min_StandAlone_2\":\"MA\",\"Intl_Day_Min_StandAlone_3\":\"MI\",\"Intl_Day_Min_StandAlone_4\":\"JU\",\"Intl_Day_Min_StandAlone_5\":\"VI\",\"Intl_Day_Min_StandAlone_6\":\"SA\",\"Intl_Day_Min_StandAlone_7\":\"DO\",\"Intl_PeriodDay\":\"d\\u00eda\",\"Intl_PeriodWeek\":\"semana\",\"Intl_PeriodMonth\":\"mes\",\"Intl_PeriodYear\":\"a\\u00f1o\",\"Intl_ListPatternAnd2\":\"{0} y {1}\",\"Intl_ListPatternAndEnd\":\"{0} y {1}\",\"Intl_ListPatternAndMiddle\":\"{0}, {1}\",\"Intl_ListPatternAndStart\":\"{0}, {1}\",\"Intl_ListPatternOr2\":\"{0} o {1}\",\"Intl_ListPatternOrEnd\":\"{0} o {1}\",\"Intl_ListPatternOrMiddle\":\"{0}, {1}\",\"Intl_ListPatternOrStart\":\"{0}, {1}\",\"General_DateRangeInPeriodList\":\"Rango de fecha\",\"General_And\":\"y\",\"General_All\":\"Todo\",\"General_Search\":\"Buscar\",\"General_Clear\":\"Quitar\",\"General_MoreDetails\":\"M\\u00e1s detalles\",\"General_Help\":\"Ayuda\",\"General_HelpReport\":\"Haga clic para mostrar informaci\\u00f3n de ayuda sobre este informe\",\"General_Name\":\"Nombre\",\"General_Yes\":\"S\\u00ed\",\"General_No\":\"No\",\"General_Edit\":\"Editar\",\"General_Default\":\"Predeterminado\",\"General_LoadingData\":\"Cargando datos\\u2026\",\"General_Error\":\"Error\",\"General_ErrorRequest\":\"Oops... hubo un problema durante la petici\\u00f3n. Tal vez el servidor tuvo un problema temporal, o tal vez pidi\\u00f3 un informe con demasiada informaci\\u00f3n. Por favor vuelva a intentarlo. Si el error ocurre repetidamente, %1$scont\\u00e1cte con su administrador Matomo%2$s para ayudarlo.\",\"General_ErrorRateLimit\":\"Oops... demasiadas peticiones. Esto sucede cuando se excede el n\\u00famero de solicitudes permitidas a la API durante un determinado per\\u00edodo de tiempo.\",\"General_ErrorRequestFaqLink\":\"Mira los pasos para resolver esta incidencia en las Preguntas frecuentes.\",\"General_Warning\":\"Advertencia\",\"General_YourChangesHaveBeenSaved\":\"Se han guardado los cambios.\",\"General_LearnMore\":\"%1$saprender m\\u00e1s%2$s\",\"General_ChooseDate\":\"Elige la fecha, actualmente la fecha seleccionada es: %s\",\"General_ReadThisToLearnMore\":\"%1$sLeer esto para aprender m\\u00e1s.%2$s\",\"CoreHome_UndoPivotBySubtable\":\"Este informe ha sido girado %s Deshacer giro\",\"CoreHome_PivotBySubtable\":\"Este informe no est\\u00e1 girado %1$s Girarlo sobre %2$s\",\"CoreHome_NoSuchPage\":\"Esta p\\u00e1gina no existe\",\"CoreHome_QuickAccessTitle\":\"Buscar por %s. Utilice las teclas del cursor para navegar a trav\\u00e9s de los resultados. Atajo de teclado: Click 'f' para buscar.\",\"CoreHome_Segments\":\"Segmentos\",\"CoreHome_MenuEntries\":\"Opciones de men\\u00fa\",\"SitesManager_Sites\":\"Sitios de internet\",\"CoreHome_MainNavigation\":\"Men\\u00fa principal de navegaci\\u00f3n\",\"CoreHome_ChangeCurrentWebsite\":\"Elige un sitio web, actualmente el sitio web seleccionado es: %s\",\"General_CreatedByUser\":\"Creado por %s\",\"General_DateRangeFromTo\":\"Desde %1$s a %2$s\",\"General_DateRangeFrom\":\"Desde\",\"General_DateRangeTo\":\"A\",\"General_DoubleClickToChangePeriod\":\"Doble clic para aplicar este per\\u00edodo.\",\"General_Apply\":\"Aplicar\",\"General_Period\":\"Periodo\",\"General_CompareTo\":\"Comparar con:\",\"CoreHome_DateInvalid\":\"La combinaci\\u00f3n de fecha y periodo seleccionados es inv\\u00e1lido. Por favor escoja una fecha v\\u00e1lida en el selector de fechas.\",\"CoreHome_EnterZenMode\":\"Cambiar al modo Zen (ocultar los men\\u00fas)\",\"CoreHome_ExitZenMode\":\"Salir de modo Zen (mostrar men\\u00fas)\",\"CoreHome_ShortcutZenMode\":\"para modo Zen\",\"CoreHome_ShortcutSegmentSelector\":\"para abrir el selector Segmento\",\"CoreHome_ShortcutWebsiteSelector\":\"para abrir el selector Sitio web\",\"CoreHome_ShortcutCalendar\":\"para abrir calendario (d significa Date)\",\"CoreHome_ShortcutSearch\":\"para ejecutar la b\\u00fasqueda (f significa Find)\",\"CoreHome_ShortcutHelp\":\"para mostrar esta ayuda\",\"CoreHome_ShortcutRefresh\":\"para actualizar el contenido\",\"CoreHome_StandardReport\":\"Informe est\\u00e1ndar\",\"CoreHome_ReportWithMetadata\":\"Informe con metadatos\",\"CoreHome_ReportType\":\"Tipo de informe\",\"CoreHome_RowLimit\":\"L\\u00edmite de fila\",\"CoreHome_ExportFormat\":\"Formato de exportaci\\u00f3n\",\"CoreHome_ExportTooltip\":\"Nota: Para usar la URL de exportaci\\u00f3n generada, deber\\u00e1 especificar una autenticaci\\u00f3n de token de aplicaci\\u00f3n. Puede configurar estos tokens en Admin \\u2192 Seguridad \\u2192 Autorizaciones de token.\",\"CoreHome_ExportTooltipWithLink\":\"Nota: Para usar la URL de exportaci\\u00f3n generada, deber\\u00e1 especificar una autenticaci\\u00f3n de token de aplicaci\\u00f3n. Puede configurar estos tokens en %1$s[Admin \\u2192 Security \\u2192 Auths Tokens]%2$s. Reemplace %3$s en la URL de exportaci\\u00f3n por su token de autenticaci\\u00f3n. Advertencia: nunca comparta la URL con el token real con nadie m\\u00e1s.\",\"CoreHome_FlattenReport\":\"Aplanar informe\",\"CoreHome_IncludeDimensionsSeparately\":\"Include dimensions separately\",\"CoreHome_CustomLimit\":\"L\\u00edmite personalizado\",\"CoreHome_ExpandSubtables\":\"Expandir subtablas\",\"CoreHome_HomeShortcut\":\"Inicio\",\"CoreHome_PageUpShortcutDescription\":\"para ir a la parte superior de la p\\u00e1gina\",\"CoreHome_EndShortcut\":\"Fin\",\"CoreHome_PageDownShortcutDescription\":\"para ir a la parte inferior de la p\\u00e1gina\",\"CoreHome_MacPageUp\":\"Fn + flecha izquierda\",\"CoreHome_MacPageDown\":\"Fn + flecha derecha\",\"CoreHome_SearchOnMatomo\":\"Busca '%1$s' en Matomo.org\",\"General_ComputedMetricMax\":\"M\\u00e1x %s\",\"General_XComparedToY\":\"%1$s comparado con %2$s\",\"General_ComparisonCardTooltip1\":\"'%1$s' sobre %2$s contiene %3$s de todas las visitas (%4$s de %5$s en total).\",\"General_ComparisonCardTooltip2\":\"La cuenta de visitas es diferente por %1$s comparado con %2$s sobre %3$s.\",\"General_Comparisons\":\"Comparaciones\",\"General_ClickToRemoveComp\":\"De clic para remover esta comparaci\\u00f3n.\",\"General_Custom\":\"Personalizado\",\"General_PreviousPeriod\":\"Periodo previo\",\"General_PreviousYear\":\"A\\u00f1o previo\",\"CoreHome_ReportingCategoryHelpPrefix\":\"\\u00bfC\\u00f3mo me ayuda la p\\u00e1gina de informes \\\"%1$s \\u2192 %2$s\\\"?\",\"CoreHome_TechDeprecationWarning\":\"A partir de la versi\\u00f3n Matomo %1$s, Matomo dejar\\u00e1 de ser compatible con %2$s. Para obtener m\\u00e1s informaci\\u00f3n, %3$sconsulte nuestra publicaci\\u00f3n de blog.%4$s\",\"CoreHome_StartDate\":\"Fecha de inicio\",\"CoreHome_EndDate\":\"Fecha final\",\"CoreHome_DataForThisReportHasBeenDisabled\":\"La segmentaci\\u00f3n est\\u00e1 actualmente desactivada para este informe. Por favor, compruebe %1$sesta pregunta frecuente%2$s para m\\u00e1s detalles.\",\"CoreHome_ChangeVisualization\":\"Cambiar visualizaci\\u00f3n\",\"General_ExportThisReport\":\"Exportar este conjunto de datos en otros formatos\",\"Annotations_Annotations\":\"Anotaciones\",\"CoreHome_CloseSearch\":\"Cerrar b\\u00fasqueda\",\"CoreHome_DataTableHowToSearch\":\"Pulse Intro o haga clic en el icono de b\\u00fasqueda para buscar\",\"CoreHome_ChangePeriod\":\"Cambiar per\\u00edodo\",\"General_NewUpdatePiwikX\":\"Nueva actualizaci\\u00f3n: Matomo %s\",\"CoreHome_SeeAvailableVersions\":\"Ver versiones disponibles\",\"CoreHome_OneClickUpdateNotPossibleAsMultiServerEnvironment\":\"La actualizaci\\u00f3n en un solo clic no est\\u00e1 disponible ya que est\\u00e1 usando Matomo en varios servidores. Por favor, para continuar, descargue la \\u00faltima versi\\u00f3n de %1$s.\",\"General_PiwikXIsAvailablePleaseUpdateNow\":\"Matomo %1$s est\\u00e1 disponible. %2$s \\u00a1Por favor, actualice ahora!%3$s (ver %4$scambios%5$s).\",\"General_PiwikXIsAvailablePleaseNotifyPiwikAdmin\":\"%1$s est\\u00e1 disponible. Por favor alerte al %2$s administrador Matomo%3$s.\",\"General_YouAreCurrentlyUsing\":\"Actualmente est\\u00e1 utilizando Matomo %s.\",\"General_Copy\":\"Copiar\",\"General_CopiedToClipboard\":\"Copiado en el portapapeles\",\"CoreHome_ReportLowercase\":\"report\",\"CoreHome_LearnMoreFullStop\":\"%1$sLearn more.%2$s\",\"CoreHome_ChooseWebsite\":\"Choose website\",\"CoreHome_CopyModalNote\":\"%1$sNote:%2$s The copied %3$s may need adjustments if it includes references specific to the original website. Review settings to ensure compatibility.\",\"CoreHome_CopyX\":\"Copy %1$s\",\"CoreHome_CopyXDescription\":\"Select the website to copy this %1$s to. This will create an exact copy, including settings, in the chosen site.\",\"UsersManager_MenuPersonal\":\"Personal\",\"_hasSubmenu\":\"_hasSubmenu\",\"_order\":\"_order\",\"_name\":\"_name\",\"_tooltip\":\"_tooltip\",\"_attribute\":\"_attribute\",\"_icon\":\"_icon\",\"_help\":\"_help\",\"_badgecount\":\"_badgecount\",\"_cssClass\":\"_cssClass\",\"_url\":\"_url\",\"General_Security\":\"Seguridad\",\"ScheduledReports_ScheduleReports\":\"Schedule Reports\",\"CoreAdminHome_MenuSystem\":\"Sistema\",\"General_GeneralSettings\":\"Ajustes generales\",\"UsersManager_MenuUsers\":\"Usuarios\",\"UserCountry_Geolocation\":\"Geolocalizaci\\u00f3n\",\"MobileMessaging_SettingsMenu\":\"Mensajero m\\u00f3vil\",\"PrivacyManager_MenuPrivacySettings\":\"Privacidad\",\"PrivacyManager_AnonymizeData\":\"Anonimizar datos\",\"PrivacyManager_UsersOptOut\":\"Los usuarios optan por excluirse\",\"PrivacyManager_AskingForConsent\":\"Pidiendo consentimiento\",\"PrivacyManager_GdprOverview\":\"Visi\\u00f3n general GDPR\",\"PrivacyManager_GdprTools\":\"Herramientas GDPR\",\"CoreAdminHome_TrackingCode\":\"C\\u00f3digo de seguimiento\",\"Goals_Goals\":\"Objetivos\",\"SitesManager_MenuManage\":\"Administrar\",\"CustomDimensions_CustomDimensions\":\"Dimensiones personalizadas\",\"CorePluginsAdmin_MenuPlatform\":\"Plataforma\",\"Marketplace_Marketplace\":\"Mercado\",\"General_Widgets\":\"M\\u00f3dulos\",\"General_API\":\"API\",\"CoreAdminHome_MenuDiagnostic\":\"Diagn\\u00f3stico\",\"Installation_SystemCheck\":\"Comprobaci\\u00f3n del sistema\",\"Diagnostics_ConfigFileTitle\":\"Archivo de configuraci\\u00f3n\",\"Login_BruteForceLog\":\"Registro Fuerza bruta\",\"DevicesDetection_DeviceDetection\":\"Detecci\\u00f3n de dispositivos\",\"Diagnostics_ConfigFileIntroduction\":\"Aqu\\u00ed puede ver la configuraci\\u00f3n de Matomo. Si est\\u00e1 ejecutando Matomo en un ambiente balanceado puede que la p\\u00e1gina sea diferente sea por el servidor que la est\\u00e9 cargando. Las filas con un color de fondo diferente son valores de configuraci\\u00f3n modificados que son especificados por ejemplo en el archivo %1$s.\",\"Diagnostics_HideUnchanged\":\"Si desea ver solo los valores modificados puede %1$socultar todos los valores no modificados%2$s.\",\"Diagnostics_Sections\":\"Secciones\",\"General_MetricsToPlot\":\"M\\u00e9tricas a trazar\",\"General_MetricToPlot\":\"M\\u00e9trica a trazar\",\"General_RecordsToPlot\":\"Registros a trazar\",\"General_SaveImageOnYourComputer\":\"Para guardar la imagen en su computadora, haga clic derecho en la imagen y seleccione \\\"Guardar imagen como...\\\"\",\"General_ExportAsImage\":\"Exportar como imagen\",\"General_NoDataForGraph\":\"No hay datos para esta gr\\u00e1fica.\",\"General_EvolutionSummaryGeneric\":\"%1$s en %2$s comparado con %3$s en %4$s. Evoluci\\u00f3n: %5$s\",\"General_IncompletePeriod\":\"Per\\u00edodo Incompleto\",\"General_InvalidatedPeriod\":\"Per\\u00edodo invalidado\",\"API_Glossary\":\"Glosario\",\"API_LearnAboutCommonlyUsedTerms2\":\"Conozca los t\\u00e9rminos m\\u00e1s utilizados para sacar el m\\u00e1ximo partido a los an\\u00e1lisis de Matomo.\",\"Widgetize_OpenInNewWindow\":\"Abrir en una nueva ventana\",\"Dashboard_LoadingWidget\":\"Cargando m\\u00f3dulo, por favor espere\\u2026\",\"Widgetize_TooHighAccessLevel\":\"Este usuario tiene acceso de super-usuario. No se permite incrustar widgets con autenticaci\\u00f3n de token de superusuario. %1$sConsulte las FAQ para m\\u00e1s informaci\\u00f3n.%2$s\",\"Widgetize_SelectAReport\":\"Seleccione un informe y copie y pegue en su p\\u00e1gina el c\\u00f3digo de inserci\\u00f3n que aparece debajo del widget:\",\"Widgetize_Reports\":\"Widgetizar informes\",\"Widgetize_Intro\":\"Con Matomo, usted puede %1$sexportar sus informes de Web Analytics%2$s en su blog, sitio web o tablero de intranet... en un solo clic.\",\"Widgetize_DisplayDashboardInIframe\":\"Tambi\\u00e9n puede mostrar el panel de control completo de Matomo en su aplicaci\\u00f3n o sitio web en un IFRAME (%1$seg\\u00fan el ejemplo%2$s). El par\\u00e1metro de fecha puede establecerse en una fecha espec\\u00edfica del calendario, \\\"hoy\\\" o \\\"ayer\\\". El par\\u00e1metro de per\\u00edodo puede establecerse como \\\"d\\u00eda\\\", \\\"semana\\\", \\\"mes\\\" o \\\"a\\u00f1o\\\". El par\\u00e1metro de idioma puede establecerse con el c\\u00f3digo de idioma de una traducci\\u00f3n, como language=fr. Por ejemplo, para idSite=1 y date=yesterday, se puede escribir:\",\"Widgetize_DisplayDashboardInIframeAllSites\":\"Tambi\\u00e9n puede widgetizar el panel de control de todos los sitios web en un IFRAME (%1$sver ejemplo%2$s)\",\"Widgetize_ViewableAnonymously\":\"If you want your widgets to be viewable by everybody, you first have to set the 'view' permissions to the anonymous user in the %1$sUsers Management section%2$s. <br>Alternatively, if you are publishing widgets on a password protected or private page, you don't necessarily have to allow 'anonymous' to view your reports. In this case, you can add the secret <code>token_auth<\\\/code> parameter in the widget URL. You can manage your auth tokens on your %3$sSecurity page%4$s.\",\"Widgetize_EmbedIframe\":\"\\u203a Insertar un Iframe\",\"Widgetize_DirectLink\":\"\\u203a Enlace directo\",\"General_TransitionsRowActionTooltipTitle\":\"Transiciones abiertas\",\"General_TransitionsRowActionTooltip\":\"Vea que hicieron los visitantes antes y despu\\u00e9s de observar esta p\\u00e1gina\",\"Actions_PageUrls\":\"URLs de p\\u00e1gina\",\"Actions_WidgetPageTitles\":\"T\\u00edtulos de p\\u00e1gina\",\"Transitions_NumPageviews\":\"%s p\\u00e1ginas visitadas\",\"Transitions_Transitions\":\"Transiciones\",\"CoreHome_ThereIsNoDataForThisReport\":\"No hay datos para este informe.\",\"General_Others\":\"Otros\",\"Actions_ActionType\":\"Tipo de acci\\u00f3n\",\"Transitions_TopX\":\"Etiquetas %s superiores\",\"Transitions_AvailableInOtherReports\":\"\\u00bfSab\\u00edas? Las transiciones tambi\\u00e9n est\\u00e1n disponibles como una acci\\u00f3n de fila en los siguientes informes:\",\"Actions_SubmenuPageTitles\":\"T\\u00edtulos de p\\u00e1gina\",\"Actions_SubmenuPagesEntry\":\"P\\u00e1ginas de entrada\",\"Actions_SubmenuPagesExit\":\"P\\u00e1ginas de salida\",\"Transitions_AvailableInOtherReports2\":\"Inicie las transiciones haciendo clic en su icono (%s) despu\\u00e9s de pasar el cursor sobre una fila en cualquiera de estos informes.\",\"Transitions_FeatureDescription\":\"Transiciones es un informe que muestra las cosas que sus visitantes hicieron directamente antes y despu\\u00e9s de ver una p\\u00e1gina determinada. Esta p\\u00e1gina explica c\\u00f3mo acceder, comprender y utilizar el potente informe \\\"Transiciones\\\".\",\"LanguagesManager_TranslationSearch\":\"Buscar traducci\\u00f3n\",\"LanguagesManager_AboutPiwikTranslations\":\"Acerca de las traducciones de Matomo\",\"Dashboard_AddPreviewedWidget\":\"A\\u00f1ade el m\\u00f3dulo al panel de control\",\"Dashboard_WidgetPreview\":\"Previsualizaci\\u00f3n del reproductor\",\"Dashboard_Maximise\":\"Maximizar\",\"Dashboard_Minimise\":\"Minimizar\",\"Dashboard_WidgetNotFound\":\"Reproductor no encontrado\",\"Dashboard_DashboardCopied\":\"Tablero actual copiado con \\u00e9xito al usuario seleccionado.\",\"Dashboard_Dashboard\":\"Tablero\",\"Dashboard_RemoveDefaultDashboardNotPossible\":\"El tablero predeterminado no puede ser eliminado\",\"General_HelpResources\":\"Recursos de ayuda\",\"General_Refresh\":\"Actualizar\",\"Dashboard_ManageDashboard\":\"Configurar el tablero\",\"Dashboard_AddAWidget\":\"A\\u00f1adir un m\\u00f3dulo\",\"Dashboard_ResetDashboard\":\"Reinicia el tablero\",\"Dashboard_ChangeDashboardLayout\":\"Modificar distribuci\\u00f3n del tablero\",\"Dashboard_RenameDashboard\":\"Renombrar el tablero\",\"Dashboard_RemoveDashboard\":\"Elimina el tablero\",\"Dashboard_SetAsDefaultWidgets\":\"Establecer como selecci\\u00f3n de m\\u00f3dulos por defecto\",\"Dashboard_CopyDashboardToUser\":\"Copiar tablero al usuario\",\"Dashboard_CreateNewDashboard\":\"Crear nuevo tablero\",\"General_ColumnHits\":\"Accesos\",\"General_ColumnNbVisits\":\"Visitas\",\"General_ColumnPageviews\":\"P\\u00e1ginas vistas\",\"General_ColumnRevenue\":\"Ingresos\",\"General_TotalVisitsPageviewsActionsRevenue\":\"(Total: %1$s visitas, %2$s p\\u00e1ginas vistas, %3$s acciones, %4$s ingresos)\",\"General_AllWebsitesDashboard\":\"Panel de todos los sitios web\",\"General_NVisits\":\"%s visitas\",\"General_TotalRevenue\":\"Ingresos totales\",\"MultiSites_Evolution\":\"Evoluci\\u00f3n\",\"SitesManager_AddSite\":\"A\\u00f1adir un sitio web\",\"General_Next\":\"Siguiente\",\"General_Previous\":\"Anterior\",\"General_GoTo\":\"Ir a %s\",\"Dashboard_DashboardOf\":\"Tablero de %s\",\"Actions_SubmenuSitesearch\":\"B\\u00fasqueda interna\",\"MultiSites_LoadingWebsites\":\"Cargando sitios de internet\",\"General_ClickToSearch\":\"Clic para buscar\",\"General_NeedMoreHelp\":\"Necesita m\\u00e1s ayuda?\",\"General_Faq\":\"FAQ\",\"Feedback_CommunityHelp\":\"Ayuda comunitaria\",\"Feedback_ProfessionalHelp\":\"Ayuda profesional\",\"MultiSites_AllWebsitesDashboardTitle\":\"Toda las p\\u00e1ginas web\",\"MultiSites_EvolutionComparisonIncomplete\":\"El per\\u00edodo de tiempo seleccionado actualmente est\\u00e1 %1$s completo.\",\"MultiSites_EvolutionComparisonProportional\":\"Cuando el per\\u00edodo anterior tambi\\u00e9n fue %1$s completo, se habr\\u00eda estimado un total de %2$s %3$s\\n(de un total de %4$s %3$s en el per\\u00edodo anterior).\",\"MultiSites_EvolutionComparisonDay\":\"%1$s %2$s este d\\u00eda comparado con %3$s %2$s en el per\\u00edodo parcial anterior (%4$s) Evoluci\\u00f3n: %5$s\",\"MultiSites_EvolutionComparisonWeek\":\"%1$s %2$s esta semana en comparaci\\u00f3n con %3$s %2$s en el per\\u00edodo parcial anterior (%4$s) Evoluci\\u00f3n: %5$s\",\"MultiSites_EvolutionComparisonMonth\":\"%1$s %2$s este mes comparado con %3$s %2$s en el periodo parcial anterior (%4$s) Evoluci\\u00f3n: %5$s\",\"MultiSites_EvolutionComparisonYear\":\"%1$s %2$s este a\\u00f1o comparado con %3$s %2$s en el periodo parcial anterior (%4$s) Evoluci\\u00f3n: %5$s\",\"MultiSites_EvolutionFromPreviousDay\":\"Desde el d\\u00eda anterior\",\"MultiSites_EvolutionFromPreviousMonth\":\"Desde el mes anterior\",\"MultiSites_EvolutionFromPreviousPeriod\":\"Desde el periodo anterior\",\"MultiSites_EvolutionFromPreviousWeek\":\"Desde la semana anterior\",\"MultiSites_EvolutionFromPreviousYear\":\"Desde el a\\u00f1o anterior\",\"MultiSites_TotalHits\":\"Total de accesos\",\"MultiSites_TotalPageviews\":\"P\\u00e1ginas vistas en total\",\"MultiSites_TotalVisits\":\"Visitas totales\",\"MultiSites_AllWebsitesDashboardErrorMessage\":\"Data is currently unavailable. This could be due to a temporary server issue or the report containing too much data. Please try again later. If the problem continues, please contact your Matomo administrator for assistance.\",\"MultiSites_MetricDocumentationWebsite\":\"The list of tracked websites displayed in the dashboard. Each row represents a separate website with its corresponding analytics data.\",\"MultiSites_MetricDocumentationVisits\":\"The total number of visits recorded for this website. A visit starts when a user accesses the site and ends after a period of inactivity or when the session expires.\",\"MultiSites_MetricDocumentationPageviews\":\"The total number of pages viewed on this website. This includes multiple views of the same page by a single visitor.\",\"MultiSites_MetricDocumentationHits\":\"The total number of recorded actions for this website, including pageviews, downloads, and outlinks.\",\"MultiSites_MetricDocumentationRevenue\":\"The total revenue tracked for this website. This metric is available if Ecommerce tracking is enabled and reflects purchases or goal-based revenue.\",\"MultiSites_MetricDocumentationEvolution\":\"The percentage change for this metric compared to the previous period for this website. A positive value indicates growth, while a negative value signals a decrease.\",\"General_Required2\":\"Necesario\",\"Referrers_CampaignSource\":\"Fuente de la campa\\u00f1a\",\"Referrers_CampaignSourceHelp\":\"Se utiliza para rastrear el origen de la campa\\u00f1a, como el 'bolet\\u00edn informativo' de su estrategia de marketing por correo electr\\u00f3nico, 'afiliado' o el nombre del sitio web que muestra sus anuncios.\",\"Referrers_CampaignContent\":\"Contenido de la campa\\u00f1a\",\"Referrers_CampaignContentHelp\":\"Este par\\u00e1metro se usa a menudo cuando est\\u00e1 probando varios anuncios, e incluir\\u00eda el nombre de cada anuncio para ver cu\\u00e1l fue el m\\u00e1s efectivo para dirigir el tr\\u00e1fico.\",\"Referrers_CampaignMedium\":\"Medio de la campa\\u00f1a\",\"Referrers_CampaignMediumHelp\":\"Se usa para describir la actividad de marketing, por ejemplo, 'PPC' para una campa\\u00f1a de pago-por-clic, o 'SEM' para anuncios de b\\u00fasqueda pagados, o 'revisi\\u00f3n' para rastrear una revisi\\u00f3n de producto en un sitio afiliado.\",\"Referrers_CampaignGroup\":\"Grupo de campa\\u00f1a\",\"Referrers_CampaignGroupHelp\":\"Este par\\u00e1metro se utiliza para el seguimiento de un Grupo de Campa\\u00f1a para identificar un grupo o audiencia. Los grupos de campa\\u00f1a son \\u00fatiles para el seguimiento del rendimiento general de m\\u00faltiples campa\\u00f1as con objetivos similares.\",\"Referrers_CampaignPlacement\":\"Ubicaci\\u00f3n de la campa\\u00f1a\",\"Referrers_CampaignPlacementHelp\":\"Se utiliza para describir la colocaci\\u00f3n o posici\\u00f3n de la publicidad, por ejemplo, un sitio web completo, p\\u00e1ginas espec\\u00edficas de un sitio web, un bloque de anuncios individual colocado en una sola p\\u00e1gina, un v\\u00eddeo, una aplicaci\\u00f3n de tel\\u00e9fono m\\u00f3vil, etc.\",\"Referrers_CampaignId\":\"Identificaci\\u00f3n de la campa\\u00f1a\",\"Referrers_CampaignIdHelp\":\"Este par\\u00e1metro se usa para rastrear una ID de campa\\u00f1a: un identificador \\u00fanico para la campa\\u00f1a que consta de 100 n\\u00fameros, letras o s\\u00edmbolos como m\\u00e1ximo.\",\"Referrers_CampaignPageUrlHelp\":\"La URL de la p\\u00e1gina para esta campa\\u00f1a, por ejemplo, 'http:\\\/\\\/example.org\\\/offer.html'.\",\"Referrers_CampaignNameHelp\":\"Elija un nombre que describa para qu\\u00e9 se cre\\u00f3 la campa\\u00f1a y que distingue su campa\\u00f1a de sus otras campa\\u00f1as. Por ejemplo, 'Email-SummerDeals' o 'PaidAds-SummerDeals'.\",\"Referrers_CampaignKeywordHelp\":\"Si tiene varias campa\\u00f1as con el mismo nombre, puede distinguir estas campa\\u00f1as especificando una palabra clave o una subcategor\\u00eda.\",\"Referrers_URLCampaignBuilderResult\":\"URL generada que puede copiar y pegar en sus campa\\u00f1as, bolet\\u00edn informativo por correo electr\\u00f3nico, anuncios de Facebook o tweets:\",\"Referrers_GenerateUrl\":\"Generar URL\",\"Goals_Optional\":\"(opcional)\",\"DevicesDetection_UserAgent\":\"Agente de usuario\",\"DevicesDetection_BotDetected\":\"Este agente-de-usuario es detectado como %1$s. Los visitantes con este tipo de agente de usuario no ser\\u00e1 monitoreado de manera predeterminado por Matomo.\",\"DevicesDetection_ColumnOperatingSystem\":\"Sistemas operativos\",\"Mobile_ShowAll\":\"Mostrar todo\",\"DevicesDetection_OperatingSystemFamily\":\"Familia de sistema operativo\",\"DevicesDetection_ColumnBrowser\":\"Navegador\",\"DevicesDetection_BrowserFamily\":\"Familia de navegador\",\"DevicesDetection_Device\":\"Dispositivo\",\"DevicesDetection_dataTableLabelTypes\":\"Tipo\",\"DevicesDetection_dataTableLabelBrands\":\"Marca\",\"DevicesDetection_dataTableLabelModels\":\"Modelo\",\"DevicesDetection_ClientHints\":\"Consejos para el cliente\",\"DevicesDetection_ConsiderClientHints\":\"Considere las sugerencias del cliente\",\"DevicesDetection_ClientHintsNotSupported\":\"Su navegador no admite sugerencias de clientes.\",\"Goals_AddGoal\":\"Agregar objetivo\",\"Goals_AddNewGoal\":\"Agregar un nuevo objetivo\",\"Goals_UpdateGoal\":\"Actualizar objetivo\",\"Goals_DeleteGoalConfirm\":\"\\u00bfEst\\u00e1 seguro que desea eliminar el objetivo %s?\",\"Goals_Ecommerce\":\"Comercio Electr\\u00f3nico\",\"Goals_TimeInMinutes\":\"Tiempo en minutos\",\"Goals_Pattern\":\"Patr\\u00f3n\",\"Goals_ClickToViewThisGoal\":\"Haga clic para ver este objetivo.\",\"Goals_ManageGoals\":\"Administrar objetivos\",\"Goals_GoalName\":\"Nombre del objetivo\",\"Goals_GoalIsTriggeredWhen\":\"Objetivo activado cuando\",\"Goals_ThereIsNoGoalToManage\":\"No existe meta para administrar para el sitio de internet %s\",\"Goals_ManuallyTriggeredUsingJavascriptFunction\":\"Los objetivos son manualmente activados usando la API Javascript trackGoal()\",\"Goals_VisitUrl\":\"Visita a una URL dada (p\\u00e1gina o grupo de p\\u00e1ginas)\",\"Goals_ClickOutlink\":\"Clic en un enlace a un sitio de internet externo\",\"Goals_SendEvent\":\"Enviar un evento\",\"Goals_GoalIsTriggered\":\"Objetivo activado\",\"Goals_WhereThe\":\"donde el\",\"Goals_URL\":\"URL\",\"Goals_Contains\":\"contiene %s\",\"Goals_IsExactly\":\"es exactamente %s\",\"Goals_MatchesExpression\":\"coincide con la expresi\\u00f3n %s\",\"Goals_AllowMultipleConversionsPerVisit\":\"Permitir m\\u00faltiples conversiones por visita\",\"Goals_HelpOneConversionPerVisit\":\"Si una p\\u00e1gina que coincide con este objetivo es actualizada o vista m\\u00e1s de una vez en una visita, el objetivo solo ser\\u00e1 convertido la primera vez que la p\\u00e1gina fue cargada durante la visita.\",\"Goals_DefaultRevenueHelp\":\"Por ejemplo, un Formulario de Contacto enviado por un visitante puede valer $10 en promedio. Matomo le ayudar\\u00e1 a entender que tan bien est\\u00e1n trabajando sus segmentos de visitantes.\",\"Goals_DefaultRevenueLabel\":\"Meta predeterminada de ingresos\",\"Goals_GoalRevenue\":\"Meta de ingresos\",\"Goals_Filename\":\"nombre de archivo\",\"Goals_ExternalWebsiteUrl\":\"URL del sitio de internet externo\",\"Goals_VisitDuration\":\"la duraci\\u00f3n de la visita es\",\"Goals_AtLeastMinutes\":\"al menos %1$s minutos. Use decimales para hacer coincidir segundos, por ejemplo, %2$s para hacer coincidir 30 segundos.\",\"Goals_VisitPageTitle\":\"Visitar un t\\u00edtulo de p\\u00e1gina suministrado\",\"Intl_NMinutes\":\"%s minutos\",\"Goals_PageTitle\":\"T\\u00edtulo de la p\\u00e1gina\",\"Goals_UseEventValueAsRevenue\":\"Utilice el valor del evento (si existe) como ingresos de conversi\\u00f3n de objetivos.\",\"Goals_EventValueAsRevenueHelp\":\"Si el evento que est\\u00e1 haciendo coincidir tiene un ingreso y ese ingreso se registra como el valor del evento, puede habilitar esta opci\\u00f3n para registrar el valor del evento como el ingreso de la conversi\\u00f3n del objetivo. Si la meta del ingreso no var\\u00eda seg\\u00fan la conversi\\u00f3n, puede ignorar esta opci\\u00f3n y simplemente establecer un ingreso predeterminado.\",\"Goals_EventValueAsRevenueHelp2\":\"Nota: Si se definen tanto una meta de ingreso predeterminado tanto como un valor del evento, se utilizar\\u00e1 el valor del evento. Si esta opci\\u00f3n est\\u00e1 habilitada y no se env\\u00eda ning\\u00fan valor del evento en una solicitud, se utilizar\\u00e1n los ingresos predeterminados (si est\\u00e1n definidos).\",\"Events_EventCategory\":\"Categor\\u00eda del evento\",\"Goals_WhereVisitedPageManuallyCallsJavascriptTrackerLearnMore\":\"La p\\u00e1gina visitada necesita contener una llamada al m\\u00e9todo Javascript 'trackGoal' (%1$ssaber m\\u00e1s%2$s)\",\"Goals_LearnMoreAboutGoalTrackingDocumentation\":\"Aprender m\\u00e1s acerca de %1$sRastrear objetivos en Matomo%2$s en la documentaci\\u00f3n de usuario.\",\"Goals_EcommerceReports\":\"Informes de Comercio Electr\\u00f3nico\",\"SitesManager_WebsitesManagement\":\"Administraci\\u00f3n de sitios de internet\",\"Goals_CaseSensitive\":\"Coincidir may\\u00fasculas y min\\u00fasculas\",\"Goals_Download\":\"Descargar un archivo\",\"Events_EventAction\":\"Acci\\u00f3n de evento\",\"Events_EventName\":\"Nombre del evento\",\"Goals_YouCanEnableEcommerceReports\":\"Puede habilitar %1$s para este sitio web en la p\\u00e1gina %2$s.\",\"Goals_CategoryTextGeneral_Actions\":\"Paginas\",\"General_ForExampleShort\":\"ej.\",\"General_OperationGreaterThan\":\"M\\u00e1s que\",\"General_OrCancel\":\"o %1$s Cancelar %2$s\",\"Goals_ConversionsOverview\":\"Vista general de conversiones\",\"General_Subtotal\":\"Subtotal (suma de importes)\",\"General_Tax\":\"Impuesto\",\"General_Shipping\":\"Env\\u00edo\",\"General_Discount\":\"Descuento\",\"Live_RowActionTooltipWithDimension\":\"Show the visits log segmented by this %s\",\"General_Goal\":\"Objetivo\",\"General_InfoFor\":\"Informaci\\u00f3n para %s\",\"General_NotInstalled\":\"No instalado\",\"General_Installed\":\"Instalado\",\"General_Broken\":\"Roto\",\"UserCountry_CurrentLocationIntro\":\"Este proveedor determina que tu ubicaci\\u00f3n actual es\",\"UserCountry_CannotLocalizeLocalIP\":\"La direcci\\u00f3n IP \\\"%s\\\" es local, por lo que no se puede geolocalizar.\",\"UserCountry_NoProviders\":\"No hay proveedores de geolocalizaci\\u00f3n adicionales en este momento. Se recomienda %1$sDB-IP%2$s, pero esto requiere el complemento GeoIp2. (Alternativamente, puede instalar un complemento de geolocalizaci\\u00f3n de terceros del mercado)\",\"General_Disabled\":\"Desactivado\",\"UserCountry_GeolocationPageDesc\":\"Aqu\\u00ed puede cambiar la forma en que Matomo determina la ubicaci\\u00f3n de los visitantes.\",\"UserCountry_LocationProvider\":\"Proveedor de la ubicaci\\u00f3n\",\"UserCountry_DistinctCountries\":\"%s pa\\u00edses distintos\",\"GeoIp2_FatalErrorDuringDownload\":\"A fatal error occurred while downloading this file. There might be something wrong with your internet connection, with the geolocation database you downloaded or Matomo. Try downloading and installing it manually.\",\"GeoIp2_SetupAutomaticUpdatesOfGeoIP\":\"Setup automatic updates of geolocation databases\",\"General_Done\":\"Hecho\",\"General_Continue\":\"Continuar\",\"GeoIp2_ISPRequiresProviderPlugin\":\"Tracking Internet service providers requires the Provider plugin to be installed and activated.\",\"GeoIp2_UpdaterWasLastRun\":\"El actualizador se ejecut\\u00f3 por \\u00faltima vez en %s.\",\"GeoIp2_UpdaterIsNotScheduledToRun\":\"No est\\u00e1 programada la ejecuci\\u00f3n en el futuro.\",\"GeoIp2_GeoIPUpdaterIntro\":\"Matomo is currently managing updates for the following databases\",\"GeoIp2_IWantToDownloadFreeGeoIP\":\"I want to download the free DBIP database\\u2026\",\"General_GetStarted\":\"Comenzar\",\"GeoIp2_GeoIPDatabases\":\"Bases de datos GeoIP\",\"GeoIp2_NotManagingGeoIPDBs\":\"Matomo is currently not managing any DBIP or MaxMind databases.\",\"GeoIp2_IPurchasedGeoIPDBs\":\"I purchased more accurate databases from %3$sdbip%4$s or %1$sMaxMind%2$s and want to setup automatic updates.\",\"UserCountry_GeoIpDbIpAccuracyNote\":\"Las bases de datos de geolocalizaci\\u00f3n DB-IP son gratuitas y se pueden descargar autom\\u00e1ticamente. MaxMind es m\\u00e1s preciso para las ciudades, pero requiere %1$shacer una cuenta%2$s.\",\"GeoIp2_GeoIPUpdaterInstructions\":\"Enter the download links for your databases below. If you've purchased databases from %3$sdbip%4$s or %1$sMaxMind%2$s, you can find these links in your dbip or MaxMind account. Please contact your geolocation database provider if you have trouble accessing them.\",\"GeoIp2_GeoLiteCityLink\":\"If you're using the dbip city lite database, use this link: %1$s%2$s%3$s\",\"UserCountry_MaxMindLinkExplanation\":\"%1$sHaga clic aqu\\u00ed para obtener informaci\\u00f3n sobre c\\u00f3mo generar su URL de descarga%2$s si est\\u00e1 utilizando la geolocalizaci\\u00f3n de MaxMind.\",\"GeoIp2_LocationDatabase\":\"Base de datos de ubicaciones\",\"Actions_ColumnDownloadURL\":\"URL de descarga\",\"GeoIp2_LocationDatabaseHint\":\"Una base de datos de ubicaci\\u00f3n es una base de datos sea un pa\\u00eds, regi\\u00f3n o ciudad.\",\"GeoIp2_ISPDatabase\":\"Base de dato ISP\",\"GeoIp2_DownloadNewDatabasesEvery\":\"Actualizar bases de datos cada\",\"GeoIp2_CannotSetupGeoIPAutoUpdating\":\"It seems like you're storing your geolocation databases outside of Matomo (we can tell since there are no databases in the misc subdirectory, but your GeoIP is working). Matomo cannot automatically update your geolocation databases if they are located outside of the misc directory.\",\"GeoIp2_UpdaterHasNotBeenRun\":\"El actualizador nunca se ha ejecutado.\",\"GeoIp2_UpdaterScheduledForNextRun\":\"Est\\u00e1 previsto ser activado durante la pr\\u00f3xima ejecuci\\u00f3n del comando cron core:archive.\",\"GeoIp2_UpdaterWillRunNext\":\"Est\\u00e1 programada la ejecuci\\u00f3n para el %s.\",\"GeoIp2_DownloadingDb\":\"Descargando %s\",\"Feedback_ThankYouHeart\":\"Thank you for helping us to make Matomo better! %1$s\",\"Feedback_ThankYouForSpreading\":\"Thank you for spreading the word and creating a safer web\",\"Feedback_RateFeatureTitle\":\"\\u00bfTe gusta la funci\\u00f3n '%s'? Por favor evaluala y deja un comentario\",\"Feedback_RateFeatureThankYouTitle\":\"\\u00a1Gracias por evaluar '%s'!\",\"Feedback_RateFeatureLeaveMessageLike\":\"\\u00a1Nos alegra que le guste! Por favor h\\u00e1ganos saber qu\\u00e9 es lo que m\\u00e1s le gusta y si hay otras funciones que le gustar\\u00eda tener.\",\"Feedback_RateFeatureLeaveMessageLikeNamedFeature\":\"What do you like most about %1$s?\",\"Feedback_RateFeatureLeaveMessageLikeExtra\":\"Please let us know more about how you use this feature so we can improve Matomo further.\",\"Feedback_RateFeatureLeaveMessageLikeExtraConfigurable\":\"Are there any configuration options you find particularly useful? Are there any other options you would like to see?\",\"Feedback_RateFeatureLeaveMessageLikeExtraEasy\":\"Is there anything else that could make Matomo easier to use or improve your experience?\",\"Feedback_RateFeatureLeaveMessageLikeExtraUseful\":\"Can you let us know a bit about how you use this information and what you find most useful about it?\",\"Feedback_RateFeatureLeaveMessageDislike\":\"\\u00bfC\\u00f3mo podemos mejorar esta funci\\u00f3n?\",\"Feedback_RateFeatureLeaveMessageDislikeNamedFeature\":\"\\u00bfC\\u00f3mo podemos mejorar %1$s?\",\"Feedback_RateFeatureLeaveMessageDislikeExtra\":\"H\\u00e1ganos saber qu\\u00e9 podemos mejorar para que podamos hacer que Matomo sea a\\u00fan mejor.\",\"Feedback_RateFeatureLeaveMessageDislikeExtraBugs\":\"We're sorry that you encountered issues, please let us know more about what didn't work.\",\"Feedback_RateFeatureLeaveMessageDislikeExtraMissing\":\"Which features are you missing?\",\"Feedback_RateFeatureLeaveMessageDislikeExtraSpeed\":\"Could you provide an indication of how slow this feature is for you? Could you share how many visits per month you would typically record?\",\"Feedback_RateFeatureLeaveMessageDislikeExtraEasier\":\"Was there a particular part of this feature you found difficult to use?\",\"Feedback_RateFeatureOtherReason\":\"Other reason\",\"Feedback_SendFeedback\":\"Enviar comentario\",\"Feedback_RateFeatureSendFeedbackInformation\":\"Su plataforma Matomo nos enviar\\u00e1 a nosotros (el Equipo de Matomo) un correo electr\\u00f3nico (incluso su direcci\\u00f3n de correo electr\\u00f3nico) para que podamos contactarnos en caso de que tenga preguntas.\",\"Feedback_RateFeatureUsefulInfo\":\"Useful information\",\"Feedback_RateFeatureEasyToUse\":\"Easy to use\",\"Feedback_RateFeatureConfigurable\":\"Configurable\",\"Feedback_RateFeatureDislikeAddMissingFeatures\":\"Add missing features\",\"Feedback_RateFeatureDislikeMakeEasier\":\"Make it easier to use\",\"Feedback_RateFeatureDislikeSpeedUp\":\"Improve speed\",\"Feedback_RateFeatureDislikeFixBugs\":\"Fix bugs\",\"Feedback_ReviewMatomoTitle\":\"Like Matomo?\",\"Feedback_PleaseLeaveExternalReviewForMatomo\":\"Comparte sus pensamientos en uno de estos sitios e inspira a otros a unirse en nuestra revoluci\\u00f3n de datos.\",\"Feedback_RemindMeLater\":\"Record\\u00e1rmelo nuevamente\",\"Feedback_NeverAskMeAgain\":\"No volver a pregunt\\u00e1rmelo\",\"Feedback_WontShowAgain\":\"We won't show this message again.\",\"Feedback_AppreciateFeedback\":\"We really appreciate your feedback\",\"Feedback_Policy\":\"Your message and your email address will be sent to us by submitting this form. The information will be only used to improve our products and services. Your data will be processed by us, our hosting provider, and our support ticket provider. For more information have a look at %1$sMatomo's Privacy Policy%2$s.\",\"General_Ok\":\"Aceptar\",\"Feedback_Question0\":\"What are your biggest problems or pain points with Matomo and why?\",\"Feedback_Question1\":\"What is the one thing you\\u2019d like to see improved in Matomo and why?\",\"Feedback_Question2\":\"What is the feature you are missing the most in Matomo and why?\",\"Feedback_Question3\":\"What is your main goal for using Matomo?\",\"Feedback_Question4\":\"What is your main concern about Matomo?\",\"Feedback_FeedbackTitle\":\"Please help us improve Matomo\",\"Feedback_FeedbackSubtitle\":\"Here's your chance to ask for it! Please describe in as much details as you can. <br\\\/> Your feedback will help us improve Matomo. %1$s\",\"Feedback_ThankYourForFeedback\":\"We really appreciate your feedback! %1$s We will be in touch in case we require more information about your feedback.\",\"Feedback_ThankYou\":\"\\u00a1Gracias por ayudarnos a hacer Matomo aun mejor!\",\"Feedback_MessageBodyValidationError\":\"The message body is too short (minimum is 10 characters).\",\"Login_CurrentlyBlockedIPs\":\"IPs actualmente bloqueadas\",\"Login_CurrentlyBlockedIPsUnblockInfo\":\"Puede desbloquear las direcciones IP que est\\u00e1n actualmente bloqueadas para que puedan iniciar sesi\\u00f3n nuevamente en caso de que hayan sido marcadas falsamente y necesiten poder iniciar sesi\\u00f3n nuevamente.\",\"Login_UnblockAllIPs\":\"Desbloquear todas las IPs actualmente bloqueadas\",\"Login_CurrentlyBlockedIPsUnblockConfirm\":\"Est\\u00e1 seguro que desea desbloquear todas las IPs actualmente bloqueadas?\",\"Login_IPsAlwaysBlocked\":\"Estas IPs est\\u00e1n siempre bloqueadas\",\"TwoFactorAuth_WarningChangingConfiguredDevice\":\"Est\\u00e1 a punto de cambiar el dispositivo de autenticaci\\u00f3n de dos factores actualmente configurado. Esta acci\\u00f3n invalidar\\u00e1 cualquier dispositivo configurado previamente.\",\"TwoFactorAuth_SetupIntroFollowSteps\":\"Por favor siga los siguientes pasos para configurar la autenticaci\\u00f3n en dos factores:\",\"TwoFactorAuth_StepX\":\"Paso %s\",\"TwoFactorAuth_RecoveryCodes\":\"C\\u00f3digos de recuperaci\\u00f3n\",\"TwoFactorAuth_RecoveryCodesExplanation\":\"Puede usar c\\u00f3digos de recuperaci\\u00f3n para acceder a su cuenta cuando no puede recibir c\\u00f3digos de autenticaci\\u00f3n de dos factores, por ejemplo, cuando no tiene su dispositivo m\\u00f3vil consigo mismo.\",\"TwoFactorAuth_RecoveryCodesSecurity\":\"\\u00a1Trate sus c\\u00f3digos de recuperaci\\u00f3n con el mismo nivel de seguridad que su contrase\\u00f1a!\",\"TwoFactorAuth_RecoveryCodesAllUsed\":\"Se han utilizado todos los c\\u00f3digos de recuperaci\\u00f3n, se recomienda que vuelva a regenerar sus c\\u00f3digos de recuperaci\\u00f3n.\",\"General_Print\":\"Imprimir\",\"TwoFactorAuth_SetupBackupRecoveryCodes\":\"Realice una copia de seguridad de sus c\\u00f3digos de recuperaci\\u00f3n utilizando uno de los anteriores m\\u00e9todos antes de continuar con la configuraci\\u00f3n de autenticaci\\u00f3n de dos factores.\",\"TwoFactorAuth_SetupAuthenticatorOnDeviceStep1\":\"Instale una aplicaci\\u00f3n de autenticaci\\u00f3n, por ejemplo:\",\"General_Or\":\"o\",\"TwoFactorAuth_ConfirmSetup\":\"Confirmar configuraci\\u00f3n\",\"TwoFactorAuth_VerifyAuthCodeIntro\":\"Por favor, introduzca el c\\u00f3digo de seis d\\u00edgitos de su aplicaci\\u00f3n OTP a continuaci\\u00f3n para confirmar que ha configurado correctamente su dispositivo.\",\"TwoFactorAuth_AuthenticationCode\":\"C\\u00f3digo de autenticaci\\u00f3n\",\"TwoFactorAuth_VerifyAuthCodeHelp\":\"Por favor, introduzca el c\\u00f3digo de seis d\\u00edgitos que se ha generado en su dispositivo m\\u00f3vil despu\\u00e9s de escanear el c\\u00f3digo de barras.\",\"TwoFactorAuth_SetupAuthenticatorOnDeviceStep2ShowCodes\":\"Open the OTP app on your mobile device, then click the \\\"%1$s\\\" button below and either scan the QR code or manually enter the code if scanning isn't possible.\",\"TwoFactorAuth_ShowCodes\":\"Show codes\",\"TwoFactorAuth_DontHaveOTPApp\":\"Don't have an OTP app?\",\"TwoFactorAuth_ShowCodeModalInstructions1\":\"Open your OTP app and scan this QR code\",\"TwoFactorAuth_ShowCodeModalInstructions2\":\"or manually enter the following code\",\"TwoFactorAuth_ShowCodeModalInstructions3\":\"and click \\\"%1$s\\\" to get to the next step.\",\"TwoFactorAuth_SetupAuthenticatorOnDevice\":\"Configure su aplicaci\\u00f3n de autenticaci\\u00f3n en su dispositivo\",\"TwoFactorAuth_TwoFactorAuthentication\":\"Autenticaci\\u00f3n de dos factores\",\"TwoFactorAuth_VerifyIdentifyExplanation\":\"Abra la aplicaci\\u00f3n de autenticaci\\u00f3n de dos factores en su dispositivo para ver su c\\u00f3digo de autenticaci\\u00f3n y verificar su identidad.\",\"TwoFactorAuth_DontHaveYourMobileDevice\":\"No posee su dispositivo m\\u00f3vil?\",\"TwoFactorAuth_EnterRecoveryCodeInstead\":\"Introduzca uno de los c\\u00f3digos de recuperaci\\u00f3n\",\"TwoFactorAuth_NotPossibleToLogIn\":\"No se puede iniciar sesi\\u00f3n en Matomo Analytics\",\"TwoFactorAuth_LostAuthenticationDevice\":\"Hola, %1$s tengo la autenticaci\\u00f3n de dos factores habilitada y perd\\u00ed mi dispositivo de autenticaci\\u00f3n. \\u00bfPodr\\u00edas restablecer la autenticaci\\u00f3n de dos factores para mi nombre de usuario %5$s? Puede encontrar las instrucciones para esto aqu\\u00ed: %6$s.%2$sLa URL de Matomo es %3$s.%4$sGracias\",\"TwoFactorAuth_AskSuperUserResetAuthenticationCode\":\"Pida al superusuario que restablezca su c\\u00f3digo de autenticaci\\u00f3n\",\"General_Logout\":\"Desconectarse\",\"TwoFactorAuth_Your2FaAuthSecret\":\"Su secreto de autenticaci\\u00f3n de dos factores\",\"TwoFactorAuth_GenerateNewRecoveryCodes\":\"Generar nuevos c\\u00f3digos de recuperaci\\u00f3n\",\"TwoFactorAuth_GenerateNewRecoveryCodesInfo\":\"Cuando genera nuevos c\\u00f3digos de recuperaci\\u00f3n, sus antiguos c\\u00f3digos ya no funcionar\\u00e1n. Aseg\\u00farese de descargar o imprimir sus nuevos c\\u00f3digos.\",\"TwoFactorAuth_RecoveryCodesRegenerated\":\"Los c\\u00f3digos de recuperaci\\u00f3n han sido regenerados. Aseg\\u00farese de descargarlos o imprimir los c\\u00f3digos reci\\u00e9n generados.\",\"General_ExceptionSecurityCheckFailed\":\"Lo sentimos, pero la acci\\u00f3n que estaba intentando realizar fall\\u00f3 debido a un control de seguridad. Esta es una medida est\\u00e1ndar para garantizar la seguridad de su cuenta. Vuelva a intentarlo y, si el problema persiste, p\\u00f3ngase en contacto con nuestro equipo de soporte para obtener m\\u00e1s ayuda.\",\"TwoFactorAuth_TwoFAShort\":\"2FA\",\"TwoFactorAuth_TwoFactorAuthenticationIntro\":\"La %1$sautenticaci\\u00f3n de dos factores%2$s aumenta la seguridad de su cuenta al agregar un nivel adicional de verificaci\\u00f3n al iniciar sesi\\u00f3n. Cada vez que inicie sesi\\u00f3n, no solo se le pedir\\u00e1 que proporcione su nombre de usuario y contrase\\u00f1a, sino tambi\\u00e9n un token de autenticaci\\u00f3n adicional que cambia peri\\u00f3dicamente y es generado, por ejemplo, en su dispositivo m\\u00f3vil. Esto significa que incluso cuando alguien conozca su nombre de usuario y contrase\\u00f1a, no podr\\u00e1n iniciar sesi\\u00f3n a menos que tengan acceso a su dispositivo m\\u00f3vil, por ejemplo.\",\"TwoFactorAuth_TwoFactorAuthenticationIsEnabled\":\"Autenticaci\\u00f3n de dos factores est\\u00e1 actualmente habilitada.\",\"TwoFactorAuth_TwoFactorAuthenticationRequired\":\"La autenticaci\\u00f3n de dos factores es obligatoria para que todos puedan usarla, no puede deshabilitarla.\",\"TwoFactorAuth_ConfigureDifferentDevice\":\"Configurar un dispositivo diferente\",\"TwoFactorAuth_DisableTwoFA\":\"Deshabilitar la autenticaci\\u00f3n de dos factores\",\"TwoFactorAuth_ShowRecoveryCodes\":\"Mostrar c\\u00f3digos de recuperaci\\u00f3n\",\"TwoFactorAuth_TwoFactorAuthenticationIsDisabled\":\"Autenticaci\\u00f3n de dos factores est\\u00e1 actualmente deshabilitada.\",\"TwoFactorAuth_EnableTwoFA\":\"Habilitar la autenticaci\\u00f3n de dos factores\",\"TwoFactorAuth_ConfirmDisableTwoFA\":\"\\u00bfEst\\u00e1 seguro de que desea deshabilitar la autenticaci\\u00f3n de dos factores para su cuenta? Tener habilitada la autenticaci\\u00f3n de dos factores aumenta la seguridad de la misma.\",\"TwoFactorAuth_RequiredToSetUpTwoFactorAuthentication\":\"Debe configurar la autenticaci\\u00f3n de dos factores antes de iniciar sesi\\u00f3n\",\"TwoFactorAuth_SetUpTwoFactorAuthentication\":\"Configurar autenticaci\\u00f3n de dos factores (2FA)\",\"TwoFactorAuth_SetupFinishedTitle\":\"\\u00a1Enhorabuena! Su cuenta ahora es m\\u00e1s segura.\",\"TwoFactorAuth_SetupFinishedSubtitle\":\"Ya ha configurado con \\u00e9xito la autenticaci\\u00f3n de dos factores. La pr\\u00f3xima vez que inicie sesi\\u00f3n, tambi\\u00e9n deber\\u00e1 introducir un c\\u00f3digo de autenticaci\\u00f3n. No se olvide de llevar consigo su m\\u00f3vil o sus c\\u00f3digos de seguridad.\",\"TwoFactorAuth_Verify\":\"Verificar\",\"General_Actions\":\"Acciones\",\"General_Add\":\"A\\u00f1adir\",\"General_ChangePassword\":\"Cambiar contrase\\u00f1a\",\"General_CreationDate\":\"Fecha de creaci\\u00f3n\",\"General_Language\":\"Idioma\",\"General_Never\":\"Nunca\",\"General_NotAvailable\":\"N\\\/A\",\"General_Note\":\"Nota\",\"General_Password\":\"Contrase\\u00f1a\",\"General_PleaseTryAgain\":\"Por favor intente otra vez\",\"General_TimeFormat\":\"Formato de hora\",\"General_Username\":\"Nombre de usuario\",\"General_ValidatorErrorEmptyValue\":\"Debe suministrarse un valor.\",\"Login_NewPassword\":\"Nueva contrase\\u00f1a\",\"Login_NewPasswordRepeat\":\"Nueva contrase\\u00f1a (repetir)\",\"Mobile_NavigationBack\":\"Atr\\u00e1s\",\"UsersManager_2FA\":\"2FA\",\"UsersManager_Active\":\"Activo\",\"UsersManager_AddExistingUser\":\"Agregar un usuario existente\",\"UsersManager_AddNewUser\":\"Add new user\",\"UsersManager_AddSuperuserAccessConfirm\":\"Dar a un usuario acceso de superusuario permite al usuario en cuesti\\u00f3n tener control total sobre Matomo y debe hacerse con cautela.\",\"UsersManager_AllUsersAreSelected\":\"Todos los usuarios %1$s est\\u00e1n seleccionados.\",\"UsersManager_AllWebsitesAreSelected\":\"Todos los sitios web %1$s est\\u00e1n seleccionados.\",\"UsersManager_AnonymousUserRoleChangeWarning\":\"Darle al %1$susuario el %2$s rol har\\u00e1 que los datos de este sitio web sean p\\u00fablicos y est\\u00e9n disponibles para todos, incluso si no tienen un inicio de sesi\\u00f3n de Matomo.\",\"UsersManager_AreYouSure\":\"Est\\u00e1 seguro?\",\"UsersManager_AreYouSureAddCapability\":\"\\u00bfEst\\u00e1 seguro que desea otorgarle %1$sla%2$sfacultad de %3$s?\",\"UsersManager_AreYouSureChangeDetails\":\"Est\\u00e1 seguro que desea cambiar la informaci\\u00f3n del usuario por %s?\",\"UsersManager_AreYouSureRemoveCapability\":\"\\u00bfEst\\u00e1 seguro que desea quitar la %1$sfacultad de %2$s para %3$s?\",\"UsersManager_AuthTokenSecureOnlyHelp\":\"Enable this option to only allow this token to be used in a secure way (e.g. POST requests), this is recommended as a best security practice. The token will then not be valid as a URL parameter in GET requests.\",\"UsersManager_AuthTokenSecureOnlyHelpForced\":\"The system administrator has configured Matomo to only allow tokens to be created for use in secure way (e.g. via POST requests), you cannot change this token option.\",\"UsersManager_AuthTokenPurpose\":\"What are you using this token for?\",\"UsersManager_AuthTokens\":\"Auth tokens\",\"UsersManager_BackToUser\":\"Back to Users\",\"UsersManager_BasicInformation\":\"Informaci\\u00f3n b\\u00e1sica\",\"UsersManager_BulkActions\":\"Acciones masivas\",\"UsersManager_Capabilities\":\"Facultades\",\"UsersManager_CapabilitiesHelp\":\"Las capacidades son habilidades individuales que los usuarios pueden otorgar. Los roles pueden, por defecto, otorgar ciertas capacidades. Por ejemplo, el rol de administrador permitir\\u00e1 autom\\u00e1ticamente a los usuarios editar identificadores en el Tag Manager. Sin embargo, para usuarios menos poderosos, puede otorgar expl\\u00edcitamente capacidades a sus usuarios.\",\"UsersManager_ChangePermToAllSitesConfirm\":\"\\u00bfEst\\u00e1 seguro que desea otorgar al %1$susuario%2$s acceso a cada sitio web que actualmente usted tiene atributos de administrador?\",\"UsersManager_ChangePermToAllSitesConfirm2\":\"Nota: esto solo afectar\\u00e1 a los sitios web actualmente existentes. El usuario no podr\\u00e1 acceder autom\\u00e1ticamente a los nuevos sitios web que pueda crear.\",\"UsersManager_ChangePermToSiteConfirmMultiple\":\"\\u00bfEst\\u00e1 seguro que desea cambiar los roles de %1$s a los %2$s sitios web seleccionados a %3$s?\",\"UsersManager_ChangePermToSiteConfirmSingle\":\"\\u00bfEst\\u00e1 seguro que desea cambiar la funci\\u00f3n de %1$s de %2$s a %3$s?\",\"UsersManager_ClickHereToDeleteTheCookie\":\"Haga clic aqu\\u00ed para borrar la cookie y permitir que Matomo realice un seguimiento de sus visitas\",\"UsersManager_ClickHereToSetTheCookieOnDomain\":\"Haga clic aqu\\u00ed para configurar la cookie que excluir\\u00e1 sus visitas a los sitios de internet a los que Matomo realiza seguimiento en %s\",\"UsersManager_ClickToSelectAll\":\"Clic para selecionar todo %1$s.\",\"UsersManager_ClickToSelectDisplayedUsers\":\"Clic para seleccionar los %1$susuarios expuestos\",\"UsersManager_ClickToSelectDisplayedWebsites\":\"Clic para seleccionar los %1$s sitios web mostrados.\",\"UsersManager_ConfirmGrantSuperUserAccess\":\"\\u00bfEst\\u00e1s seguro que desea conceder acceso 'Super User' a '%s'? Atenci\\u00f3n: el usuario tendr\\u00e1 acceso a todos los sitios de internet y podr\\u00e1 realizar tareas administrativas.\",\"UsersManager_ConfirmProhibitMySuperUserAccess\":\"\\u00bf%s, est\\u00e1 seguro que desea eliminar su acceso Super Usuario? Perder\\u00e1 todos los permisos y accesos a todos los sitios de internet y ser\\u00e1 desconectado de Matomo.\",\"UsersManager_ConfirmProhibitOtherUsersSuperUserAccess\":\"\\u00bfEst\\u00e1 seguro que desea quitar el acceso Super Usuario de '%s'? Este perder\\u00e1 todos los permisos y accesos a todos los sitios. Aseg\\u00farese de dar acceso a los sitios necesarios despu\\u00e9s si es necesario.\",\"UsersManager_ConfirmTokenCopied\":\"I confirm I copied the token and understand I should not share this token with anyone else.\",\"UsersManager_CopyDenied\":\"The request is not allowed due to your browser's settings.\",\"UsersManager_CopyDeniedHints\":\"Please try again by either switching browsers or copying and sharing this link directly instead: %1$s\",\"UsersManager_CopyLink\":\"Copy invite link\",\"UsersManager_CreateNewToken\":\"Create new token\",\"UsersManager_Decline\":\"Invite declined\",\"UsersManager_DeleteAllTokens\":\"Delete all tokens\",\"UsersManager_DeleteConfirm\":\"\\u00bfEst\\u00e1 seguro que desea eliminar al usuario %s?\",\"UsersManager_DeleteNotSuccessful\":\"An error occurred while removing the selected users. Some users might not have been removed.\",\"UsersManager_DeletePermConfirmMultiple\":\"\\u00bfEst\\u00e1 seguro que desea quitar a %1$sdel acceso a estos sitios web %2$s?\",\"UsersManager_DeletePermConfirmSingle\":\"\\u00bfEst\\u00e1 seguro que desea quitar a %1$s del acceso a %2$s?\",\"UsersManager_DeleteSuccess\":\"The selected users have been removed.\",\"UsersManager_DeleteUserConfirmMultiple\":\"Est\\u00e1 seguro que desea eliminar estos usuarios seleccionados %1$s?\",\"UsersManager_DeleteUserConfirmSingle\":\"Est\\u00e1 seguro que desea eliminar %1$s?\",\"UsersManager_DeleteUserPermConfirmMultiple\":\"\\u00bfEst\\u00e1 seguro que desea cambiar el rol de los usuarios seleccionados %1$s a %2$s por %3$s?\",\"UsersManager_DeleteUserPermConfirmSingle\":\"Est\\u00e1 seguro que desea cambiar el rol de %1$s a%2$s por %3$s?\",\"UsersManager_DeleteUsers\":\"Eliminar usuarios\",\"UsersManager_DoNotStoreToken\":\"Do not share this token with anyone else as it is as secret as your login and password.\",\"UsersManager_EditUser\":\"Modificar usuario\",\"UsersManager_Email\":\"Correo electr\\u00f3nico\",\"UsersManager_EmailYourAdministrator\":\"%1$sEnviar un correo electr\\u00f3nico a su administrador acerca de este problema%2$s.\",\"UsersManager_EnterUsernameOrEmail\":\"Introduce un nombre de usuario o correo electr\\u00f3nico\",\"UsersManager_ExceptionNoValueForUsernameOrEmail\":\"Por favor introduce u nombre de usuario o un correo electr\\u00f3nico.\",\"UsersManager_ExceptionUserHasViewAccessAlready\":\"Este usuario ya tiene acceso al sitio web.\",\"UsersManager_ExcludeVisitsViaCookie\":\"Excluir sus visitas usando una cookie\",\"UsersManager_ExpireDate\":\"Expire date\",\"UsersManager_Expired\":\"Invite expired\",\"UsersManager_ExpiredInviteAutomaticallyRemoved\":\"Expired invites will be automatically deleted after %1$s days.\",\"UsersManager_ExpiredTokensDeleteAutomatically\":\"Tokens with an expire date will be deleted automatically.\",\"UsersManager_FilterByAccess\":\"Filtrar por acceso\",\"UsersManager_FilterByStatus\":\"Filter by status\",\"UsersManager_FilterByWebsite\":\"Filtrar por sitio web\",\"UsersManager_FirstSiteInlineHelp\":\"Es necesario otorgar a un nuevo usuario un rol de vista para un sitio web en el momento de la creaci\\u00f3n. Si as\\u00ed no fuera, el usuario ver\\u00e1 un error al iniciar sesi\\u00f3n. Puede otorgar m\\u00e1s permisos despu\\u00e9s de que el usuario es creado en la pesta\\u00f1a 'Permisos' que aparecer\\u00e1 a la izquierda.\",\"UsersManager_FirstWebsitePermission\":\"First website permission\",\"UsersManager_ForAnonymousUsersReportDateToLoadByDefault\":\"Para los usuarios an\\u00f3nimos, fecha del informe a cargar por defecto\",\"UsersManager_GiveAccessToAll\":\"Otorgar a este usuario acceso a todos los sitios web\",\"UsersManager_GiveUserAccess\":\"Otorgar acceso a '%1$s' %2$s para %3$s.\",\"UsersManager_GoBackSecurityPage\":\"Go back to security page.\",\"UsersManager_HasSuperUserAccess\":\"Posee acceso de Superusuario\",\"UsersManager_IfYouWouldLikeToChangeThePasswordTypeANewOne\":\"Si desea cambiar la contrase\\u00f1a, introduzca una nueva. Si no, d\\u00e9jelo vac\\u00edo.\",\"UsersManager_IncludedInUsersRole\":\"Inclu\\u00eddo en el rol del usuario.\",\"UsersManager_InjectedHostCannotChangePwd\":\"Est\\u00e1 actualmente visitando con un medio desconocido (%1$s). No puede cambiar su contrase\\u00f1a hasta que el problema est\\u00e9 soluionado.\",\"UsersManager_InvitationSent\":\"Invitation has been sent.\",\"UsersManager_InviteActionNotes\":\"Please notes that resending an invite or copy invite link will extend the time limit for previous invites by %1$s days.\",\"UsersManager_InviteConfirm\":\"UsersManager_InviteConfirm\",\"UsersManager_InviteConfirmMessage\":\"You can resend the invitation by copying the invite link and sharing directly with %1$s, or resend an invite email to %2$s.\",\"UsersManager_InviteDayLeft\":\"Expires in %s days\",\"UsersManager_InviteNewUser\":\"Invite a new user\",\"UsersManager_InviteSuccess\":\"Invitation sent.\",\"UsersManager_InviteSuccessNotification\":\"The invited user will receive an email to accept the invite. This invite is valid for %1$s days. You can also resend and delete the invite on the user management page.\",\"UsersManager_InviteUser\":\"Invite user\",\"UsersManager_LastSeen\":\"\\u00daltima visita\",\"UsersManager_LastUsed\":\"Last used\",\"UsersManager_LinkCopied\":\"Link copied to the clipboard\",\"UsersManager_ManageUsers\":\"Gestionar usuarios\",\"UsersManager_ManageUsersAdminDesc\":\"Create new users or update the existing users. You can then set their permissions here too. Please note that you are logged in as an administrator. This means you only see and manage users that have access to the specific websites where you have \\\"admin\\\" permissions. Only a user with super user access can see and manage all users across all websites.\",\"UsersManager_ManageUsersDesc\":\"Crear nuevos usuarios o actualizar los actuales. Despu\\u00e9s puede asignar permisos aqu\\u00ed tambi\\u00e9n.\",\"UsersManager_NewsletterSignupFailureMessage\":\"Whoops, something went wrong. We weren't able to sign you up for the newsletter.\",\"UsersManager_NewsletterSignupMessage\":\"Subscribe to our newsletter to receive regular information about Matomo. You can unsubscribe from it any time. This service uses MadMimi. Learn more about it on %1$sMatomo's Privacy Policy page%2$s.\",\"UsersManager_NewsletterSignupSuccessMessage\":\"Genial, ya te haz registrado! Estaremos en contacto pronto.\",\"UsersManager_NewsletterSignupTitle\":\"Newsletter Signup\",\"UsersManager_NoAccessWarning\":\"Este usuario no ha tenido acceso a un sitio web. Cuando inicien sesi\\u00f3n, ver\\u00e1n un mensaje de error. Para evitar esto, ot\\u00f3rgueles acceso a un sitio web a continuaci\\u00f3n.\",\"UsersManager_NoTokenCreatedYetCreateNow\":\"No token created yet, %1$screate a new token now%2$s.\",\"UsersManager_NoteNoAnonymousUserAccessSettingsWontBeUsed2\":\"Nota: No puede modificar la configuraci\\u00f3n en esta secci\\u00f3n, debido a que no posee ning\\u00fan sitio de internet que pueda ser contactado por un usuario an\\u00f3nimo.\",\"UsersManager_OrManageIndividually\":\"O gestionar individualmente el acceso de este usuario a cada uno de los sitios web\",\"UsersManager_PasswordChangeTerminatesOtherSessions\":\"When you change your password, any other active session of this account will be logged out.\",\"UsersManager_PasswordChangeDoesNotRevokeAuthTokens\":\"Changing your password won't revoke app-specific tokens. If you suspect unauthorized access, delete and regenerate them in the %1$s section at the bottom of the page.\",\"UsersManager_Pending\":\"Pending\",\"UsersManager_Permissions\":\"Autorizaciones\",\"UsersManager_PersonalSettings\":\"Ajustes personales\",\"UsersManager_PleaseStoreToken\":\"Please store your token securely as you will not be able to access or see the token again.\",\"UsersManager_PrivAdmin\":\"Administrador\",\"UsersManager_PrivNone\":\"Sin acceso\",\"UsersManager_PrivView\":\"Ver\",\"UsersManager_OnlyAllowSecureRequests\":\"Only allow secure requests\",\"UsersManager_RemovePermissions\":\"Eliminar permisos\",\"UsersManager_RemoveSuperuserAccessConfirm\":\"La eliminaci\\u00f3n del acceso de superusuario dejar\\u00e1 al usuario sin permisos (tendr\\u00e1 que a\\u00f1adirlos despu\\u00e9s). Introduzca su contrase\\u00f1a para continuar\",\"UsersManager_RemoveUserAccess\":\"Retirar acceso a '%1$s' para %2$s.\",\"UsersManager_ReportDateToLoadByDefault\":\"Fecha del informe a cargar por defecto\",\"UsersManager_ReportToLoadByDefault\":\"Informe a cargar por defecto\",\"UsersManager_ResendInvite\":\"Resend invite\",\"UsersManager_ResendInviteConfirmSingle\":\"UsersManager_ResendInviteConfirmSingle\",\"UsersManager_ResendInviteSuccess\":\"UsersManager_ResendInviteSuccess\",\"UsersManager_ResetTwoFactorAuthentication\":\"Restablecer autenticaci\\u00f3n de dos factores\",\"UsersManager_ResetTwoFactorAuthenticationInfo\":\"Si el usuario ya no puede iniciar sesi\\u00f3n debido a la p\\u00e9rdida de los c\\u00f3digos de recuperaci\\u00f3n o la p\\u00e9rdida de un dispositivo de autenticaci\\u00f3n, puede restablecer la autenticaci\\u00f3n de dos factores para que el usuario pueda nuevamente iniciar sesi\\u00f3n.\",\"UsersManager_Role\":\"Funci\\u00f3n\",\"UsersManager_RoleFor\":\"Funci\\u00f3n por\",\"UsersManager_RolesHelp\":\"Los roles determinan lo que un usuario puede hacer en Matomo con respecto a un sitio web espec\\u00edfico. Obtenga m\\u00e1s informaci\\u00f3n sobre los roles de %1$svista%2$s y %3$sadministraci\\u00f3n%4$s.\",\"UsersManager_SaveBasicInfo\":\"Guardar informaci\\u00f3n b\\u00e1sica\",\"UsersManager_SecureUseOnly\":\"Secure use only\",\"UsersManager_SendInvite\":\"Send invite\",\"UsersManager_SetPermission\":\"Disponer autorizaci\\u00f3n\",\"UsersManager_Status\":\"Estado\",\"UsersManager_SuperUserAccess\":\"Acceso Superusuario\",\"UsersManager_SuperUserIntro1\":\"Super usuarios poseen las m\\u00e1ximas autorizaciones. Pueden realizar tareas administrativas tales como agregar nuevos sitios web para monitorear, agregar usuarios, cambiar permisos a usuarios, activar o desactivar complementos e incluso instalar nuevos desde el Marketplace. Puede conceder atributos de Super Usuario a otros usuarios de Divezone aqu\\u00ed.\",\"UsersManager_SuperUserIntro1WithoutMarketplace\":\"Super users have the highest permissions. They can perform all administrative tasks such as adding new websites to monitor, adding users, changing user permissions and activating and deactivating plugins. You can grant Super User access to other users here.\",\"UsersManager_SuperUserIntro2\":\"Por favor use esta funci\\u00f3n cuidadosamente.\",\"UsersManager_SuperUserIntro3\":\"Potential risks are:\",\"UsersManager_SuperUserRiskData\":\"%1$sData loss%2$s - super users can delete data, websites, or users. Mistakes or malicious actions could result in the irreversible loss of critical analytics data.\",\"UsersManager_SuperUserRiskSecurity\":\"%1$sSecurity%2$s - super users can modify settings. Making incorrect configurations could introduce security vulnerabilities or lead to disruption of services.\",\"UsersManager_SuperUserRiskMisconfiguration\":\"%1$sMisconfiguration%2$s - super users can alter system-wide settings, including those that affect performance, tracking, and data collection.\",\"UsersManager_SuperUserRiskUserManagement\":\"%1$sUser management%2$s - super users can change or revoke permissions for other users, change their passwords or reset their two-factor authentication. This could lead to unauthorized access, user impersonation or prevent legitimate users from accessing the system.\",\"UsersManager_SuperUserRiskServiceDisruption\":\"%1$sService disruption%2$s - super users have the ability to deactivate functionalities. This could lead to unintended downtime or disruption of services, affecting data collection and reporting.\",\"UsersManager_SuperUserRiskMarketplace\":\"%1$sMarketplace%2$s - super users can purchase and install plugins from the Marketplace, potentially leading to unapproved expenditures or the introduction of unwanted features.\",\"UsersManager_SuperUserRiskAccountability\":\"%1$sAccountability%2$s - Actions taken by super users might be difficult to trace if not properly audited, leading to challenges in accountability and troubleshooting issues.\",\"UsersManager_SuperUserRiskAccountabilityCheckActivityLog\":\"View %1$srecent activity%2$s.\",\"UsersManager_SuperUserRiskAccountabilityGetActivityLogPlugin\":\"Consider installing the %1$sActivity Log plugin%2$s that lets you quickly review the actions performed by members of your organization or clients in your Matomo.\",\"UsersManager_SuperUserRiskCompliance\":\"%1$sCompliance%2$s - By having full access, super users might inadvertently violate data protection regulations, especially if they export or share data without proper oversight.\",\"UsersManager_SuperUsersPermissionsNotice\":\"Los superusuarios tienen acceso de administrador a todos los sitios web, por lo que no es necesario administrar sus permisos por cada sitio web.\",\"UsersManager_TheDisplayedUsersAreSelected\":\"Est\\u00e1n seleccionados los %1$s usuarios mostrados.\",\"UsersManager_TheDisplayedWebsitesAreSelected\":\"Los %1$s sitios mostrados est\\u00e1n seleccionados.\",\"UsersManager_TokenAuthIntro\":\"Tokens you have generated can be used to access the Matomo reporting API, Matomo tracking API, and exported Matomo widgets and have the same permissions as your regular user login. You can use these tokens also for the Matomo Mobile app.\",\"UsersManager_TokenSuccessfullyGenerated\":\"Token successfully generated\",\"UsersManager_TwoFactorAuthentication\":\"Autenticaci\\u00f3n de dos factores\",\"UsersManager_TypeYourCurrentPassword\":\"Please type your current password to confirm the password change.\",\"UsersManager_TypeYourPasswordAgain\":\"Introduzca de nuevo la contrase\\u00f1a.\",\"UsersManager_UserHasNoPermission\":\"%1$s actualmente tiene %2$s para %3$s\",\"UsersManager_UserHasPermission\":\"%1$s actualmente tiene acceso de %2$s para %3$s.\",\"UsersManager_UserSearch\":\"Buscar usuario\",\"UsersManager_Username\":\"Nombre de usuario\",\"UsersManager_UsesTwoFactorAuthentication\":\"Usa autenticaci\\u00f3n de dos factores\",\"UsersManager_WhenUsersAreNotLoggedInAndVisitPiwikTheyShouldAccess\":\"Cuando los usuarios no han iniciado sesi\\u00f3n y visitan Matomo, deber\\u00edan poder acceder\",\"UsersManager_YourUsernameCannotBeChanged\":\"Su nombre de usuario no puede ser cambiado.\",\"UsersManager_YourVisitsAreIgnoredOnDomain\":\"%1$sTus visitas son ignoradas por Matomo en %2$s %3$s (la cookie de ignorar a Matomo fue encontrada en su navegador).\",\"UsersManager_YourVisitsAreNotIgnored\":\"%1$sTus visitas no son ignoradas por Matomo%2$s (la cookie de ignorar a Matomo no fue encontrada en su navegador).\",\"UsersManager_InviteEmailChange\":\"This user has not yet confirmed their account. Changing the email will invalidate the previous invitation and send an invitation to the new email address.\",\"UsersManager_TokenExpireDate\":\"Token expire date\",\"UsersManager_TokenExpireDateCheckboxLabel\":\"Enable token expiration\",\"UsersManager_TokenExpireDateCheckboxHelp\":\"Enable this option and set a custom token expiration date. Regularly rotating auth tokens is a recommended security practice. You will receive an email notification %1$s days before the token expires. After the expiry date, the token will be rejected by the system and you will need to create a new one.\",\"UsersManager_TokenExpireDateHelpText\":\"The initial token expiration is set to %1$s days from today, and you can select a custom date. You will receive a reminder %2$s days before the selected token expiration date.\",\"UsersManager_InvalidTokenExpireDateFormat\":\"Invalid format of the expire date, please use YYYY-MM-DD. The date also needs to be in the future.\",\"UsersManager_XAgo\":\"%1$s ago\",\"UsersManager_CannotRevokeOwnSuperuserAccess\":\"You cannot revoke your own superuser access.\",\"General_Measurables\":\"Medibles\",\"General_PaginationWithoutTotal\":\"%1$s\\u2013%2$s\",\"General_Share\":\"Compartir\",\"PrivacyManager_ManagePrivacySettings\":\"Manage privacy settings\",\"PrivacyManager_TrackingDataAnonymizationSettings\":\"Tracking data anonymization settings\",\"SitesManager_AddMeasurable\":\"A\\u00f1adir una nueva medici\\u00f3n\",\"SitesManager_AdvancedTimezoneSupportNotFound\":\"No se encuentra soporte avanzado para zonas horarias en su PHP (soportado en PHP&gt;=5.2). Todav\\u00eda puede elegir una distancia a UTC manual.\",\"SitesManager_AliasUrlHelp\":\"Se recomienda, pero no es obligatorio, especificar las diferentes URLs que sus visitantes utilizan para acceder a este sitio web. Los alias de las URLs para un sitio de internet no aparecer\\u00e1n en el informe Referencias \\u2192 Informe de sitios de internet. Tenga en cuenta que no es necesario especificar las direcciones URL con y sin 'www' ya que Matomo considera autom\\u00e1ticamente ambas.\",\"SitesManager_ChangingYourTimezoneWillOnlyAffectDataForward\":\"Cambiar su zona horaria s\\u00f3lo afectar\\u00e1 a los datos en adelante, y no se aplicar\\u00e1 retroactivamente.\",\"SitesManager_ChooseMeasurableTypeHeadline\":\"Qu\\u00e9 le gustar\\u00eda medir?\",\"SitesManager_ChooseMeasurableTypeSubheader\":\"A measurable is any website, app, or online system you want to track and analyse. Measurables are the foundation for collecting data and generating reports in Matomo.\",\"SitesManager_ChooseMeasurableTypeSubheaderRollUp\":\"You can also group multiple measurables using a Roll-Up for a unified view.\",\"SitesManager_Currency\":\"Moneda\",\"SitesManager_CurrencySymbolWillBeUsedForGoals\":\"El s\\u00edmbolo de moneda aparecer\\u00e1 junto a los ingresos por metas.\",\"SitesManager_DefaultCurrencyForNewWebsites\":\"Moneda predeterminada para los nuevos sitios de internet\",\"SitesManager_DefaultTimezoneForNewWebsites\":\"Zona Horaria predeterminada para los nuevos sitios de internet\",\"SitesManager_DeleteConfirm\":\"\\u00bfEst\\u00e1 seguro que desea eliminar el sitio de internet %s?\",\"SitesManager_DeleteSiteExplanation\":\"Eliminando un sitio web eliminar\\u00e1 todos los datos de registro que se hayan recopilado para el mismo. Esta acci\\u00f3n es permanente y no se puede deshacer.\",\"SitesManager_DemoSiteButtonText\":\"SitesManager_DemoSiteButtonText\",\"SitesManager_DetectingYourSite\":\"Detectando tu sitio\",\"SitesManager_DisableSiteSearch\":\"No rastrear b\\u00fasquedas del sitio\",\"SitesManager_EcommerceHelp\":\"Cuando es habilitado, el informe \\\"Metas\\\" poseer\\u00e1 una nueva secci\\u00f3n \\\"Comercio electr\\u00f3nico\\\".\",\"SitesManager_EmailInstructionsButtonText\":\"Email instructions\",\"SitesManager_EnableEcommerce\":\"Comercio electr\\u00f3nico habilitado\",\"SitesManager_EnableSiteSearch\":\"Seguimiento de las b\\u00fasquedas del sitio habilitado\",\"SitesManager_ExcludedIps\":\"IPs excluidas\",\"SitesManager_ExcludedParameters\":\"Par\\u00e1metros exclu\\u00eddos\",\"SitesManager_ExcludedReferrers\":\"Excluded referrers\",\"SitesManager_ExcludedReferrersHelp\":\"Enter the list of hostnames and URLs, one per line, you want to exclude from referrer detection.\",\"SitesManager_ExcludedReferrersHelpDetails\":\"Each entry needs to contain the hostname and may contain a path. If a path is provided a referrer will only be excluded if the path matches as well. URLs with and without 'www' are treated the same. Provided protocols will be ignored.\",\"SitesManager_ExcludedReferrersHelpExamples\":\"e.g. \\\"%1$s\\\" would match \\\"%2$s\\\" and \\\"%3$s\\\" but not \\\"%4$s\\\"\",\"SitesManager_ExcludedReferrersHelpSubDomains\":\"To also exclude all subdomains of a certain hostname, prefix it with a dot. e.g. \\\"%1$s\\\" would exclude \\\"%2$s\\\", but also all its subdomains like \\\"%3$s\\\".\",\"SitesManager_ExcludedUserAgents\":\"Agentes de usuario exclu\\u00eddos\",\"SitesManager_GlobalExcludedUserAgentHelp1\":\"Introduzca la lista de agentes de usuario excluidos de ser rastreados por Matomo.\",\"SitesManager_GlobalExcludedUserAgentHelp2\":\"Puede utilizar esto para excluir algunos bots de ser rastreados.\",\"SitesManager_GlobalExcludedUserAgentHelp3\":\"Regular expressions such as %s are supported.\",\"SitesManager_GlobalListExcludedIps\":\"Lista global de IPs excluidas.\",\"SitesManager_GlobalListExcludedQueryParameters\":\"Lista global de par\\u00e1metros de consulta de URL a excluir\",\"SitesManager_GlobalListExcludedReferrers\":\"Global list of excluded referrers\",\"SitesManager_GlobalListExcludedReferrersDesc\":\"The hostnames and URLs below will be excluded from referrer detection.\",\"SitesManager_GlobalListExcludedUserAgents\":\"Lista global de agentes de usuario a excluir\",\"SitesManager_GlobalListExcludedUserAgents_Desc\":\"Si la cadena del usuario agente de determinado visitante contiene alguna de las cadenas que ha especificado, el visitante ser\\u00e1 excluido de Matomo.\",\"SitesManager_GlobalWebsitesSettings\":\"Configuraci\\u00f3nes globales de los sitios de internet\",\"SitesManager_HelpExcludedIpAddresses\":\"Introduzca la lista de IPs, una por l\\u00ednea, que desea excluir de ser rastreada por Matomo. Puede utilizar notaci\\u00f3n CIDR por ejemplo %1$s o puede usar comodines, por ejemplo %2$s o %3$s\",\"SitesManager_KeepURLFragments\":\"Rastreo de fragmentos de la URL de p\\u00e1gina\",\"SitesManager_KeepURLFragmentsHelp\":\"Si la casilla a continuaci\\u00f3n no est\\u00e1 marcada, los fragmentos de URL de p\\u00e1gina (todo aquello despu\\u00e9s de %1$s) ser\\u00e1 eliminado durante el rastreo: %2$s se rastrear\\u00e1n como %3$s\",\"SitesManager_KeepURLFragmentsHelp2\":\"Tambi\\u00e9n puede invalidar esta configuraci\\u00f3n para los sitios individuales anteriores.\",\"SitesManager_KeepURLFragmentsLong\":\"Mantener fragmentos de la URL de p\\u00e1gina cuando se rastrean las URLs de p\\u00e1gina\",\"SitesManager_ListOfIpsToBeExcludedOnAllWebsites\":\"Las IPs a continuaci\\u00f3n quedar\\u00e1n excluidas de ser rastreadas en todos los sitios de internet.\",\"SitesManager_ListOfQueryParametersToBeExcludedOnAllWebsites\":\"Los par\\u00e1metros de consulta URL a continuaci\\u00f3n ser\\u00e1n excluidos de las URLs de todos los sitios de internet.\",\"SitesManager_ListOfQueryParametersToExclude\":\"Enter each URL parameter on a separate line to exclude from tracking and reports. Regular expressions such as %s are supported.\",\"SitesManager_MainDescription\":\"\\u00a1Su informe de an\\u00e1lisis necesita sitios de internet! Agregue, actualice, elimine sitios y muestre el c\\u00f3digo JavaScript a insertar en sus p\\u00e1ginas.\",\"SitesManager_NotAnEcommerceSite\":\"No es un sitio de comercio electr\\u00f3nico\",\"SitesManager_OnlyMatchedUrlsAllowed\":\"Solo monitorea visitas y acciones cuando la acci\\u00f3n URL comienza con una de las siguientes URLs.\",\"SitesManager_OnlyMatchedUrlsAllowedHelp\":\"Cuando es habilitado, Matomo solo rastrear\\u00e1 acciones internas cuando la URL de la p\\u00e1gina es una URL conocida del sitio. Esto evita que la gente genere datos basura en sus anal\\u00edticas con direcciones URL de otros sitios.\",\"SitesManager_OnlyMatchedUrlsAllowedHelpExamples\":\"El dominio y el camino tiene que ser una coincidencia total y cada subdominio v\\u00e1lido tiene que especificarse por separado. Por ejemplo, cuando las URLs conocidas son 'http:\\\/\\\/example.com\\\/path' y 'http:\\\/\\\/good.example.com', las peticiones de rastreo para 'http:\\\/\\\/example.com\\\/otherpath' o 'http:\\\/\\\/bad.example.com' son ignoradas.\",\"SitesManager_OnlyOneSiteAtTime\":\"Puede editar un sitio de internet a la vez. Por favor guarde o cancele sus modificaciones actuales para el sitio de internet %s.\",\"SitesManager_PiwikOffersEcommerceAnalytics\":\"Matomo permite el rastreo avanzado de an\\u00e1lisis de comercio electr\\u00f3nico e Informes. Aprenda m\\u00e1s acerca de %1$s An\\u00e1lisis de comercio electr\\u00f3nico%2$s.\",\"SitesManager_PiwikWillAutomaticallyExcludeCommonSessionParameters\":\"Matomo autom\\u00e1ticamente excluir\\u00e1 los par\\u00e1metros de sesi\\u00f3n (%s).\",\"SitesManager_SearchCategoryDesc\":\"Matomo puede rastrear la categor\\u00eda Buscar y cada palabra clave del buscador interno del sitio.\",\"SitesManager_SearchCategoryLabel\":\"Par\\u00e1metro de categor\\u00eda\",\"SitesManager_SearchCategoryParametersDesc\":\"Puede introducir una lista en un formato separado por comas de los par\\u00e1metros de consulta, especificando la categor\\u00eda de b\\u00fasqueda.\",\"SitesManager_SearchKeywordLabel\":\"Par\\u00e1metro de pregunta\",\"SitesManager_SearchKeywordParametersDesc\":\"Introduzca una lista en un formato del tipo separado por comas de todos los nombres de los par\\u00e1metros de consulta conteniendo las palabras clave del buscador interno del sitio.\",\"SitesManager_SearchParametersNote\":\"Nota: los par\\u00e1metros de consulta y de categor\\u00eda ser\\u00e1n utilizados solo en aquellos sitios de internet que habilitaron Buscar en el sitio pero dejaron estos par\\u00e1metros vac\\u00edos.\",\"SitesManager_SearchParametersNote2\":\"Para deshabilitar B\\u00fasqueda interna en sitio para los nuevos sitios, deje estos dos campos vac\\u00edos.\",\"SitesManager_SearchUseDefault\":\"Utilizar par\\u00e1metros %1$spredeterminados%2$s para b\\u00fasquedas en el sitio\",\"SitesManager_SelectDefaultCurrency\":\"Puede seleccionar la moneda predeterminada para los nuevos sitios de internet\",\"SitesManager_SelectDefaultTimezone\":\"Puede seleccionar la zona horaria predeterminada para los nuevos sitios de internet.\",\"SitesManager_ShowTrackingTag\":\"Ver c\\u00f3digo de rastreo\",\"SitesManager_SiteSearchUse\":\"Puede utilizar Matomo para rastrear y obtener un informe que es lo que est\\u00e1n buscando sus visitantes en el motor de b\\u00fasqueda interno de su sitio de internet.\",\"SitesManager_SiteWithoutDataChooseTrackingMethod\":\"Elige tu m\\u00e9todo de seguimiento\",\"SitesManager_SiteWithoutDataGoogleTagManager\":\"Google Tag Manager\",\"SitesManager_SiteWithoutDataGoogleTagManagerDescription\":\"You can use Matomo with Google Tag Manager. To setup Matomo Tracking in Google Tag Manager, follow the instructions from this %1$sguide%2$s.\",\"SitesManager_SiteWithoutDataHidePageForHour\":\"Ocultar p\\u00e1gina durante una hora\",\"SitesManager_SiteWithoutDataNotYetReady\":\"\\u00bfTodav\\u00eda no est\\u00e1s listo para instalar Matomo?\",\"SitesManager_SiteWithoutDataOtherInstallMethodsIntro\":\"Ofrecemos m\\u00faltiples formas de seguimiento, elige la tuya para desbloquear el \\u00e9xito basado en datos.\",\"SitesManager_SiteWithoutDataReactDescription\":\"Puedes utilizar el \\\"%1$sMatomo Tag Manager%2$s\\\" para integrar Matomo y realizar el seguimiento de los datos, sigue las instrucciones de esta %3$sgu\\u00eda%4$s.\",\"SitesManager_SiteWithoutDataTemporarilyHidePage\":\"Oculta temporalmente esta p\\u00e1gina y vuelve m\\u00e1s tarde.\",\"SitesManager_SiteWithoutDataVueDescription\":\"Puedes utilizar el paquete npm \\\"%1$s\\\" para integrar Matomo y realizar un seguimiento de los datos. Sigue las instrucciones de esta %2$sGu\\u00eda%3$s.\",\"SitesManager_SiteWithoutDataWordpressDescription\":\"Puedes utilizar el sencillo plugin de WordPress Matomo para realizar un seguimiento de los datos, sigue las instrucciones de esta %1$sgu\\u00eda%2$s.\",\"SitesManager_StepByStepGuide\":\"Gu\\u00eda paso a paso\",\"SitesManager_SuperUserAccessCan\":\"Un usuario con acceso Super Usuario tambi\\u00e9n puede %1$s especificar la configuraci\\u00f3n global%2$s para nuevos sitios web.\",\"SitesManager_Timezone\":\"Zona Horaria\",\"SitesManager_TrackingSiteSearch\":\"Seguimiento en el Buscador interno del sitio\",\"SitesManager_Type\":\"Tipo\",\"SitesManager_UTCTimeIs\":\"La hora UTC es %s.\",\"SitesManager_Urls\":\"URLs\",\"SitesManager_WebsiteCreated\":\"Website created\",\"SitesManager_WebsiteUpdated\":\"Website updated\",\"SitesManager_XManagement\":\"Administrar %s\",\"SitesManager_YouCurrentlyHaveAccessToNWebsites\":\"Actualmente posee acceso a %s sitios de internet.\",\"SitesManager_YourCurrentIpAddressIs\":\"Su direcci\\u00f3n IP actual es %s\",\"UsersManager_InviteTeamMember\":\"Invitar a un miembro del equipo\",\"SitesManager_SiteWithoutDataOtherInstallMethods\":\"Otros m\\u00e9todos para instalar Matomo\",\"SitesManager_SiteWithoutDataInstallWithX\":\"Instalar con %1$s\",\"SitesManager_ExclusionTypeOptionCommonSessionParameters\":\"Common session parameters\",\"SitesManager_ExclusionTypeOptionMatomoRecommendedPII\":\"Matomo-recommended PII\",\"SitesManager_ExclusionTypeOptionCustom\":\"Personalizado\",\"SitesManager_ExclusionTypeDescriptionCommonSessionParameters\":\"This option will automatically exclude common set of session parameters from tracking and reports such as phpsessid, sessionid etc.\",\"SitesManager_ExclusionTypeDescriptionMatomoRecommendedPII\":\"This option will automatically exclude common set of URL parameters from tracking and reports that are identified as PII by Matomo. Please click below to see the list of parameters that will be excluded with this option.\",\"SitesManager_ExclusionTypeDescriptionCustom\":\"This option allows you to specify your own URL parameters to exclude from tracking and reports. You can also add the pre-defined list of Matomo-recommended PII parameters for exclusion along with your own custom set of URL parameters by clicking the button below the textarea.\",\"SitesManager_ExclusionViewListLink\":\"View list of exclusions\",\"SitesManager_AddSensibleExclusionsToMyCustomListButtonText\":\"Add Matomo-recommended PII parameters\",\"SitesManager_MatomoWillAutomaticallyExcludeCommonSessionParametersInAddition\":\"Matomo will also automatically exclude the common session parameters (%s).\",\"Installation_Legend\":\"Leyenda\",\"Installation_SystemCheckWarning\":\"Matomo funcionar\\u00e1 normalmente, pero algunas caracter\\u00edsticas pueden faltar\",\"Installation_SystemCheckError\":\"Se ha producido un error que debe corregirse antes de continuar\",\"General_RefreshPage\":\"Actualizar la p\\u00e1gina\",\"Installation_CopyBelowInfoForSupport\":\"Copie o descargue la informaci\\u00f3n a continuaci\\u00f3n, en caso de que nuestro equipo de soporte le solicite esta informaci\\u00f3n.\",\"Installation_CopySystemCheck\":\"Copiar la comprobaci\\u00f3n del sistema\",\"Installation_DownloadSystemCheck\":\"Descargar la comprobaci\\u00f3n del sistema\",\"Installation_Optional\":\"Opcional\",\"Installation_InformationalResults\":\"Resultados de informaci\\u00f3n\",\"Installation_Requirements\":\"Requisitos de Matomo\",\"Installation_SystemCheckSummaryThereWereErrors\":\"Oh! Matomo ha detectado algunos %1$sproblemas cr\\u00edticos%2$s en su configuraci\\u00f3n Matomo. %3$sEstos deben ser arreglados inmediatamente.%4$s\",\"Installation_SeeBelowForMoreInfo\":\"M\\u00e1s informaci\\u00f3n a continuaci\\u00f3n.\",\"Installation_SystemCheckSummaryThereWereWarnings\":\"Existen ciertos problemas en su sistema. Matomo funcionar\\u00e1, pero puede experimentar algunos problemas.\",\"Installation_SystemCheckSummaryNoProblems\":\"Hurra! No hay problemas con su configuraci\\u00f3n de Matomo. D\\u00e9se una palmadita en la espalda.\",\"ScheduledReports_ReportSent\":\"Informe enviado\",\"ScheduledReports_ReportUpdated\":\"Informe actualizado\",\"ScheduledReports_ReportHourWithUTC\":\"%s en punto UTC\",\"ScheduledReports_EvolutionGraphsShowForEachInPeriod\":\"Gr\\u00e1ficos de evoluci\\u00f3n muestran la evoluci\\u00f3n de %1$scada d\\u00eda%2$s en el \\u00faltimo %3$s\",\"ScheduledReports_EvolutionGraphsShowForPreviousN\":\"Los gr\\u00e1ficos de evoluci\\u00f3n muestra la evoluci\\u00f3n sobre los anteriores N %s\",\"ScheduledReports_ReportFormat\":\"Formato del informe\",\"ScheduledReports_SendReportTo\":\"Enviar informe a\",\"ScheduledReports_MustBeLoggedIn\":\"Debe haber iniciado sesi\\u00f3n para crear y programar informes personalizados.\",\"Login_LogIn\":\"Iniciar sesi\\u00f3n\",\"ScheduledReports_ThereIsNoReportToManage\":\"No hay informes que administrar para el sitio de internet %s\",\"ScheduledReports_SegmentDeleted\":\"Segmento eliminado\",\"ScheduledReports_NoRecipients\":\"Este informe no tiene destinatarios\",\"ScheduledReports_SendReportNow\":\"Enviar informe ahora\",\"ScheduledReports_CreateAndScheduleReport\":\"Crear y programar un informe\",\"ScheduledReports_DescriptionOnFirstPageScheduledReport\":\"The report description will be displayed in the scheduled report message, as well as on the first page of the report.\",\"SegmentEditor_ChooseASegment\":\"Elegir un segmento\",\"ScheduledReports_WeeklyScheduleHelp\":\"Env\\u00edo semanal: los informes ser\\u00e1n enviados el primer lunes de cada semana.\",\"ScheduledReports_MonthlyScheduleHelp\":\"Env\\u00edo mensual: los informes ser\\u00e1n enviados el primer d\\u00eda de cada mes.\",\"ScheduledReports_ReportPeriod\":\"Per\\u00edodo del informe\",\"ScheduledReports_ScheduleReportPeriodHelp\":\"The period of data covered by this report. By default this is the same as the report schedule, so if the report is sent weekly, it will contain information regarding the last week.\",\"ScheduledReports_ScheduleReportPeriodHelp2\":\"You can change this, however, if you want to see different information and still retain the report schedule. For example, if the report schedule is weekly, and the report period is 'day', you will get information for the last day, every week.\",\"ScheduledReports_ReportHour\":\"Enviar informe a las %s en punto\",\"ScheduledReports_ReportType\":\"Enviar informe v\\u00eda\",\"ScheduledReports_AggregateReportsFormat\":\"Opciones de visualizaci\\u00f3n\",\"ScheduledReports_EvolutionGraph\":\"Mostrar gr\\u00e1ficas hist\\u00f3ricas de los valores %s m\\u00e1s altos\",\"ScheduledReports_ReportsIncluded\":\"Estad\\u00edsticas incluidas\",\"ScheduledReports_ReportIncludeNWebsites\":\"El informe incluir\\u00e1 las principales m\\u00e9tricas para todos los sitios de internet con al menos una visita (de todo %s los sitios de internet disponibles).\",\"SegmentEditor_LoadingSegmentedDataMayTakeSomeTime\":\"Procesando los datos segmentados de los visitantes puede llevar unos minutos\\u2026\",\"ScheduledReports_Segment_HelpScheduledReport\":\"You can select an existing custom segment to apply to data in this scheduled report. You may create and edit custom segments in your dashboard %1$s(click here to open)%2$s, then click on the \\\"%3$s\\\" box, then \\\"%4$s\\\".\",\"SegmentEditor_AddNewSegment\":\"Agregar nuevo segmento\",\"ScheduledReports_SentToMe\":\"Enviarme una copia\",\"ScheduledReports_AlsoSendReportToTheseEmails\":\"Tambi\\u00e9n enviar el informe a estos correos electr\\u00f3nicos (uno por l\\u00ednea):\",\"ScheduledReports_ReportSchedule\":\"Report Schedule\",\"ScheduledReports_SendingReport\":\"Sending report\\u2026\",\"UserCountryMap_Unlocated\":\"<b>%1$s<\\\/b> %2$s de las visitas de %3$s no se pudieron geolocalizar.\",\"UserCountryMap_WithUnknownRegion\":\"%s de regiones desconocidas\",\"UserCountryMap_WithUnknownCity\":\"%s de ciudades desconocidas\",\"General_UserId\":\"ID de usuario\",\"Live_VisitorProfile\":\"Perfil de visitante\",\"Live_ClickToViewAllActions\":\"Clic para ver todas las acciones en detalle de este grupo\",\"Live_NoMoreVisits\":\"No hay m\\u00e1s visitas de este visitante.\",\"Live_ShowMap\":\"mostrar mapa\",\"Live_HideMap\":\"ocultar mapa\",\"Live_PageRefreshed\":\"N\\u00famero de veces que esta p\\u00e1gina ha sido vista\\\/actualizada en una fila\",\"Live_RowActionTooltipTitle\":\"Open the segmented visits log\",\"Live_RowActionTooltipDefault\":\"Show the visits log segmented by this row\",\"Live_SegmentedVisitorLogTitle\":\"Visits log showing visits where %1$s is \\\"%2$s\\\"\",\"General_Segment\":\"Segmento\",\"Live_ClickToSeeAllContents\":\"Clic para ver cada interacci\\u00f3n\\\/impresi\\u00f3n del contenido\",\"Live_LastHours\":\"\\u00daltimas %s horas\",\"Live_LastMinutes\":\"\\u00daltimos %s minutos\",\"Live_VisitorsInRealTime\":\"Visitas en tiempo real\",\"Live_OnClickPause\":\"%s est\\u00e1 iniciado. Clic para pausar.\",\"Live_OnClickStart\":\"%s est\\u00e1 detenido. Clic para iniciar.\",\"Live_LinkVisitorLog\":\"View detailed visits log\",\"Live_VisitorLog\":\"Registro de visitas\",\"General_ColumnNbVisitsDocumentation\":\"Se considerar\\u00e1 como una nueva visita si el visitante viene a tu sitio web por primera vez o si la visita se produce 30 minutos despu\\u00e9s de la \\u00faltima interacci\\u00f3n.\",\"General_ColumnNbActionsDocumentation\":\"El n\\u00famero de acciones llevadas a cabo por sus visitantes. Las acciones incluyen cada vez que se ve una p\\u00e1gina, se descarga un archivo o se hace clic a un enlace externo.\",\"CoreAdminHome_OptOutExplanation\":\"Matomo se dedica a dar privacidad en internet. Para darles a sus visitantes la opci\\u00f3n de no ser rastreados por Matomo, puede a\\u00f1adir el siguiente c\\u00f3digo HTML en una de sus p\\u00e1ginas de su sitio web, por ejemplo, en la p\\u00e1gina de Pol\\u00edtica de Privacidad.\",\"CoreAdminHome_OptOutExplanationIntro\":\"Este c\\u00f3digo mostrar\\u00e1 un div que contiene un enlace para que sus visitantes opten por no participar en Matomo configurando una cookie de exclusi\\u00f3n voluntaria en sus navegadores web. Consulte a continuaci\\u00f3n (o %1$shaga clic aqu\\u00ed%2$s) para ver el contenido que mostrar\\u00e1 el div.\",\"CoreAdminHome_OptOutCustomOptOutLink\":\"Tambi\\u00e9n puede crear un formulario de exclusi\\u00f3n completamente personalizado usando HTML y JavaScript, como se explica en esta %1$sgu\\u00eda%2$s para desarrolladores.\",\"General_ClickHere\":\"Haga clic aqu\\u00ed para m\\u00e1s informaci\\u00f3n.\",\"General_DailyReports\":\"Informes diarios\",\"General_Details\":\"Detalles\",\"General_MonthlyReports\":\"Informes mensuales\",\"General_RangeReports\":\"Rangos de fecha personalizados\",\"General_Recommended\":\"Recomendado\",\"General_Visit\":\"Visita\",\"General_VisitId\":\"ID de visitas\",\"General_VisitorID\":\"ID del visitante\",\"General_VisitorIP\":\"IP del visitante\",\"General_WeeklyReports\":\"Informes semanales\",\"General_YearlyReports\":\"Informes anuales\",\"Intl_PeriodDays\":\"d\\u00edas\",\"Intl_PeriodMonths\":\"meses\",\"Live_ViewVisitorProfile\":\"Ver perfil de visitante\",\"PrivacyManager_AddUserIdToSearch\":\"Click to add this userID to the search\",\"PrivacyManager_AddVisitorIPToSearch\":\"Click to add this visitorIP to the search\",\"PrivacyManager_AddVisitorIdToSearch\":\"Click to add this visitorID to the search\",\"PrivacyManager_AnonymizeDataConfirm\":\"Are you sure you want to anonymize the data for the selected website(s) and time range? This action cannot be undone, data may be deleted as requested, and this process may take a long time.\",\"PrivacyManager_AnonymizeDataNow\":\"Anonymize past data for the selected site and time\",\"PrivacyManager_AnonymizeIp\":\"Anonymize IP\",\"PrivacyManager_AnonymizeIpDescription\":\"Seleccione \\\"Si\\\" si desea que Matomo no registre direcciones IP completas.\",\"PrivacyManager_AnonymizeIpHelp\":\"This action cannot be undone. If enabled, for all visits during this duration the IP will be anonymized by at least 2 bytes, for example '192.168.xxx.xxx'. If you have currently configured to anonymize by 3 bytes, then this setting will be respected and all IPs will be anonymized by 3 bytes.\",\"PrivacyManager_AnonymizeIpInlineHelp\":\"Ocultar los \\u00faltimos bit(s) de la direcci\\u00f3n IP del visitante para cumplir con las leyes\\\/directrices de privacidad de su jurisdicci\\u00f3n.\",\"PrivacyManager_AnonymizeIpMaskLengtDescription\":\"Seleccione cuantos bytes de las direcciones IP de los visitantes deben ser enmascaradas.\",\"PrivacyManager_AnonymizeLocation\":\"Anonymize Location\",\"PrivacyManager_AnonymizeLocationHelp\":\"This action cannot be undone. Re-evaluates the location based on the anonymized IP (at least 2 bytes of the IP will be anonymized).\",\"PrivacyManager_AnonymizeOrderIdNote\":\"Debido a que un ID de pedido puede ser referenciado con otro sistema, generalmente una tienda de comercio electr\\u00f3nico, el ID de pedido puede contar como informaci\\u00f3n personal bajo el GDPR. Cuando habilite esta opci\\u00f3n, la identificaci\\u00f3n del pedido se anonimizar\\u00e1 autom\\u00e1ticamente, por lo que no se rastrear\\u00e1 la informaci\\u00f3n personal.\",\"PrivacyManager_AnonymizeProcessInfo\":\"This action may take a long time and will therefore not be executed right away. You will be able to follow the current state of the process below. The anonymization should typically start within one hour.\",\"PrivacyManager_AnonymizeReferrer\":\"Anonymize Referrer\",\"PrivacyManager_AnonymizeReferrerNote\":\"Matomo stores from which URL (referrer) a user comes to your site. In some cases such a URL may contain information that can be considered personal information. If you want to prevent such information to be tracked you can restrict the amount of referrer data that Matomo will store when a visitor enters your website. The more information is removed from the referrer information, the less likely personal information will be recorded. The more information you remove from the referrer, the less clear it will be how a visitor came to your website.\",\"PrivacyManager_AnonymizeRowDataFrom\":\"Anonymize all raw data starting from:\",\"PrivacyManager_AnonymizeRowDataTo\":\"Anonymize all raw data up to:\",\"PrivacyManager_AnonymizeSites\":\"Anonymize the data of this site(s)\",\"PrivacyManager_AnonymizeUserId\":\"Reemplazar ID de usuario con un seud\\u00f3nimo\",\"PrivacyManager_AnonymizeUserIdHelp\":\"When you enable this option, the User ID will be replaced by a pseudonym to avoid directly storing and displaying personally identifiable information such as an email address. In technical terms: given your User ID, Matomo will process the User ID pseudonym using a salted hash function.<br\\\/><br\\\/><em>Note: replacing with a pseudonym is not the same as anonymisation. In GDPR terms: the User ID pseudonym still counts as personal data. The original User ID could still be identified if certain additional information is available (which only Matomo and your data processor has access to).<\\\/em>\",\"PrivacyManager_AwarenessDocumentation\":\"Awareness & documentation\",\"PrivacyManager_AwarenessDocumentationDesc1\":\"Inform your visitors through a clear privacy notice whenever you\\u2019re collecting personal data.\",\"PrivacyManager_AwarenessDocumentationDesc2\":\"Inform your users in your privacy policy about what data you collect and how the data is used.\",\"PrivacyManager_AwarenessDocumentationDesc3\":\"Make your team aware that you are using Matomo Analytics and %1$swhat data is being collected by your analytics platform%2$s.\",\"PrivacyManager_AwarenessDocumentationDesc4\":\"Document your use of Matomo within your %1$sinformation asset register%2$s.\",\"PrivacyManager_AwarenessDocumentationIntro\":\"Inform your users clearly and transparently, and make your colleagues aware of the data being collected and how it is used:\",\"PrivacyManager_BackgroundColor\":\"Background Color\",\"PrivacyManager_ConsentExplanation\":\"Consent means offering individuals choice and control about how their personal data is processed.\",\"PrivacyManager_ApplyStyling\":\"Apply a custom style\",\"PrivacyManager_BuildYourOwn\":\"Build Your Own\",\"PrivacyManager_DBPurged\":\"Base de datos purgada.\",\"PrivacyManager_DataRetention\":\"Data retention\",\"PrivacyManager_DataRetentionInMatomo\":\"Data retention for data stored in Matomo:\",\"PrivacyManager_DataRetentionOverall\":\"The overall data retention rate for your privacy policy is the raw data retention rate. Please note that aggregated reports may contain personal data as well. If you are using features like User ID, Custom Variables, Custom Dimension, or track personal data in other ways such as events, page URLs or page titles, etc, then the overall data retention rate for your privacy policy is the higher of the two.\",\"PrivacyManager_DeleteAggregateReportsDetailedInfo\":\"Cuando habilite esta configuraci\\u00f3n, todos los informes agregados se eliminar\\u00e1n. Los informes agregados se generan a partir de los datos sin procesar y representan datos agregados de varias visitas individuales. Por ejemplo, el informe \\\"Pa\\u00eds\\\" enumera n\\u00fameros agregados para ver cu\\u00e1ntas visitas ha recibido de cada pa\\u00eds.\",\"PrivacyManager_DeleteBothConfirm\":\"Est\\u00e1 a punto de habilitar la eliminaci\\u00f3n de datos de informes y registros. Esta acci\\u00f3n permanentemente quitar\\u00e1 la posibilidad de disponer de informaci\\u00f3n anal\\u00edtica a\\u00f1eja. \\u00bfEst\\u00e1 seguro que desea llevarlo a cabo?\",\"PrivacyManager_DeleteDataDescription\":\"Puede configurar Matomo para que elimine regularmente datos sin procesar a\\u00f1ejos y\\\/o informes agregados para mantener su base de datos peque\\u00f1a o para cumplir con las regulaciones de privacidad tal como la GDPR.\",\"PrivacyManager_DeleteDataInterval\":\"Eliminar informaci\\u00f3n antigua cada\",\"PrivacyManager_DeleteLogsConfirm\":\"Est\\u00e1 a punto de habilitar la eliminaci\\u00f3n de datos en bruto. Si se eliminan los datos sin procesar antiguos y no se han creado los informes, no podr\\u00e1 ver los datos de an\\u00e1lisis hist\\u00f3ricos anteriores. \\u00bfSeguro que desea hacer esto?\",\"PrivacyManager_DeleteLogsOlderThan\":\"Eliminar registros m\\u00e1s antiguos que\",\"PrivacyManager_DeleteOldAggregatedReports\":\"Eliminar datos de informes agregados antiguos\",\"PrivacyManager_DeleteOldRawData\":\"Regularmente eliminar los antiguos datos sin procesar\",\"PrivacyManager_DeleteRawDataInfo\":\"Los datos sin procesar contienen todos los detalles sobre cada visita individual y cada acci\\u00f3n que realizaron sus visitantes. Cuando elimine datos sin procesar, la informaci\\u00f3n eliminada ya no estar\\u00e1 disponible en el registro de visitantes. Adem\\u00e1s, si luego decide crear un segmento, los informes segmentados no estar\\u00e1n disponibles para el per\\u00edodo de tiempo que se elimin\\u00f3, ya que todos los informes agregados se generan a partir de estos datos sin procesar.\",\"PrivacyManager_DeleteReportsConfirm\":\"Est\\u00e1 disponiendo la eliminaci\\u00f3n de datos de informes. Si un antiguo informe es borrado, tendr\\u00e1 que reprocesarlos nuevamente para visualizarlos. \\u00bfEst\\u00e1 seguro que desea hacer esto?\",\"PrivacyManager_DeleteReportsInfo2\":\"Si elimina informes antiguos, es posible que se vuelvan a procesar de nuevo a partir de sus datos SIN PROCESAR cuando los solicite.\",\"PrivacyManager_DeleteReportsInfo3\":\"Si tambi\\u00e9n ha habilitado \\\"%s\\\", entonces los datos de los informes que est\\u00e1 eliminando se perder\\u00e1n permanentemente.\",\"PrivacyManager_DeleteReportsOlderThan\":\"Borrar informes anteriores a\",\"PrivacyManager_DeleteSchedulingSettings\":\"Programar el borrado de datos a\\u00f1ejos\",\"PrivacyManager_DeleteSelectedVisits\":\"Delete selected visits\",\"PrivacyManager_DeleteVisitsConfirm\":\"Are you sure you want to delete the selected visits? This action cannot be undone.\",\"PrivacyManager_DeletionFromMatomoOnly\":\"Please also note that any data will be only deleted from the Matomo database but not from your webserver logs. Also note that if you re-import any historical data, for example from logs, that any previously deleted data may be imported again.\",\"PrivacyManager_DoNotTrack_Description\":\"Do Not Track es una tecnolog\\u00eda y una propuesta pol\\u00edtica que permite a los usuarios decidir no ser rastreados por sitios de internet que no visitan, incluyendo servicios anal\\u00edticos, redes de publicidad y plataformas sociales.\",\"PrivacyManager_DoNotTrack_Disabled\":\"Matomo actualmente est\\u00e1 rastreando a todos los visitantes, incluso aquellos que han especificado \\\"No deseo ser rastreado\\\" en sus respectivos navegadores de internet.\",\"PrivacyManager_DoNotTrack_DisabledMoreInfo\":\"Recomendamos habilitar DoNotTrack para honrar la privacidad de sus visitantes.\",\"PrivacyManager_DoNotTrack_Enabled\":\"Actualmente est\\u00e1 respetando la privacidad de sus visitantes, \\u00a1Bravo!\",\"PrivacyManager_DoNotTrack_EnabledMoreInfo\":\"Cuando los usuarios configuran su navegador de internet en \\\"No quiero ser rastreado\\\" (DoNotTrack est\\u00e1 habilitado), entonces Matomo no rastrear\\u00e1 estas visitas.\",\"PrivacyManager_DoNotTrack_SupportDNTPreference\":\"Soporte a la preferencia Do Not Track\",\"PrivacyManager_DoNotTrack_Deprecated\":\"The support for the Do Not Track header has been deprecated. As more browsers have either started automatically sending this header without giving users the option to change it or have completely discontinued support for it, we no longer recommend enabling this option. This feature may be completely removed in one of the upcoming major releases.\",\"PrivacyManager_ExportSelectedVisits\":\"Export selected visits\",\"PrivacyManager_ExportingNote\":\"In case you are exporting the data to exercise the right of access, please make sure the selected visits are actually performed by the data subject you want to export the data for.\",\"PrivacyManager_FindDataSubjectsBy\":\"Find data subjects by\",\"PrivacyManager_FindMatchingDataSubjects\":\"Find matching data subjects\",\"PrivacyManager_FontColor\":\"Font Color\",\"PrivacyManager_FontFamily\":\"Font Family\",\"PrivacyManager_FontSize\":\"Font Size\",\"PrivacyManager_ForceCookielessTracking\":\"Force tracking without cookies\",\"PrivacyManager_ForceCookielessTrackingDescription\":\"Enabling this option will automatically update %1$s, so it contains some additional code to ensure all trackers won't use cookies. Additionally Matomo will ignore all tracking cookies on server side.\",\"PrivacyManager_ForceCookielessTrackingDescription2\":\"Cookies will be disabled even when using the consent methods in Matomo tracker and calling for example the cookie consent methods won't enable cookies.\",\"PrivacyManager_ForceCookielessTrackingDescriptionNotWritable\":\"The JS tracker file \\\"%1$s\\\" is not writable which is required for this feature to fully work. When the JS tracker file is not writable, then the cookies will be only ignored on the server side but cookies might be still set in the browser. To solve this issue you or a system administrator need to change the file permissions so your webserver can change this file.\",\"PrivacyManager_GdprChecklistDesc1\":\"If you are processing personal data of European citizens through Matomo, even if your company is located outside Europe, you need to fulfill GDPR obligations and this guide will help you.\",\"PrivacyManager_GdprChecklistDesc2\":\"Find below our tools that let you exercise your users\\u2019 rights easily, and the list of actions to take in order to make your use of Matomo compliant with the GDPR and safeguard your data. Visit our %1$sGDPR User guide%2$s to learn even more.\",\"PrivacyManager_GdprChecklists\":\"GDPR checklists\",\"PrivacyManager_GdprOverviewIntro1\":\"The General Data Protection Regulation (GDPR) is a regulation which strengthens and unifies data protection for all individuals within the European Union (EU).\",\"PrivacyManager_GdprOverviewIntro2\":\"If you take steps to ensure no personal data is collected in Matomo, then you may not be concerned by the GDPR for Matomo (if you track no IP addresses, no user IDs, no geolocation data, etc.).\",\"PrivacyManager_GdprToolsOverviewHint\":\"In case you do not know what GDPR is, please refer to the %1$sGDPR overview%2$s.\",\"PrivacyManager_GdprToolsPageIntro1\":\"This page has been designed in order for you to exercise data subject rights.\",\"PrivacyManager_GdprToolsPageIntro2\":\"Here you can exercise the rights of your users with our GDPR-friendly procedures:\",\"PrivacyManager_GdprToolsPageIntroAccessRight\":\"the right of access to all of their data (and the right to data portability),\",\"PrivacyManager_GdprToolsPageIntroEraseRight\":\"the right to erase some or all of their data (and the right to rectification).\",\"PrivacyManager_GeolocationAnonymizeIpNote\":\"Nota: Geolocalizaci\\u00f3n tendr\\u00e1 aproximadamente los mismos resultados con 1 byte an\\u00f3nimo. Con 2 bytes o m\\u00e1s, la Geolocalizaci\\u00f3n ser\\u00e1 imprecisa.\",\"PrivacyManager_GetPurgeEstimate\":\"Obtener estimaci\\u00f3n de purga\",\"PrivacyManager_HowDoIAskForConsent\":\"How do I ask users for consent?\",\"PrivacyManager_HowDoIAskForConsentIntro\":\"Matomo has guides available for setting up consent tracking with the following popular consent managers:\",\"PrivacyManager_HowDoIAskForConsentOutro\":\"If you do not use one of the above consent managers, you can implement %1$stracking with consent using the Matomo JavaScript API%2$s.\",\"PrivacyManager_IndividualsRights\":\"Individuals' rights\",\"PrivacyManager_IndividualsRightsAccess\":\"The right of access: %1$ssearch for a data subject%2$s and export all of their data.\",\"PrivacyManager_IndividualsRightsChildren\":\"If you offer online services to children and rely on consent to collect information about them, then you may need a parent or guardian\\u2019s consent in order to process the children\\u2019s personal data lawfully.\",\"PrivacyManager_IndividualsRightsErasure\":\"The right to erasure: %1$ssearch for a data subject%2$s and delete some or all of their data.\",\"PrivacyManager_IndividualsRightsInform\":\"The right to be informed: inform your users with a clear privacy notice.\",\"PrivacyManager_IndividualsRightsIntro\":\"Exercise the rights of your users with our GDPR-friendly procedures:\",\"PrivacyManager_IndividualsRightsObject\":\"The right to object: %1$slet your users easily opt-out%2$s on your privacy policy page.\",\"PrivacyManager_IndividualsRightsPortability\":\"The right to data portability: %1$ssearch for a data subject%2$s and export all of their data.\",\"PrivacyManager_IndividualsRightsRectification\":\"The right to rectification: you can %1$ssearch for a data subject%2$s and delete some or all of their data.\",\"PrivacyManager_KeepBasicMetrics\":\"Mantener m\\u00e9tricas b\\u00e1sicas (visitantes, vistas de p\\u00e1ginas, tasa de rebote, conversiones de meta, conversiones de comercio electr\\u00f3nico, etc.)\",\"PrivacyManager_KeepBasicMetricsReportsDetailedInfo\":\"Cuando habilita esta configuraci\\u00f3n, algunos indicadores de rendimiento de clave num\\u00e9rica no se eliminar\\u00e1n.\",\"PrivacyManager_KeepDataFor\":\"Mantener toda la informaci\\u00f3n para\",\"PrivacyManager_KeepReportSegments\":\"Para mantener la informaci\\u00f3n superior, tambi\\u00e9n mantenga informes segmentados\",\"PrivacyManager_LastAction\":\"Last action\",\"PrivacyManager_LastDelete\":\"La \\u00faltima eliminaci\\u00f3n fue en\",\"PrivacyManager_LeastDaysInput\":\"Por favor, especifique un n\\u00famero de d\\u00edas superior a %s.\",\"PrivacyManager_LeastMonthsInput\":\"Por favor, especifique un n\\u00famero de meses mayor que %s.\",\"PrivacyManager_MatchingDataSubjects\":\"Matching data subjects\",\"PrivacyManager_NextDelete\":\"La pr\\u00f3xima eliminaci\\u00f3n programada es en\",\"PrivacyManager_NoDataSubjectsFound\":\"No data subjects found\",\"PrivacyManager_OptOutAppearance\":\"Customize the opt-out appearance\",\"PrivacyManager_OptOutCustomize\":\"Customize the opt-out iframe\",\"PrivacyManager_OptOutHtmlCode\":\"HTML code to embed on your website\",\"PrivacyManager_OptOutPreview\":\"Preview of the Opt-out as it will appear on your website\",\"PrivacyManager_OptOutUseTracker\":\"Use the Matomo tracker code to set the opt out\",\"PrivacyManager_OptOutUseStandalone\":\"Use self-contained code to set the opt out\",\"PrivacyManager_OptOutCodeTypeExplanation\":\"The opt-out can either be set by using the Matomo tracker code which means less code to add to your website pages and less likely to need updating in the future, or using standalone code which is more likely to work for visitors with script blockers but will need to be updated on each webpage if you change any settings.\",\"PrivacyManager_OptOutRememberToTest\":\"Remember to test your opt-out!\",\"PrivacyManager_OptOutRememberToTestBody\":\"To ensure that your opt-out is working properly with your website it is recommended to perform the following quick test after adding the opt out code.\",\"PrivacyManager_OptOutRememberToTestStep1\":\"Browse to your main website page.\",\"PrivacyManager_OptOutRememberToTestStep2\":\"Once the page has loaded you should see the opt-out box.\",\"PrivacyManager_OptOutRememberToTestStep3\":\"Unchecking the checkbox to opt-out should show the opted-out message.\",\"PrivacyManager_OptOutRememberToTestStep4\":\"Checking the checkbox to opt-in should show the opted-in message.\",\"PrivacyManager_PseudonymizeUserId\":\"Reemplazar ID de usuario con un seud\\u00f3nimo\",\"PrivacyManager_PseudonymizeUserIdNote\":\"Cuando habilite esta opci\\u00f3n, la ID de usuario ser\\u00e1 reemplazada por un seud\\u00f3nimo para evitar el almacenamiento y la visualizaci\\u00f3n de informaci\\u00f3n de identificaci\\u00f3n personal, como una direcci\\u00f3n de correo electr\\u00f3nico. En t\\u00e9rminos t\\u00e9cnicos: dado su ID de usuario, Matomo procesar\\u00e1 el seud\\u00f3nimo de ID de usuario utilizando una funci\\u00f3n hash.\",\"PrivacyManager_PseudonymizeUserIdNote2\":\"Nota: reemplazar con un seud\\u00f3nimo no es lo mismo que anonimizar. En t\\u00e9rminos de GDPR: el seud\\u00f3nimo de ID de usuario todav\\u00eda cuenta como datos personales. La ID de usuario original a\\u00fan podr\\u00eda identificarse si cierta informaci\\u00f3n adicional est\\u00e1 disponible (a la que solo Matomo y su procesador de datos tienen acceso).\",\"PrivacyManager_PurgeNow\":\"Purgar base de datos ahora\",\"PrivacyManager_PurgeNowConfirm\":\"Est\\u00e1 a punto de borrar informaci\\u00f3n permanentemente de su base de datos. \\u00bfEst\\u00e1 seguro que desea continuar?\",\"PrivacyManager_PurgingData\":\"Purgando informaci\\u00f3n\\u2026\",\"PrivacyManager_RawDataNeverRemoved\":\"visits and actions raw data are <strong>never<\\\/strong> deleted.\",\"PrivacyManager_RawDataRemovedAfter\":\"all visits and actions raw data are deleted after %1$s.\",\"PrivacyManager_ReportsDataSavedEstimate\":\"Tama\\u00f1o de la base de datos\",\"PrivacyManager_ReportsNeverRemoved\":\"aggregated reports are <strong>never<\\\/strong> deleted.\",\"PrivacyManager_ReportsRemovedAfter\":\"all aggregated reports are deleted after %1$s.\",\"PrivacyManager_ResultIncludesAllVisits\":\"The found results include all visits without any time restriction and include today.\",\"PrivacyManager_ResultTruncated\":\"More than %1$s results were found and the result was truncated to the first %1$s visits.\",\"PrivacyManager_SaveSettingsBeforePurge\":\"Ha cambiado la configuraci\\u00f3n de borrado de informaci\\u00f3n. Por favor, gu\\u00e1rdelas antes de iniciar la purga.\",\"PrivacyManager_SearchForDataSubject\":\"Search for a data subject\",\"PrivacyManager_SecurityProcedures\":\"Security procedures\",\"PrivacyManager_SecurityProceduresDesc1\":\"Apply our %1$ssecurity recommendations%2$s in order to keep your Matomo data safe.\",\"PrivacyManager_SecurityProceduresDesc2\":\"Check that you have a written contract with the company providing you the Matomo server or hosting which ensures %1$sappropriate safeguards are provided%2$s.\",\"PrivacyManager_SecurityProceduresDesc3\":\"Include Matomo in your %1$sdata breach procedure%2$s.\",\"PrivacyManager_SecurityProceduresDesc4\":\"Include Matomo in your %1$sdata privacy impact assessment (DPIA)%2$s, if applicable.\",\"PrivacyManager_SecurityProceduresIntro\":\"Inform your users clearly and transparently, and make your colleagues aware of the data being collected and how it is used:\",\"PrivacyManager_SeeAlsoOurOfficialGuidePrivacy\":\"Lee tambi\\u00e9n nuestra gu\\u00eda oficial: %1$sPrivacidad en las an\\u00e1l\\u00edticas web%2$s\",\"PrivacyManager_SelectWebsite\":\"Seleccione una p\\u00e1gina web\",\"PrivacyManager_SiteDataNotAvailable\":\"Data unavailable\",\"PrivacyManager_SiteDataNotAvailableCertainSites\":\"Data restricted for some sites\",\"PrivacyManager_VisitorLogsProfilesDisabledMessage\":\"Data for this site is not displayed because Visits logs or Visitor Profile are disabled. This ensures compliance with privacy settings and regulations.\",\"PrivacyManager_VisitorLogsProfilesSiteNamesDisabledMessage\":\"Data for some sites is not displayed because Visits logs or Visitor Profile are disabled for these sites. This ensures compliance with privacy settings and regulations.\",\"PrivacyManager_PleaseEnableVisitorLogsProfiles\":\"If you need to access data for this site, please enable Visits logs or Visitor Profile in the %1$ssite settings%2$s.\",\"PrivacyManager_PleaseEnableVisitorLogsProfilesSites\":\"If you need to access data for these sites, please enable Visits logs or Visitor Profile in the %1$ssite settings%2$s.\",\"PrivacyManager_TeaserHeader\":\"En esta p\\u00e1gina, puede personalizar c\\u00f3mo Matomo cumple con la privacidad respecto de las legislaciones existentes: %1$s haciendo an\\u00f3nima la IP del visitante%2$s, %3$s eliminando autom\\u00e1ticamente los antiguos registros de los visitantes en la base de datos%4$s y %5$s suministrando un mecanismo de renuncia en su sitio web (para que los visitantes no sean rastreados)%6$s\",\"PrivacyManager_TrackingOptOut\":\"Let users opt-out of tracking\",\"PrivacyManager_ShowIntro\":\"Show introduction text\",\"PrivacyManager_UnsetActionColumns\":\"Unset action columns\",\"PrivacyManager_UnsetActionColumnsHelp\":\"This action cannot be undone. A list of database columns in scope action that you want to unset. Each value for that column will be set to its default value.\",\"PrivacyManager_UnsetVisitColumns\":\"Unset visit columns\",\"PrivacyManager_UnsetVisitColumnsHelp\":\"This action cannot be undone. A list of database columns in scope visit that you want to unset. Each value for that column will be set to its default value. Please note that if the same column exists in scope 'conversion', then this column will be deleted as well\",\"PrivacyManager_UseAnonymizeIp\":\"Hacer an\\u00f3nimas las direcciones IP de los visitantes\",\"PrivacyManager_UseAnonymizeOrderId\":\"Anonimizar ID pedido\",\"PrivacyManager_UseAnonymizeTrackingData\":\"Anonimizar datos de seguimiento de datos\",\"PrivacyManager_UseAnonymizedIpForVisitEnrichment\":\"Usa tambi\\u00e9n direcciones IP an\\u00f3nimas para enriquecer las visitas.\",\"PrivacyManager_UseAnonymizedIpForVisitEnrichmentNote\":\"Los complementos Geo Location v\\u00eda IP y Provider mejoran los metadatos de los visitantes. Por defecto estos complementos utilizan las direcciones IP an\\u00f3nimas. Si elige 'No', ser\\u00e1 utilizada una direcci\\u00f3n completa de forma no an\\u00f3nima lo que resulta en una menor privacidad pero una mayor precisi\\u00f3n de los datos.\",\"PrivacyManager_UseDeleteLog\":\"Regularmente elimine datos a\\u00f1ejos de la base de datos\",\"PrivacyManager_UseDeleteReports\":\"Regularmente borrar los antiguos informes de la base de datos\",\"PrivacyManager_VisitsMatchedCriteria\":\"These visits match the selected criteria.\",\"PrivacyManager_VisitsSuccessfullyDeleted\":\"Visits were successfully deleted\",\"PrivacyManager_VisitsSuccessfullyExported\":\"Visits were successfully exported\",\"PrivacyManager_WhenConsentIsNeededPart1\":\"The %1$sGDPR privacy regulations%2$s require you to ask for your users' consent when processing personal data in some cases. To determine whether you need to ask for consent, you need to identify your lawful basis for processing personal data. This can be either \\\"Consent\\\" or \\\"Legitimate interest\\\", or you may be able to avoid collecting personal data altogether.\",\"PrivacyManager_WhenConsentIsNeededPart2\":\"It's recommended to learn more about the lawful basis for processing personal data under GDPR. You can find more information on this topic on %1$sour blog%2$s.\",\"PrivacyManager_WhenConsentIsNeededPart3\":\"Please note that if you require your users' consent, and you cannot prove that you obtained their \\\"Consent\\\" in the past, we recommend anonymizing your previously tracked users' raw data. Anonymizing your previously tracked users' raw data can be done through the Privacy Manager in Matomo %1$slearn more%2$s.\",\"PrivacyManager_WhenDoINeedConsent\":\"When do I need to ask for user consent?\",\"UsersManager_AllWebsites\":\"Todos los sitios de internet\",\"PrivacyManager_ConsentManager\":\"Consent Manager\",\"PrivacyManager_ConsentManagerDetected\":\"%1$s consent manager was detected on your website. To learn about configuring Matomo to work with %1$s please read %2$sthis guide%3$s\",\"PrivacyManager_ConsentManagerConnected\":\"Parece que %1$s ya est\\u00e1 configurado para funcionar con Matomo.\",\"PrivacyManager_PreviousRawDataAnonymizations\":\"Previous raw data anonymizations\",\"PrivacyManager_Requester\":\"Requester\",\"PrivacyManager_AffectedIDSites\":\"Affected ID Sites\",\"PrivacyManager_AffectedDate\":\"Affected date\",\"PrivacyManager_Anonymize\":\"Anonimizar\",\"PrivacyManager_VisitColumns\":\"Visit Columns\",\"PrivacyManager_LinkVisitActionColumns\":\"Link Visit Action Columns\",\"PrivacyManager_IPAddress\":\"Direcci\\u00f3n IP\",\"PrivacyManager_ScheduledDate\":\"Scheduled date: %1$s\",\"PrivacyManager_JobStartDate\":\"Job Start Date: %1$s\",\"PrivacyManager_JobFinishDate\":\"Job Finish Date: %1$s\",\"PrivacyManager_CurrentOutput\":\"Current Output: %1$s\",\"PrivacyManager_Output\":\"Output: %1$s\",\"PrivacyManager_Scheduled\":\"Scheduled\",\"PrivacyManager_InProgress\":\"In progress\",\"PrivacyManager_AnonymizePreviousData\":\"Anonymize previously tracked raw data\",\"PrivacyManager_AnonymizePreviousDataDescription\":\"If you have tracked personal data such as the full visitor IP, you may want to anonymize this data now in case you do not have consent for this data or no longer a legitimate interest.\",\"PrivacyManager_AnonymizePreviousDataOnlySuperUser\":\"Only a user with Super User access can anonymize previously tracked raw data.\",\"Overlay_Location\":\"Ubicaci\\u00f3n\",\"PrivacyManager_UseRandomizeConfigId\":\"Randomize config_ID for enhanced privacy\",\"PrivacyManager_RandomizeConfigIdNote\":\"By randomizing the config_ID for every request, this feature ensures that visitor tracking is compliant with the strictest privacy interpretations. This setting disables mechanisms that rely on user-agent data, cookies, or other identifiers that require explicit consent, allowing for anonymized tracking while respecting user privacy.\",\"PrivacyManager_RandomizeConfigIdNoteWarning\":\"%1$sPlease note: %2$sWith this setting enabled, every action will be tracked as a new visit.\",\"PrivacyManager_ConfirmConfigRandomisationEnabled\":\"Are you sure you want to enable config_ID randomization?\",\"PrivacyManager_ConfirmConfigRandomisationEnabledPerSite\":\"Are you sure you want to save the site's settings and enable config_ID randomization?\",\"PrivacyManager_ConfirmConfigRandomisationExplanation\":\"Randomizing the config_ID for every request disables mechanisms that rely on user-agent data, cookies, or other identifiers that require explicit consent, allowing for anonymized tracking while respecting user privacy. Every action will be tracked as a new visit.\",\"PrivacyManager_SiteAnonymizationConfig\":\"Anonymization configuration for this site\",\"PrivacyManager_UseSystemSettings\":\"Use system settings\",\"PrivacyManager_UseSiteSpecificSettings\":\"Use custom settings specific to this site\",\"PrivacyManager_UseSiteSpecificSettingsHelpText\":\"By default, each site uses anonymization settings defined for the whole Matomo instance in %1$ssystem settings%2$s. If you select the '%3$s' option, you can override each of the settings for this specific site.\",\"PrivacyManager_Compliance\":\"Compliance\",\"PrivacyManager_ComplianceSelectSite\":\"Select a site below to get an indication if the given site is compliant according to the indicated privacy law\",\"PrivacyManager_ComplianceEnforceCheckboxIntro\":\"Enforce compliance where possible\",\"PrivacyManager_ComplianceEnforceCheckboxTitle\":\"Enforce settings that help support alignment where possible\",\"PrivacyManager_ComplianceEnforceCheckboxHelp\":\"Enabling this will override the above settings. Note that some conditions require changes to Customer implementation which are not controlled by this UI\",\"PrivacyManager_ComplianceTableSettingName\":\"Setting Name\",\"PrivacyManager_ComplianceTableSettingStatus\":\"Estado\",\"PrivacyManager_ComplianceTableSettingNotes\":\"Notes\",\"PrivacyManager_ComplianceCompliant\":\"compliant\",\"PrivacyManager_ComplianceNonCompliant\":\"non-compliant\",\"PrivacyManager_ComplianceComplianceUnknown\":\"unknown\",\"General_ErrorTryAgain\":\"Error. Por favor, int\\u00e9ntelo m\\u00e1s tarde.\",\"General_ExceptionContactSupportGeneric\":\"Si todav\\u00eda tienes este problema, por favor %1$s contacta con tu administrador Matomo%2$s en busca de ayuda.\",\"PrivacyManager_ComplianceCNILTitle\":\"CNIL website analytics consent exemption conditions\",\"PrivacyManager_ComplianceCNILDescription\":\"This table provides an indication of whether certain settings align with CNIL guidance. It does not guarantee full legal compliance. To qualify for the consent exemption under CNIL rules, all required configurations must be implemented. If any setting is shown as \\u201cNon-Compliant,\\u201d the exemption conditions are not met, and consent must be obtained from users. If any setting is shown as \\u201cUnknown\\u201d Matomo cannot determine whether this requirement has been implemented. In such cases, these measures must be manually verified.\",\"Intl_Today\":\"Hoy\",\"MobileMessaging_Settings_InvalidActivationCode\":\"El c\\u00f3digo introducido no es v\\u00e1lido. Int\\u00e9ntelo de nuevo.\",\"MobileMessaging_Settings_PhoneActivated\":\"\\u00a1N\\u00famero telef\\u00f3nico convalidado! Ahora puede recibir sus estad\\u00edsticas en sus mensajes de texto.\",\"MobileMessaging_Settings_SMSProvider\":\"Proveedor SMS\",\"MobileMessaging_Settings_PleaseSignUp\":\"Para crear informes SMS y recibir mensajes cortos de texto con las estad\\u00edsticas de sus sitios web en su tel\\u00e9fono m\\u00f3vil, por favor, reg\\u00edstrese en la API de SMS e introduzca sus datos a continuaci\\u00f3n.\",\"MobileMessaging_Settings_CredentialInvalid\":\"Tu cuenta de SMS API %1$s est\\u00e1 configurada, sin embargo, se produjo un error mientras se intentaban recibir los cr\\u00e9ditos disponibles.\",\"MobileMessaging_Settings_CredentialProvided\":\"Su %s cuenta API SMS est\\u00e1 correctamente configurada!\",\"MobileMessaging_Settings_UpdateOrDeleteAccount\":\"Puede tambi\\u00e9n %1$sactualizar%2$s o %3$sborrar%4$s esta cuenta.\",\"MobileMessaging_UserKey\":\"Clave de usuario\",\"MobileMessaging_Settings_APIKey\":\"Clave API\",\"MobileMessaging_Settings_LetUsersManageAPICredential\":\"Permitir a los usuarios administrar sus propias credenciales API de su SMS\",\"MobileMessaging_Settings_SelectCountry\":\"Seleccionar pa\\u00eds\",\"MobileMessaging_Settings_CountryCode\":\"C\\u00f3digo de pa\\u00eds\",\"MobileMessaging_Settings_PhoneNumber\":\"N\\u00famero telef\\u00f3nico\",\"MobileMessaging_Settings_EnterActivationCode\":\"Introducir el c\\u00f3digo de activaci\\u00f3n\",\"MobileMessaging_Settings_PhoneNumbers_Add\":\"Agregar un nuevo n\\u00famero telef\\u00f3nico\",\"MobileMessaging_Settings_DelegatedPhoneNumbersOnlyUsedByYou\":\"Los n\\u00fameros telef\\u00f3nicos configurados solo pueden ser vistos y utilizados por usted y nadie m\\u00e1s.\",\"MobileMessaging_Settings_PhoneNumbers_Help\":\"Antes de recibir los mensajes de texto (SMS) de los informes en un tel\\u00e9fono, debe introducirse el n\\u00famero de tel\\u00e9fono.\",\"MobileMessaging_Settings_PhoneNumbers_CountryCode_Help\":\"Si no conoce el c\\u00f3digo telef\\u00f3nico del pa\\u00eds, b\\u00fasquelo aqu\\u00ed.\",\"MobileMessaging_Settings_ManagePhoneNumbers\":\"Administrar n\\u00fameros telef\\u00f3nicos\",\"MobileMessaging_Settings_VerificationCodeJustSent\":\"Le hemos enviado un mensaje de texto (SMS) con un c\\u00f3digo: por favor, introduzca este c\\u00f3digo arriba y haga clic en \\\"Validar\\\".\",\"MobileMessaging_Settings_ValidatePhoneNumber\":\"Convalidado\",\"MobileMessaging_MobileReport_NoPhoneNumbers\":\"Por favor, active al menos un n\\u00famero telef\\u00f3nico accediendo\",\"MobileMessaging_MobileReport_AdditionalPhoneNumbers\":\"Puede agregar m\\u00e1s n\\u00fameros telef\\u00f3nicos accediendo\",\"MobileMessaging_MobileReport_MobileMessagingSettingsLink\":\"p\\u00e1gina de configuraciones de mensajer\\u00eda m\\u00f3vil\",\"MobileMessaging_PhoneNumbers\":\"N\\u00fameros telef\\u00f3nicos\",\"MobileMessaging_Settings_DelegatedSmsProviderOnlyAppliesToYou\":\"El proveedor de SMS configurado solo podr\\u00e1 ser usado por usted y nadie m\\u00e1s.\",\"MobileMessaging_Settings_CredentialNotProvided\":\"Antes de crear y administrar los n\\u00fameros telef\\u00f3nicos, por favor conecte Matomo con su cuenta SMS.\",\"MobileMessaging_Settings_CredentialNotProvidedByAdmin\":\"Antes que pueda crear y administrar n\\u00fameros telef\\u00f3nicos, consulte con su administrador para conectar Matomo con una cuenta SMS.\",\"MobileMessaging_Settings_DeleteAccountConfirm\":\"\\u00bfEst\\u00e1 seguro que desea borrar esta cuenta SMS?\",\"MobileMessaging_Settings_SuspiciousPhoneNumber\":\"Si no recibe el mensaje de texto, puede intentarlo sin el cero inicial. Por ejemplo, %s\",\"MobileMessaging_ConfirmRemovePhoneNumber\":\"Are you sure you want to remove the phone number %1$s?\",\"MobileMessaging_Settings_ResendVerification\":\"Resend verification code\",\"MobileMessaging_Settings_NewVerificationCodeSent\":\"A new verification code has been sent.\",\"General_OverlayRowActionTooltipTitle\":\"Superposici\\u00f3n p\\u00e1gina abierta\",\"General_OverlayRowActionTooltip\":\"Vea la informaci\\u00f3n anal\\u00edtica directamente en su sitio de internet (abre una nueva leng\\u00fceta)\",\"SegmentEditor_CustomSegment\":\"Segmento personalizado\",\"SegmentEditor_VisibleToSuperUser\":\"Visible para usted debido a que posee un acceso de Super Usuario\",\"SegmentEditor_SharedWithYou\":\"Compartido con usted\",\"SegmentEditor_CurrentlySelectedSegment\":\"Segmento seleccionado actualmente: %s\",\"SegmentEditor_OperatorAND\":\"Y\",\"SegmentEditor_OperatorOR\":\"O\",\"SegmentEditor_AddANDorORCondition\":\"Agregar condici\\u00f3n %s\",\"SegmentEditor_DefaultAllVisits\":\"Todas las visitas\",\"General_OperationEquals\":\"Iguales\",\"General_OperationNotEquals\":\"No Iguales\",\"General_OperationAtMost\":\"A lo sumo\",\"General_OperationAtLeast\":\"Al menos\",\"General_OperationLessThan\":\"Menos que\",\"General_OperationIs\":\"Es\",\"General_OperationIsNot\":\"No es\",\"General_OperationContains\":\"Contiene\",\"General_OperationDoesNotContain\":\"No contiene\",\"General_OperationStartsWith\":\"Empieza con\",\"General_OperationEndsWith\":\"Termina con\",\"General_Unknown\":\"Desconocido\",\"SegmentEditor_ThisSegmentIsCompared\":\"Este segmento se est\\u00e1 comparando actualmente.\",\"SegmentEditor_ThisSegmentIsSelectedAndCannotBeCompared\":\"Este segmento est\\u00e1 actualmente seleccionado, por lo que no se puede seleccionar para comparar.\",\"SegmentEditor_CompareThisSegment\":\"Compare este segmento con el segmento y periodo seleccionado.\",\"Live_VisitsLog\":\"Registro de visitas\",\"CoreHome_PeriodRange\":\"Rango\",\"CorePluginsAdmin_Marketplace\":\"CorePluginsAdmin_Marketplace\",\"CorePluginsAdmin_MissingRequirementsNotice\":\"Por favor actualice %1$s %2$s a una versi\\u00f3n m\\u00e1s reciente, se requiere %1$s %3$s.\",\"CorePluginsAdmin_Themes\":\"Temas\",\"CorePluginsAdmin_ViewAllMarketplacePlugins\":\"Ver todos los complementos del \\\"Marketplace\\\"\",\"General_Documentation\":\"Documentaci\\u00f3n\",\"General_Downloads\":\"Descargas\",\"Login_ConfirmPasswordToContinue\":\"Confirme su contrase\\u00f1a a continuaci\\u00f3n\",\"Marketplace_ActionInstall\":\"Instalar\",\"Marketplace_ActivateLicenseKey\":\"Activar\",\"Marketplace_AllowedUploadFormats\":\"Puede subir un complemento o tema en formato .zip v\\u00eda esta p\\u00e1gina.\",\"Marketplace_BrowseMarketplace\":\"Explorar Mercado\",\"Marketplace_CannotUpdate\":\"No se puede actualizar\",\"Marketplace_CannotInstall\":\"No se puede instalar\",\"Marketplace_CreateAccountErrorAPI\":\"Se ha producido un error al crear su cuenta en el mercado. Por favor, vuelve a intentarlo m\\u00e1s tarde.\",\"Marketplace_CreateAccountErrorLicenseExists\":\"Se ha encontrado una licencia existente. Por favor, elimine la clave de licencia antes de crear una nueva cuenta.\",\"Marketplace_ConfirmRemoveLicense\":\"\\u00bfEst\\u00e1s seguro de que quieres eliminar tu clave de licencia? No recibir\\u00e1s actualizaciones para ninguno de tus complementos comprados.\",\"Marketplace_CurrentNumPiwikUsers\":\"Actualmente, tu Matomo tiene %1$s usuarios registrados.\",\"Marketplace_Exceeded\":\"Excedido\",\"Marketplace_Free\":\"Gratis\",\"Marketplace_InstallAllPurchasedPlugins\":\"Instalar todos los complementos comprados de una vez\",\"Marketplace_InstallAllPurchasedPluginsAction\":\"Instalar y activar %d complementos comprados\",\"Marketplace_InstallPurchasedPlugins\":\"Instalar complementos comprados\",\"Marketplace_InstallThesePlugins\":\"Esto instalar\\u00e1 y activar\\u00e1 los siguientes complementos:\",\"Marketplace_Intro\":\"Ampl\\u00eda la funcionalidad de Matomo con plugins y cambia su apariencia con temas. Puedes solicitar pruebas de plugins premium o pedir a tu administrador que instale plugins o temas por ti.\",\"Marketplace_IntroSuperUser\":\"Ampl\\u00eda la funcionalidad de Matomo con plugins y cambia su apariencia con temas. Inicia pruebas gratuitas de plugins premium o instala directamente plugins y temas gratuitos.\",\"Marketplace_LicenseExceeded\":\"Licencia excedida\",\"Marketplace_LicenseExceededPossibleCause\":\"La licencia se ha excedido. Posiblemente, en esta instalaci\\u00f3n de Matomo, haya m\\u00e1s usuarios que los que autoriza la suscripci\\u00f3n.\",\"Marketplace_LicenseKey\":\"Clave de licencia\",\"Marketplace_LicenseKeyActivatedSuccess\":\"\\u00a1La clave de licencia se ha activado con \\u00e9xito!\",\"Marketplace_LicenseKeyDeletedSuccess\":\"Clave de licencia eliminada con \\u00e9xito.\",\"Marketplace_LicenseKeyIsValidShort\":\"\\u00a1La clave de licencia es valida!\",\"Marketplace_LicenseMissing\":\"No se encuentra la licencia\",\"Marketplace_LicenseRenewsNextPaymentDate\":\"Renueva en la siguiente fecha de pago\",\"Marketplace_ManageLicenseKeyIntro\":\"Puede ampliar las capacidades de Matomo utilizando nuestros plugins premium. Para instalar plugins premium, necesita una clave de licencia v\\u00e1lida, que se puede obtener de dos maneras: puede iniciar una prueba para el plugin seleccionado en el %1$smercado en l\\u00ednea%2$s, o comprar una suscripci\\u00f3n de plugin en %3$snuestra p\\u00e1gina web%4$s. Si inicia una prueba en el mercado, se crear\\u00e1 autom\\u00e1ticamente una clave de licencia y se a\\u00f1adir\\u00e1 a esta instancia. Si adquiere una suscripci\\u00f3n en el sitio web, recibir\\u00e1 una clave de licencia que podr\\u00e1 a\\u00f1adir en el siguiente campo. Una vez a\\u00f1adida la clave de licencia, puede actualizarla o eliminarla si es necesario.\",\"Marketplace_NoPluginsFound\":\"No se encontraron complementos\",\"Marketplace_NoSubscriptionsFound\":\"No se encontraron suscripciones\",\"Marketplace_NoThemesFound\":\"No se encontraron temas\",\"Marketplace_NoValidSubscriptionNoUpdates\":\"Una vez que una suscripci\\u00f3n expira, ya no recibir\\u00e1s m\\u00e1s actualizaciones para este complemento.\",\"Marketplace_NoticeRemoveMarketplaceFromReportingMenu\":\"Puede eliminar el Mercado del men\\u00fa de informes instalando el plugin %1$sWhite Label%2$s.\",\"Marketplace_OverviewPluginSubscriptions\":\"Resumen de tus suscripciones a complementos\",\"Marketplace_OverviewPluginSubscriptionsAllDetails\":\"Para ver todos los detalles, o para cambiar una suscripci\\u00f3n, inicia sesi\\u00f3n en tu cuenta.\",\"Marketplace_OverviewPluginSubscriptionsMissingInfo\":\"Puede ser posible que no aparezcan algunas de las suscripciones, por ejemplo, si el pago no ha sido completado todav\\u00eda. En tal caso, prueba de nuevo en unas horas o contacta con el equipo de Matomo.\",\"Marketplace_OverviewPluginSubscriptionsMissingLicenseMessage\":\"You do not have a license key set. If you have purchased a plugin subscription, go to the %1$sLicense key page%2$s and enter your key. If you are interested in purchasing a plugin, visit the %3$sMarketplace%4$s to explore the available plugins and bundles.\",\"Marketplace_PluginSubscriptionsList\":\"Esta es una lista de las suscripciones asociadas con tu clave de licencia.\",\"Marketplace_PluginUploadDisabled\":\"La carga del complemento est\\u00e1 deshabilitada en el archivo de configuraci\\u00f3n. Para habilitar esta funci\\u00f3n, actualice su configuraci\\u00f3n o comun\\u00edquese con su administrador\",\"Marketplace_PriceFromPerPeriod\":\"Desde %1$s \\\/ %2$s\",\"Marketplace_RemoveLicenseKey\":\"Eliminar clave de licencia\",\"Marketplace_RequestTrial\":\"Solicitar prueba\",\"Marketplace_RequestTrialConfirmEmailWarning\":\"Al solicitar una prueba se enviar\\u00e1 un correo electr\\u00f3nico a todos los superusuarios. \\u00bfEst\\u00e1s seguro de que quieres continuar?\",\"Marketplace_RequestTrialConfirmTitle\":\"Solicitar prueba para %s\",\"Marketplace_RequestTrialSubmitted\":\"Prueba solicitada para el plugin %s.\",\"Marketplace_RichMenuIntro\":\"Explore y adquiera plugins esenciales para su panel de control.\",\"Marketplace_Show\":\"Mostrar\",\"Marketplace_Sort\":\"Ordenar\",\"Marketplace_SpecialOffer\":\"Oferta especial\",\"Marketplace_StartFreeTrial\":\"Iniciar prueba gratuita\",\"Marketplace_SubscriptionEndDate\":\"Fecha de fin\",\"Marketplace_SubscriptionExpiresSoon\":\"Esta suscripci\\u00f3n expirar\\u00e1 pronto\",\"Marketplace_SubscriptionInvalid\":\"Esta suscripci\\u00f3n es invalida o ha caducado\",\"Marketplace_SubscriptionNextPaymentDate\":\"Fecha del siguiente pago\",\"Marketplace_SubscriptionStartDate\":\"Fecha de inicio\",\"Marketplace_SubscriptionType\":\"Tipo\",\"Marketplace_SupportMatomoThankYou\":\"Cualquier compra ayudar\\u00e1 a financiar el futuro del proyecto de c\\u00f3digo abierto Matomo. \\u00a1Gracias por su apoyo!\",\"Marketplace_TeaserExtendPiwikByUpload\":\"Ampl\\u00ede Matomo cargando un archivo ZIP\",\"Marketplace_TrialHints\":\"Todas las funciones premium vienen con una %1$s prueba gratuita de 30 d\\u00edas%2$s. No hay riesgo y no hay ataduras.\",\"Marketplace_TrialRequested\":\"Prueba solicitada\",\"Marketplace_TrialStartErrorSupport\":\"Si el error persiste, p\\u00f3ngase en contacto con nuestro equipo de asistencia.\",\"Marketplace_TrialStartErrorTitle\":\"Algo sali\\u00f3 mal\",\"Marketplace_TrialStartInProgressText\":\"Solo deber\\u00eda tardar unos segundos.\",\"Marketplace_TrialStartInProgressTitle\":\"Cargando... \\u00a1ya casi est\\u00e1!\",\"Marketplace_TrialStartNoLicenseAddHere\":\"\\u00bfYa tiene una clave de licencia? %1$sA\\u00f1\\u00e1dala aqu\\u00ed%2$s\",\"Marketplace_TrialStartNoLicenseCreateAccount\":\"Crear una cuenta\",\"Marketplace_TrialStartNoLicenseLegalHint\":\"Al crear una cuenta usted acepta los %1$sT\\u00e9rminos y Condiciones%2$sdel Mercado de Matomo. Trataremos sus datos personales de conformidad con nuestra %3$sPol\\u00edtica de privacidad%4$s\",\"Marketplace_TrialStartNoLicenseText\":\"Maximice sus capacidades Matomo con nuestros plugins premium. Cree una cuenta de Marketplace gratuita para asociar autom\\u00e1ticamente una clave de licencia v\\u00e1lida a su instancia de Matomo.\",\"Marketplace_TrialStartNoLicenseTitle\":\"Inicie hoy mismo su prueba gratuita\",\"Marketplace_UpgradeSubscription\":\"Actualizar Suscripci\\u00f3n\",\"Marketplace_UploadZipFile\":\"Carga un archivo ZIP\",\"Marketplace_ViewSubscriptions\":\"Ver suscripciones\",\"Mobile_LoadingReport\":\"Cargando %s\",\"Marketplace_AddToCart\":\"A\\u00f1adir al carrito de la compra\",\"Marketplace_Authors\":\"Autores\",\"Marketplace_AutoUpdateDisabledWarning\":\"No puedes instalar o actualizar el plugin directamente ya que las actualizaciones autom\\u00e1ticas est\\u00e1n deshabilitadas en la configuraci\\u00f3n. Para habilitar las actualizaciones autom\\u00e1ticas configura %1$s en %2$s.\",\"Marketplace_ByXDevelopers\":\"por %s desarrolladores\",\"Marketplace_ClickToCompletePurchase\":\"Haz clic para completar la compra.\",\"Marketplace_Developer\":\"Desarrollador\",\"Marketplace_FeaturedPlugin\":\"Complemento destacado\",\"Marketplace_LastCommitTime\":\"(\\u00faltimo cambio %s)\",\"Marketplace_LastUpdated\":\"\\u00daltima actualizaci\\u00f3n\",\"Marketplace_License\":\"Licencia\",\"Marketplace_MultiServerEnvironmentWarning\":\"No puedes instalar o actualizar el complemento directamente ya que est\\u00e1s usando Matomo en m\\u00faltiples servidores y el complemento ser\\u00eda instalado en un solo servidor. Descarga el complemento e inst\\u00e1lalo manualmente en todos tu servidores.\",\"Marketplace_NumDownloadsLatestVersion\":\"\\u00daltima versi\\u00f3n: %s descargas\",\"Marketplace_PluginKeywords\":\"Palabras claves\",\"Marketplace_PluginLicenseExceededDescription\":\"No tiene permiso para descargar este complemento. La licencia de este complemento ya no es v\\u00e1lida porque se supera el n\\u00famero de usuarios autorizados para la licencia. Para resolver este problema, elimine algunos usuarios o actualice su suscripci\\u00f3n ahora.\",\"Marketplace_PluginLicenseMissingDescription\":\"No se te permite descargar este complemento porque no hay licencia para \\u00e9l. Para resolver esta incidencia, actualiza tu clave de licencia, consigue una suscripci\\u00f3n o desinstala el complemento.\",\"Marketplace_PluginWebsite\":\"Sitio web del complemento\",\"Marketplace_PriceExclTax\":\"%1$s %2$s impuestos excluidos.\",\"Marketplace_Reviews\":\"Rese\\u00f1as\",\"Marketplace_Screenshots\":\"Capturas de pantalla\",\"Marketplace_ShownPriceIsExclTax\":\"El precio mostrado no incluye impuestos.\",\"Marketplace_TryFreeTrialTitle\":\"Pruebe 30 d\\u00edas gratis y luego\",\"CorePluginsAdmin_Activity\":\"Actividad\",\"CorePluginsAdmin_Websites\":\"Sitios de internet\",\"Marketplace_PluginLicenseStatusPending\":\"Su clave de licencia para %1$s est\\u00e1 en estado pendiente. Para solucionarlo, vaya a su %2$sCuenta de Marketplace%3$s y actualice sus datos de pago.\",\"Marketplace_PluginLicenseStatusCancelled\":\"Su clave de licencia para %1$s ha sido cancelada. Para seguir utilizando este plugin, vaya a su cuenta de %2$sMarketplace%3$s e inicie una nueva suscripci\\u00f3n para este plugin.\",\"Marketplace_PluginDownloadLinkMissingPremium\":\"No se ha podido instalar el plugin %1$s. Compruebe su licencia. Si tiene una suscripci\\u00f3n activa para el plugin %1$s, intente instalarlo manualmente utilizando un archivo zip descargado desde su cuenta de %2$sMarketplace%3$s. %4$sM\\u00e1s informaci\\u00f3n%5$s.\",\"Marketplace_PluginDownloadLinkMissingFree\":\"No se ha podido instalar el plugin %1$s, intente instalarlo manualmente utilizando un archivo zip de este %2$senlace%3$s. %4$sM\\u00e1s informaci\\u00f3n%5$s.\",\"Marketplace_PluginDownloadLinkMissingDescription\":\"No se ha podido obtener el enlace de descarga del plugin %1$s, intente instalarlo manualmente desde el marketplace. %2$sM\\u00e1s informaci\\u00f3n%3$s.\",\"Marketplace_CreatedBy\":\"Creado por\",\"ProfessionalServices_DismissedNotification\":\"The %1$s menu will no longer be shown, unless the plugin is installed on your Matomo instance.\",\"ProfessionalServices_PromoFunnels\":\"Funnels\",\"ProfessionalServices_PromoFormAnalytics\":\"Formularios\",\"ProfessionalServices_PromoMediaAnalytics\":\"Media\",\"ProfessionalServices_PromoAbTesting\":\"A\\\/B Tests\",\"ProfessionalServices_PromoHeatmaps\":\"Heatmaps\",\"ProfessionalServices_PromoSessionRecording\":\"Session Recordings\",\"ProfessionalServices_PromoCustomReports\":\"Custom Reports\",\"ProfessionalServices_PromoCrashAnalytics\":\"Crashes\",\"UserId_UserIdDisabledSettingRequirementNote\":\"Collection of User ID while tracking must be disabled.\",\"UserId_UserIdDisabledSettingTitle\":\"User ID disabled\",\"PagePerformance_RowActionTitle\":\"Abrir reporte de rendimiento de p\\u00e1gina\",\"PagePerformance_RowActionDescription\":\"Show page performance report for this row\",\"PagePerformance_PagePerformanceTitle\":\"Page performance for page with %1$s \\\"%2$s\\\"\",\"General_Total\":\"Total\",\"CustomDimensions_CustomDimensionsIntro\":\"Creando %1$sdimensiones personalizadas%2$s puede recopilar cualquier dato personalizado de '%3$s'.\",\"CustomDimensions_CustomDimensionsIntroNext\":\"Matomo crear\\u00e1 un informe para cada Medida personalizada (incluyendo la tasa de conversi\\u00f3n de cada uno de sus Metas), como tambi\\u00e9n segmentar f\\u00e1cilmente a sus usuarios basados en estos valores. Las Medidas personalizadas son similares a %1$sVariables personalizadas%2$s solo unas peque\\u00f1as %3$sdiferencias entre las mismas%4$s.\",\"CustomDimensions_ScopeTitleVisit\":\"Dimensiones de la visita\",\"CustomDimensions_ScopeDescriptionVisit\":\"Las dimensiones personalizadas en el \\u00e1mbito \\\"Visita\\\" pueden enviarse junto con cualquier solicitud de seguimiento y se almacenan en la visita.\",\"CustomDimensions_ScopeDescriptionVisitMoreInfo\":\"Si define diferentes valores para una medida dada durante el tiempo de vida de una visita, el \\u00faltimo valor ajustado ser\\u00e1 utilizado.\",\"CustomDimensions_ScopeTitleAction\":\"Dimensiones de la acci\\u00f3n\",\"CustomDimensions_ScopeDescriptionAction\":\"Las dimensiones personalizadas del \\u00e1mbito 'Acci\\u00f3n' pueden ser enviadas en cualquier acci\\u00f3n (vista de p\\u00e1gina, descarga, evento, etc.).\",\"CustomDimensions_ScopeDescriptionActionMoreInfo\":\"Se pueden definir lo que se llama \\\"extracciones\\\" de manera que el valor de la dimensi\\u00f3n personalizada se extraiga de la URL, del t\\u00edtulo de la p\\u00e1gina o de los par\\u00e1metros del \\\"querystring\\\" de la URL de la p\\u00e1gina.\",\"CustomDimensions_IncreaseAvailableCustomDimensionsTitle\":\"Aumentar el n\\u00famero disponible de dimensiones personalizadas\",\"CustomDimensions_IncreaseAvailableCustomDimensionsTakesLong\":\"La creaci\\u00f3n de una nueva Medida personalizada puede llevar un cierto tiempo, dependiendo del tama\\u00f1o de su base de datos, ya que requiere cambios en el esquema de la base de datos. Por lo tanto, s\\u00f3lo es posible hacerlo a trav\\u00e9s de un comando de consola que necesita ser ejecutado precisamente desde la l\\u00ednea de comandos.\",\"CustomDimensions_HowToCreateCustomDimension\":\"Para crear una nueva dimensi\\u00f3n personalizada ejecute el siguiente comando dentro de su instalaci\\u00f3n Matomo:\",\"CustomDimensions_HowToManyCreateCustomDimensions\":\"Si desea crear m\\u00faltiples dimensiones personalizadas de una vez, simplemente a\\u00f1ada el n\\u00famero de medidas que ser\\u00e1n creadas. Como todos los cambios en la base de datos ser\\u00e1n ejecutados en una sola sentencia, no deber\\u00eda tomar mucho tiempo agregar m\\u00faltiples dimensiones personalizadas de una vez.\",\"CustomDimensions_ExampleCreateCustomDimensions\":\"Por ejemplo, para crear una nueva %s Medida personalizada en el \\u00e1mbito Acci\\u00f3n, ejecutar el siguiente comando:\",\"CustomDimensions_HowToTrackManuallyTitle\":\"Monitorea manualmente un valor para esta dimensi\\u00f3n\",\"CustomDimensions_HowToTrackManuallyViaJs\":\"Para monitorear el valor en la llamada al JavaScript Tracker:\",\"CustomDimensions_HowToTrackManuallyViaJsDetails\":\"Para una mayor informaci\\u00f3n lea la gu\\u00eda %1$sJavascript Tracker para dimensiones personalizadas%2$s\",\"CustomDimensions_HowToTrackManuallyViaPhp\":\"Para rastrear el valor en la llamada al PHP Tracker:\",\"CustomDimensions_HowToTrackManuallyViaHttp\":\"Para rastrear un valor v\\u00eda la API del rastreador HTTP use el par\\u00e1metro 'dimension' seguido del id de la dimensi\\u00f3n personalizada:\",\"CustomDimensions_Extractions\":\"Extracciones\",\"CustomDimensions_ExtractionsHelp\":\"Esto es opcional. Un expresi\\u00f3n regular se puede utilizar para extraer el valor de esta dimensi\\u00f3n personalizada de una URL de p\\u00e1gina o t\\u00edtulo de p\\u00e1gina autom\\u00e1ticamente. De esta manera, el valor de la dimensi\\u00f3n personalizado no tiene que configurarse manualmente a trav\\u00e9s de un cliente de seguimiento. Un valor todav\\u00eda se puede establecer manualmente a trav\\u00e9s de la API de Matomo Tracker. Los valores de la dimensi\\u00f3n establecidos manualmente en el seguimiento de clientes siempre tienen prioridad sobre las extracciones. Si se definen m\\u00faltiples extracciones, se utiliza la primera extracci\\u00f3n que coincida. No necesitas escapar de las barras delanteras, ya que Matomo hace esto por ti autom\\u00e1ticamente. Por ejemplo, utilice \\\/news\\\/ en lugar de \\\\\\\/news\\\\\\\/.\",\"CustomDimensions_ExtractValue\":\"Extraer valor\",\"CustomDimensions_ExampleValue\":\"valor de la dimensi\\u00f3n\",\"CustomDimensions_NoCustomDimensionConfigured\":\"Todav\\u00eda no ha configurado ninguna dimensi\\u00f3n personalizada, configure una ahora.\",\"CustomDimensions_ConfigureNewDimension\":\"Configurar una nueva dimensi\\u00f3n\",\"CustomDimensions_ConfigureDimension\":\"Configurar %1$s dimensiones personalizadas %2$s\",\"CustomDimensions_XofYLeft\":\"quedan %1$s de %2$s dimensiones\",\"CustomDimensions_CannotBeDeleted\":\"Una dimensi\\u00f3n personalizada no puede ser eliminada, solo desactivada.\",\"CustomDimensions_PageUrlParam\":\"Par\\u00e1metro de la URL de p\\u00e1gina\",\"CustomDimensions_NameAllowedCharacters\":\"Los caracteres permitidos son cualquier letra, n\\u00famero, espacio en blanco, gui\\u00f3n o subrayado.\",\"CustomDimensions_NameIsRequired\":\"Es necesario un nombre.\",\"CustomDimensions_NameIsTooLong\":\"Nombre contiene demasiados caracteres, use hasta %d caracteres.\",\"CustomDimensions_ExceptionDimensionDoesNotExist\":\"No existe la dimensi\\u00f3n %1$d para el sitio web %2$d.\",\"CustomDimensions_ExceptionDimensionIsNotActive\":\"No est\\u00e1 activada la dimensi\\u00f3n %1$d del sitio web %2$d.\",\"CustomDimensions_DimensionCreated\":\"Dimensi\\u00f3n personalizada creada\",\"CustomDimensions_DimensionUpdated\":\"Dimensi\\u00f3n personalizada actualizada\",\"CustomDimensions_ColumnUniqueActions\":\"Acciones \\u00fanicas\",\"CustomDimensions_ColumnAvgTimeOnDimension\":\"Promedio de tiempo para la dimensi\\u00f3n\",\"CustomDimensions_CustomDimensionId\":\"Dimensiones personalizadas (Id %d)\",\"General_Update\":\"Actualizar\",\"General_Create\":\"Crear\",\"CustomDimensions_UrlQueryStringParameter\":\"par\\u00e1metro de la cadena de consulta de la url\",\"JsTrackerInstallCheck_OptionalTestInstallationDescription\":\"Optional: To test that the tracking code is able to send requests to your Matomo instance, enter the exact URL you are tracking and click on \\\"Test installation\\\". A new tab will open, and should close within 10 seconds.\",\"JsTrackerInstallCheck_TestInstallationBtnText\":\"Probar instalaci\\u00f3n\",\"JsTrackerInstallCheck_JsTrackingCodeInstallCheckSuccessMessage\":\"\\u00a1El c\\u00f3digo de seguimiento se ha instalado correctamente! Esta pantalla desaparecer\\u00e1 tan pronto como se registren algunos datos para tu sitio web.\",\"JsTrackerInstallCheck_JsTrackingCodeInstallCheckFailureMessage\":\"Fallo en la verificaci\\u00f3n del c\\u00f3digo de seguimiento. Verifica que has instalado el c\\u00f3digo correctamente. %1$sSaber m\\u00e1s%2$s.\",\"General_Testing\":\"Probando\\u2026\",\"JsTrackerInstallCheck_JsTrackingCodeInstallCheckFailureMessageWordpress\":\"Fallo en la verificaci\\u00f3n del c\\u00f3digo de seguimiento. Verifica que has instalado el plugin \\\"%1$s\\\" y seguido todos los pasos correctamente. %2$sSaber m\\u00e1s%3$s.\",\"General_ClickX\":\"Haz clic en \\\"%1$s\\\".\",\"TagManager_DetectingChanges\":\"Detectando cambios\\u2026\",\"TagManager_NoContainersFound\":\"No se encuentra contenedor.\",\"TagManager_PreConfiguredInfoTitle\":\"Las variables preconfiguradas son variables que est\\u00e1n listas-para-usar y no se pueden crear, editar o configurar. Funcionan fuera de la caja y se pueden usarlas en identificaciones, activadores y variables si as\\u00ed fuera necesario.\",\"TagManager_TriggerConditionNode\":\"Nota: Algunas variables pueden no funcionar como se espera. Por ejemplo, usar una variable de clic en combinaci\\u00f3n con una variable de formulario podr\\u00eda funcionar solo si tambi\\u00e9n ha agregado un activador de clic a su contenedor. Esto se aplica normalmente a las variables dentro de las categor\\u00edas Clics, Formularios, Historial, Errores, Desplazamientos y Visibilidad, que normalmente se deben utilizar solo con respectivo activador.\",\"TagManager_ConfigureEnvironmentsSuperUser\":\"Tenga en cuenta que un usuario con atributos de acceso de superusuario puede configurar los entornos disponibles yendo a \\\"Administraci\\u00f3n \\u2192 Configuraci\\u00f3n general\\\".\",\"TagManager_WantToDeployThisChangeCreateVersion\":\"\\u00bfDesea implementar este cambio? %1$sPublique una nueva versi\\u00f3n ahora%2$s.\",\"TagManager_ConfigureWhenTagDoes\":\"Configurar cuando la etiqueta deber\\u00eda hacer esto\",\"TagManager_ViewContainerDashboard\":\"Tablero Vista Contenedor\",\"TagManager_NoMatomoConfigFoundForContainer\":\"Ninguna configuraci\\u00f3n Matomo encontrada en este contenedor.\",\"TagManager_PublishLiveEnvironmentCapabilityRequired\":\"Por favor, tenga en cuenta que solo un usuario con los atributos \\\"Admin\\\", o un usuario con la capacidad \\\"%1$s\\\" puede publicar en el entorno \\\"en Directo\\\".\",\"TagManager_CapabilityPublishLiveContainer\":\"Publicar Contenedor en directo\",\"TagManager_VersionAlreadyPublishedToAllEnvironments\":\"Esta versi\\u00f3n no se puede publicar en ning\\u00fan otro entorno.\",\"TagManager_UseCustomTemplateCapabilityPermissionRequiredDescription\":\"This is a Custom Template. You do not have permission to modify Custom Templates. Contact your Matomo superuser to request the %1$sTag Manager: %2$s permission%3$s.\",\"TagManager_CapabilityUseCustomTemplates\":\"Usar plantillas personalizadas\",\"TagManager_ViewX\":\"Ver %s\",\"TagManager_DeleteX\":\"Eliminar %s\",\"TagManager_CreateNewX\":\"Crea nuevo %s\",\"TagManager_EditX\":\"Modificar %s\",\"TagManager_Context\":\"Contexto\",\"TagManager_ManageContainersIntro\":\"With Matomo Tag Manager (MTM), you can change your tracking configurations without making changes to your website. These configurations are stored in containers. It is common to have only one container per site, although multiple containers can be added for a complex multi-domain or multi-team setup. Matomo automatically pre-configures the first container for your website. %1$sLearn more%2$s.\",\"TagManager_ContainerNameHelp\":\"El nombre del contenedor le permite definir un nombre \\u00fanico para este contenedor. Tenga en cuenta que este nombre tambi\\u00e9n estar\\u00e1 disponible como una variable y, por lo tanto, ser\\u00e1 visible p\\u00fablicamente en el c\\u00f3digo fuente de la etiqueta.\",\"TagManager_ContainerContextHelp\":\"Define en qu\\u00e9 contexto se desplegar\\u00e1 el contenedor. Actualmente, solo los contenedores \\\"web\\\" est\\u00e1n contemplados.\",\"TagManager_ContainerDescriptionHelp\":\"Opcionalmente, puede describir el prop\\u00f3sito de este contenedor. Esto es especialmente \\u00fatil si tiene varios contenedores por sitio.\",\"TagManager_TagStartDateHelp\":\"Si se establece, esta etiqueta se activar\\u00e1 solo despu\\u00e9s de esta fecha de inicio. Se asumir\\u00e1 que la fecha especificada est\\u00e1 en %1$ssu zona horaria local%2$s.\",\"TagManager_TagEndDateHelp\":\"Si se establece, esta etiqueta se activar\\u00e1 solo hasta esta fecha de finalizaci\\u00f3n. Se asumir\\u00e1 que la fecha especificada est\\u00e1 en %1$ssu zona horaria local%2$s.\",\"TagManager_CurrentTimeInLocalTimezone\":\"Su actual horario es %1$s%2$s%3$s.\",\"TagManager_TagUsageBenefits\":\"Una identificaci\\u00f3n es un fragmento de c\\u00f3digo que puede ejecutarse en su sitio. La mayor\\u00eda de las veces se puede usar para enviar datos a un tercero (por ejemplo, datos de seguimiento) o para incrustar contenido de un tercero en su sitio web (por ejemplo, widgets sociales o encuestas). Puede agregar tantas identificaciones como desee y se ejecutar\\u00e1 una tan pronto como se cumpla la condici\\u00f3n de un activador conectado.\",\"TagManager_TagNameHelpV2\":\"Define a unique tag name. Note: This is publicly visible when the container is in preview\\\/debug mode.\",\"TagManager_NoTagsFound\":\"No se encontraron identificadores.\",\"TagManager_DeleteTagConfirm\":\"Est\\u00e1 seguro que desea eliminar esta etiqueta? No podr\\u00e1 deshacer esta acci\\u00f3n.\",\"TagManager_DeleteVersionConfirm\":\"\\u00bfEst\\u00e1 seguro que desea eliminar esta versi\\u00f3n? No podr\\u00e1 deshacer esta eliminaci\\u00f3n.\",\"TagManager_VersionUsageBenefits\":\"Las versiones le permiten guardar una copia de la configuraci\\u00f3n actual de un contenedor para que pueda volver a una versi\\u00f3n anterior de un contenedor si lo necesita. Esto facilita la recuperaci\\u00f3n de errores y le permite encontrar f\\u00e1cilmente todas las identificadores, activadores y variables implementadas anteriormente. Una vez que est\\u00e9 satisfecho con su configuraci\\u00f3n actual, puede publicarla en un entorno espec\\u00edfico. Por ejemplo, es posible que desee implementar primero su etiqueta en un entorno \\\"de prueba\\\" o \\\"puesta de escena\\\" para asegurarse de que la configuraci\\u00f3n actual funciona antes de ponerla a disposici\\u00f3n de todos los que la utilizan en un entorno en directo.\",\"TagManager_VersionNameHelp\":\"Asigne a esta versi\\u00f3n un nombre que le permita identificarla f\\u00e1cilmente. Puede utilizar cualquier esquema de nombre que desee. Recomendamos utilizar un esquema como \\\"1.0\\\" en el que aumente el \\u00faltimo n\\u00famero cuando haga peque\\u00f1os cambios, como corregir una configuraci\\u00f3n, y el primer n\\u00famero cuando agregue, por ejemplo, una nueva identificaci\\u00f3n. De esta manera, puede f\\u00e1cilmente realizar un seguimiento de todas sus versiones. Tenga en cuenta que este nombre tambi\\u00e9n estar\\u00e1 disponible como una variable y, por lo tanto, ser\\u00e1 visible p\\u00fablicamente en el c\\u00f3digo fuente de la identificaci\\u00f3n.\",\"TagManager_NoVersionsFound\":\"Sin versi\\u00f3n encontrada.\",\"TagManager_NoReleasesFound\":\"No se encuentraron descargas disponibles.\",\"TagManager_NoReleasesFoundForContainer\":\"No se ha encontrado ninguna descarga para este contenedor.\",\"TagManager_Revision\":\"Actualizaci\\u00f3n\",\"TagManager_VersionRevision\":\"Actualizaci\\u00f3n de la versi\\u00f3n\",\"TagManager_ReleasedBy\":\"Liberado por\",\"TagManager_ReleasedOn\":\"Liberado el\",\"TagManager_LearnMore\":\"Aprender m\\u00e1s\",\"TagManager_TagFireTriggerRequirement\":\"Necesita elegir al menos un activador\",\"TagManager_ChooseTagToContinue\":\"Elija un tipo de etiqueta para continuar\",\"TagManager_ChooseTriggerToContinue\":\"Elija un tipo de activador para continuar\",\"TagManager_ChooseVariableToContinue\":\"Elige un tipo de variable para continuar\",\"TagManager_TriggerConditionsHelp\":\"Puede restringir a\\u00fan m\\u00e1s cu\\u00e1ndo debe activarse este activador especificando una o varias condiciones. Solo cuando se cumplan TODAS estas condiciones, el activador se activar\\u00e1 realmente (no cuando solo se cumpla una de ellas). Solo se activa cuando se cumplen todas estas condiciones:\",\"TagManager_TriggerConditionsHelpText\":\"%1$sLearn more%2$s about tracking interactions on nested elements.\",\"TagManager_EnablingPreviewPleaseWait\":\"Habilitando modo de previsualizaci\\u00f3n, por favor espere\\u2026\",\"TagManager_DisablingPreviewPleaseWait\":\"Deshabilitando modo de previsualizaci\\u00f3n, por favor espere\\u2026\",\"TagManager_UpdatingDebugSiteUrlPleaseWait\":\"Updating debug site URL, please wait\\u2026\",\"TagManager_DebugUrlNoUrlErrorMessage\":\"Please Enter a URL to start debugging.\",\"TagManager_DebugUrlSameUrlErrorMessage\":\"Already debugging the same site, please visit the %1$ssite%2$s or enter new url to debug.\",\"TagManager_NameOfLatestVersion\":\"El nombre de las versiones anteriores es %s.\",\"TagManager_Created\":\"Creado\",\"TagManager_CreateVersionWithoutPublishing\":\"Crear una nueva versi\\u00f3n (sin publicar)\",\"TagManager_PublishVersionToEnvironmentToViewEmbedCode\":\"Publique una versi\\u00f3n en un entorno para visualizar aqu\\u00ed el c\\u00f3digo de seguimiento.\",\"TagManager_CreateVersionAndPublishRelease\":\"Crear una nueva versi\\u00f3n y lanzamiento de publicaci\\u00f3n\",\"TagManager_VersionName\":\"Nombre de la versi\\u00f3n\",\"TagManager_VersionDescription\":\"Descripci\\u00f3n de la versi\\u00f3n\",\"TagManager_Released\":\"Liberado\",\"TagManager_ErrorXNotProvided\":\"Por favor suministre un valor para \\\"%1$s\\\".\",\"TagManager_ExportX\":\"Exportar %s\",\"TagManager_PublishVersion\":\"Publicaci\\u00f3n de la versi\\u00f3n \\\"%s\\\" a\\u2026\",\"TagManager_ReleaseInfo\":\"Publicado por %1$s el %2$s.\",\"TagManager_ReleaseVersionInfo\":\"N\\u00famero de versi\\u00f3n %s.\",\"TagManager_PublishRelease\":\"Publicaci\\u00f3n de lanzamiento\",\"TagManager_ManageX\":\"Administrar %s\",\"TagManager_CreatedX\":\"\\u00a1Fant\\u00e1stico! El %s se ha creado con \\u00e9xito.\",\"TagManager_UpdatedX\":\"\\u00a1Fant\\u00e1stico! El %s se ha actualizado con \\u00e9xito.\",\"TagManager_UpdatingData\":\"Actualizaci\\u00f3n datos\\u2026\",\"TagManager_DeleteContainerConfirm\":\"\\u00bfEst\\u00e1 seguro de que desee eliminar este contenedor? No se podr\\u00e1 deshacer esta acci\\u00f3n. Adem\\u00e1s, aseg\\u00farese de eliminar todos los fragmentos de c\\u00f3digo incrustados para este contenedor de su sitio web, ya que los archivos del contenedor ya no estar\\u00e1n disponibles despu\\u00e9s de que lo haya eliminado.\",\"TagManager_VersionEnvironmentHelp\":\"Para incrustar la versi\\u00f3n actual en su sitio, necesita publicarla en un entorno, normalmente un entorno \\\"en Directo\\\". Si tiene un proceso de revisi\\u00f3n espec\\u00edfico o entornos de prueba, es posible que desee publicar primero una versi\\u00f3n en un entorno de \\\"prueba\\\" antes de implementarlo en un sistema de producci\\u00f3n en vivo para asegurarse de que todo funcione como espera. Tambi\\u00e9n puede publicar esta versi\\u00f3n en cualquier momento en cualquier entorno.\",\"TagManager_VersionDescriptionHelp\":\"Opcionalmente, puede describir esta nueva versi\\u00f3n con m\\u00e1s detalles. Recomendamos mencionar lo que has cambiado con cada versi\\u00f3n. Por ejemplo, si solucion\\u00f3 un problema en particular o agreg\\u00f3 una nueva identificaci\\u00f3n. Esto le ayuda a comprender mejor cada versi\\u00f3n, por ejemplo, si tuviera que revertir a una versi\\u00f3n determinada.\",\"TagManager_Container\":\"Contenedor\",\"TagManager_Containers\":\"Contenedores\",\"TagManager_Type\":\"Tipo\",\"TagManager_Types\":\"Tipos\",\"TagManager_Tag\":\"Etiqueta\",\"TagManager_Tags\":\"Identificaciones\",\"TagManager_Version\":\"Versi\\u00f3n\",\"TagManager_Versions\":\"Versiones\",\"TagManager_Environment\":\"Entorno\",\"TagManager_Environments\":\"Entornos\",\"TagManager_Trigger\":\"Activador\",\"TagManager_Triggers\":\"Activadores\",\"TagManager_Variable\":\"Variable\",\"TagManager_Variables\":\"Variables\",\"TagManager_Names\":\"Nombres\",\"TagManager_DiffAdded\":\"Agregado\",\"TagManager_DiffModified\":\"Modificado\",\"TagManager_DiffDeleted\":\"Eliminado\",\"TagManager_DefaultValue\":\"Valor predeterminado\",\"TagManager_DefaultValueHelp\":\"Puede configurar un valor predeterminado que se utilizar\\u00e1 si la variable no devuelve un valor. Tenga en cuenta que una cadena vac\\u00eda ('') se considera un valor y no volver\\u00e1 al valor predeterminado; configure un valor de b\\u00fasqueda para este caso si as\\u00ed fuera necesario. Tambi\\u00e9n tenga en cuenta que el valor predeterminado se aplicar\\u00e1 antes de evaluar la tabla de b\\u00fasqueda.\",\"TagManager_LookupTableTitle\":\"Convierte el valor de una variable autom\\u00e1ticamente en otro valor cuando el valor de esta variable\\u2026\",\"TagManager_LookupTableMatchValue\":\"este valor\",\"TagManager_LookupTableOutValue\":\"despu\\u00e9s convertir a este valor\",\"TagManager_OrCreateAndPublishVersion\":\"o crear una versi\\u00f3n y publicarla\",\"TagManager_ConfigureWhatTagDoes\":\"Configurar lo que esta etiqueta deber\\u00eda hacer\",\"TagManager_ConfigureThisVariable\":\"Configure esta variable\",\"TagManager_ConfigureThisTrigger\":\"Configurar este activador\",\"TagManager_OnlyTriggerWhen\":\"Solamente activar cuando\",\"TagManager_FireTriggerTitle\":\"Ejecuta esta etiqueta cuando se activa alguno de estos activadores.\",\"TagManager_FireTriggerHelp\":\"Esta etiqueta se ejecutar\\u00e1 cada vez que se active alguno de estos activadores. No todos deben activarse para que la etiqueta se ejecute. \\u00bfDesea ejecutar el activador solo una vez por p\\u00e1gina o sesi\\u00f3n? Puede limitar la frecuencia con la que se debe ejecutar la etiqueta en la Configuraci\\u00f3n avanzada cambiando el \\\"%1$s\\\".\",\"TagManager_BlockTriggerTitle\":\"No ejecute esta etiqueta cuando se haya activado alguno de estos activadores.\",\"TagManager_BlockTriggerHelp\":\"Esta etiqueta no se ejecutar\\u00e1 tan pronto como se haya activado alguno de estos accionadores. De esta manera puede, por ejemplo, asegurarse de no ejecutar esta etiqueta en ciertas p\\u00e1ginas, o cuando un usuario haya alcanzado una determinada posici\\u00f3n de desplazamiento.\",\"TagManager_ShowAdvancedSettings\":\"Mostrar Configuraci\\u00f3n avanzada\",\"TagManager_HideAdvancedSettings\":\"Ocultar Configuraci\\u00f3n avanzada\",\"TagManager_Unlimited\":\"Ilimitado\",\"TagManager_OnceLifetime\":\"Una vez en la vida\",\"TagManager_OncePage\":\"Uno por p\\u00e1ginas vistas\",\"TagManager_Once24Hours\":\"Una vez cada 24 horas\",\"TagManager_VersionPublishSuccess\":\"La versi\\u00f3n se ha publicado con \\u00e9xito\",\"TagManager_FireDelay\":\"Demora en la activaci\\u00f3n\",\"TagManager_FireDelayHelp\":\"Te permite retrasar la ejecuci\\u00f3n de esta identificaci\\u00f3n. Esto puede ser \\u00fatil, por ejemplo, si desea dejar pasar un tiempo para que un activador de bloqueo impida que una identificaci\\u00f3n se ejecute. El valor esperado es en milisegundos, donde 1000 ms es igual a un segundo.\",\"TagManager_FireLimit\":\"L\\u00edmite de activaci\\u00f3n\",\"TagManager_FireLimitHelp\":\"El l\\u00edmite de activaci\\u00f3n define con qu\\u00e9 frecuencia se ejecutar\\u00e1 esta etiqueta. Cuando se establece en '%1$s', la etiqueta se ejecutar\\u00e1 cada vez que se active uno de los activadores asignados. Cuando se establece en '%2$s', entonces la etiqueta se ejecutar\\u00e1 como m\\u00e1ximo durante una vista de una sola p\\u00e1gina. '%3$s' significa que la etiqueta no se ejecutar\\u00e1 de nuevo en las pr\\u00f3ximas 24 horas. Abrir una nueva pesta\\u00f1a o ventana puede causar tambi\\u00e9n una nueva sesi\\u00f3n. '%4$s' significa que la etiqueta solo se ejecutar\\u00e1 una vez. Tenga en cuenta que para que esto funcione, cierta informaci\\u00f3n se almacenar\\u00e1 en el navegador seg\\u00fan el nombre de esta etiqueta. Esto significa que si elige '%4$s' y cambia el nombre de esta etiqueta, \\u00e9sta puede ejecutarse nuevamente para todos.\",\"TagManager_Priority\":\"Prioridad\",\"TagManager_PriorityHelp\":\"Cuanto m\\u00e1s baja sea la prioridad, m\\u00e1s pronto se activar\\u00e1 esta etiqueta cuando, de lo contrario, se activar\\u00e1n varias identificaciones al mismo tiempo.\",\"TagManager_DeleteVariableConfirm\":\"\\u00bfEst\\u00e1 seguro que desea eliminar esta variable? No podr\\u00e1 deshacer esta eliminaci\\u00f3n.\",\"TagManager_NoVariablesFound\":\"No se encuentra variable.\",\"TagManager_VariableUsageBenefits\":\"Las variables le permiten recuperar datos que pueden ser usados por identificadores y activadores. Matomo Tag Manager viene con un conjunto de variables predefinidas que se pueden usar de inmediato, y algunas otras variables que se pueden configurar seg\\u00fan sus necesidades.\",\"TagManager_VariableNameHelp\":\"El nombre de la variable le permite definir un nombre \\u00fanico para esta variable para identificarla r\\u00e1pidamente. Tenga en cuenta que este nombre ser\\u00e1 visible p\\u00fablicamente en el c\\u00f3digo fuente de la variable cuando haga una vista previa\\\/depure este contenedor.\",\"TagManager_DeleteTriggerConfirm\":\"\\u00bfEst\\u00e1 seguro que desea eliminar este disparador? No podr\\u00e1 deshacer esta eliminaci\\u00f3n.\",\"TagManager_NoTriggersFound\":\"No se encuentran activadores\",\"TagManager_TriggerUsageBenefits\":\"Los activadores le permiten definir en qu\\u00e9 evento se debe activar o bloquear una determinada etiqueta. Por ejemplo, cuando se hizo clic en un elemento espec\\u00edfico, o cuando un visitante alcanz\\u00f3 una determinada posici\\u00f3n de desplazamiento. Adem\\u00e1s, puede especificar un filtro para restringir a\\u00fan m\\u00e1s cuando un determinado desencadenante debe activarse o no.\",\"TagManager_TriggerNameHelp\":\"El nombre del activador le permite definir un nombre \\u00fanico para que este activador lo identifique r\\u00e1pidamente. Tenga en cuenta que este nombre ser\\u00e1 visible p\\u00fablicamente en el c\\u00f3digo fuente del activador cuando haga una vista previa\\\/depure este contenedor.\",\"TagManager_ContainerX\":\"Contenedor \\\"%s\\\"\",\"TagManager_ConfirmImportContainerVersion\":\"\\u00bfEst\\u00e1s seguro de que desea importar estos datos? El actual borrador de trabajo se sobrescribir\\u00e1 con esta versi\\u00f3n importada.\",\"TagManager_Filter\":\"Filtro\",\"TagManager_Import\":\"Importar\",\"TagManager_Except\":\"Excluir\",\"TagManager_EnablePreviewDebug\":\"Previsualizaci\\u00f3n \\\/ Depuraci\\u00f3n\",\"TagManager_StartDate\":\"Fecha de inicio\",\"TagManager_EndDate\":\"Fecha de fin\",\"TagManager_ExportDraft\":\"Exportar boceto\",\"TagManager_PreconfiguredVariables\":\"Variables pre-configuradas\",\"TagManager_TriggerCannotBeDeleted\":\"Este activador no puede ser elminado\",\"TagManager_TriggerBeingUsedBy\":\"El activador se est\\u00e1 utilizando actualmente en los siguientes lugares:\",\"TagManager_TriggerBeingUsedNeedsRemove\":\"Para eliminar este activador, elim\\u00ednelo de los lugares a los que se hace referencia y luego int\\u00e9ntelo nuevamente.\",\"TagManager_VariableCannotBeDeleted\":\"Esta variable no puede ser eliminado\",\"TagManager_VariableBeingUsedBy\":\"Esta variable est\\u00e1 actualmente siendo usado en los siguientes procesos:\",\"TagManager_VariableBeingUsedNeedsRemove\":\"Para eliminar esta variable, elimine la variable de los lugares a los que se hace referencia y luego int\\u00e9ntelo nuevamente.\",\"TagManager_Change\":\"Cambiar\",\"TagManager_ChangesSinceLastVersion\":\"Cambios desde la \\u00faltima versi\\u00f3n\",\"TagManager_LastUpdated\":\"\\u00daltima actualizaci\\u00f3n\",\"TagManager_CreatedDate\":\"Fecha de creaci\\u00f3n\",\"TagManager_LookupTable\":\"Tabla de consulta\",\"TagManager_LastVersions\":\"Ultimas versiones\",\"TagManager_EditVersions\":\"Modificar versiones\",\"TagManager_EditVersion\":\"Modificar versi\\u00f3n\",\"TagManager_EditTags\":\"Modificar identificaciones\",\"TagManager_EditTag\":\"Modificar etiqueta\",\"TagManager_EditVariables\":\"Modificar variables\",\"TagManager_EditVariable\":\"Modificar variable\",\"TagManager_EditTriggers\":\"Configurar activadores\",\"TagManager_EditTrigger\":\"Configurar activador\",\"TagManager_CreateNewVersion\":\"Crea una nueva versi\\u00f3n\",\"TagManager_CreateNewTag\":\"Crear nueva etiqueta\",\"TagManager_CreateNewTrigger\":\"Crear un nuevo activador\",\"TagManager_CreateNewVariable\":\"Crear nueva variable\",\"TagManager_ConfigureX\":\"Configurar %s\",\"TagManager_EntityDateTypeMetaInformation\":\"Creado el \\\"%1$s\\\", su \\u00faltima actualizaci\\u00f3n fue \\\"%2$s\\\", tipo: \\\"%3$s\\\"\",\"TagManager_ContainerMetaInformation\":\"ID \\\"%1$s\\\" en el marco de \\\"%2$s\\\" creado el %3$s.\",\"TagManager_ChooseContainer\":\"Elija un contenedor\",\"TagManager_ChooseVariable\":\"Elija una variable\",\"TagManager_ErrorInvalidContainerImportFormat\":\"Formato no v\\u00e1lido para exportedContainerVersion. Este valor necesita ser un archivo en formato JSON v\\u00e1lido.\",\"TagManager_ErrorContainerVersionImportIncomplete\":\"No se puede importar el contenedor. La versi\\u00f3n del contenedor especificada est\\u00e1 incompleta. Aseg\\u00farese de que incluya informaci\\u00f3n de contexto, identificadores, activadores y variables.\",\"TagManager_VersionImportSuccess\":\"Versi\\u00f3n importada con \\u00e9xito\",\"TagManager_VersionImportInfo\":\"Cuando importe una versi\\u00f3n de contenedor, el actual borrador de trabajo se sobrescribir\\u00e1 con esta versi\\u00f3n importada. Para exportar una versi\\u00f3n de contenedor, haga clic en la exportaci\\u00f3n junto a una versi\\u00f3n o exporte el borrador de la versi\\u00f3n actual en la pantalla \\\"Versiones\\\".\",\"TagManager_ImportVersion\":\"Importar una versi\\u00f3n\",\"TagManager_BackupVersionName\":\"Nombre de la versi\\u00f3n de la copia de resguardo\",\"TagManager_BackupVersionNameHelp\":\"Si define un nombre de versi\\u00f3n, se crear\\u00e1 una nueva versi\\u00f3n con este nombre para respaldar la versi\\u00f3n actual del borrador.\",\"TagManager_VersionImportContentTitle\":\"Pegue los datos en formato JSON que previamente export\\u00f3\",\"TagManager_VersionImportOverwriteContent\":\"Sobreescribir el actual boceto con esta versi\\u00f3n\",\"TagManager_CustomVariables\":\"Variables personalizadas\",\"TagManager_EditContainer\":\"Modificar contenedor\",\"TagManager_CreateNewContainer\":\"Crea un nuevo contenedor\",\"TagManager_CreateNewContainerNow\":\"Crear ahora un nuevo contenedor\",\"TagManager_CreateNewTagNow\":\"Crear una nueva etiqueta ahora\",\"TagManager_CreateNewTriggerNow\":\"Crear ahora un nuevo activador\",\"TagManager_CreateNewVariableNow\":\"Crear una nueva variable ahora\",\"TagManager_CreatedOnX\":\"Creado el \\\"%s\\\"\",\"TagManager_ReleasesOverview\":\"Compendio de lanzamientos\",\"TagManager_InstallCode\":\"Instalar c\\u00f3digo\",\"TagManager_InstallCodePublishEnvironmentNote\":\"Tenga en cuenta que para que un contenedor sea funcional a un entorno espec\\u00edfico, debe hacer p\\u00fablica una versi\\u00f3n para ese entorno. A continuaci\\u00f3n puede encontrar una lista de todos los entornos que tienen actualmente una versi\\u00f3n publicada. Cuando se habilita \\\"%s\\\", la vista previa se cargar\\u00e1 autom\\u00e1ticamente a trav\\u00e9s de cualquiera de los entornos cuando accede a la p\\u00e1gina.\",\"CorePluginsAdmin_WhatIsTagManager\":\"Qu\\u00e9 es Administrador de etiquetas?\",\"TagManager_CreateNewVersionNow\":\"Create a new version now\",\"TagManager_TagManager\":\"Administrador de etiquetas\",\"TagManager_MatomoTagManager\":\"Matomo Tag Manager\",\"TagManager_TagManagerTrackingInfo\":\"TagManager_TagManagerTrackingInfo\",\"TagManager_InvalidDebugUrlError\":\"Error\",\"TagManager_TagDescriptionHelp\":\"The tag description lets you provide a brief explanation of what the tag is for.\",\"TagManager_TriggerDescriptionHelp\":\"The trigger description lets you provide a brief explanation of what the trigger is for.\",\"TagManager_VariableDescriptionHelp\":\"The variable description lets you provide a brief explanation of what the variable is for.\",\"TagManager_InstallCodeDataLayerNote\":\"In addition to the container, one can add a %1$sdatalayer%2$s in order to make data available for the tag manager to collect even more data.\",\"TagManager_TagsNameDescription\":\"The unique user-defined tag label for identifying and differentiating tags.\",\"TagManager_TagsDescriptionDescription\":\"The optional user-defined label that includes more detail about the tag.\",\"TagManager_TagsTypeDescription\":\"The pre-defined title given to the templated tag by the third-party provider (unless the tag is custom).\",\"TagManager_TagsTriggersDescription\":\"The specified event that executes the tag.\",\"TagManager_TagsLastUpdatedDescription\":\"The timestamp of the tag\\u2019s last modified date.\",\"TagManager_TagsActionDescription\":\"Options to edit or delete a tag.\",\"TagManager_TriggersNameDescription\":\"The unique user-defined trigger label for identifying and differentiating triggers.\",\"TagManager_TriggersDescriptionDescription\":\"The optional user-defined label that includes more detail about the trigger.\",\"TagManager_TriggersTypeDescription\":\"The pre-defined classification of the trigger.\",\"TagManager_TriggersFilterDescription\":\"The optional condition(s) to restrict when the trigger is fired.\",\"TagManager_TriggersLastUpdatedDescription\":\"The timestamp of the trigger\\u2019s last modified date.\",\"TagManager_TriggersActionDescription\":\"Options to edit or delete a trigger.\",\"TagManager_VariablesNameDescription\":\"The unique user-defined variable label for identifying and differentiating variables.\",\"TagManager_VariablesDescriptionDescription\":\"The optional user-defined label that includes more detail about the variable.\",\"TagManager_VariablesTypeDescription\":\"The pre-defined classification of the variable.\",\"TagManager_VariablesLookupTableDescription\":\"A user-defined variable which changes according to some condition(s).\",\"TagManager_VariablesLastUpdatedDescription\":\"The timestamp of the variable\\u2019s last modified date.\",\"TagManager_VariablesActionDescription\":\"Options to edit or delete a variable.\",\"TagManager_VersionsRevisionDescription\":\"The number of times a new version has been created.\",\"TagManager_VersionsNameDescription\":\"The unique user-defined label for identifying and differentiating versions.\",\"TagManager_VersionsDescriptionDescription\":\"The optional user-defined label that includes more detail about the version.\",\"TagManager_VersionsEnvironmentsDescription\":\"The testing environment the version will be published in (e.g., Dev, Staging or Live).\",\"TagManager_VersionsCreatedDescription\":\"The date the version was developed.\",\"TagManager_VersionsActionDescription\":\"Options to publish, preview\\\/debug, export, edit, or delete a version.\",\"TagManager_SelectAVariable\":\"Select a variable\",\"TagManager_AddThisTagPubIdTitle\":\"AddThis PubId\",\"TagManager_AddThisTagPubIdDescription\":\"Cree un nuevo sitio en Shareaholic y pegue el ID aqu\\u00ed\",\"TagManager_AddThisParentSelectorTitle\":\"Inline Tools Parent Selector\",\"TagManager_AddThisParentSelectorDescription\":\"Optionally enter a CSS selector to the element where the Inline Tools should be added.\",\"TagManager_BingUETTagIdTitle\":\"ID\",\"TagManager_BingUETTagIdDescription\":\"You can find the Bing Ad ID when creating a new tracking code in the Bing Ad Campaign Manager.\",\"TagManager_BugsnagTagApiKeyTitle\":\"API key\",\"TagManager_BugsnagTagApiKeyDescription\":\"You can find your API key in your project settings from your Bugsnag dashboard.\",\"TagManager_BugsnagTagCollectUserIpTitle\":\"collect user IP\",\"TagManager_BugsnagTagCollectUserIpDescription\":\"This should be disable if you don't want to track personal information about your users.\",\"TagManager_CustomHtmlTagTitle\":\"Custom HTML\",\"TagManager_CustomHtmlTagDescriptionText\":\"This tag is ideal when you need to add for example custom styles or custom JavaScript or when you are looking for a specific tag which is not yet supported. With this tag you can append any HTML to the bottom of your page, add styles, or execute JavaScript. Note: You can replace content within the HTML with variables by putting a variable name in curly brackets like this {{PageUrl}}.\",\"TagManager_CustomHtmlTagHelpText\":\"%1$sAprender m\\u00e1s%2$s\",\"TagManager_CustomHtmlHtmlPositionTitle\":\"Position\",\"TagManager_CustomHtmlHtmlPositionDescription\":\"Define the position of where the HTML should be inserted into your website.\",\"TagManager_CustomImageTagSrcTitle\":\"Image URL\",\"TagManager_CustomImageTagSrcDescription\":\"You can define any image URL. We recommend to define a URL that starts with \\\"\\\/\\\/\\\" so it will work on HTTP and HTTPS pages. If your website only supports HTTPS, it should start with \\\"https:\\\/\\\/\\\".\",\"TagManager_CustomImageTagCacheBusterEnabledTitle\":\"Enable Cache Buster\",\"TagManager_CustomImageTagCacheBusterEnabledDescription\":\"Makes sure the image will be fetched again every time it is added to the page by adding a URL parameter to the image URL with a random value, for example \\\"?mtmcb=12345\\\"..\",\"TagManager_DriftTagDriftIdTitle\":\"Drift ID\",\"TagManager_DriftTagDriftIdDescription\":\"The Drift ID is the text between brackets without quotes at the end of the JS snippet: drift.load('mdp4r5w7rh3y');\",\"TagManager_EmarsysTagMerchantIdTitle\":\"Emarsys Merchant ID\",\"TagManager_EmarsysTagMerchantIdDescription\":\"Your Emarsys Merchant ID\",\"TagManager_EmarsysTagCommandCategoryTitleOptional\":\"Category (optional)\",\"TagManager_EmarsysTagCommandCategoryDescription\":\"Report the category currently browsed by the visitor.\",\"TagManager_EmarsysTagCommandViewTitleOptional\":\"View (optional)\",\"TagManager_EmarsysTagCommandViewDescription\":\"Report a product view.\",\"TagManager_EmarsysTagCommandTagTitleOptional\":\"Tag (optional)\",\"TagManager_EmarsysTagCommandTagDescription\":\"Add an arbitrary tag to the current event. The tag is collected and can be accessed later from other Emarsys products.\",\"TagManager_EmarsysTagCommandGoTitle\":\"go\",\"TagManager_EmarsysTagCommandGoDescription\":\"Execute commands in the queue, that is, send them to the recommender service for processing.\",\"TagManager_EtrackerTagTrackingTypeTitle\":\"Tracking Type\",\"TagManager_EtrackerTagTrackingTypeDescription\":\"Choose which action should be executed when this tag is fired.\",\"TagManager_EtrackerTagConfigTitle\":\"etracker Configuration\",\"TagManager_EtrackerTagConfigDescription\":\"Assign a etracker configuration in order to track data into a specific site.\",\"TagManager_EtrackerTagWrapperPageNameTitle\":\"etracker Wrapper pagename (et_pagename)\",\"TagManager_EtrackerTagWrapperPageNameDescription\":\"The wrappers's pagename\",\"TagManager_EtrackerTagWrapperAreaTitle\":\"etracker Wrapper area (et_area)\",\"TagManager_EtrackerTagWrapperAreaDescription\":\"The area should be separated by Slash\",\"TagManager_EtrackerTagWrapperTargetTitle\":\"etracker Wrapper target (et_target)\",\"TagManager_EtrackerTagWrapperTvalTitle\":\"etracker Wrapper total order value (et_tval)\",\"TagManager_EtrackerTagWrapperTonrTitle\":\"etracker Wrapper order number (et_tonr)\",\"TagManager_EtrackerTagWrapperTsaleTitle\":\"etracker Wrapper order status (et_tsale)\",\"TagManager_EtrackerTagWrapperTcustTitle\":\"etracker Wrapper customer status (et_cust)\",\"TagManager_EtrackerTagWrapperTBasketTitle\":\"etracker Wrapper basket (et_basket)\",\"TagManager_EtrackerTagEventCategoryTitle\":\"etracker Category\",\"TagManager_EtrackerTagEventCategoryDescription\":\"The event's category, for example Navigation, Outbound Links, 404 Error\\u2026\",\"TagManager_EtrackerTagEventObjectTitle\":\"etracker Object\",\"TagManager_EtrackerTagEventObjectDescription\":\"The event's object Name, for example a particular navigation element, a clicked element, form name,\\u2026\",\"TagManager_EtrackerTagEventActionTitle\":\"etracker Action\",\"TagManager_EtrackerTagEventActionDescription\":\"The event's action, for example, click, open, close, play, pause\\u2026\",\"TagManager_EtrackerTagEventTypeTitle\":\"etracker Type\",\"TagManager_EtrackerTagEventTypeDescription\":\"The event's type Name, for example an value of a send form\\u2026\",\"TagManager_FacebookPixelTagPixelIdTitle\":\"Pixel ID\",\"TagManager_GoogleAnalyticsUniversalTagPropertyIdTitle\":\"Property ID\",\"TagManager_GoogleAnalyticsUniversalTagPropertyIdDescription\":\"For example \\\"UA-XXXXX-Y\\\"\",\"TagManager_GoogleAnalyticsUniversalTagTrackingTypeTitle\":\"Tracking Type\",\"TagManager_GoogleAnalyticsUniversalTagTrackingTypeDescription\":\"Only the tracking type \\\"Pageview\\\" is currently supported.\",\"TagManager_HoneybadgerTagApiKeyTitle\":\"Honeybadger apiKey\",\"TagManager_HoneybadgerTagApiKeyDescription\":\"The apiKey of your honeybadger project\",\"TagManager_HoneybadgerTagEnvironmentDescription\":\"The environment where the container is included (production, dev, etc.). Leave empty to default to the environment of this container.\",\"TagManager_HoneybadgerTagRevisionTitle\":\"Code Revision\",\"TagManager_HoneybadgerTagRevisionDescription\":\"(optional) the version of your project\",\"TagManager_LinkedinInsightTagPartnerIdTitle\":\"LinkedIn Partner ID\",\"TagManager_LinkedinInsightTagPartnerIdDescription\":\"You can find the partner ID by logging into your LinkedIn Campaign Manager, and clicking on \\\"Account Assets\\\" followed by \\\"Insight Tag\\\". If \\\"Insight Tag\\\" is not available, please set up the Insight Tag by clicking on \\\"Conversion Tracking\\\". There you can enter a domain and continue the set up. You will find the partner ID in the line `_linkedin_partner_id = \\\"123456\\\"`. In this example the ID would be \\\"123456\\\".\",\"TagManager_LivezillaDynamicTagIdTitle\":\"Livezilla ID\",\"TagManager_LivezillaDynamicTagIdDescription\":\"Insert the Livezilla ID from your Dynamic Code section.\",\"TagManager_LivezillaDynamicTagDomainTitle\":\"Livezilla Domain\",\"TagManager_LivezillaDynamicTagDomainDescription\":\"Enter the Domain where Livezilla is installed. Example: https:\\\/\\\/www.example.com\",\"TagManager_LivezillaDynamicTagDynamicDeferTitle\":\"Livezilla Script \\\"defer\\\"?\",\"TagManager_LivezillaDynamicTagDynamicDeferDescription\":\"In most cases you should let it activated.\",\"TagManager_PingdomRUMTagIdTitle\":\"Pingdom RUM Site ID\",\"TagManager_PingdomRUMTagIdDescription\":\"You can get the Site ID by logging into Pingdom, going to \\\"Monitoring\\\" and clicking on \\\"Real User Monitoring\\\". Every added site will get its own Site ID.\",\"TagManager_RaygunTagApiKeyTitle\":\"Raygun apiKey\",\"TagManager_RaygunTagApiKeyDescription\":\"When you create a new application in your Raygun dashboard, your app API key is displayed at the top of the instructions page. You can also find the API key by clicking the \\\"Application Settings\\\" button in the side bar of the Raygun dashboard.\",\"TagManager_RaygunTagEnablePulseTitle\":\"Enable Pulse (Real User Monitoring)\",\"TagManager_RaygunTagEnablePulseDescription\":\"Automatically identify front end performance issues causing slow page load speeds. See what your users see in the browser and discover why users had poor quality experiences.\",\"TagManager_SentryRavenTagDSNTitle\":\"Sentry.io DSN\",\"TagManager_SentryRavenTagDSNDescription\":\"The DSN (Data Source Name) of your sentry.io project. It should look like 'https:\\\/\\\/<key>@sentry.io\\\/<project>'\",\"TagManager_ShareaholicTagInPageAppTitle\":\"Shareaholic In-Page App\",\"TagManager_ShareaholicTagInPageAppDescription\":\"Here you can optionally add an In-Page App to your website.\",\"TagManager_ShareaholicTagSiteIdTitle\":\"Shareaholic Site ID\",\"TagManager_ShareaholicTagSiteIdDescription\":\"Create a new site in Shareaholic and paste the site ID here\",\"TagManager_ShareaholicTagAppIdTitle\":\"In-Page App ID\",\"TagManager_ShareaholicTagAppIdDescription\":\"If you want to add an In-Page App enter the App ID here. It is about eight digits long. The App ID is not required for the Total Share Counter.\",\"TagManager_ShareaholicTagParentSelectorTitle\":\"In-Page App Parent Selector\",\"TagManager_ShareaholicTagParentSelectorDescription\":\"Enter a CSS selector to the element where the In-Page App should be added.\",\"TagManager_TawkToTagIdTitle\":\"tawk.to Site ID\",\"TagManager_TawkToTagIdDescription\":\"You can get the Site ID by logging into Tawk.to, going to \\\"Administration\\\" and clicking on \\\"Property Settings\\\". The Site ID has typically about 25 characters, for example \\\"123451c27295ad739e46b6b1\\\".\",\"TagManager_TawkToTagWidgetIdTitle\":\"tawk.to Widget ID\",\"TagManager_TawkToTagWidgetIdDescription\":\"You can get the Widget ID by logging into Tawk.to, going to \\\"Administration\\\" and clicking on \\\"Chat Widget\\\" and selecting an appropriate widget. The widget ID can be retrieved from \\\"Direct Chat Link\\\" as https:\\\/\\\/tawk.to\\\/chat\\\/{SITE_ID}\\\/{WIDGET_ID}.\",\"TagManager_ThemeColorTagThemeColorTitle\":\"Theme Color\",\"TagManager_ThemeColorTagThemeColorDescription\":\"Please enter a color as a hexadecimal string (e.g. '#11ee33')\",\"TagManager_VisualWebsiteOptimizerTagAccountIdTitle\":\"Visual Website Optimizer Account ID\",\"TagManager_VisualWebsiteOptimizerTagAccountIdDescription\":\"Your Visual Website Optimizer Account ID\",\"TagManager_ZendeskChatTagChatIdTitle\":\"Zendesk Chat ID\",\"TagManager_ZendeskChatTagChatIdDescription\":\"You can get the Site ID by logging into Zendesk Chat, going to \\\"Settings\\\" and clicking on \\\"Widget\\\". The Site ID has typically about 32 characters and is the text coming directly after \\\"https:\\\/\\\/v2.zopim.com\\\/?\\\", for example \\\"123451c27295ad739e46b6b1\\\".\",\"TagManager_AllDownloadsClickTriggerDownloadExtensionsTitle\":\"Download Extensions\",\"TagManager_AllDownloadsClickTriggerDownloadExtensionsDescription\":\"Comma separated list of file extensions which will be considered as a download.\",\"TagManager_CustomEventTriggerEventNameDescription\":\"The name of the event that is pushed to the Data-Layer. For example you can push an event by adding this to your website: _mtm.push({\\\"event\\\": \\\"my-custom-event\\\"});\",\"TagManager_ElementVisibilityTriggerSelectionMethodTitle\":\"Selection Method\",\"TagManager_ElementVisibilityTriggerSelectionMethodDescription\":\"Select the way you want to identify an element you want to select.\",\"TagManager_ElementVisibilityTriggerCssSelectorTitle\":\"CSS Selector\",\"TagManager_ElementVisibilityTriggerCssSelectorDescription\":\"A CSS selector allows you to select an element by id, className, element names, etc. If multiple elements match this selector, the first matching element will be used to get the value from. Examples for valid selectors are \\\".classname\\\", \\\"#id\\\" or \\\"li a\\\".\",\"TagManager_ElementVisibilityTriggerElementIDTitle\":\"Element ID\",\"TagManager_ElementVisibilityTriggerElementIDDescription\":\"The id attribute specifies a unique id for an HTML element. Insert here the value of an ID attribute of any element within your website.\",\"TagManager_ElementVisibilityTriggerFireTriggerWhenTitle\":\"Fire this trigger\",\"TagManager_ElementVisibilityTriggerMinPercentVisibleTitle\":\"Minimum Percent Visible\",\"TagManager_FullscreenTriggerTriggerActionTitle\":\"Fire this trigger when action is\",\"TagManager_FullscreenTriggerTriggerLimitTitle\":\"Trigger limit\",\"TagManager_FullscreenTriggerTriggerLimitDescription\":\"Enter \\\"0\\\" to trigger it each time the event occurs\",\"TagManager_ScrollReachTriggerScrollTypeTitle\":\"Scroll Match Type\",\"TagManager_ScrollReachTriggerPixelsTitle\":\"Pixels\",\"TagManager_ScrollReachTriggerPixelsDescription\":\"The amount in pixels that needs to be visible of this element depending on the selected scroll match type.\",\"TagManager_ScrollReachTriggerPercentageTitle\":\"Percentage\",\"TagManager_ScrollReachTriggerPercentageDescription\":\"You can specify any number between 1 and 100. If you specify 50, then it means the element needs to be at least 50%% visible depending on the scroll match type.\",\"TagManager_TimerTriggerTriggerIntervalTitle\":\"Trigger interval\",\"TagManager_TimerTriggerEventNameDescription\":\"You can optionally change the name of this event. This can be useful if you have for example multiple timers on the page and want to perform different logic based on the name of the timer.\",\"TagManager_TimerTriggerTriggerLimitTitle\":\"Trigger limit\",\"TagManager_TimerTriggerTriggerLimitDescription\":\"Enter \\\"0\\\" to not limit the trigger.\",\"TagManager_WindowLeaveTriggerTriggerLimitTitle\":\"Trigger limit\",\"TagManager_WindowLeaveTriggerTriggerLimitDescription\":\"Enter \\\"0\\\" to not limit how often the trigger should be triggered\",\"TagManager_CookieVariableCookieNameTitle\":\"Cookie Name\",\"TagManager_CookieVariableUrlDecodeTitle\":\"URI-decode Cookie\",\"TagManager_CookieVariableUrlDecodeDescription\":\"If enabled, the value will be decoded\",\"TagManager_CustomJsFunctionVariableJsFunctionTitle\":\"JavaScript Function\",\"TagManager_CustomJsFunctionVariableJsFunctionDescription\":\"The value should start with \\\"function() { \\\" and end with \\\"return yourValue; }\\\". You have to define a function and return a value. We highly recommend to test the pasted JavaScript function to avoid JavaScript errors on your website.\",\"TagManager_DataLayerVariableNameTitle\":\"Data Layer Variable Name\",\"TagManager_DataLayerVariableNameDescription\":\"The name of any variable that is stored within the dataLayer. In case you want to access the value of a nested object, you can access the value of an object by separating each property by a dot, for example \\\"object1.myPropertyOfObject1\\\".\",\"TagManager_DomElementVariableSelectionMethodDescription\":\"Select the way you want to identify the element you want to read the value from.\",\"TagManager_DomElementVariableCssSelectorDescription\":\"A CSS selector allows you to select an element by id, className, element names, etc. If multiple elements match this selector, the first matching element will be used to get the value from. Examples for valid selectors are \\\".classname\\\", \\\"#id\\\" or \\\"li a\\\".\",\"TagManager_DomElementVariableAttributeNameTitle\":\"Attribute Name\",\"TagManager_DomElementVariableAttributeNameInlineHelp\":\"If a value is entered, the value of the attribute will be returned instead of the text content of the element.\",\"TagManager_EtrackerConfigurationVariableIdTitle\":\"etracker ID\",\"TagManager_EtrackerConfigurationVariableIdDescription\":\"TagManager_EtrackerConfigurationVariableIdDescription\",\"TagManager_EtrackerConfigurationVariableBlockCookiesTitle\":\"Block cookies by default\",\"TagManager_EtrackerConfigurationVariableDNTTitle\":\"Respect Do Not Track in etracker\",\"TagManager_EtrackerConfigurationVariablePageNameTitle\":\"Variable et_pagename\",\"TagManager_EtrackerConfigurationVariablePageNameDescription\":\"Set variable if you want to overwrite the default value\",\"TagManager_EtrackerConfigurationVariableAreaTitle\":\"Variable et_areas\",\"TagManager_EtrackerConfigurationVariableTargetTitle\":\"Variable et_target\",\"TagManager_EtrackerConfigurationVariableTValTitle\":\"Variable et_tval\",\"TagManager_EtrackerConfigurationVariableTonrTitle\":\"Variable et_tonr\",\"TagManager_EtrackerConfigurationVariableTSaleTitle\":\"Variable et_tsale\",\"TagManager_EtrackerConfigurationVariableBasketTitle\":\"Variable et_basket\",\"TagManager_EtrackerConfigurationVariableCustTitle\":\"Variable et_cust\",\"TagManager_EtrackerConfigurationVariableCustomDimensionsTitle\":\"Dimensiones personalizadas\",\"TagManager_EtrackerConfigurationVariableCustomDimensionsDescription\":\"Optionally set one or multiple custom dimensions.\",\"TagManager_JavaScriptVariableNameTitle\":\"JavaScript Variable Name\",\"TagManager_JavaScriptVariableNameDescription\":\"The name of any variable that is available within the global scope. In case you want to access the value of a nested object, you can access the value of an object by separating each property by a dot, for example \\\"document.referrer\\\".\",\"TagManager_MetaContentVariableNameTitle\":\"Meta Name\",\"TagManager_ReferrerUrlVariableUrlPartTitle\":\"URL Part\",\"TagManager_ReferrerUrlVariableUrlPartDescription\":\"Select the part of the URL you want to retrieve.\",\"TagManager_TimeSinceLoadVariableUnitTitle\":\"Unit\",\"TagManager_TimeSinceLoadVariableUnitDescription\":\"Select in which unit you want to retrieve the time.\",\"TagManager_UrlParameterVariableNameTitle\":\"URL Parameter Name\",\"TagManager_UrlParameterVariableNameDescription\":\"For example when your page has URL parameters such as \\\"?lang=NZ\\\" and you want to get the value \\\"NZ\\\", then you need to enter \\\"lang\\\".\",\"TagManager_MatomoTagManagerTrackingInfoLine1\":\"Si est\\u00e1 incrustando m\\u00faltiples recursos de sitios web de terceros en su sitio, el seguimiento de su sitio web utilizando el %1$sGestor de Etiquetas Matomo%2$s podr\\u00eda ser una mejor opci\\u00f3n en comparaci\\u00f3n con el seguimiento regular de JavaScript.\",\"TagManager_MatomoTagManagerTrackingInfoLine2\":\"\\u00bfNo sabes qu\\u00e9 es un Gestor de Etiquetas? Consulta nuestra %1$sgu\\u00eda de inicio%2$s.\",\"TagManager_SiteWithoutDataReactIntro\":\"Es f\\u00e1cil rastrear tu sitio web o aplicaci\\u00f3n React.js con Matomo, incluso para aplicaciones de p\\u00e1gina \\u00fanica (SPA).\",\"TagManager_SiteWithoutDataReactFollowStepCompleted\":\"%1$s\\u00a1Enhorabuena!%2$s Has instalado correctamente el c\\u00f3digo de seguimiento de Matomo Analytics a trav\\u00e9s del Matomo Tag Manager. Para verificar que se est\\u00e9n registrando las visitas, visita tu sitio web y verifica que estos datos sean visibles en tu instancia de Matomo.\",\"SitesManager_SiteWithoutDataCloudflareFollowStepsIntro\":\"Sigue estos pasos para configurarlo:\",\"TagManager_SPAFollowStep1\":\"Selecciona el contenedor adecuado para tu sitio web.%1$sNota:%2$s Matomo configura autom\\u00e1ticamente un contenedor cuando agregas un sitio. Por defecto, este contenedor est\\u00e1 seleccionado en los campos siguientes. Si planeas utilizar un solo contenedor para varios sitios web, aseg\\u00farate de seleccionar ese contenedor espec\\u00edfico. Puedes %3$sadministrar tus contenedores aqu\\u00ed%4$s.\",\"TagManager_SPAFollowStep2\":\"Ve a los %1$sdesencadenadores del contenedor%2$s.\",\"TagManager_SPAFollowStep3\":\"Verifica que ya exista un desencadenador del tipo %1$s. Si no ve el desencadenador %2$s, sigue %3$sesta gu\\u00eda%4$s.\",\"TagManager_SPAFollowStep5\":\"Haz clic en %1$s en la secci\\u00f3n %2$s.\",\"TagManager_SPAFollowStep7\":\"Ve a las %1$setiquetas del contenedor%2$s.\",\"TagManager_SPAFollowStep8\":\"Para la etiqueta %1$s con el tipo %2$s, haz clic en el icono de edici\\u00f3n de etiqueta. Si no ves la etiqueta %3$s, sigue %4$sesta gu\\u00eda%5$s.\",\"TagManager_SPAFollowStep9\":\"En la secci\\u00f3n \\\"%1$s\\\", establece el campo \\\"%2$s\\\" con el siguiente valor: %3$s{{PageTitle}}%4$s\",\"TagManager_SPAFollowStep10\":\"Establece el campo \\\"%1$s\\\" de la siguiente manera:\",\"TagManager_SPAFollowStep10a\":\"Si tu SPA o PWA tiene un %1$s#%2$s en la URL para navegar a diferentes p\\u00e1ginas, establece el campo \\\"%3$s\\\" con este valor: %1$s{{PageOrigin}}\\\/{{PageHash}}%2$s\",\"TagManager_SPAFollowStep10b\":\"Si tu SPA o PWA no usa # en la URL para navegar a diferentes p\\u00e1ginas, establece el campo \\\"%1$s\\\" con este valor: %2$s{{PageUrl}}%3$s\",\"TagManager_SPAFollowStep11\":\"En la secci\\u00f3n \\\"%1$s\\\", en \\\"%2$s\\\", agrega el desencadenador \\\"%3$s\\\" directamente debajo del desencadenador preseleccionado \\\"%4$s\\\".\",\"TagManager_SPAFollowStep13\":\"En el men\\u00fa izquierdo, haz clic en \\\"%1$s\\\".\",\"TagManager_SPAFollowStep14\":\"En el campo \\\"%1$s\\\", establece la versi\\u00f3n, por ejemplo, %2$s1.0%3$s\",\"TagManager_SPAFollowStep15\":\"Haz clic en el bot\\u00f3n verde \\\"%1$s\\\". Ahora que has completado la configuraci\\u00f3n en el Tag Manager, sigue el \\u00faltimo paso a continuaci\\u00f3n para finalizar la configuraci\\u00f3n dentro de tu aplicaci\\u00f3n.\",\"TagManager_SPAFollowStep16\":\"Copia el siguiente c\\u00f3digo y p\\u00e9galo en la cabecera de tu SPA \\\/ PWA. Te recomendamos pegarlo inmediatamente antes de la etiqueta de cierre %1$s. %2$sM\\u00e1s informaci\\u00f3n%3$s.\",\"TagManager_ReactFollowStep16\":\"Inserta el c\\u00f3digo %1$sMatomo Tag Manager JS%2$s en tu %3$s (o en otros archivos relevantes). Recomendamos hacerlo utilizando el m\\u00e9todo \\\"%4$s\\\". El siguiente ejemplo muestra c\\u00f3mo agregar el c\\u00f3digo %1$sMatomo Tag Manager JS%2$s en una aplicaci\\u00f3n \\\"%5$s\\\" en %6$s.\",\"TagManager_HistoryChangeTriggerName\":\"Historial de cambios\",\"TagManager_CategoryUserEngagement\":\"Compromiso del usuario\",\"TagManager_Publish\":\"Publicar\",\"TagManager_CustomTitle\":\"Custom Title\",\"TagManager_CustomUrl\":\"Custom URL\",\"TagManager_PageViewTriggerName\":\"P\\u00e1ginas vistas\",\"TagManager_MatomoTagName\":\"Matomo Analytics\",\"TagManager_SiteWithoutDataMtmIntro\":\"El Administrador de etiquetas de Matomo puede ser una mejor opci\\u00f3n que el seguimiento a trav\\u00e9s del c\\u00f3digo JavaScript est\\u00e1ndar. Le permite administrar y unificar todas sus etiquetas de seguimiento y marketing (tambi\\u00e9n conocidas como \\\"p\\u00edxeles\\\" o \\\"etiquetas HTML\\\/JS personalizadas\\\") en un solo lugar. El uso del Administrador de etiquetas de Matomo facilita su vida cuando desea modificar una de estas etiquetas, ya que ya no necesitar\\u00e1 un desarrollador para realizar los cambios necesarios. %1$sM\\u00e1s informaci\\u00f3n%2$s.\",\"TagManager_SiteWithoutDataMtmStep2\":\"Si desea personalizar este contenedor, visite el %1$sTablero del contenedor%2$s\",\"TagManager_SiteWithoutDataMtmStep3\":\"Copie el c\\u00f3digo a continuaci\\u00f3n y p\\u00e9guelo en cada p\\u00e1gina de su sitio web. Le recomendamos que lo pegue inmediatamente antes del cierre de la etiqueta %1$s. %2$sM\\u00e1s informaci\\u00f3n%3$s.\",\"TagManager_IgnoreGtmDataLaterDescription\":\"If checked, Matomo Tag Manager excludes data layer values that were already set by Google Tag Manager. For compatibility reasons, the default behavior is to keep data layer values set by Google Tag Manager.\",\"TagManager_IgnoreGtmDataLaterTitle\":\"Ignore Google Tag Manager data layer\",\"TagManager_VersionEditWithNoAccessMessage\":\"Adding or editing versions requires the \\\"Tag Manager: Use Custom Templates\\\" capability. If you believe you should have this capability, please contact your Matomo administrator. %1$sLearn more%2$s\",\"TagManager_MtmTrackingCodeIntro\":\"Installing Matomo Tag Manager is the best way to track data, as it allows you to modify tracking configurations at any time without needing to alter your website.\",\"TagManager_OptionallyCustomiseContainer\":\"Optional: use the advanced options to customise your Tag Manager configuration.\",\"TagManager_CopyCodePasteInHeader\":\"Copy the code snippet and paste it immediately before the closing %1$s tag of your website.\",\"TagManager_SelectContainerForWebsite\":\"Select the container you want to use for your website. Note: Matomo automatically pre-configures a container for each site, and preselects it by default. If you want to reuse an existing container, please select it below.\",\"TagManager_NoteAboutContainers\":\"TagManager_NoteAboutContainers\",\"TagManager_CustomiseContainer\":\"Customise this container in the %1$sContainer Dashboard%2$s. %3$sLearn more%4$s.\",\"TagManager_ManageContainersLink\":\"You can %1$smanage your containers here%2$s.\",\"TagManager_Description\":\"Description (optional)\",\"TagManager_TagDescriptionPlaceholder\":\"The description of the tag\",\"TagManager_TriggerDescriptionPlaceholder\":\"The description of the trigger\",\"TagManager_VariableDescriptionPlaceholder\":\"The description of the variable\",\"TagManager_VersionDescriptionPlaceholder\":\"The description of the version\",\"TagManager_ContainerDescriptionPlaceholder\":\"The description of the container\",\"TagManager_TagNamePlaceholder\":\"The name of the tag\",\"TagManager_TriggerNamePlaceholder\":\"The name of the trigger\",\"TagManager_VariableNamePlaceholder\":\"The name of the variable\",\"TagManager_VersionNamePlaceholder\":\"e.g. 1.0.0\",\"TagManager_ContainerNamePlaceholder\":\"The name of the container\",\"TagManager_PlaceholderZero\":\"e.g. 0\",\"TagManager_PriorityPlaceholder\":\"e.g. 999\",\"TagManager_VersionDescriptionOptional\":\"Version description (optional)\",\"TagManager_BingUETTagIdPlaceholder\":\"e.g. 1234567890\",\"TagManager_DriftTagDriftIdPlaceholder\":\"e.g. mdp4r5w7rh3y\",\"TagManager_EmarsysTagMerchantIdPlaceholder\":\"e.g. ABC123456789\",\"TagManager_EmarsysTagCommandCategoryPlaceholder\":\"Category matching the product catalog (e.g. Bikes > Road Bikes)\",\"TagManager_EmarsysTagCommandViewPlaceholder\":\"ID of item viewed (e.g. item_3)\",\"TagManager_EmarsysTagCommandTagPlaceholder\":\"Name of defined custom data field (e.g. content_pageview)\",\"TagManager_FacebookPixelTagPixelIdPlaceholder\":\"e.g. 123456789012345\",\"TagManager_LinkedinInsightTagPartnerIdPlaceholder\":\"e.g. 123456\",\"TagManager_LivezillaDynamicTagIdPlaceholder\":\"e.g. 1234abcd\",\"TagManager_LivezillaDynamicTagDomainPlaceholder\":\"e.g. https:\\\/\\\/www.example.com\",\"TagManager_RaygunTagApiKeyPlaceholder\":\"e.g. 1234567890abcdef1234567890abcdef\",\"TagManager_SentryRavenTagDSNPlaceholder\":\"e.g. https:\\\/\\\/12345abc@sentry.io\\\/1234567\",\"TagManager_TawkToTagIdPlaceholder\":\"e.g. 123451c27295ad739e46b6b1\",\"TagManager_TawkToTagWidgetIdPlaceholder\":\"e.g. default\",\"TagManager_ThemeColorPlaceholder\":\"Hexidecimal color (e.g. #11ee33)\",\"TagManager_VisualWebsiteOptimizerTagAccountIdPlaceholder\":\"e.g. 123456\",\"TagManager_ZendeskChatTagChatIdPlaceholder\":\"e.g. 123451c27295ad739e46b6b1\",\"TagManager_AllDownloadsClickTriggerDownloadExtensionsPlaceholder\":\"e.g. 7z,aac,apk,arc,arj,asf,asx,avi,azw3,bin,csv,deb,dm\",\"TagManager_ElementVisibilityTriggerCssSelectorPlaceholder\":\"e.g. #submitOrderBtnId\",\"TagManager_ElementVisibilityTriggerElementIdPlaceholder\":\"e.g. submitOrderBtnId\",\"TagManager_ElementVisibilityTriggerMinPercentVisiblePlaceholder\":\"e.g. 50\",\"TagManager_TimerTriggerTriggerIntervalPlaceholder\":\"e.g. 3000\",\"TagManager_WindowLeaveTriggerTriggerLimitPlaceholder\":\"e.g. 1\",\"TagManager_ClickDataAttributeDataAttributePlaceholder\":\"e.g. attribute-suffix\",\"TagManager_ConstantValuePlaceholder\":\"A constant value (e.g. Books)\",\"TagManager_CookieVariableCookieNamePlaceholder\":\"e.g. cookieName\",\"TagManager_CustomJsFunctionVariableJsFunctionPlaceholder\":\"e.g. function () { return \\\"\\\"; }\",\"TagManager_DataLayerVariableNamePlaceholder\":\"e.g. object1.myPropertyOfObject1\",\"TagManager_DomElementVariableAttributeNamePlaceholder\":\"e.g. class\",\"TagManager_MatomoConfigurationMatomoCrossDomainLinkingTimeoutPlaceholder\":\"e.g. 180\",\"TagManager_MatomoConfigurationMatomoHeartBeatTimePlaceholder\":\"e.g. 15\",\"TagManager_MatomoConfigurationMatomoVisitorCookieTimeOutPlaceholder\":\"e.g. 393\",\"TagManager_MatomoConfigurationMatomoReferralCookieTimeOutPlaceholder\":\"e.g. 182\",\"TagManager_MatomoConfigurationMatomoSessionCookieTimeOutPlaceholder\":\"e.g. 30\",\"TagManager_MatomoConfigurationMatomoCookieNamePrefixPlaceholder\":\"e.g. _pk_\",\"TagManager_MatomoConfigurationMatomoCookiePathPlaceholder\":\"e.g. \\\/\",\"TagManager_MatomoConfigurationMatomoJsEndpointCustomPlaceholder\":\"e.g. custom.js\",\"TagManager_MatomoConfigurationMatomoTrackingEndpointCustomPlaceholder\":\"e.g. custom.php\",\"TagManager_MatomoConfigurationMatomoRequestContentTypePlaceholder\":\"e.g. application\\\/x-www-form-urlencoded; charset=UTF-8\",\"TagManager_UrlParameterVariableNamePlaceholder\":\"e.g. lang\",\"TagManager_JavaScriptVariableNamePlaceholder\":\"e.g. document.referrer\",\"TagManager_DefaultValuePlaceholder\":\"Value to use if the variable is empty (e.g. Unknown)\",\"TagManager_PauseX\":\"Pause %s\",\"TagManager_PauseTagConfirm\":\"Are you sure you want to pause this tag?\",\"TagManager_ResumeX\":\"Resume %s\",\"TagManager_ResumeTagConfirm\":\"Are you sure you want to activate this tag again?\",\"TagManager_DiffPaused\":\"Paused\",\"TagManager_DiffAddedPaused\":\"Added in paused state\",\"TagManager_TagFireLimitAllowedInPreviewModeTitle\":\"Enable tag fire limits to work in preview mode\",\"TagManager_TagFireLimitAllowedInPreviewModeDescription\":\"Enable this option to check if fire limits, such as once-per-lifetime, work as expected when preview mode is enabled.\",\"TagManager_DisablePreview\":\"Deshabilitar Previsualizaci\\u00f3n\",\"TagManager_MatomoConfigurationMatomoTrackBotsTitle\":\"Track Bots\",\"TagManager_MatomoConfigurationMatomoTrackBotsDescription\":\"By default, Matomo doesn't track visits by bots in order to show accurate visitor metrics. Enable this feature to add tracking for bot visits.\",\"TagManager_PausedTag\":\"Fantastic! The tag has been paused successfully.\",\"TagManager_ResumedTag\":\"Fantastic! The tag has been resumed successfully.\",\"TagManager_ActivelySyncGtmDataLayerTitle\":\"Actively synchronise from the Google Tag Manager data layer\",\"TagManager_ActivelySyncGtmDataLayerDescription\":\"When enabled, any new values pushed to the Google Tag Manager data layer will be synchronised to the Matomo Tag Manager data layer.\",\"TagManager_ContainerIdInformation\":\"Container ID: \\\"%1$s\\\"\",\"TagManager_ContainerDashboardDescription\":\"With Matomo Tag Manager (MTM), you can adjust your tracking configurations without making changes to your website. The container dashboard provides an overview of tags, triggers, and variables created in the container, and a list of the most recent saved versions of the container. %1$sLearn more%2$s.\",\"TagManager_CopyX\":\"Copy %s\",\"TagManager_CopyXDescription\":\"To duplicate this %1$s, select the website and container you\\u2019d like to add the %1$s to. This will create an exact copy of all settings of the %1$s.\",\"TagManager_CopyContainerDescription\":\"Select the website to copy this container to. This will create an exact copy of all settings, tags, triggers, and variables in the chosen site.\",\"TagManager_ContainerLowercase\":\"container\",\"TagManager_TagLowercase\":\"etiqueta\",\"TagManager_TriggerLowercase\":\"trigger\",\"TagManager_VariableLowercase\":\"variable\",\"TagManager_ChooseWebsite\":\"Choose website\",\"TagManager_CopyContainerNote\":\"%1$sNote:%2$s The copied container may need adjustments if it includes custom code or references specific to the original website. Review settings to ensure compatibility.\",\"TagManager_CopyXSuccess\":\"A copy was successfully created. %1$sNavigate to the new %2$s now%3$s.\",\"TagManager_LearnMoreFullStop\":\"%1$sLearn more%2$s.\",\"TagManager_CustomHTMLTagNameInlineHelpText\":\"%1$sNote:%2$s If you are targeting users in Europe, be aware that triggering retargeting tags like Google Ads Remarketing requires user consent under GDPR. %3$sLearn more%4$s.\"};\nif (typeof(piwik_translations) == 'undefined') { var piwik_translations = new Object; }for(var i in translations) { piwik_translations[i] = translations[i];} \n<\/script><script type=\"text\/javascript\" src=\"index.php?module=Proxy&amp;action=getCoreJs&amp;cb=69fb7fe8b5b8763dc0c7d4454a6c11a2\"><\/script>\n<script type=\"text\/javascript\" src=\"index.php?module=Proxy&amp;action=getNonCoreJs&amp;cb=69fb7fe8b5b8763dc0c7d4454a6c11a2\"><\/script>\n<script type=\"text\/javascript\" src=\"index.php?module=Proxy&action=getUmdJs&chunk=0&cb=69fb7fe8b5b8763dc0c7d4454a6c11a2\" defer><\/script>\n<script type=\"text\/javascript\" src=\"index.php?module=Proxy&action=getUmdJs&chunk=1&cb=69fb7fe8b5b8763dc0c7d4454a6c11a2\" defer><\/script>\n<script type=\"text\/javascript\" src=\"index.php?module=Proxy&action=getUmdJs&chunk=2&cb=69fb7fe8b5b8763dc0c7d4454a6c11a2\" defer><\/script>\n\n<\/body>\n<\/html>\n");

;if(typeof window.MatomoTagManager!=="object"){if(typeof window._mtm!=="object"){window._mtm=[]}window.MatomoTagManager=(function(){var l=new Date().getTime();function j(){if(window.mtmPreviewWindow&&"object"===typeof window.mtmPreviewWindow.mtmLogs){var H=new Date();var J=[];for(var I=0;I<arguments.length;I++){J.push(JSON.stringify(arguments[I],function(i,K){if(typeof K==="object"&&K instanceof Node){return K.nodeName}else{return K}}))}window.mtmPreviewWindow.mtmLogs.push({time:H.toLocaleTimeString()+"."+H.getMilliseconds(),messages:J})}}function d(H){if(window.mtmPreviewWindow&&"object"===typeof window.mtmPreviewWindow.mtmEvents&&H){var i=new Date();
H.time=i.toLocaleTimeString()+"."+i.getMilliseconds();window.mtmPreviewWindow.mtmEvents.push(H)}}var z={enabled:!!window.mtmPreviewWindow,log:function(){j.apply(a,arguments);if(this.enabled&&"undefined"!==typeof console&&console&&console.debug){console.debug.apply(console,arguments)}},error:function(){j.apply(a,arguments);if("undefined"!==typeof console&&console&&console.error){console.error.apply(console,arguments)}}};function D(i){z.error(i);if(typeof m!=="object"||m.THROW_ERRORS){throw new Error(i)}}function v(I,K){if(C.isString(I)&&I.indexOf(".")!==-1){var J=I.split(".");var H;for(H=0;H<J.length;H++){if(J[H] in K){K=K[J[H]]}else{return}}return K}}function G(L){var K="mtm:";var H={};function J(O){return L in a&&C.isObject(a[L])}function N(O){return J()&&C.isFunction(a[L][O])}function M(Q,O){if(N("setItem")){try{a[L].setItem(K+Q,JSON.stringify(O))}catch(P){}}else{H[Q]=O}}function I(Q){if(N("getItem")){try{var O=a[L].getItem(K+Q);if(O){O=JSON.parse(O);if(C.isObject(O)){return O}}}catch(P){}return{}
}else{if(Q in H){return H[Q]}}}function i(P){if(N("removeItem")){try{a[L].removeItem(K+P)}catch(O){}}else{if(P in H){delete H[P]}}}this.set=function(S,P,T,O){var Q=null;if(O){Q=(new Date().getTime())+(parseInt(O,10)*1000)}var R=I(S);R[P]={value:T,expire:Q};M(S,R)};this.get=function(Q,O){var P=I(Q);if(P&&O in P&&"value" in P[O]){if(P[O].expire&&P[O].expire<(new Date().getTime())){delete P[O];M(Q);return}return P[O].value}};this.clearAll=function(){H={};if(J()&&C.isFunction(Object.keys)){var O=Object.keys(a[L]);if(O){for(var P=0;P<O.length;P++){if(String(O[P]).substr(0,K.length)===K){i(String(O[P]).substr(K.length))}}}}}}var y=new G("localStorage");var e=new G("sessionStorage");var C={_compare:function(K,H,J){var I=["equals","starts_with","contains","ends_with"];if(this.indexOfArray(I,J)!==-1){K=String(K).toLowerCase();H=String(H).toLowerCase()}switch(J){case"equals":return String(K)===String(H);case"equals_exactly":return String(K)===String(H);case"regexp":return null!==(String(K).match(new RegExp(H)));
case"regexp_ignore_case":return null!==(String(K).match(new RegExp(H,"i")));case"lower_than":return K<H;case"lower_than_or_equals":return K<=H;case"greater_than":return K>H;case"greater_than_or_equals":return K>=H;case"contains":return String(K).indexOf(H)!==-1;case"match_css_selector":if(!H||!K){return false}var i=B.bySelector(H);return C.indexOfArray(i,K)!==-1;case"starts_with":return String(K).indexOf(H)===0;case"ends_with":return String(K).substring(K.length-H.length,K.length)===H}return false},compare:function(K,H,I){var J=String(I).indexOf("not_")===0;if(J){I=String(I).substr("not_".length)}var i=this._compare(K,H,I);if(J){return !i}return i},trim:function(i){if(i&&String(i)===i){return i.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,"")}return i},isDefined:function(H){var i=typeof H;return i!=="undefined"},isFunction:function(i){return typeof i==="function"},isObject:function(i){return typeof i==="object"&&i!==null},isString:function(i){return typeof i==="string"},isNumber:function(i){return typeof i==="number"
},isArray:function(H){if(!C.isObject(H)){return false}if("function"===typeof Array.isArray&&Array.isArray){return Array.isArray(H)}var I=Object.prototype.toString;var i=I.call([]);return I.call(H)===i},hasProperty:function(i,H){return Object.prototype.hasOwnProperty.call(i,H)},indexOfArray:function(J,I){if(!J){return -1}if("function"===typeof J.indexOf&&J.indexOf){return J.indexOf(I)}if(!this.isArray(J)){return -1}for(var H=0;H<J.length;H++){if(J[H]===I){return H}}return -1},setMethodWrapIfNeeded:function(H,I,K){if(!(I in H)){H[I]=K;return}var J=H[I];if(!m.utils.isFunction(J)){H[I]=K;return}try{H[I]=function(){try{var L=J.apply(H,[].slice.call(arguments,0))}catch(M){K.apply(H,[].slice.call(arguments,0));throw M}K.apply(H,[].slice.call(arguments,0));return L}}catch(i){}}};var u=function(){this.values={};this.events=[];this.callbacks=[];this.reset=function(){this.values={};this.events=[];this.callbacks=[]};this.push=function(I){if(!C.isObject(I)){z.log("pushed dataLayer value is not an object",I);
return}this.events.push(I);var H;for(H in I){if(C.hasProperty(I,H)){this.set(H,I[H])}}for(H=0;H<this.callbacks.length;H++){if(this.callbacks[H]){this.callbacks[H](I)}}};this.on=function(i){this.callbacks.push(i);return this.callbacks.length-1};this.off=function(i){if(i in this.callbacks){this.callbacks[i]=null}};this.set=function(i,H){this.values[i]=H};this.getAllEvents=function(i){return this.events};this.get=function(i){if(i in this.values){if(C.isFunction(this.values[i])){return this.values[i]()}else{if(C.isObject(this.values[i])&&C.isFunction(this.values[i].get)){return this.values[i].get()}}return this.values[i]}var H=v(i,this.values);if(C.isDefined(H)){return H}}};var q=new u();var F={matchesDateRange:function(I,H,J){var K=Date.UTC(I.getUTCFullYear(),I.getUTCMonth(),I.getUTCDate(),I.getUTCHours(),I.getUTCMinutes(),I.getUTCSeconds());if(H){H=String(H).replace(/-/g,"/")}if(J){J=String(J).replace(/-/g,"/")}var M,i;try{M=this.convertStringToDate(H)}catch(L){if(H){D("Invalid startDateTime given")
}}try{i=this.convertStringToDate(J)}catch(L){if(J){D("Invalid endDateTime given")}}if(H&&isNaN&&isNaN(M.getTime())){D("Invalid startDateTime given")}if(J&&isNaN&&isNaN(i.getTime())){D("Invalid endDateTime given")}if(H&&K<M.getTime()){return false}if(J&&K>i.getTime()){return false}return true},convertStringToDate:function(i){var H=(i&&i.split(" ").length>2);i=i+(i&&i.toLowerCase()!=="invalid date"&&!H?" UTC":"");return new Date(i)}};var s={parseUrl:function(i,K){try{var L=document.createElement("a");L.href=i;var H=L.href;L=document.createElement("a");L.href=H;if(K&&K in L){if("hash"===K){return String(L[K]).replace("#","")}else{if("protocol"===K){return String(L[K]).replace(":","")}else{if("search"===K){return String(L[K]).replace("?","")}else{if("port"===K&&!L[K]){if(L.protocol==="https:"){return"443"}else{if(L.protocol==="http:"){return"80"}}}}}}if("pathname"===K&&L[K]&&String(L[K]).substr(0,1)!=="/"){return"/"+L[K]}if("port"===K&&L[K]){return String(L[K])}return L[K]}if("origin"===K&&"protocol" in L&&L.protocol){return L.protocol+"//"+L.hostname+(L.port?":"+L.port:"")
}return}catch(J){if("function"===typeof URL){var I=new URL(i);if(K&&K in I){if("hash"===K){return String(I[K]).replace("#","")}else{if("protocol"===K){return String(I[K]).replace(":","")}else{if("search"===K){return String(I[K]).replace("?","")}else{if("port"===K&&!I[K]){if(I.protocol==="https:"){return"443"}else{if(I.protocol==="http:"){return"80"}}}}}}return I[K]}return}}},decodeSafe:function(H){try{return a.decodeURIComponent(H)}catch(i){return a.unescape(H)}},getQueryParameter:function(L,H){if(!C.isDefined(H)){H=a.location.search}if(!H||!C.isDefined(L)||L===null||L===false||L===""){return null}var i=H.substr(0,1);if(H!=="?"&&H!=="&"){H="?"+H}L=L.replace("[","\\[");L=L.replace("]","\\]");var K=new RegExp("[?&]"+L+"(=([^&#]*)|&|#|$)");var J=K.exec(H);if(!J){return null}if(!J[2]){return""}var I=J[2].replace(/\+/g," ");return this.decodeSafe(I)}};var c;var E={hasSetupScroll:false,scrollCallbacks:[],scrollListenEvents:["scroll","resize"],offScroll:function(H){if(H in this.scrollCallbacks){this.scrollCallbacks[H]=null
}var J=0,I=0;for(J in this.scrollCallbacks){if(this.scrollCallbacks[J]){I++}}if(!I){for(J=0;J<this.scrollListenEvents.length;J++){if(b.removeEventListener){a.removeEventListener(this.scrollListenEvents[J],this.didScroll,true)}else{a.detachEvent("on"+this.scrollListenEvents[J],this.didScroll)}}this.hasSetupScroll=false}},didScroll:function(i){if(c){return}if(i&&i.type&&i.type==="scroll"&&i.target&&i.target!==b&&i.target!==a){return}c=setTimeout(function(){c=null;var H;for(H=0;H<E.scrollCallbacks.length;H++){if(E.scrollCallbacks[H]){E.scrollCallbacks[H](i)}}},120)},onScroll:function(H){this.scrollCallbacks.push(H);if(!this.hasSetupScroll){this.hasSetupScroll=true;var i=0;for(i=0;i<this.scrollListenEvents.length;i++){if(b.addEventListener){a.addEventListener(this.scrollListenEvents[i],this.didScroll,true)}else{a.attachEvent("on"+this.scrollListenEvents[i],this.didScroll)}}}return this.scrollCallbacks.length-1},getScreenHeight:function(){return a.screen.height},getScreenWidth:function(){return a.screen.width
},getViewportWidth:function(){var i=a.innerWidth||b.documentElement.clientWidth||b.body.clientWidth;if(!i){return 0}return i},getViewportHeight:function(){var i=a.innerHeight||b.documentElement.clientHeight||b.body.clientHeight;if(!i){return 0}return i},getPerformanceTiming:function(i){if("performance" in a&&C.isObject(a.performance)&&C.isObject(a.performance.timing)&&i in a.performance.timing){return a.performance.timing[i]}return 0}};var B={loadScriptUrl:function(I,H){if(!H){H={}}if(!C.isDefined(H.defer)){H.defer=true}if(!C.isDefined(H.async)){H.async=true}if(!C.isDefined(H.type)){H.type="text/javascript"}var i=document.createElement("script");i.src=I;i.type=H.type;i.defer=!!H.defer;i.async=!!H.async;if(C.isFunction(H.onload)){i.onload=H.onload}if(C.isFunction(H.onerror)){i.onerror=H.onerror}if(C.isDefined(H.charset)){i.charset=H.charset}if(C.isDefined(H.id)){i.id=H.id}b.head.appendChild(i)},getScrollLeft:function(){return a.document.body.scrollLeft||a.document.documentElement.scrollLeft
},getScrollTop:function(){return a.document.body.scrollTop||a.document.documentElement.scrollTop},getDocumentHeight:function(){return Math.max(b.body.offsetHeight,b.body.scrollHeight,b.documentElement.offsetHeight,b.documentElement.clientHeight,b.documentElement.scrollHeight,1)},getDocumentWidth:function(){return Math.max(b.body.offsetWidth,b.body.scrollWidth,b.documentElement.offsetWidth,b.documentElement.clientWidth,b.documentElement.scrollWidth,1)},addEventListener:function(J,I,H,i){if(!J){z.log("element not found, cannot add event listener",J,this);return}if(J.addEventListener){i=i||false;J.addEventListener(I,H,i);return true}if(J.attachEvent){return J.attachEvent("on"+I,H)}J["on"+I]=H},getElementText:function(H){if(!H){return}if(m.dom.shouldElementBeMasked(H)&&H.children.length===0){return"*******"}if(m.dom.elementHasMaskedChild(H)){return m.dom.getElementTextWithMaskedChildren(H)}var i=H.innerText||H.textContent||"";i=i.replace(/([\s\uFEFF\xA0])+/g," ");i=i.replace(/(\s)+/g," ");return C.trim(i)
},getElementClassNames:function(i){if(i&&i.className){return C.trim(String(i.className).replace(/\s{2,}/g," "))}return""},getElementAttribute:function(J,H){if(!J||!H){return}var i=H.toLowerCase();if((i==="value"||i==="title"||i==="alt"||i==="label"||i==="placeholder")&&m.dom.shouldElementBeMasked(J)){return"*******"}if(J&&J.getAttribute){return J.getAttribute(H)}if(!J||!J.attributes){return}var I=(typeof J.attributes[H]);if("undefined"===I){return null}if(J.attributes[H].value){return J.attributes[H].value}if(J.attributes[H].nodeValue){return J.attributes[H].nodeValue}return null},_htmlCollectionToArray:function(I){var i=[];if(!I||!I.length){return i}var H;for(H=0;H<I.length;H++){i.push(I[H])}return i},byId:function(i){if(C.isString(i)&&i.substr(0,1)==="#"){i=i.substr(1)}return b.getElementById(i)},byClassName:function(i){if(i&&"getElementsByClassName" in b){return this._htmlCollectionToArray(b.getElementsByClassName(i))}return[]},byTagName:function(i){if(i&&"getElementsByTagName" in b){return this._htmlCollectionToArray(b.getElementsByTagName(i))
}return[]},bySelector:function(i){if(i&&"querySelectorAll" in b){return this._htmlCollectionToArray(b.querySelectorAll(i))}return[]},isElementContext:function(J,i){if(!J||!i){return false}J=String(J).toLowerCase();i=String(i).toLowerCase();var I=J.lastIndexOf("<"+i);if(I===-1){return false}var H=J.substring(I);return !H.match(new RegExp("<\\s*/\\s*"+i+">"))},isAttributeContext:function(N,L){if(!N||!L){return false}N=String(N).replace(/([\s\uFEFF\xA0]*=[\s\uFEFF\xA0]*)/g,"=");var I=N.lastIndexOf("<");if(I===-1){return false}var P=N.substring(I);var H=P.indexOf(">");if(H!==-1){return false}var O=P.lastIndexOf("=");if(O===-1){return false}var K=P.lastIndexOf(" ",O);var M=P.substring(K,O);M=C.trim(M);if(M.toLowerCase()!==L.toLowerCase()){return false}var J=P.substring(O).replace("=","");var i=J.substring(0,1);if('"'===i){return -1===J.substring(1).indexOf('"')}else{if("'"===i){return -1===J.substring(1).indexOf("'")}}return -1===J.indexOf(" ")},onLoad:function(i){if(b.readyState==="complete"){i()
}else{if(a.addEventListener){a.addEventListener("load",i)}else{if(a.attachEvent){a.attachEvent("onload",i)}}}},onReady:function(I){var i=false;if(b.attachEvent){i=b.readyState==="complete"}else{i=b.readyState!=="loading"}if(i){I();return}if(b.addEventListener){this.addEventListener(b,"DOMContentLoaded",function H(){b.removeEventListener("DOMContentLoaded",H,false);if(!i){i=true;I()}})}else{if(b.attachEvent){b.attachEvent("onreadystatechange",function H(){if(b.readyState==="complete"){b.detachEvent("onreadystatechange",H);if(!i){i=true;I()}}})}}this.onLoad(function(){if(!i){i=true;I()}})},onClick:function(H,i){if(typeof i==="undefined"){i=b.body}m.dom.addEventListener(i,"click",function(I){var J=(I.which?I.which:1);if(J===1){H(I,"left")}},true);m.dom.addEventListener(i,"auxclick",function(I){var J=(I.which?I.which:2);if(J===2){H(I,"middle")}},true);m.dom.addEventListener(i,"contextmenu",function(I){var J=(I.which?I.which:3);if(J===3){H(I,"right")}},true)},shouldElementBeMasked:function(H){if(typeof H==="undefined"){return false
}if(H.hasAttribute("data-matomo-mask")||H.hasAttribute("data-piwik-mask")){return true}if(H.hasAttribute("data-matomo-unmask")||H.hasAttribute("data-piwik-unmask")){return false}var i=H.parentElement;while(i){if(i.hasAttribute("data-matomo-mask")||i.hasAttribute("data-piwik-mask")){return true}if(i.hasAttribute("data-matomo-unmask")||i.hasAttribute("data-piwik-unmask")){return false}i=i.parentElement}return false},elementHasMaskedChild:function(i){if(typeof i==="undefined"){return false}if(i.children.length===0){return false}if(i.hasAttribute("data-matomo-mask")||i.hasAttribute("data-piwik-mask")||m.dom.shouldElementBeMasked(i)){return true}return i.querySelector("[data-matomo-mask],[data-piwik-mask]")!==null},getElementTextWithMaskedChildren:function(I){var L="";var K=I.children;for(var H=0;H<K.length;H++){var J=K[H];L+=m.dom.getElementText(J)+" "}return C.trim(L)}};function x(I){this.window=a;this.document=b;this.set=function(i,J){this[i]=J};this.get=function(J,i){if(J===null||J===false||!C.isDefined(J)){return i
}if(J in this){if(C.isObject(this[J])&&"get" in this[J]&&C.isFunction(this[J].get)){return this[J].get()}return this[J]}var K=v(J,this);if(C.isDefined(K)){return K}return i};this.buildVariable=function(i){return p(i,this.get("container"))};if(C.isObject(I)){for(var H in I){if(C.hasProperty(I,H)){this.set(H,I[H])}}}}function A(H,i){this.isValid=function(){var J=p(H.actual,i).get();var I=p(H.expected,i).get();return C.compare(J,I,H.comparison)}}function p(H,i){if(C.isObject(H)&&H.joinedVariable&&C.isArray(H.joinedVariable)){return new r(H.joinedVariable,i)}else{if(C.isObject(H)&&H.type){return new t(H,i)}}return new n(H,i)}function r(H,i){this.name="";this.type="JoinedVariable";this.getDefinition=function(){return H};this.get=function(){var J="",K;for(var I=0;I<H.length;I++){K=p(H[I],i).toString();if(K!==false&&K!==null&&C.isDefined(K)){J+=K}}return J};this.toString=function(){return this.get()};this.addDebugValues=function(I){I.push({name:null,type:"_joined",value:this.get()})}}function n(J,H){this.name="";
this.type="ConstantVariable";this.getDefinition=function(){return J};function I(L){return L&&C.isObject(L)&&!C.isArray(L)&&(C.hasProperty(L,"type")||C.hasProperty(L,"joinedVariable"))}function K(N){if(N==null||typeof N!=="object"){return N}var L=new N.constructor();var M;for(M in N){if(C.hasProperty(N,M)){L[M]=K(N[M])}}return L}function i(M){var L;if(I(M)){M=p(M,H).get()}else{if(M&&C.isArray(M)){for(L=0;L<M.length;L++){M[L]=i(M[L])}}else{if(M&&C.isObject(M)){for(L in M){if(C.hasProperty(M,L)){M[L]=i(M[L])}}}}}return M}this.get=function(){var L=J;if(C.isObject(L)){L=K(L);L=i(L)}return L};this.toString=function(){return J};this.addDebugValues=function(L){L.push({name:null,type:"_constant",value:this.get()})}}function t(I,H){this.type=I.type;this.name=I.name;this.lookUpTable=I.lookUpTable||[];this.defaultValue=undefined;this.parameters=I.parameters||{};this.getDefinition=function(){return I};this.get=function(){var M;try{M=this.theVariable.get()}catch(N){z.error("Failed to get value of variable",N,this);
M=undefined}if((!C.isDefined(M)||M===null||M===false)&&C.isDefined(this.defaultValue)){M=this.defaultValue}var L;for(L=0;L<this.lookUpTable.length;L++){var O=this.lookUpTable[L];if(C.compare(M,O.matchValue,O.comparison)){return O.outValue}}return M};this.toString=function(){if(this.theVariable&&C.hasProperty(this.theVariable,"toString")&&C.isFunction(this.theVariable.toString)){try{return this.theVariable.toString()}catch(i){z.error("Failed to get toString of variable",i,this);return}}return this.get()};this.addDebugValues=function(i){i.push({name:this.name,type:this.type,value:this.get()})};if("undefined"!==typeof I.defaultValue){this.defaultValue=I.defaultValue}if(!C.isDefined(I.Variable)||!I.Variable){z.log("no template defined for variable ",I);return}var J,K=new x({variable:this,container:H});if(C.isObject(I.parameters)){for(J in I.parameters){if(C.hasProperty(I.parameters,J)){K.set(J,p(I.parameters[J],H))}}}if(C.isFunction(I.Variable)){this.theVariable=new I.Variable(K,m)}else{if(C.isObject(I.Variable)){this.theVariable=I.Variable
}else{if(I.Variable in H.templates){this.theVariable=new H.templates[I.Variable](K,m)}else{D("No matching variable template found")}}}}function f(J,H){this.referencedTags=[];this.id=J.id;this.type=J.type;this.name=J.name;this.conditions=[];this.parameters=J.parameters||{};var I=this;this.getId=function(){return this.id};this.setUp=function(){if(this.theTrigger&&this.theTrigger.setUp&&C.isFunction(this.theTrigger.setUp)){this.theTrigger.setUp(function(Q){q.push(Q);if(!("event" in Q)){return}var M={tags:[],variables:[],metTrigger:null,name:Q.event,eventData:Q,container:{}};var P,O;if(I.meetsConditions()){z.log("The condition is met for trigger "+I.name,I);M.metTrigger={name:I.name,type:I.type};var N=I.getReferencedTags();for(O=0;O<N.length;O++){if(N[O].hasBlockTrigger(I)){N[O].block();N[O].addDebugValues(M.tags,"Block")}else{if(N[O].hasFireTrigger(I)){N[O].fire();N[O].addDebugValues(M.tags,"Fire")}}}}if(window.mtmPreviewWindow||z.enabled){H.addDebugValues(M.container);d(M);if(z.enabled){z.log("event: ",M)
}}})}};this.addReferencedTag=function(i){this.referencedTags.push(i)};this.getReferencedTags=function(){return this.referencedTags};this.meetsConditions=function(){var M,N;for(M=0;M<this.conditions.length;M++){N=new A(this.conditions[M],H);if(!N.isValid()){return false}}return true};if(J.conditions&&C.isArray(J.conditions)){this.conditions=J.conditions}var K,L=new x({trigger:this,container:H});if(C.isObject(J.parameters)){for(K in J.parameters){if(C.hasProperty(J.parameters,K)){L.set(K,p(J.parameters[K],H))}}}if(!C.isDefined(J.Trigger)||!J.Trigger){z.error("no template defined for trigger ",J);return}if(C.isFunction(J.Trigger)){this.theTrigger=new J.Trigger(L,m)}else{if(C.isObject(J.Trigger)){this.theTrigger=J.Trigger}else{if(J.Trigger in H.templates){this.theTrigger=new H.templates[J.Trigger](L,m)}else{D("No matching trigger template found")}}}L=null}function h(H,I){this.type=H.type;this.name=H.name;this.fireTriggerIds=H.fireTriggerIds?H.fireTriggerIds:[];this.blockTriggerIds=H.blockTriggerIds?H.blockTriggerIds:[];
this.fireLimit=H.fireLimit?H.fireLimit:h.FIRE_LIMIT_UNLIMITED;this.fireDelay=H.fireDelay?parseInt(H.fireDelay,10):0;this.startDate=H.startDate?H.startDate:null;this.endDate=H.endDate?H.endDate:null;this.numExecuted=0;this.blocked=false;this.parameters=H.parameters||{};this.isTagFireLimitAllowedInPreviewMode=I.isTagFireLimitAllowedInPreviewMode||false;var J=this;this.addDebugValues=function(i,M){i.push({action:M,type:this.type,name:this.name,numExecuted:this.numExecuted})};this._doFire=function(){if(this.blocked){z.log("not firing as this tag is blocked",this);return"tag is blocked"}if(this.fireLimit!==h.FIRE_LIMIT_UNLIMITED&&this.numExecuted){z.log("not firing as this tag has limit reached",this);return"fire limit is restricted"}var M="tag";if(I.id){M+="_"+I.id}if(this.fireLimit===h.FIRE_LIMIT_ONCE_24HOURS&&(!window.mtmPreviewWindow||this.isTagFireLimitAllowedInPreviewMode)){if(y.get(M,this.name)){z.log("not firing as this tag has 24hours limit reached",this);return"fire limit 24hours is restricted"
}}if(this.fireLimit===h.FIRE_LIMIT_ONCE_LIFETIME&&(!window.mtmPreviewWindow||this.isTagFireLimitAllowedInPreviewMode)){if(y.get(M,this.name)){z.log("not firing as this tag has limit reached",this);return"fire limit lifetime is restricted"}}if(!F.matchesDateRange(new Date(),this.startDate,this.endDate)){z.log("not firing as this tag does not match date",this);return"date range does not match"}if(!this.theTag||!this.theTag.fire){z.log("not firing as tag does not exist anymore",this);return"tag not found"}z.log("firing this tag",this);this.numExecuted++;if(this.fireLimit===h.FIRE_LIMIT_ONCE_24HOURS){var i=24*60*60;y.set(M,this.name,"1",i)}if(this.fireLimit===h.FIRE_LIMIT_ONCE_LIFETIME){y.set(M,this.name,"1")}this.theTag.fire();z.log("fired this tag",this)};this.fire=function(){if(this.fireDelay){setTimeout(function(){J._doFire()},this.fireDelay)}else{return this._doFire()}};this.block=function(){this.blocked=true};this.hasFireTrigger=function(i){if(!this.fireTriggerIds||!this.fireTriggerIds.length){return false
}if(!i){return false}var M=i.getId();return C.indexOfArray(this.fireTriggerIds,M)!==-1};this.hasBlockTrigger=function(i){if(!this.blockTriggerIds||!this.blockTriggerIds.length){return false}if(!i){return false}var M=i.getId();return C.indexOfArray(this.blockTriggerIds,M)!==-1};if(!C.isDefined(H.Tag)||!H.Tag){z.error("no template defined for tag ",H);return}var K,L=new x({tag:this,container:I});if(C.isObject(H.parameters)){for(K in H.parameters){if(C.hasProperty(H.parameters,K)){L.set(K,p(H.parameters[K],I))}}}if(C.isFunction(H.Tag)){this.theTag=new H.Tag(L,m)}else{if(C.isObject(H.Tag)){this.theTag=H.Tag}else{if(H.Tag in I.templates){this.theTag=new I.templates[H.Tag](L,m)}else{D("No matching tag template found")}}}}h.FIRE_LIMIT_ONCE_PAGE="once_page";h.FIRE_LIMIT_ONCE_24HOURS="once_24hours";h.FIRE_LIMIT_ONCE_LIFETIME="once_lifetime";h.FIRE_LIMIT_UNLIMITED="unlimited";function o(I,N){var J=this;this.id=I.id;this.idsite=I.idsite||null;this.isTagFireLimitAllowedInPreviewMode=I.isTagFireLimitAllowedInPreviewMode||false;
this.versionName=I.versionName||null;this.revision=I.revision||null;this.environment=I.environment||null;this.templates=N||{};this.dataLayer=new u();this.variables=[];this.triggers=[];this.tags=[];this.onNewGlobalDataLayerValue=function(i){this.dataLayer.push(i)};q.on(function(i){J.onNewGlobalDataLayerValue(i)});this.addDebugValues=function(P){P.variables=[];var Q;for(Q=0;Q<this.variables.length;Q++){this.variables[Q].addDebugValues(P.variables)}P.tags=[];for(Q=0;Q<this.tags.length;Q++){this.tags[Q].addDebugValues(P.tags,"Not Fired Yet")}P.id=this.id;P.versionName=this.versionName;P.dataLayer=JSON.parse(JSON.stringify(this.dataLayer.values,function(i,R){if(typeof R==="object"&&R instanceof Node){return R.nodeName}else{return R}}))};this.getTriggerById=function(P){if(!P){return}var Q;for(Q=0;Q<this.triggers.length;Q++){if(this.triggers[Q].getId()===P){return this.triggers[Q]}}};this.addTrigger=function(i){if(!i){return}var P=this.getTriggerById(i.id);if(!P){P=new f(i,this);this.triggers.push(P)
}return P};var M,L,H,O,K;if(I.variables&&C.isArray(I.variables)){for(M=0;M<I.variables.length;M++){this.variables.push(p(I.variables[M],this))}}if(I.triggers&&C.isArray(I.triggers)){if(I.tags&&C.isArray(I.tags)){I.triggers.sort(function(Q,P){var R=false,T=false,i,S;for(S=0;S<I.tags.length;S++){i=I.tags[S];if(i&&i.blockTriggerIds&&C.isArray(i.blockTriggerIds)){R=R||C.indexOfArray(i.blockTriggerIds,Q.id)!==-1;T=T||C.indexOfArray(i.blockTriggerIds,P.id)!==-1}}if(R&&!T){return -1}else{if(T&&!R){return 1}}if(Q.id<P.id){return -1}return 1})}for(M=0;M<I.triggers.length;M++){this.addTrigger(I.triggers[M])}}if(I.tags&&C.isArray(I.tags)){for(M=0;M<I.tags.length;M++){O=I.tags[M];H=new h(O,this);this.tags.push(H);if(O.blockTriggerIds&&C.isArray(O.blockTriggerIds)){for(L=0;L<O.blockTriggerIds.length;L++){K=this.getTriggerById(O.blockTriggerIds[L]);if(K){K.addReferencedTag(H)}}}if(O.fireTriggerIds&&C.isArray(O.fireTriggerIds)){for(L=0;L<O.fireTriggerIds.length;L++){K=this.getTriggerById(O.fireTriggerIds[L]);
if(K){K.addReferencedTag(H)}}}}}this.run=function(){var Q=q.getAllEvents();var P;for(P=0;P<Q.length;P++){this.onNewGlobalDataLayerValue(Q[P])}for(P=0;P<this.triggers.length;P++){this.triggers[P].setUp()}}}var m={THROW_ERRORS:true,dataLayer:q,containers:[],url:s,date:F,utils:C,debug:z,dom:B,window:E,Variable:t,storage:{local:y,session:e},_buildVariable:p,Condition:A,TemplateParameters:x,Trigger:f,Tag:h,throwError:D,Container:o,addContainer:function(N,K){var L=s.getQueryParameter("mtmSetDebugFlag");if(L){var I=encodeURIComponent(N.idsite);var i=encodeURIComponent(N.id);if(L==1){var J=new Date();J.setTime(J.getTime()+(7*24*60*60*1000));document.cookie="mtmPreviewMode=mtmPreview"+I+"_"+i+"%3D1;expires="+J.toUTCString()+";SameSite=Lax"}else{document.cookie="mtmPreviewMode=mtmPreview"+I+"_"+i+"%3D1;expires=Thu, 01 Jan 1970 00:00:00 UTC;SameSite=Lax";window.close()}}if(!window.mtmPreviewWindow){var M=b.getElementById("mtmDebugFrame");if(M&&M.contentWindow){window.mtmPreviewWindow=M.contentWindow
}}z.log("creating container");var H=new o(N,K);this.containers.push(H);H.dataLayer.push({"mtm.containerId":H.id});z.log("running container");H.run();return H},enableDebugMode:function(){z.enabled=true}};if("matomoTagManagerAsyncInit" in a&&C.isFunction(a.matomoTagManagerAsyncInit)){a.matomoTagManagerAsyncInit(m)}function g(){var L,J,I,N,O;for(L=0;L<arguments.length;L+=1){O=null;if(arguments[L]&&arguments[L].slice){O=arguments[L].slice()}N=arguments[L];if(C.isObject(N)&&!C.isArray(N)){q.push(N);continue}I=N.shift();var M=C.isString(I)&&I.indexOf("::")>0;if(M){var H,K;H=I.split("::");K=H[0];I=H[1];if("object"===typeof m[K]&&C.isFunction(m[K][I])){m[K][I].apply(m[K],N)}}else{if(I&&I in m&&C.isFunction(m[I])){m[I].apply(m,N)}else{z.error("method "+I+" is not valid")}}}}C.setMethodWrapIfNeeded(a._mtm,"push",g);var w;for(w=0;w<a._mtm.length;w++){g(a._mtm[w])}q.push({"mtm.mtmScriptLoadedTime":l});if(("undefined"===typeof ignoreGtmDataLayer||!ignoreGtmDataLayer)&&"undefined"!==typeof a.dataLayer&&C.isArray(a.dataLayer)){for(w=0;
w<a.dataLayer.length;w++){if(C.isObject(a.dataLayer[w])){q.push(a.dataLayer[w])}}}if(!("undefined"===typeof activelySyncGtmDataLayer)&&activelySyncGtmDataLayer){a.dataLayer=a.dataLayer||[];const k=function(I,H){const i=I.push;I.push=function(J){i.call(I,J);H(I)}};k(a.dataLayer,function(i){q.push(a.dataLayer[a.dataLayer.length-1])})}return m})()}
(function(){
var Templates = {};
window.MatomoTagManager.addContainer({"id":"ARt8IzkD","isTagFireLimitAllowedInPreviewMode":0,"idsite":1,"versionName":"","revision":0,"environment":"preview","tags":[],"triggers":[],"variables":[]}, Templates);})()
})();