<?php

use App\Controllers\Article;
use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
service('auth')
    ->routes($routes,[
    "except"=>[
    ]
]);

$routes->get('/', 'Home::index');

$routes->get('/inicio', 'Home::sale');
$routes->get('/inventario', 'Home::inventory');
$routes->get('/articulos', 'Home::articles');
$routes->get('/perfil', 'Home::profile');
$routes->get('/mis-ventas', 'Home::mySales');
$routes->get('/ventas', 'Home::salesHistory');
$routes->get('/reportes', 'Home::reports');
$routes->get('/report/utilities', 'Report::bestUtility');
$routes->get('/entregas', 'Home::deliver');
$routes->get('/apartados', 'Home::aside');
$routes->get('/categorias', 'Home::categories');
$routes->get('/clientes', 'Home::clients');
$routes->get('/usuarios', 'Home::users');
$routes->get('/ingresos', 'Home::incomes');
$routes->get('/creditos', 'Home::credits');
$routes->get('/traspasos', 'Home::transfers');
$routes->get('/proveedores', 'Home::suppliers');
$routes->get('/tiendas', 'Home::store');
$routes->get("/inventario/tienda/(:any)/articulo/(:any)","Home::historyItem/$1/$2");

$routes->get("/stock",[Article::class,'stock']);
$routes->get("/stock/store/(:any)","Inventory::inventory/$1/$2/$3");
$routes->get("/inventory/store/(:any)","Inventory::inventory/$1/$2/$3");
$routes->get("/sale/(:segment)/(:segment)","Sale::sales/$1/$2");
$routes->get("/mi-corte","CashOut::index");
$routes->get("/aside/items/(:num)","Aside::items/$1");
//EXPENSES
$routes->get('/gastos', 'Expenses::new');



//CATEGORIES
$routes->resource("expenses");
$routes->resource("inventory");
$routes->resource("payment");
$routes->resource("article");
$routes->resource("income");
$routes->resource("itemCategory");
$routes->resource("store");
$routes->resource("supplier");
$routes->resource("user");
$routes->resource("transfer");
$routes->resource("sale");
$routes->resource("saleItem");
$routes->resource("customer");
$routes->resource("report");
$routes->resource("credit");
$routes->resource("delivery");
$routes->resource("aside");


$routes->get("debugger","Dummy::debugger");

$routes->post("/user/store","User::myStore");

$routes->get("/ticket/(:any)","Sale::ticket/$1");
$routes->get("/tickets","Sale::tickets");
$routes->get("/apartado/(:any)","Aside::ticket/$1");
$routes->get("/abono/(:any)","Credit::ticket/$1");
$routes->get("/uuid","Sale::uuid");


