<?php

namespace App\Controllers;

use App\Models\AsideModel;
use App\Models\ExpensesCategoryModel;
use App\Models\StoreModel;
use App\Services\AsideService;
use App\Services\InventoryService;
use App\Services\ReportService;
use CodeIgniter\HTTP\RedirectResponse;
use CodeIgniter\I18n\Time;

class Home extends BaseController
{
    public function __construct()
    {
        //
    }
    
    public function index(): RedirectResponse | string
    {
        return auth()->loggedIn()
            ? redirect()->back()
            : view('login');
    }

    public function sale(): string
    {
		$today = Time::today();
		$report = new ReportService();
        $reports = [];
        $reports['sales_today']=$report->today($today);
        $reports['sales_week']=$report->week();
        $reports['expenses_today']=$report->expensesToday($today);
        $reports['debt']=$report->total_debt();
        $reports['byCredit']=$report->incomeByCredits($today);
        
		$this->viewData['reports'] = $reports;
		$this->viewData['date'] = $today;
		$this->viewData['path'] = '/inicio';
		$this->viewData['title'] = 'Inicio';
        return view('components/sale', $this->viewData);
    }

    public function store(): string
    {
        $this->viewData['path'] = '/tiendas';
        $this->viewData['title'] = 'Tiendas';
        return view('components/store', $this->viewData);
    }

    public function articles(): string
    {
        $this->viewData['path'] = '/articulos';
        $this->viewData['title'] = 'Artículos';
        return view('components/articles', $this->viewData);
    }

    public function categories(): string
    {
        $this->viewData['path'] = '/categorias';
        $this->viewData['title'] = 'Categorías';
        return view('components/categories', $this->viewData);
    }

    public function suppliers(): string
    {
        $this->viewData['path'] = '/proveedores';
        $this->viewData['title'] = 'Proveedores';
        return view('components/suppliers', $this->viewData);
    }

    public function users(): string
    {
        $this->viewData['path'] = '/usuarios';
        $this->viewData['title'] = 'Usuarios';
        return view('components/users', $this->viewData);
    }

    public function clients(): string
    {
        $this->viewData['path'] = '/clientes';
        $this->viewData['title'] = 'Clientes';
        return view('components/clients', $this->viewData);
    }

    public function inventory(): string
    {
        helper("number");
        $inventory = new InventoryService();
        $this->viewData['path'] = '/inventario';
        $this->viewData['title'] = 'Inventario';
        $this->viewData['inventoryStats'] = $inventory->inventoryCost();
        return view('components/inventory', $this->viewData);
    }

    public function salesHistory(): string
    {
        $this->viewData['path'] = '/ventas';
        $this->viewData['title'] = 'Ventas';
        return view('components/salesHistory', $this->viewData);
    }

    public function profile(): string
    {
        $this->viewData['path'] = '/perfil';
        $this->viewData['title'] = 'Perfil';
        return view('components/profile', $this->viewData);
    }

    public function mySales(): string
    {
        $this->viewData['path'] = '/mis-ventas';
        $this->viewData['title'] = 'Mis Ventas';
        return view('components/my-sales', $this->viewData);
    }

    public function deliver(): string
    {
        $this->viewData['path'] = '/entregas';
        $this->viewData['title'] = 'Entregas';
        return view('components/deliver', $this->viewData);
    }

    public function historyItem($store, $item)
    {
        $inventory = new InventoryService();
        $history = $inventory->getInventory($store,"item",$item);
        $this->viewData['path'] = '/detalle';
        $this->viewData['title'] = 'Detalle';
        $this->viewData['history'] = $history;
       
        $export = $this->request->getGet("export");
        if($export==="xls") {
            $view = "xls";
            
            header("Pragma: public");
            header("Expires: 0");
            $filename ="Inventarios_".$history[0]->code."_".$history[0]->item_name.".xls";
            header("Content-type: application/x-msdownload");
            header("Content-Disposition: attachment; filename=$filename");
            header("Pragma: no-cache");
            header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
            
            
        } else {
            $view = "detail";
        }
       
        return view('components/inventory_'.$view, $this->viewData);
    }
    
    public function reports()
	{
		$range = $this->request->getGet();
		$today = empty($range) ? Time::today() : $range;
		$report = new ReportService();
		$reports = $report->index($today);
		$this->viewData['path'] = '/reportes';
		$this->viewData['title'] = 'Reportes';
		$this->viewData['reports'] = $reports;
		$this->viewData['date'] = $today;
		return view('components/report', $this->viewData);
	}

	public function credits(): string
	{
		$this->viewData['path'] = '/creditos';
		$this->viewData['title'] = 'Créditos';
		return view('components/credits', $this->viewData);
	}

	public function transfers(): string
	{
		$this->viewData['path'] = '/traspasos';
		$this->viewData['title'] = 'Traspasos';
		return view('components/transfers', $this->viewData);
	}

	public function aside(): string
	{
		$this->viewData['path'] = '/apartados';
		$this->viewData['title'] = 'Apartados';
		$aside = new AsideService();
		$asides = $aside->list();
		$this->viewData['asides'] = $asides;
		return view('components/aside', $this->viewData);
	}

    public function incomes(): string
    {
        $this->viewData['path'] = '/ingresos';
        $this->viewData['title'] = 'Ingresos';
        $this->viewData["today"] = date('Y-m-d');
        $this->viewData["categories"] = model(ExpensesCategoryModel::class)->findAll();
        $this->viewData["users"] = auth()->getProvider()->findAll();
        return view('components/incomes', $this->viewData);
    }
}
