<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\SupplierModel;
use CodeIgniter\API\ResponseTrait;
use CodeIgniter\HTTP\ResponseInterface;

class Supplier extends BaseController
{
    use ResponseTrait;
    protected SupplierModel  $supplierModel;
    
    
    public function __construct()
    {
        $this->supplierModel = new SupplierModel();
    }
    
    public function index(): ResponseInterface
    {
        return $this->respond($this->supplierModel->findAll());
    }
    
    public function show($id): ResponseInterface
    {
        return $this->respond($this->supplierModel->find($id));
    }
    
    public function create(): ResponseInterface
    {
        $supplier = new \App\Entities\Supplier($this->request->getPost());
        
        try {
            $inserted = $this->supplierModel->save($supplier);
            
        } catch (\ReflectionException $e) {
            return $this->fail($e->getMessage());
        }
        $lastId = $this->supplierModel->getInsertID();
        return $inserted  ?
            $this->respondCreated($this->supplierModel->find($lastId)) : $this->fail($this->supplierModel->errors());
    }
    public function update($id):ResponseInterface
    {
        $supplier = $this->supplierModel->find($id);
        
        $supplier->fill($this->request->getRawInput());
        
        try {
            $updated = $this->supplierModel->save($supplier);
        } catch (\ReflectionException $e) {
            return $this->fail($e->getMessage());
        }
        
        return $updated? $this->respondUpdated($supplier): $this->fail($this->supplierModel->errors());
        
    }
    
    public function delete($id): ResponseInterface
    {
        return $this->respondDeleted( $this->supplierModel->delete($id));
    }
}
