<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;
use CodeIgniter\Database\RawSql;

class TableExpenses extends Migration
{
    public function up()
    {
        $this->forge->addField([
            "id"=> [
                "TYPE"=>"INT",
                "CONTSTRAINT"=>11,
                "auto_increment"=> true ,
            ],
            "concept"=>[
                "type"=>"VARCHAR",
                "constraint"=>300
            ],
            "amount"=>[
                "type"=>"decimal",
                "constraint"=>"7,2",
            ],
           
            "responsible"=>[
                "type"=>"int",
                "constraint"=>"11",
                "null"=>true
            ],
            "category"=>[
                "type"=>"INT",
                "constraint"=>11
            ],
            "created_by"=>[
                "type"=>"INT",
                "constraint"=>11
            ],
            "comments"=>[
                "type"=>"varchar",
                "constraint"=>500,
                "null"=>true,
            ],
            "applied"=>[
                "type"=>"datetime",
                "null"=>true,
            ],
            "reconciled"=>[
                "type"=>"datetime",
                "null"=>true,
            ],
            "created_at"=>[
                "type"=>"datetime",
                "default"=>new RawSql("CURRENT_TIMESTAMP")
            ],
            "updated_at"=>[
                "type"=>"datetime",
                "null"=>true,
            ],
            "deleted_at"=>[
                "type"=>"datetime",
                "null"=>true,
            
            ]
        ]);
        $this->forge->addPrimaryKey("id");
        $this->forge->createTable("expenses",true);
    }

    public function down()
    {
        $this->forge->dropTable("expenses");
    }
}
