<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;
use CodeIgniter\Database\RawSql;

class TableItems extends Migration
{
    public function up()
    {
        $this->forge->addField([
            "id"=>[
                "type"=>"INT",
                "constraint"=>11,
                "auto_increment"=>true,
            ],
            "barcode" =>[
                "type"=>"varchar",
                "constraint"=>36,
                "null"=>true
            ],
           
            "name"=>[
                "type"=>"varchar",
                "constraint"=>150 ,
                "null"=>false,
            ],
            "category"=>[
                "type"=>"INT",
                "constraint"=>11,
            ],
            "cost"=> [
                "type"=>"decimal",
                "constraint"=>"10,2",
                "null"=>true,
                
            ],
            "public_price"=>[
                "type"=>"decimal",
                "constraint"=>"10,2",
                "null"=>true,
            ],
            "special_price"=>[
                "type"=>"decimal",
                "constraint"=>"10,2",
                "null"=>true,
            ],
            "qty_special_price"=>[
                "type"=>"int",
                "constraint"=>2,
                "null"=>true,
            ],
            "wholesale_price"=>[
                "type"=>"decimal",
                "constraint"=>"10,2",
                "null"=>true,
            ],
            "qty_wholesale_price"=>[
                "type"=>"int",
                "constraint"=>2,
                "null"=>true,
            ],
            
            "created_at"=>[
                "type"=>"DATETIME",
                "default"=>new RawSql("CURRENT_TIMESTAMP")
            ],
            "updated_at"=>[
                "type"=>"datetime",
                "null"=>true
            ],
            "deleted_at"=>[
                "type"=>"datetime",
                "null"=>true
            ]
        ]);
        $this->forge->addPrimaryKey("id")->createTable("items");
        
    }

    public function down()
    {
        $this->forge->dropTable("items");
    }
}
