<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;
use CodeIgniter\Database\RawSql;

class TableInventory extends Migration
{
    public function up()
    {
        $this->forge->addField([
            "id"=>[
                "type"=>"INT",
                "constraint"=>11,
                "auto_increment"=>true,
            ],
            "code"=>[
                "type"=>"varchar",
                "constraint"=>"50",
            ],
            "item"=>[
                "type"=>"INT",
                "constraint"=>11,
            ],
            "supplier"=>[
                "type"=>"INT",
                "constraint"=>11,
            ],
            "store"=>[
                "type"=>"INT",
                "constraint"=>11,
            ],
            "stock"=>[
                "type"=>"INT",
                "constraint"=>11,
            ],
            "bill"=>[
                "type"=>"varchar",
                "constraint"=>36,
            ],
            "enter_at"=>[
                "type"=>"DATETIME",
                "default"=>new RawSql("CURRENT_TIMESTAMP")
            ],
            "created_at"=>[
                "type"=>"DATETIME",
                "default"=>new RawSql("CURRENT_TIMESTAMP")
            ],
            "updated_at"=>[
                "type"=>"datetime",
                "null"=>true
            ],
            "deleted_at"=>[
                "type"=>"datetime",
                "null"=>true
            ]
            
        ])->addPrimaryKey("id")->createTable("inventory");
    }

    public function down()
    {
        $this->forge->dropTable("inventory");
    }
}
