<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;
use CodeIgniter\Database\RawSql;

class TableStore extends Migration
{
    public function up()
    {
        $this->forge
            ->addField([
                "id"=>[
                    "type"=>"INT",
                    "constraint"=>11,
                    "auto_increment"=>true,
                ],
                "name"=>[
                    "type"=>"varchar",
                    "constraint"=>50,
                ],
                "address"=>[
                    "type"=>"varchar",
                    "constraint"=>75,
                    "null"=>true
                ],
                "phone"=>[
                    "type"=>"varchar",
                    "constraint"=>15,
                    "null"=>true
                ],
                "created_at"=>[
                    "type"=>"DATETIME",
                    "default"=>new RawSql("CURRENT_TIMESTAMP")
                ],
                "updated_at"=>[
                    "type"=>"datetime",
                    "null"=>true
                ],
                "deleted_at"=>[
                    "type"=>"datetime",
                    "null"=>true
                ]
            ])
            ->addPrimaryKey("id")
            ->createTable("stores");
    }

    public function down()
    {
        $this->forge->dropTable("stores");
    }
}
