<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;
use CodeIgniter\Database\RawSql;

class TableCustomer extends Migration
{
    public function up()
    {
        $this->forge->addField([
            "id"=>[
                "type"=>"int",
                "constraint"=>11,
                "auto_increment"=>true
            ],
            "name"=>[
                "type"=>"varchar",
                "constraint"=>100,
            ],
            "last_name"=>[
                "type"=>"varchar",
                "constraint"=>100,
            ],
            "phone"=>[
                "type"=>"varchar",
                "constraint"=>15,
                "null"=>true
            ],
            "email"=>[
                "type"=>"varchar",
                "constraint"=>50,
                "null"=>true
            ],
            "address"=>[
                "type"=>"varchar",
                "constraint"=>250
            ],
            "created_by"=>[
                "type" =>"INT",
                "constraint"=>11,
            ],
            "created_at"=>[
                "type" =>"DATETIME",
                "default"=>new RawSql("CURRENT_TIMESTAMP")
            ],
            "updated_at"=>[
                "type" =>"DATETIME",
                "null"=>true
            ],
            "deleted_at"=>[
                "type" =>"DATETIME",
                "null"=>true
            ]
        ])
            ->addPrimaryKey("id")
            ->createTable("customers");
    }

    public function down()
    {
        $this->forge->dropTable("customers");
    }
}
