<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class TableSalePayments extends Migration
{
    public function up()
    {
        $this->forge->renameTable("credit_payments","payments");
        $this->forge->addColumn("payments",[
            "sale"=>[
                "type"=> "int",
                "constraint"=>11,
                "unsigned"=>true,
                "null" => true,
                "after"=>"credit"
            ],
            "cash"=>[
                "type"=> "decimal",
                "constraint"=>"10,2",
                "unsigned"=>true,
                "null" => true,
                "after"=>"amount"
            ],
            "cashback"=>[
                "type"=> "decimal",
                "constraint"=>"10,2",
                "unsigned"=>true,
                "null" => true,
                "after"=>"cash"
            ]
        ]);
        $this->forge->modifyColumn("payments",[
            "credit"=>["type" => "int", "constraint"=>11, "null"=>true, "unsigned"=>true],
        ]);
        
    }

    public function down()
    {
        //
    }
}
