<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;
use CodeIgniter\Database\RawSql;

class AsideTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            "id"=>[
                "type"=>"int",
                "constraint"=>11,
                "auto_increment"=>true
            ],
            "sale"=>[
                "type"=>"int",
                "constraint"=>11,
            ],
            "customer"=>[
                "type"=>"int",
                "constraint"=>11,
            ],
            "financing"=>[
                "type"=>"decimal",
                "constraint"=>"10,2"
            ],
            "created_by"=>[
                "type" =>"INT",
                "constraint"=>11,
            ],
            "paid_at"=>[
                "type" =>"DATETIME",
                "null"=>true
            ],
            "created_at"=>[
                "type" =>"DATETIME",
                "default"=>new RawSql("CURRENT_TIMESTAMP")
            ],
            "updated_at"=>[
                "type" =>"DATETIME",
                "null"=>true
            ],
            "deleted_at"=>[
                "type" =>"DATETIME",
                "null"=>true
            ]

        ])->addPrimaryKey("id")
          //  ->addforeignKey("customer","customers","id")
           // ->addForeignKey("created_by","users","id")
            //->addForeignKey("sale","sales","id")
            ->createTable("asides",true,["ENGINE"=>"InnoDB"]);

    }

    public function down()
    {
        $this->forge->dropTable("asides");
    }
}
