<?php

namespace App\Entities;

use App\Models\PaymentModel;
use CodeIgniter\Entity\Entity;

class Sale extends Entity
{
    
    private Payment $fee;
   
    protected $datamap = [];
    protected $dates   = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];
    
    protected $casts   = [
        "id"            => "integer",
        "store"         => "integer",
        "items"         => "integer",
        "customer"      => "integer",
        "amount"        => "double",
        "created_by"    => "integer"
    ];
    public function pay(Payment $payment): bool
    {
        $paymentModel = new PaymentModel();
        $inserted =  $paymentModel->save($payment);
        $this->fee = $paymentModel->find($paymentModel->getInsertID());
        return $inserted;
        
    }
    public function getFee(): Payment
    {
        return $this->fee;
    }
    
    public function deleteFee($id): bool
    {
        $paymentModel = new PaymentModel();
        $payment = $paymentModel->where(["sale"=>$id])->first();
        return $paymentModel->delete($payment->id);
        
    }
}
