<?php

namespace App\Models;

use App\Entities\Article;
use CodeIgniter\Model;

class ArticleModel extends Model
{
    protected $table            = 'items';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = Article::class;
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = [
        "name",
        "category",
        "cost",
        "public_price",
        "special_price",
        "qty_special_price",
        "wholesale_price",
        "qty_wholesale_price",
        "supplier",
        "created_at",
        "updated_at",
        "deleted_at"

    ];

    protected bool $allowEmptyInserts = false;

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [
       
        "name"=>"required",
        "category"=>"required",
        
        
    ];
    protected $validationMessages   = [
       
        "name"=> [
            "required"=>"El nombre es requerido"
        ],
        "category"=>[
            "required"=>"la categoría es requerida"
        ]
    ];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];
}
