<?php
namespace App\Services;

use App\Entities\Sale;
use App\Entities\SaleItem;
use App\Models\SaleItemsModel;
use App\Models\SaleModel;
use Throwable;

class SaleItemService
{
  
    protected SaleItemsModel $saleItemsModel;
    
    public function __construct()
    {
        $this->saleItemsModel = new SaleItemsModel();
        
    }
    
    /**
     * @throws \ReflectionException
     */
    public function setSaleItems(Sale $sale, array $cart): array | false
    {
        $inventoryService = new InventoryService();
        $cart = array_filter($cart);
        $items = [];
        $decreased = false;
        foreach ($cart as $key => $item)
        {
            $itemStock = $inventoryService->getInventory($sale->store,"item",$item["id"]);
            $decreased = $inventoryService->decrease($itemStock,(int)$item["qty"]);
            if ($decreased) {
                
                $decreasedIds= $inventoryService->getDecreasedId();
                
                
                foreach ($decreasedIds as $key => $inventoryDecreased)
                {
                    if($inventoryDecreased->item==$item["id"]) {
                        $singleItem = new SaleItem();
                        $singleItem->fill([
                            "sale" => $sale->id,
                            "qty"=>$inventoryDecreased->decreased,
                            "item" => $item["id"],
                            "inventory" => $inventoryDecreased->id,
                            "sale_price" => $item["public_price"],
                            "unit_price" => $item["unit_price"],
                            "final_price" => $inventoryDecreased->decreased * $item["unit_price"],
                        ]);
                        
                        $items[] = $singleItem->toArray();
                    }
                }
                $inventoryService->resetDecreased();
                    
            }
        }
        $inserted =( $decreased && count($items) > 0 )&& $this->saleItemsModel->insertBatch($items);
        return $inserted && $decreased ?
            $this->saleItemsModel
                ->where(["sale"=>$sale->id])
                ->findAll() :
           false;
    }
    
    public function getSaleItems(Sale $sale): ?array
    {
        return $this->saleItemsModel->where(["sale"=>$sale->id])->findAll();
    }
}




