saleBlock();
console.log('Sales JS loaded');
const saleForm = $("#sale-form");
const saleBtn =  $("#saleBtn");
const articles = $('#allArticles');
const cashback = $("#cashback");
const moneyReceived = $("#cashreceived")
const ticketNumber = $("#ticketNumber");
let articlesName;
let indexedArticles;
let articlesLoaded = false;
let customers;
const customerSelector = $("#allCustomers");
let customersLoaded  = false;
let itemsOrder = 1 ;
let inventoryLoaded = false;
let itemsQty = 0;
const discountValue = $('#discountValue')
const totalToSale =  $('#total');
let paymentType = $("#paymentMethod");
let paymentComplete = false;
const saleType = $("#saleType");
let publicPrice = 0;
let subtotal = 0;
let saleStock= [];
let sale = {
    store:store.id ,
    customer : $("#customerId").val(),
    payment_type :paymentType.val(),
    type: 'cash',
    payment : []
}

let cart = {};
let payments = [];
const toPay = $("#topay");
const inputPayment = $(".payment");

$(function (e) {

    // handleBootstrapSelectEvents();

    //AJAX FOR ARTICLES

    saleForm.on("submit", function (e) {
        return false;
    });

    fillArticles();
    fillCustomers();
    getGeneralInventory()

    articles.on(
        'select2:select',
        function(event) {
            clearInput()
            let itemID = event.params.data.id
            let included = cart.hasOwnProperty(itemID);
            let stock = getStock(itemID);

            if (!stock || stock.stock == 0) {
                toastAlert("error","Artículo sin inventario","Favor de verificar ")

                return false
            }

            //Creation of li item in sale list
            if(included) {
                toastAlert("error","En carrito","El artículo ya fue agregado");

            }
            $("#itemsList").prepend(getArticleCard(indexedArticles[itemID],stock));
            cart[itemID] = indexedArticles[itemID];
            cart[itemID].qty = 1;
            cart[itemID].unit_price = parseFloat(indexedArticles[itemID].public_price);
            cart[itemID].final_price = cart[itemID].unit_price

            updateSubtotal(cart);
            itemsOrder++;
            increaseItemsQty();
            moneyReceived.trigger("keyup");
            calculateTotal();
        });

    moneyReceived
        .on("keyup",calculateCashback)
        .on("dblclick",clearPayment);

    saleBtn.on("click",checkoutCart);

    //Ticker number for card method payment
    paymentType.on("change",function(e) {
        // hide todos
        // show por clase.
        clearPayment();
        inputPayment.addClass("d-none");
        $("."+this.value).removeClass("d-none");
        // sale.setPaymentType(this.value);
        toggleSaleBtn();
    });
    
    ticketNumber.on("keyup",function(){
        this.value.length >3 ?toggleSaleBtn():''
    })
    
    saleType.on('change', function (e) {
        sale.type=this.value;
        if (this.value === 'cash'){
            resetPayments();
            $('#deposit').addClass('d-none').val(null);
            calculatePayment();
            toggleSaleBtn();

        }else {
            $('#deposit').removeClass('d-none');

        }
    });

    $('#deposit').on("change", function(){
        sale.payment.partial = this.value;
        updateToPay()
    })

    //Quick Save client
    $(" #customerFormSidebar" ).on("submit",function(e){
        e.preventDefault();
        customersLoaded = false;
        let customerData = $(this).serializeArray();

        $.ajax({
            method: "POST",
            url: "/customer",
            dataType: "JSON",
            data: customerData,
        }).done(function(client){
            if(client.id != null){
                toastAlert('success','Cliente registrado','El cliente se guardo exitosamente');
                $('#customerFormSidebar')[0].reset();
                $('#userAddress').text(`${client.address}`);
                $('#shipmentSection').removeClass('d-none');

                fillCustomers()
            }else{
                toastAlert('error','Error','Ocurrió un problema al guardar');
            }
        });
    });

    customerSelector.on('select2:select', function(event) {
        let customerId = event.params.data.id;
        sale.customer = customerId
    });

});
// on document loaded.
function resetPayments()
{
    payments = [];
    $("#payments").html(null);
    updateToPay();
}

function clearInput()
{
    articles.select2().val(null).trigger("change");
}

function removeItemFromCart(item)
{
    $( "#"+item.id).fadeOut( "slow");
    Reflect.deleteProperty(cart,item.id)

    if(paymentType.val()==="cash")
    {
        clearPayment();
    }


    decreaseItemsQty();
    updateSubtotal(cart)
    calculateTotal()
}

function getArticleCard(item,stock)
{

    //let stock = getStock(item.id);
    let identifier = item.id+"-"+itemsOrder;
    publicPrice = item.public_price;
    var stockBadge;
    if (!stock || stock.stock == 0) {

        inputValue = 0;
        stockBadge = `<span class="badge bg-label-danger rounded-pill" id>No disponible</span>`
        disableRadius = 'disabled';
        return false
    } else {
        stockBadge = `<span class="badge bg-label-success rounded-pill" id>En almacén</span>`
    }

    return `
                <li id="${item.id}" class="list-group-item p-3 article-item">
                    <div class="d-flex gap-3">
                        <div class="flex-grow-1">
                            <div class="row">
                                <div class="col-md-8">
                                    <h6 class="me-3">
                                        <span class="text-heading">
                                            ${item.id} - ${item.name}
                                            ${stockBadge}
                                        </span>
                                    </h6>
                                    <div class="mb-1 d-flex flex-column flex-wrap">
                                        <div class="flex-row">
                                            <span class="me-1 small">Vendido por:</span>
                                            <span class="me-1 small">${user.name}  ${user.last_name}</span>
                                        </div>
                                        <div class="flex-row">
                                            <span class="me-1 small">Disponible:</span>
                                            <span class="me-1 small" id="stock-${identifier}" >${stock.stock-1}</spa>
                                        </div>
                                        <div class="d-flex flex-row col-4 align-items-center">
                                            <span class="small">Unidades:</span>
                                            <input
                                                id="input-${identifier}"
                                                type="number"
                                                onchange="updateQty(${item.id},this,${stock.stock},'stock-${identifier}')"
                                                class="form-control form-control-sm mt-4 "
                                                value="1"
                                                min="1"
                                                max="${stock.stock}"

                                                />
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="text-md-end">
                                        <button onclick='removeItemFromCart(${JSON.stringify(item)})' type="button" class="btn-close btn-pinned" aria-label="Close"></button>
                                    </div>
                                </div>
                            </div>
                            <div class="row gy-3">
                            <div class="col-md">
                              <div class="form-check custom-option custom-option-icon">
                                <label class="form-check-label custom-option-content" for="customRadioIcon1">
                                  <span class="custom-option-body">
                                    <span class="custom-option-title"> Precio al público </span>
                                    <small>$${new Intl.NumberFormat().format(item.public_price)} </small>
                                  </span>
                                  <input
                                    name="customDeliveryRadioIcon${itemsOrder}"
                                    class="form-check-input"
                                    type="radio"
                                    value="${item.public_price}"
                                    data-cartIndex ='${item.id}'
                                    onchange="updateFinalPrice(this)"
                                    checked />
                                </label>
                              </div>
                            </div>
                            <div class="col-md">
                              <div class="form-check custom-option custom-option-icon">
                                <label class="form-check-label custom-option-content" for="customRadioIcon2">
                                  <span class="custom-option-body">
                                    <span class="custom-option-title"> Precio con descuento </span>
                                    <small>$${new Intl.NumberFormat().format(item.wholesale_price)}</small>
                                  </span>
                                  <input
                                  data-cartIndex ='${item.id}'
                                    name="customDeliveryRadioIcon${itemsOrder}"
                                    class="form-check-input"
                                    type="radio"
                                    value="${item.wholesale_price}"
                                     onchange="updateFinalPrice(this)"
                                     />
                                </label>
                              </div>
                            </div>
                            <div class="col-md">
                              <div class="form-check custom-option custom-option-icon">
                                <label class="form-check-label custom-option-content" for="customRadioIcon3">
                                  <span class="custom-option-body">
                                    <span class="custom-option-title"> Precio especial </span>
                                    <small>$${new Intl.NumberFormat().format(item.special_price)} </small>
                                  </span>
                                  <input
                                  data-cartIndex ='${item.id}'
                                    name="customDeliveryRadioIcon${itemsOrder}"
                                    class="form-check-input"
                                    type="radio"
                                    value="${item.special_price}"
                                     onchange="updateFinalPrice(this)"
                                     />
                                </label>
                              </div>
                            </div>
                          </div>
                        </div>
                    </div>
                </li>
            `
}

function getStock(item)
{
    return undefined === storeStock[item] ? false:storeStock[item];
}

function updateQty(itemId,input,stock,selectorId)
{
    let intQty =  parseInt(input.value);
    if(stock<intQty){
        toastAlert("error","Fuera de stock", `Cantidad máxima  ${stock}.`);
        input.value= stock
        $("#"+selectorId).text(0);
        cart[itemId].qty = stock;

    }else{

        let currentQty =  stock -intQty;
        $("#"+selectorId).text(currentQty);
        cart[itemId].qty = intQty;


    }


    updateFinalPrice(itemId)
    updateSubtotal(cart)
    calculateTotal();
}

function increaseItemsQty()
{
    itemsQty++;
    updateItemsQty();
}

function updateItemsQty()
{

    $("#items-qty").text(itemsQty);
    sale.items= itemsQty;
}

function decreaseItemsQty()
{
    itemsQty--;
    $("#items-qty").text(itemsQty);
    sale.items = itemsQty;
}

function calculateTotal(displayAlert = false)
{
    let finalPrice = 0;
    if(undefined=== discountValue.val())
    {
        finalPrice =  parseFloat( subtotal).toFixed(2);
    }else {
        discountAmount = parseFloat(discountValue.val());
        sale.discount = discountAmount;
        if (displayAlert){
            $('#discountAlert').removeClass('d-none');
            setTimeout(function(){
                $('#discountAlert').addClass('d-none');
            }, 1000);
            $('#discount').text(formatMoney(discountAmount));
        }
        finalPrice =parseFloat(( subtotal- discountAmount).toFixed(2));

    }

    sale.amount = finalPrice;
    moneyReceived.trigger("keyup");
    updateToPay();
    updateTotal(formatMoney(parseFloat(finalPrice).toFixed(2)));
    toggleSaleBtn()

}

function updateTotal(total)
{
    totalToSale.text(total);
    if(total ==="0")
    {
        moneyReceived.val(null);
        cashback.val(null);
    }
}

function splitPayment()
{
    let type = paymentType.val();
    let amount = moneyReceived.val();
    if(amount === '')
    {
        return ;
    }
    let select = paymentType[0].options;

    if(type === "cash"){

        let payment = {
            type : type,
            received : amount,
            amount: $("#cashToPay").val(),
            cashback:cashback.val()
        };
        payments.push(payment);

        $("#payments").append(`
     <dt class="col-6 fw-normal text-heading">${select[select.selectedIndex].text}</dt>
        <dd></dd>
     <dt class="col-6 fw-normal text-heading">Paga</dt>
         <dd class="col-6 text-end">$<span id="">${payment.amount}</span> M.N.</dd>
<dt class="col-6 fw-normal text-heading">Recibido</dt>
         <dd class="col-6 text-end">$<span id="subtotal">${payment.received}</span> M.N.</dd>
         <dt class="col-6 fw-normal text-heading">Cambio</dt>
         <dd class="col-6 text-end">
             $<span id="subtotal">${payment.cashback}</span> M.N.</dd>`);

    }else{
        payments.push({
            type : type,
            amount: amount,
            aut: ticketNumber.val(),
        });
        $("#payments").append(`
     <dt class="col-6 fw-normal text-heading">${select[select.selectedIndex].text}</dt>
         <dd class="col-6 text-end">
             $<span id="subtotal">${amount}</span> M.N.</dd>`);
    }

    $("#cashreceived,#cashback,#cashToPay").val(null);

    updateToPay();
    toggleSaleBtn();
}

function calculatePayment()
{

    let total = paid();

    paymentComplete =isAside()?total==$("#deposit").val():( total== sale.amount);
    if((isAside() && total>$("#deposit").val()) || ( total>sale.amount)){
        toastAlert("warning","Monto excedido", "No puedes recibir un monto mayor al costo")
    }
    sale.payment_type = payments.length>1?'multi':paymentType.val();

}

function paid()
{
    let total = 0 ;
    payments.forEach(payment=>total+=parseFloat(payment.amount));
    return total;

}


function checkoutCart()
{
    if (payments.length ===0 || !paymentComplete){
        toastAlert("error","No hay pagos", "Aplica un pago para continuar");
        return false;
    }
    saleBlock();
    sale.delivery = $("#shipment").prop("checked")?'pending':'store';


if(saleType.val()!=="cash" && sale.customer == 1 )
    {
        $.unblockUI();
        toastAlert('error','Error','Registre o seleccione un cliente para venta a crédito.');
        return false;
    }

    // if(saleType.val() !=="cash")
    // {
    //     sale.payment.received =$("#deposit").val();
    // }
    let withCard =  payments.find(({type})=> type ==='card');


    let voucher = (withCard!== undefined && withCard.type ==='card')? withCard.aut :null;


    if(null !== voucher && voucher === "")
    {
        toggleSaleBtn();
        $.unblockUI();
        return false
    }

    sale.comments= '';

    sale.cart = cart;
    sale.payments = payments;

    $.ajax({
        "method" : "POST",
        "url":"/sale",
        "data":sale,
        dataType:"JSON",
        statusCode : {
            500 : serverError,
            400 :saleBadRequest,
            403 :forbiddenSale,
        }
    }).done(function(sale){
        if (sale.sale.id){
            $.unblockUI();
            toastAlert('success','Venta registrada','En breve se recargará la página');
            window.open("/ticket/"+sale.sale.uuid,"_blank").print();
            location.reload();
        }else {
            $.unblockUI();
            toastAlert('error','Error','Ocurrió un problema, por favor, intenta nuevamente');
        }

    })

}

function serverError(xhr)
{
        $.unblockUI();
        toastAlert('error','Error','Ocurrió un problema, por favor intenta nuevamente');
}
function saleBadRequest(xhr)
{
    $.unblockUI();
    toastAlert('error','Error','Ocurrió un problema, por favor intenta nuevamente');
}

function forbiddenSale(xhr)
{
    console.log(xhr)
    location.href = '/login'
}

function fillArticles()
{
    $.ajax({
        method: 'GET',
        url: '/article',
        dataType: 'JSON'
    }).done(function(articles){
        articlesName = articles.map(article => {
            return {
                "id":article.id,
                "text": article.id+'-'+article.name
            }
        });
        indexedArticles  = articles.reduce((acc,article ) => {
            acc[article.id]  = article
            return acc
        },[]);
    }).then(function (resultado) {
        //LIVESEARCH
        articles.select2({
            placeholder: 'Seleccione un artículo',
            data: articlesName,
            allowClear:false,
        });
        articlesLoaded =true;
        finishLoading();
    });
}

function fillCustomers()
{
    let flatCustomers;
    $.ajax({
        method: 'GET',
        url: '/customer',
        dataType: 'JSON'
    }).done(function(customers){
        flatCustomers = customers.map(customer => {
            return {
                id: customer.id,
                text: customer.name + " " + customer.last_name,
                selected : customer.id==="1"
            }
        });
        customerSelector.select2({
            placeholder: 'Cliente',
            data: flatCustomers,
            allowClear:false
        });

        customersLoaded =true;
        finishLoading();

    });
}

$('#allCustomers').on('select2:select', function (e) {
    var data = e.params.data;
    if (data.id==='1'){
        $('#userInfoCard').addClass('d-none');
        $('#shipmentSection').addClass('d-none');
    }else {
        customerDetail(data.id);
    }
});

function customerDetail(id)
{
    $.ajax({
        method: 'GET',
        url: '/customer/'+id,
        dataType: 'JSON'
    }).done(function(user){
        $('#allCustomers').val('').trigger('change');
        $('#userName').text(user.name + ' ' + user.last_name);
        $('#userAddress').text(user.address);
        $('#userInfoCard').removeClass('d-none');
        $('#shipmentSection').removeClass('d-none');
    })
}

function updateFinalPrice(element)
{

    if( typeof(element) === "object")
    {
        let key =element.dataset.cartindex
        cart[key].final_price = parseFloat( element.value) * cart[key].qty;
        cart[key].unit_price = parseFloat(element.value)
    }else{
        let actualPrice = parseFloat( $("input[data-cartindex="+element+"]:checked").val());
        cart[element].final_price = parseFloat( actualPrice * cart[element].qty);
        cart[element].unit_price = parseFloat(actualPrice)

    }

    updateSubtotal(cart);
    calculateTotal();
}

function updateSubtotal(cart)
{
    const initialValue = 0;
    subtotal = Object.values(cart).reduce(
        (accumulator, item) =>

            (accumulator + item.final_price)
        , initialValue
    );
    $('#subtotal').text(formatMoney(subtotal));
}

let storeStock;

function getGeneralInventory()
{
    $.ajax({
        method:"GET",
        url :"/stock/store/"+store.id,
        dataType : "JSON"
    }).done(function(response){
        storeStock = response.reduce((acumulated,inventory ) => {
            acumulated[inventory.item]  = inventory
            return acumulated
        },[])
        inventoryLoaded = true;
        finishLoading();
    })

}

function toggleSaleBtn()
{
    let enable = Object.keys(cart).length >0;
    calculatePayment();
    enable = enable && paymentComplete;


    if(enable) {
        saleBtn.prop('disabled', false);
    }else {
        saleBtn.prop('disabled', true);
    }
}

function calculateCashback(e=null)
{
    if(paymentType.val() != "cash")
    {
        return ;
    }
    if(null === e || isNaN(e.currentTarget.value) )
    {
        e.currentTarget.value = '';
        return false
    }
    let received = parseFloat(e.currentTarget.value);
    let cashBack = received - $('#cashToPay').val() ;
    $("#cashback").val(Number.isInteger(cashBack)?cashBack:0);

    toggleSaleBtn();
}

function isAside() {
    let cash = saleType.val() === 'cash';
    return !cash;
}


function clearPayment(){
    ticketNumber.val(null);
    moneyReceived.val(null);
    cashback.val(null);
}

function finishLoading()
{
    articlesLoaded && customersLoaded && inventoryLoaded ? $.unblockUI():false;
}

function updateToPay()
{
    let saleType = sale.type;
    let text = '';
    if(saleType == 'cash'){

        text = paymentComplete?0:sale.amount-paid();
    }else{
        text = paymentComplete?0:sale.payment.partial-paid();
    }

    toPay.text(text);

}

