<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\ClientModel;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\API\ResponseTrait;
use CodeIgniter\I18n\Time;

class Client extends BaseController
{
    use ResponseTrait;
    protected ClientModel $clientModel;

    public function __construct()
    {
        $this->clientModel = new \App\Models\ClientModel();
    }

    public function index(): ResponseInterface
    {
        return $this->respond($this->clientModel->findAll());
    }

    public function show($id): ResponseInterface
    {
        return $this->response->setJSON($this->clientModel->find($id));
    }

    public function create(): ResponseInterface
    {
        $client = new \App\Entities\Client($this->request->getPost());

        try {
            $inserted = $this->clientModel->save($client);
        }catch (\ReflectionException $e) {
            return $this->response->fail($e->getMessage());
        }
        return $inserted ? $this->response->setJSON($this->clientModel->find($this->clientModel->getInsertID()))
            : $this->response->fail($e->getMessage(), ResponseInterface::HTTP_INTERNAL_SERVER_ERROR);
    }

    public function update($id)
    {
        $client = $this->clientModel->find($id);
        $client->fill($this->request->getRawInput());
        $client->updated_at = Time::now();
        //$client->updated_by = $session->get('id');
        try{
            $updated = $this->clientModel->save($client);
        }catch (\ReflectionException $e) {
            return $this->response->fail($e->getMessage(), ResponseInterface::HTTP_INTERNAL_SERVER_ERROR);
        }

        return $updated ? $this->response->setJSON(['message' => 'Registro actualizado correctamente'])
            : $this->response->fail($e->getMessage(), ResponseInterface::HTTP_INTERNAL_SERVER_ERROR);
    }

    public function delete($id): ResponseInterface
    {
        try {
            $deleted = $this->clientModel->delete($id);
        }catch (\ReflectionException $e) {
            return $this->response->fail($e->getMessage());
        }
        return $deleted ? $this->response->setJSON(['message' => 'Registro eliminado correctamente'])
            : $this->response->fail($e->getMessage(), ResponseInterface::HTTP_INTERNAL_SERVER_ERROR);
    }
}
