<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\PaymentModel;
use CodeIgniter\API\ResponseTrait;
use CodeIgniter\HTTP\ResponseInterface;

class Payment extends BaseController
{
    use ResponseTrait;
    protected PaymentModel $paymentModel;

    public function __construct()
    {
        $this->paymentModel = new \App\Models\PaymentModel();
    }

    public function index()
    {
        return $this->respond($this->paymentModel->findAll());
    }

    public function show($id): ResponseInterface
    {
        return $this->response->setJSON($this->paymentModel->find($id));
    }

    public function create(): ResponseInterface
    {
        $payment = new \App\Entities\Payment($this->request->getPost());

        try {
            $inserted = $this->paymentModel->save($payment);
        }catch (\ReflectionException $e) {
            return $this->fail($e->getMessage());
        }
        return $inserted ? $this->response->setJSON($this->paymentModel->find($this->paymentModel->getInsertID()))
            : $this->fail($e->getMessage(), ResponseInterface::HTTP_INTERNAL_SERVER_ERROR);
    }

    public function delete($id): ResponseInterface
    {
        try {
            $deleted = $this->paymentModel->delete($id);
        }catch (\ReflectionException $e) {
            return $this->fail($e->getMessage());
        }
        return $deleted ? $this->response->setJSON(['message' => 'Registro eliminado correctamente'])
            : $this->fail($e->getMessage(), ResponseInterface::HTTP_INTERNAL_SERVER_ERROR);
    }
}
