<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;
use CodeIgniter\Database\RawSql;

class AddSaleTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'order_date' => [
                'type'       => 'DATE',
            ],
            'client' => [
                'type'       => 'INT',
                'unsigned' => true,
            ],
            'block' => [
                'type'       => 'INT',
                'unsigned' => true,
            ],
            'lot' => [
                'type'       => 'INT',
                'unsigned' => true,
            ],
            'amount' => [
                'type'       => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'front_payment' => [
                'type'       => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'pending' => [
                'type'       => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'sale_type' => [
                'type'       => 'VARCHAR',
                'constraint' => '25',
            ],
            'payment_method' => [
                'type'       => 'VARCHAR',
                'constraint' => '25',
            ],
            'order_status' => [
                'type'       => 'VARCHAR',
                'constraint' => '25',
            ],
            'created_at'=>[
                'type'=>'DATETIME',
                'default'=>new RawSql('CURRENT_TIMESTAMP')
            ],
            'created_by'=>[
                'type'=>'INT',
                'unsigned'=>true,
            ],
            'updated_at'=>[
                'type'=>'datetime',
                'null'=>true
            ],
            'updated_by'=>[
                'type'=>'INT',
                'unsigned'=>true,
            ],
            'deleted_at'=>[
                'type'=>'datetime',
                'null'=>true
            ],
            'deleted_by'=>[
                'type'=>'INT',
                'unsigned'=>true,
            ]
        ]);
        $this->forge->addKey('id', true);
        $this->forge->addForeignKey('client', 'clients', 'id', 'CASCADE', 'RESTRICT');
        $this->forge->createTable('sales');
    }

    public function down()
    {
        $this->forge->dropTable('sales');
    }
}
