<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Blog')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Apps', 'title' => 'Blog')) ?>

                    <div class="row" data-masonry='{"percentPosition": true }'>
                        <div class="col-xl-3 col-md-6">
                            <article class="card rounded-3">
                                <!-- Card Body -->
                                <div class="card-body">
                                    <!-- Badge -->
                                    <div class="badge text-bg-dark badge-label mb-3">Design</div>
                                    <!-- Title -->
                                    <h6 class="card-title fs-lg lh-base mb-2">
                                        <a class="link-reset" href="/apps-blog-article">Mastering Figma: 7 Pro Tips for Better UI Design</a>
                                    </h6>
                                    <p class="mb-3 text-muted">Unlock advanced techniques in Figma that can speed up your workflow and help you create pixel-perfect designs every time.</p>
                                    <div>
                                        <a class="badge badge-label badge-default" href="#!">Figma</a>
                                        <a class="badge badge-label badge-default" href="#!">UX</a>
                                        <a class="badge badge-label badge-default" href="#!">Tips</a>
                                    </div>
                                    <p class="d-flex flex-wrap gap-3 text-muted mb-0 mt-3 align-items-center fs-base">
                                        <span class="d-flex align-items-center gap-1">
                                            <i class="ti ti-calendar fs-md"></i>
                                            Jan 20, 2025
                                        </span>
                                        <span class="d-flex align-items-center gap-1">
                                            <i class="ti ti-message-circle fs-md"></i>
                                            <a class="link-reset" href="#!">23</a>
                                        </span>
                                        <span class="d-flex align-items-center gap-1">
                                            <i class="ti ti-eye fs-md"></i>
                                            3,842
                                        </span>
                                    </p>
                                </div>
                                <!-- Card footer -->
                                <div class="card-footer bg-transparent d-flex justify-content-between">
                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                        <div class="avatar avatar-xs">
                                            <img alt="avatar-6" class="img-fluid rounded-circle" src="/images/users/user-6.jpg" />
                                        </div>
                                        <div>
                                            <h5 class="text-nowrap fs-sm mb-0 lh-base">
                                                <a class="link-reset" href="#!">Emma Blake</a>
                                            </h5>
                                        </div>
                                    </div>
                                    <a class="link-primary fw-semibold d-flex align-items-center gap-1" href="/apps-blog-article">
                                        Read more
                                        <i class="ti ti-arrow-right"></i>
                                    </a>
                                </div>
                            </article>
                        </div>
                        <div class="col-xl-3 col-md-6">
                            <article class="card rounded-3">
                                <!-- Badge -->
                                <div class="badge text-bg-dark badge-label position-absolute top-0 start-0 m-3">Development</div>
                                <!-- Card image -->
                                <img alt="Building APIs" class="card-img-top rounded-top-3" src="/images/blog/blog-1.jpg" />
                                <!-- Card Body -->
                                <div class="card-body">
                                    <!-- Title -->
                                    <h6 class="card-title fs-lg lh-base mb-2">
                                        <a class="link-reset" href="/apps-blog-article">Building REST APIs with Node.js</a>
                                    </h6>
                                    <p class="mb-3 text-muted">Learn how to design and build scalable REST APIs with Node.js and Express in this step-by-step tutorial.</p>
                                    <div>
                                        <a class="badge badge-label badge-default" href="#!">Node.js</a>
                                        <a class="badge badge-label badge-default" href="#!">API</a>
                                        <a class="badge badge-label badge-default" href="#!">Tutorial</a>
                                    </div>
                                    <p class="d-flex flex-wrap gap-3 text-muted mb-0 mt-3 align-items-center fs-base">
                                        <span class="d-flex align-items-center gap-1">
                                            <i class="ti ti-calendar fs-md"></i>
                                            Feb 2, 2025
                                        </span>
                                        <span class="d-flex align-items-center gap-1">
                                            <i class="ti ti-message-circle fs-md"></i>
                                            <a class="link-reset" href="#!">16</a>
                                        </span>
                                        <span class="d-flex align-items-center gap-1">
                                            <i class="ti ti-eye fs-md"></i>
                                            8,974
                                        </span>
                                    </p>
                                </div>
                                <!-- Card footer -->
                                <div class="card-footer bg-transparent d-flex justify-content-between">
                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                        <div class="avatar avatar-xs">
                                            <img alt="avatar-3" class="img-fluid rounded-circle" src="/images/users/user-3.jpg" />
                                        </div>
                                        <div>
                                            <h5 class="text-nowrap fs-sm mb-0 lh-base">
                                                <a class="link-reset" href="#!">John Doe</a>
                                            </h5>
                                        </div>
                                    </div>
                                    <a class="link-primary fw-semibold d-flex align-items-center gap-1" href="/apps-blog-article">
                                        Read more
                                        <i class="ti ti-arrow-right"></i>
                                    </a>
                                </div>
                            </article>
                        </div>
                        <!-- end col-->
                        <div class="col-xl-3 col-md-6">
                            <article class="card rounded-3">
                                <!-- Badge -->
                                <div class="badge text-bg-dark badge-label position-absolute top-0 start-0 m-3">Marketing</div>
                                <!-- Card image -->
                                <img alt="SEO Strategies" class="card-img-top rounded-top-3" src="/images/blog/blog-2.jpg" />
                                <!-- Card Body -->
                                <div class="card-body">
                                    <!-- Title -->
                                    <h6 class="card-title fs-lg lh-base mb-2">
                                        <a class="link-reset" href="/apps-blog-article">SEO Strategies for 2025: How to Rank Higher</a>
                                    </h6>
                                    <p class="mb-3 text-muted">Boost your website's search engine ranking with these proven SEO techniques for 2025.</p>
                                    <div>
                                        <a class="badge badge-label badge-default" href="#!">SEO</a>
                                        <a class="badge badge-label badge-default" href="#!">Marketing</a>
                                        <a class="badge badge-label badge-default" href="#!">Growth</a>
                                    </div>
                                    <p class="d-flex flex-wrap gap-3 text-muted mb-0 mt-3 align-items-center fs-base">
                                        <span class="d-flex align-items-center gap-1">
                                            <i class="ti ti-calendar fs-md"></i>
                                            Feb 14, 2025
                                        </span>
                                        <span class="d-flex align-items-center gap-1">
                                            <i class="ti ti-message-circle fs-md"></i>
                                            <a class="link-reset" href="#!">22</a>
                                        </span>
                                        <span class="d-flex align-items-center gap-1">
                                            <i class="ti ti-eye fs-md"></i>
                                            3,090
                                        </span>
                                    </p>
                                </div>
                                <!-- Card footer -->
                                <div class="card-footer bg-transparent d-flex justify-content-between">
                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                        <div class="avatar avatar-xs">
                                            <img alt="avatar-2" class="img-fluid rounded-circle" src="/images/users/user-2.jpg" />
                                        </div>
                                        <div>
                                            <h5 class="text-nowrap fs-sm mb-0 lh-base">
                                                <a class="link-reset" href="#!">Sophie Green</a>
                                            </h5>
                                        </div>
                                    </div>
                                    <a class="link-primary fw-semibold d-flex align-items-center gap-1" href="/apps-blog-article">
                                        Read more
                                        <i class="ti ti-arrow-right"></i>
                                    </a>
                                </div>
                            </article>
                        </div>
                        <!-- end col-->
                        <div class="col-xl-3 col-md-6">
                            <article class="card rounded-3">
                                <!-- Card Body -->
                                <div class="card-body">
                                    <!-- Badge -->
                                    <div class="badge text-bg-dark badge-label mb-3">Design</div>
                                    <!-- Title -->
                                    <h6 class="card-title fs-lg lh-base mb-2">
                                        <a class="link-reset" href="/apps-blog-article">Web Design Trends to Watch in 2025</a>
                                    </h6>
                                    <p class="mb-3 text-muted">Explore the top web design trends that will shape the user experience in 2025.</p>
                                    <div>
                                        <a class="badge badge-label badge-default" href="#!">Web Design</a>
                                        <a class="badge badge-label badge-default" href="#!">UX/UI</a>
                                        <a class="badge badge-label badge-default" href="#!">Trends</a>
                                    </div>
                                    <p class="d-flex flex-wrap gap-3 text-muted mb-0 mt-3 align-items-center fs-base">
                                        <span class="d-flex align-items-center gap-1">
                                            <i class="ti ti-calendar fs-md"></i>
                                            Apr 16, 2025
                                        </span>
                                        <span class="d-flex align-items-center gap-1">
                                            <i class="ti ti-message-circle fs-md"></i>
                                            <a class="link-reset" href="#!">36</a>
                                        </span>
                                        <span class="d-flex align-items-center gap-1">
                                            <i class="ti ti-eye fs-md"></i>
                                            1,102
                                        </span>
                                    </p>
                                </div>
                                <!-- Card footer -->
                                <div class="card-footer bg-transparent d-flex justify-content-between">
                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                        <div class="avatar avatar-xs">
                                            <img alt="avatar-5" class="img-fluid rounded-circle" src="/images/users/user-5.jpg" />
                                        </div>
                                        <div>
                                            <h5 class="text-nowrap fs-sm mb-0 lh-base">
                                                <a class="link-reset" href="#!">Anna White</a>
                                            </h5>
                                        </div>
                                    </div>
                                    <a class="link-primary fw-semibold d-flex align-items-center gap-1" href="/apps-blog-article">
                                        Read more
                                        <i class="ti ti-arrow-right"></i>
                                    </a>
                                </div>
                            </article>
                        </div>
                        <!-- end col-->
                        <div class="col-xl-3 col-md-6">
                            <article class="card rounded-3">
                                <!-- Badge -->
                                <div class="badge text-bg-dark badge-label position-absolute top-0 start-0 m-3">Business</div>
                                <!-- Card image -->
                                <img alt="Entrepreneur Tips" class="card-img-top rounded-top-3" src="/images/blog/blog-3.jpg" />
                                <!-- Card Body -->
                                <div class="card-body">
                                    <!-- Title -->
                                    <h6 class="card-title fs-lg lh-base mb-2">
                                        <a class="link-reset" href="/apps-blog-article">5 Key Tips for New Entrepreneurs</a>
                                    </h6>
                                    <p class="mb-3 text-muted">Start your entrepreneurial journey with these 5 essential tips that will guide you through the first year of business.</p>
                                    <div>
                                        <a class="badge badge-label badge-default" href="#!">Business</a>
                                        <a class="badge badge-label badge-default" href="#!">Entrepreneur</a>
                                        <a class="badge badge-label badge-default" href="#!">Startup</a>
                                    </div>
                                    <p class="d-flex flex-wrap gap-3 text-muted mb-0 mt-3 align-items-center fs-base">
                                        <span class="d-flex align-items-center gap-1">
                                            <i class="ti ti-calendar fs-md"></i>
                                            May 10, 2025
                                        </span>
                                        <span class="d-flex align-items-center gap-1">
                                            <i class="ti ti-message-circle fs-md"></i>
                                            <a class="link-reset" href="#!">88</a>
                                        </span>
                                        <span class="d-flex align-items-center gap-1">
                                            <i class="ti ti-eye fs-md"></i>
                                            15,842
                                        </span>
                                    </p>
                                </div>
                                <!-- Card footer -->
                                <div class="card-footer bg-transparent d-flex justify-content-between">
                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                        <div class="avatar avatar-xs">
                                            <img alt="avatar-7" class="img-fluid rounded-circle" src="/images/users/user-7.jpg" />
                                        </div>
                                        <div>
                                            <h5 class="text-nowrap fs-sm mb-0 lh-base">
                                                <a class="link-reset" href="#!">David Clark</a>
                                            </h5>
                                        </div>
                                    </div>
                                    <a class="link-primary fw-semibold d-flex align-items-center gap-1" href="/apps-blog-article">
                                        Read more
                                        <i class="ti ti-arrow-right"></i>
                                    </a>
                                </div>
                            </article>
                        </div>
                        <!-- end col-->
                        <div class="col-xl-3 col-md-6">
                            <article class="card rounded-3">
                                <!-- Badge -->
                                <div class="badge text-bg-dark badge-label position-absolute top-0 start-0 m-3">Technology</div>
                                <!-- Card image -->
                                <img alt="Tech Innovations" class="card-img-top rounded-top-3" src="/images/blog/blog-4.jpg" />
                                <!-- Card Body -->
                                <div class="card-body">
                                    <!-- Title -->
                                    <h6 class="card-title fs-lg lh-base mb-2">
                                        <a class="link-reset" href="/apps-blog-article">The Future of Artificial Intelligence</a>
                                    </h6>
                                    <p class="mb-3 text-muted">Discover how AI is transforming industries and what the future holds for this cutting-edge technology.</p>
                                    <div>
                                        <a class="badge badge-label badge-default" href="#!">AI</a>
                                        <a class="badge badge-label badge-default" href="#!">Technology</a>
                                        <a class="badge badge-label badge-default" href="#!">Innovation</a>
                                    </div>
                                    <p class="d-flex flex-wrap gap-3 text-muted mb-0 mt-3 align-items-center fs-base">
                                        <span class="d-flex align-items-center gap-1">
                                            <i class="ti ti-calendar fs-md"></i>
                                            May 28, 2025
                                        </span>
                                        <span class="d-flex align-items-center gap-1">
                                            <i class="ti ti-message-circle fs-md"></i>
                                            <a class="link-reset" href="#!">89</a>
                                        </span>
                                        <span class="d-flex align-items-center gap-1">
                                            <i class="ti ti-eye fs-md"></i>
                                            8,654
                                        </span>
                                    </p>
                                </div>
                                <!-- Card footer -->
                                <div class="card-footer bg-transparent d-flex justify-content-between">
                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                        <div class="avatar avatar-xs">
                                            <img alt="avatar-4" class="img-fluid rounded-circle" src="/images/users/user-4.jpg" />
                                        </div>
                                        <div>
                                            <h5 class="text-nowrap fs-sm mb-0 lh-base">
                                                <a class="link-reset" href="#!">Michael Turner</a>
                                            </h5>
                                        </div>
                                    </div>
                                    <a class="link-primary fw-semibold d-flex align-items-center gap-1" href="/apps-blog-article">
                                        Read more
                                        <i class="ti ti-arrow-right"></i>
                                    </a>
                                </div>
                            </article>
                        </div>
                        <!-- end col-->
                        <div class="col-xl-3 col-md-6">
                            <article class="card bg-primary bg-gradient rounded-3">
                                <!-- Card Body -->
                                <div class="card-body">
                                    <!-- Badge -->
                                    <div class="badge bg-white text-white bg-opacity-25 badge-label mb-3">Data Science</div>
                                    <!-- Title -->
                                    <h6 class="card-title fs-lg lh-base mb-2">
                                        <a class="text-white" href="/apps-blog-article">Top Data Science Trends in 2025</a>
                                    </h6>
                                    <p class="mb-3 text-white-50">Get ahead in the data science field with the latest trends, technologies, and tools that are reshaping the industry.</p>
                                    <div>
                                        <a class="badge badge-label border rounded border-white border-opacity-25" href="#!">Data Science</a>
                                        <a class="badge badge-label border rounded border-white border-opacity-25" href="#!">Trends</a>
                                        <a class="badge badge-label border rounded border-white border-opacity-25" href="#!">2025</a>
                                    </div>
                                    <p class="d-flex flex-wrap gap-3 text-white-50 mb-0 mt-3 align-items-center fs-base">
                                        <span class="d-flex align-items-center gap-1">
                                            <i class="ti ti-calendar fs-md"></i>
                                            Jun 05, 2025
                                        </span>
                                        <span class="d-flex align-items-center gap-1">
                                            <i class="ti ti-message-circle fs-md"></i>
                                            <a class="link-reset" href="#!">55</a>
                                        </span>
                                        <span class="d-flex align-items-center gap-1">
                                            <i class="ti ti-eye fs-md"></i>
                                            9,875
                                        </span>
                                    </p>
                                </div>
                                <!-- Card footer -->
                                <div class="card-footer bg-transparent d-flex justify-content-between border-light border-opacity-25">
                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                        <div class="avatar avatar-xs">
                                            <img alt="avatar-1" class="img-fluid rounded-circle" src="/images/users/user-1.jpg" />
                                        </div>
                                        <div>
                                            <h5 class="text-nowrap fs-sm mb-0 lh-base">
                                                <a class="text-white" href="#!">Olivia Brown</a>
                                            </h5>
                                        </div>
                                    </div>
                                    <a class="text-white fw-semibold d-flex align-items-center gap-1" href="/apps-blog-article">
                                        Read more
                                        <i class="ti ti-arrow-right"></i>
                                    </a>
                                </div>
                            </article>
                        </div>
                        <!-- end col-->
                        <div class="col-xl-3 col-md-6">
                            <article class="card rounded-3">
                                <!-- Badge -->
                                <div class="badge text-bg-dark badge-label position-absolute top-0 start-0 m-3">Data Science</div>
                                <!-- Card image -->
                                <img alt="Data Science Trends" class="card-img-top rounded-top-3" src="/images/blog/blog-5.jpg" />
                                <!-- Card Body -->
                                <div class="card-body">
                                    <!-- Title -->
                                    <h6 class="card-title fs-lg lh-base mb-2">
                                        <a class="link-reset" href="/apps-blog-article">Top Data Science Trends in 2025</a>
                                    </h6>
                                    <p class="mb-3 text-muted">Get ahead in the data science field with the latest trends, technologies, and tools that are reshaping the industry.</p>
                                    <div>
                                        <a class="badge badge-label badge-default" href="#!">Data Science</a>
                                        <a class="badge badge-label badge-default" href="#!">Trends</a>
                                        <a class="badge badge-label badge-default" href="#!">2025</a>
                                    </div>
                                    <p class="d-flex flex-wrap gap-3 text-muted mb-0 mt-3 align-items-center fs-base">
                                        <span class="d-flex align-items-center gap-1">
                                            <i class="ti ti-calendar fs-md"></i>
                                            Aug 17, 2025
                                        </span>
                                        <span class="d-flex align-items-center gap-1">
                                            <i class="ti ti-message-circle fs-md"></i>
                                            <a class="link-reset" href="#!">20</a>
                                        </span>
                                        <span class="d-flex align-items-center gap-1">
                                            <i class="ti ti-eye fs-md"></i>
                                            6,870
                                        </span>
                                    </p>
                                </div>
                                <!-- Card footer -->
                                <div class="card-footer bg-transparent d-flex justify-content-between">
                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                        <div class="avatar avatar-xs">
                                            <img alt="avatar-1" class="img-fluid rounded-circle" src="/images/users/user-1.jpg" />
                                        </div>
                                        <div>
                                            <h5 class="text-nowrap fs-sm mb-0 lh-base">
                                                <a class="link-reset" href="#!">Olivia Brown</a>
                                            </h5>
                                        </div>
                                    </div>
                                    <a class="link-primary fw-semibold d-flex align-items-center gap-1" href="/apps-blog-article">
                                        Read more
                                        <i class="ti ti-arrow-right"></i>
                                    </a>
                                </div>
                            </article>
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <script src="/plugins/masonry/masonry.pkgd.min.js"></script>
    </body>
</html>
