<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Companies')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Apps', 'title' => 'Companies')) ?>

                    <div class="row mb-3">
                        <div class="col-lg-12">
                            <form class="bg-light-subtle rounded border p-3">
                                <div class="row gap-3">
                                    <div class="col">
                                        <div class="row gap-3 justify-content-between">
                                            <div class="col-lg-4">
                                                <div class="app-search">
                                                    <input class="form-control" placeholder="Search company name..." type="text" />
                                                    <i class="ti ti-search app-search-icon text-muted"></i>
                                                </div>
                                            </div>
                                            <div class="col-auto">
                                                <div class="d-flex align-items-center gap-2">
                                                    <span class="me-2 fw-semibold">Filter By:</span>
                                                    <!-- Location Filter -->
                                                    <div class="app-search">
                                                        <select class="form-select form-control my-1 my-md-0">
                                                            <option selected="">Location</option>
                                                            <option value="USA">USA</option>
                                                            <option value="Canada">Canada</option>
                                                            <option value="Germany">Germany</option>
                                                            <option value="India">India</option>
                                                            <option value="UK">United Kingdom</option>
                                                        </select>
                                                        <i class="ti ti-map-pin app-search-icon text-muted"></i>
                                                    </div>
                                                    <!-- Category Filter -->
                                                    <div class="app-search">
                                                        <select class="form-select form-control my-1 my-md-0">
                                                            <option selected="">Category</option>
                                                            <option value="Tech">Tech</option>
                                                            <option value="Finance">Finance</option>
                                                            <option value="eCommerce">eCommerce</option>
                                                            <option value="Healthcare">Healthcare</option>
                                                            <option value="Automotive">Automotive</option>
                                                        </select>
                                                        <i class="ti ti-briefcase app-search-icon text-muted"></i>
                                                    </div>
                                                    <!-- Rating Filter -->
                                                    <div class="app-search">
                                                        <select class="form-select form-control my-1 my-md-0">
                                                            <option selected="">Rating</option>
                                                            <option value="5">5 Stars</option>
                                                            <option value="4">4 Stars &amp; Up</option>
                                                            <option value="3">3 Stars &amp; Up</option>
                                                            <option value="2">2 Stars &amp; Up</option>
                                                            <option value="1">1 Star &amp; Up</option>
                                                        </select>
                                                        <i class="ti ti-star app-search-icon text-muted"></i>
                                                    </div>
                                                    <button class="btn btn-primary" type="submit">
                                                        <i class="ti ti-plus me-1"></i>
                                                        Add
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xl-4 col-md-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-start mb-3">
                                        <!-- Logo -->
                                        <div class="d-flex align-items-center gap-3">
                                            <img alt="Amazon Logo" class="rounded" height="50" src="/images/logos/amazon.svg" width="50" />
                                            <div>
                                                <h4 class="mb-1 fw-bold">Amazon Inc.</h4>
                                                <a class="text-muted small" href="https://www.amazon.com" target="_blank">www.amazon.com</a>
                                            </div>
                                        </div>
                                        <!-- Follow Button -->
                                        <button class="btn btn-outline-danger btn-sm">
                                            <i class="ti ti-heart me-1"></i>
                                            Follow
                                        </button>
                                    </div>
                                    <!-- Badges -->
                                    <div class="mb-3 d-flex flex-wrap gap-2">
                                        <span class="badge bg-primary-subtle text-primary px-2 py-1 rounded-pill">Seattle, WA</span>
                                        <span class="badge bg-success-subtle text-success px-2 py-1 rounded-pill">eCommerce</span>
                                        <span class="badge bg-info-subtle text-info px-2 py-1 rounded-pill">Founded: 1994</span>
                                    </div>
                                    <!-- Description -->
                                    <p class="text-muted mb-4">
                                        Amazon.com, Inc. is an American multinational technology company focusing on e-commerce, cloud computing, digital streaming, and artificial intelligence. It’s one of the Big Five tech companies alongside Google, Apple, Microsoft, and Meta.
                                    </p>
                                    <!-- Stats -->
                                    <div class="row text-center mb-4">
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">1.5M+</h5>
                                            <small class="text-muted">Employees</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">$514B</h5>
                                            <small class="text-muted">Revenue</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">Andy Jassy</h5>
                                            <small class="text-muted">CEO</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">AMZN</h5>
                                            <small class="text-muted">Nasdaq</small>
                                        </div>
                                    </div>
                                    <!-- Rating -->
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="text-warning align-self-center fs-lg">
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star"></i>
                                        </div>
                                        <a class="btn btn-primary btn-sm" href="#">Visit Company Profile</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col-->
                        <div class="col-xl-4 col-md-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-start mb-3">
                                        <!-- Logo -->
                                        <div class="d-flex align-items-center gap-3">
                                            <img alt="Apple Logo" class="rounded" height="50" src="/images/logos/apple.svg" width="50" />
                                            <div>
                                                <h4 class="mb-1 fw-bold">Apple Inc.</h4>
                                                <a class="text-muted small" href="https://www.apple.com" target="_blank">www.apple.com</a>
                                            </div>
                                        </div>
                                        <!-- Follow Button -->
                                        <button class="btn btn-outline-danger btn-sm">
                                            <i class="ti ti-heart me-1"></i>
                                            Follow
                                        </button>
                                    </div>
                                    <!-- Badges -->
                                    <div class="mb-3 d-flex flex-wrap gap-2">
                                        <span class="badge bg-primary-subtle text-primary px-2 py-1 rounded-pill">Cupertino, CA</span>
                                        <span class="badge bg-success-subtle text-success px-2 py-1 rounded-pill">Technology</span>
                                        <span class="badge bg-info-subtle text-info px-2 py-1 rounded-pill">Founded: 1976</span>
                                    </div>
                                    <!-- Description -->
                                    <p class="text-muted mb-4">
                                        Apple Inc. is an American multinational technology company that designs, develops, and sells consumer electronics, software, and online services. It’s one of the Big Five tech companies alongside Google, Amazon, Microsoft, and Meta.
                                    </p>
                                    <!-- Stats -->
                                    <div class="row text-center mb-4">
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">164K+</h5>
                                            <small class="text-muted">Employees</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">$394B</h5>
                                            <small class="text-muted">Revenue</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">Tim Cook</h5>
                                            <small class="text-muted">CEO</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">AAPL</h5>
                                            <small class="text-muted">Nasdaq</small>
                                        </div>
                                    </div>
                                    <!-- Rating -->
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="text-warning align-self-center fs-lg">
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star"></i>
                                        </div>
                                        <a class="btn btn-primary btn-sm" href="#">Visit Company Profile</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col-->
                        <div class="col-xl-4 col-md-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-start mb-3">
                                        <!-- Logo -->
                                        <div class="d-flex align-items-center gap-3">
                                            <img alt="Starbucks Logo" class="rounded" height="50" src="/images/logos/starbucks.svg" width="50" />
                                            <div>
                                                <h4 class="mb-1 fw-bold">Starbucks Corporation</h4>
                                                <a class="text-muted small" href="https://www.starbucks.com" target="_blank">www.starbucks.com</a>
                                            </div>
                                        </div>
                                        <!-- Follow Button -->
                                        <button class="btn btn-outline-danger btn-sm">
                                            <i class="ti ti-heart me-1"></i>
                                            Follow
                                        </button>
                                    </div>
                                    <!-- Badges -->
                                    <div class="mb-3 d-flex flex-wrap gap-2">
                                        <span class="badge bg-primary-subtle text-primary px-2 py-1 rounded-pill">Seattle, WA</span>
                                        <span class="badge bg-success-subtle text-success px-2 py-1 rounded-pill">Coffeehouse</span>
                                        <span class="badge bg-info-subtle text-info px-2 py-1 rounded-pill">Founded: 1971</span>
                                    </div>
                                    <!-- Description -->
                                    <p class="text-muted mb-4">Starbucks Corporation is an American multinational chain of coffeehouses and roastery reserves. It’s the world’s largest coffeehouse chain and a premier roaster and retailer of specialty coffee.</p>
                                    <!-- Stats -->
                                    <div class="row text-center mb-4">
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">400K+</h5>
                                            <small class="text-muted">Employees</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">$36B</h5>
                                            <small class="text-muted">Revenue</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">Laxman Narasimhan</h5>
                                            <small class="text-muted">CEO</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">SBUX</h5>
                                            <small class="text-muted">Nasdaq</small>
                                        </div>
                                    </div>
                                    <!-- Rating -->
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="text-warning align-self-center fs-lg">
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star"></i>
                                        </div>
                                        <a class="btn btn-primary btn-sm" href="#">Visit Company Profile</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-md-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-start mb-3">
                                        <!-- Logo -->
                                        <div class="d-flex align-items-center gap-3">
                                            <img alt="Meta Logo" class="rounded" height="50" src="/images/logos/meta.svg" width="50" />
                                            <div>
                                                <h4 class="mb-1 fw-bold">Meta Platforms, Inc.</h4>
                                                <a class="text-muted small" href="https://www.meta.com" target="_blank">www.meta.com</a>
                                            </div>
                                        </div>
                                        <!-- Follow Button -->
                                        <button class="btn btn-outline-danger btn-sm">
                                            <i class="ti ti-heart me-1"></i>
                                            Follow
                                        </button>
                                    </div>
                                    <!-- Badges -->
                                    <div class="mb-3 d-flex flex-wrap gap-2">
                                        <span class="badge bg-primary-subtle text-primary px-2 py-1 rounded-pill">Menlo Park, CA</span>
                                        <span class="badge bg-success-subtle text-success px-2 py-1 rounded-pill">Social Media</span>
                                        <span class="badge bg-info-subtle text-info px-2 py-1 rounded-pill">Founded: 2004</span>
                                    </div>
                                    <!-- Description -->
                                    <p class="text-muted mb-4">Meta Platforms, Inc. is an American multinational technology conglomerate. It owns Facebook, Instagram, WhatsApp, and Quest VR products, focusing on social networking, virtual reality, and the metaverse.</p>
                                    <!-- Stats -->
                                    <div class="row text-center mb-4">
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">66K+</h5>
                                            <small class="text-muted">Employees</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">$134B</h5>
                                            <small class="text-muted">Revenue</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">M.Zuckerberg</h5>
                                            <small class="text-muted">CEO</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">META</h5>
                                            <small class="text-muted">Nasdaq</small>
                                        </div>
                                    </div>
                                    <!-- Rating -->
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="text-warning align-self-center fs-lg">
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star"></i>
                                        </div>
                                        <a class="btn btn-primary btn-sm" href="#">Visit Company Profile</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-md-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-start mb-3">
                                        <!-- Logo -->
                                        <div class="d-flex align-items-center gap-3">
                                            <img alt="Spotify Logo" class="rounded" height="50" src="/images/logos/spotify.svg" width="50" />
                                            <div>
                                                <h4 class="mb-1 fw-bold">Spotify Technology S.A.</h4>
                                                <a class="text-muted small" href="https://www.spotify.com" target="_blank">www.spotify.com</a>
                                            </div>
                                        </div>
                                        <!-- Follow Button -->
                                        <button class="btn btn-outline-danger btn-sm">
                                            <i class="ti ti-heart me-1"></i>
                                            Follow
                                        </button>
                                    </div>
                                    <!-- Badges -->
                                    <div class="mb-3 d-flex flex-wrap gap-2">
                                        <span class="badge bg-primary-subtle text-primary px-2 py-1 rounded-pill">Stockholm, Sweden</span>
                                        <span class="badge bg-success-subtle text-success px-2 py-1 rounded-pill">Music Streaming</span>
                                        <span class="badge bg-info-subtle text-info px-2 py-1 rounded-pill">Founded: 2006</span>
                                    </div>
                                    <!-- Description -->
                                    <p class="text-muted mb-4">Spotify Technology S.A. is a Swedish audio streaming and media services provider. It’s one of the world’s largest music streaming service providers with millions of active users worldwide.</p>
                                    <!-- Stats -->
                                    <div class="row text-center mb-4">
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">8.9K+</h5>
                                            <small class="text-muted">Employees</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">$13B</h5>
                                            <small class="text-muted">Revenue</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">Daniel Ek</h5>
                                            <small class="text-muted">CEO</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">SPOT</h5>
                                            <small class="text-muted">NYSE</small>
                                        </div>
                                    </div>
                                    <!-- Rating -->
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="text-warning align-self-center fs-lg">
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star"></i>
                                        </div>
                                        <a class="btn btn-primary btn-sm" href="#">Visit Company Profile</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-md-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-start mb-3">
                                        <!-- Logo -->
                                        <div class="d-flex align-items-center gap-3">
                                            <img alt="Google Logo" class="rounded" height="50" src="/images/logos/google.svg" width="50" />
                                            <div>
                                                <h4 class="mb-1 fw-bold">Google LLC</h4>
                                                <a class="text-muted small" href="https://www.google.com" target="_blank">www.google.com</a>
                                            </div>
                                        </div>
                                        <!-- Follow Button -->
                                        <button class="btn btn-outline-danger btn-sm">
                                            <i class="ti ti-heart me-1"></i>
                                            Follow
                                        </button>
                                    </div>
                                    <!-- Badges -->
                                    <div class="mb-3 d-flex flex-wrap gap-2">
                                        <span class="badge bg-primary-subtle text-primary px-2 py-1 rounded-pill">Mountain View, CA</span>
                                        <span class="badge bg-success-subtle text-success px-2 py-1 rounded-pill">Technology</span>
                                        <span class="badge bg-info-subtle text-info px-2 py-1 rounded-pill">Founded: 1998</span>
                                    </div>
                                    <!-- Description -->
                                    <p class="text-muted mb-4">Google LLC is an American multinational technology company focusing on search, online advertising, cloud computing, and artificial intelligence. It’s a subsidiary of Alphabet Inc.</p>
                                    <!-- Stats -->
                                    <div class="row text-center mb-4">
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">182K+</h5>
                                            <small class="text-muted">Employees</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">$307B</h5>
                                            <small class="text-muted">Revenue</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">Sundar Pichai</h5>
                                            <small class="text-muted">CEO</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">GOOGL</h5>
                                            <small class="text-muted">Nasdaq</small>
                                        </div>
                                    </div>
                                    <!-- Rating -->
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="text-warning align-self-center fs-lg">
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star"></i>
                                        </div>
                                        <a class="btn btn-primary btn-sm" href="#">Visit Company Profile</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Airbnb -->
                        <div class="col-xl-4 col-md-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-start mb-3">
                                        <!-- Logo -->
                                        <div class="d-flex align-items-center gap-3">
                                            <img alt="Airbnb Logo" class="rounded" height="50" src="/images/logos/airbnb.svg" width="50" />
                                            <div>
                                                <h4 class="mb-1 fw-bold">Airbnb, Inc.</h4>
                                                <a class="text-muted small" href="https://www.airbnb.com" target="_blank">www.airbnb.com</a>
                                            </div>
                                        </div>
                                        <!-- Follow Button -->
                                        <button class="btn btn-outline-danger btn-sm">
                                            <i class="ti ti-heart me-1"></i>
                                            Follow
                                        </button>
                                    </div>
                                    <!-- Badges -->
                                    <div class="mb-3 d-flex flex-wrap gap-2">
                                        <span class="badge bg-primary-subtle text-primary px-2 py-1 rounded-pill">San Francisco, CA</span>
                                        <span class="badge bg-success-subtle text-success px-2 py-1 rounded-pill">Travel &amp; Hospitality</span>
                                        <span class="badge bg-info-subtle text-info px-2 py-1 rounded-pill">Founded: 2008</span>
                                    </div>
                                    <!-- Description -->
                                    <p class="text-muted mb-4">Airbnb, Inc. is an American company operating an online marketplace for short-term homestays and experiences. It connects hosts with travelers looking for accommodations worldwide.</p>
                                    <!-- Stats -->
                                    <div class="row text-center mb-4">
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">6K+</h5>
                                            <small class="text-muted">Employees</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">$9.9B</h5>
                                            <small class="text-muted">Revenue</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">Brian Chesky</h5>
                                            <small class="text-muted">CEO</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">ABNB</h5>
                                            <small class="text-muted">Nasdaq</small>
                                        </div>
                                    </div>
                                    <!-- Rating -->
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="text-warning align-self-center fs-lg">
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star"></i>
                                        </div>
                                        <a class="btn btn-primary btn-sm" href="#">Visit Company Profile</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Shell -->
                        <div class="col-xl-4 col-md-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-start mb-3">
                                        <!-- Logo -->
                                        <div class="d-flex align-items-center gap-3">
                                            <img alt="Shell Logo" class="rounded" height="50" src="/images/logos/shell.svg" width="50" />
                                            <div>
                                                <h4 class="mb-1 fw-bold">Shell plc</h4>
                                                <a class="text-muted small" href="https://www.shell.com" target="_blank">www.shell.com</a>
                                            </div>
                                        </div>
                                        <!-- Follow Button -->
                                        <button class="btn btn-outline-danger btn-sm">
                                            <i class="ti ti-heart me-1"></i>
                                            Follow
                                        </button>
                                    </div>
                                    <!-- Badges -->
                                    <div class="mb-3 d-flex flex-wrap gap-2">
                                        <span class="badge bg-primary-subtle text-primary px-2 py-1 rounded-pill">London, UK</span>
                                        <span class="badge bg-success-subtle text-success px-2 py-1 rounded-pill">Energy &amp; Oil</span>
                                        <span class="badge bg-info-subtle text-info px-2 py-1 rounded-pill">Founded: 1907</span>
                                    </div>
                                    <!-- Description -->
                                    <p class="text-muted mb-4">Shell plc is a British multinational oil and gas company. It is one of the largest energy companies in the world, involved in oil, natural gas, and renewable energy development.</p>
                                    <!-- Stats -->
                                    <div class="row text-center mb-4">
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">90K+</h5>
                                            <small class="text-muted">Employees</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">$381B</h5>
                                            <small class="text-muted">Revenue</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">Wael Sawan</h5>
                                            <small class="text-muted">CEO</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">SHEL</h5>
                                            <small class="text-muted">NYSE</small>
                                        </div>
                                    </div>
                                    <!-- Rating -->
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="text-warning align-self-center fs-lg">
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star"></i>
                                        </div>
                                        <a class="btn btn-primary btn-sm" href="#">Visit Company Profile</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-md-6">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-start mb-3">
                                        <!-- Logo -->
                                        <div class="d-flex align-items-center gap-3">
                                            <img alt="Asana Logo" class="rounded" height="50" src="/images/logos/asana.svg" width="50" />
                                            <div>
                                                <h4 class="mb-1 fw-bold">Asana, Inc.</h4>
                                                <a class="text-muted small" href="https://www.asana.com" target="_blank">www.asana.com</a>
                                            </div>
                                        </div>
                                        <!-- Follow Button -->
                                        <button class="btn btn-outline-danger btn-sm">
                                            <i class="ti ti-heart me-1"></i>
                                            Follow
                                        </button>
                                    </div>
                                    <!-- Badges -->
                                    <div class="mb-3 d-flex flex-wrap gap-2">
                                        <span class="badge bg-primary-subtle text-primary px-2 py-1 rounded-pill">San Francisco, CA</span>
                                        <span class="badge bg-success-subtle text-success px-2 py-1 rounded-pill">Work Management</span>
                                        <span class="badge bg-info-subtle text-info px-2 py-1 rounded-pill">Founded: 2008</span>
                                    </div>
                                    <!-- Description -->
                                    <p class="text-muted mb-4">Asana, Inc. is an American software company that provides a work management platform for teams to organize, track, and manage their work. It’s widely used for task, project, and workflow management.</p>
                                    <!-- Stats -->
                                    <div class="row text-center mb-4">
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">1.7K+</h5>
                                            <small class="text-muted">Employees</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">$652M</h5>
                                            <small class="text-muted">Revenue</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">D. Moskovitz</h5>
                                            <small class="text-muted">CEO</small>
                                        </div>
                                        <div class="col-6 col-md-3">
                                            <h5 class="mb-0 fw-bold">ASAN</h5>
                                            <small class="text-muted">NYSE</small>
                                        </div>
                                    </div>
                                    <!-- Rating -->
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="text-warning align-self-center fs-lg">
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star-filled"></i>
                                            <i class="ti ti-star"></i>
                                        </div>
                                        <a class="btn btn-primary btn-sm" href="#">Visit Company Profile</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- end row-->
                    <ul class="pagination pagination-rounded pagination-boxed justify-content-center mb-3">
                        <li class="page-item">
                            <a aria-label="Previous" class="page-link" href="javascript: void(0);">
                                <span aria-hidden="true">«</span>
                            </a>
                        </li>
                        <li class="page-item active">
                            <a class="page-link" href="javascript: void(0);">1</a>
                        </li>
                        <li class="page-item">
                            <a class="page-link" href="javascript: void(0);">2</a>
                        </li>
                        <li class="page-item">
                            <a class="page-link" href="javascript: void(0);">3</a>
                        </li>
                        <li class="page-item">
                            <a class="page-link" href="javascript: void(0);">4</a>
                        </li>
                        <li class="page-item">
                            <a class="page-link" href="javascript: void(0);">5</a>
                        </li>
                        <li class="page-item">
                            <a aria-label="Next" class="page-link" href="javascript: void(0);">
                                <span aria-hidden="true">»</span>
                            </a>
                        </li>
                    </ul>
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>
    </body>
</html>
