<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Checkout')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Ecommerce', 'title' => 'Checkout')) ?>

                    <!-- Cart Layout -->
                    <div class="row">
                        <!-- Cart Items -->
                        <div class="col-lg-8">
                            <div class="card">
                                <div class="card-body">
                                    <div class="ins-wizard" data-wizard="">
                                        <!-- Navigation Tabs -->
                                        <ul class="nav nav-tabs nav-justified wizard-tabs" data-wizard-nav="" role="tablist">
                                            <li class="nav-item">
                                                <a class="nav-link py-2 active" data-bs-toggle="tab" href="#stuInfo">
                                                    <span class="d-flex align-items-center justify-content-center">
                                                        <i class="ti ti-user-circle fs-24"></i>
                                                        <span class="ms-2 text-truncate">
                                                            <span class="mb-0 lh-base d-block fw-semibold text-body fs-md">Billing Info</span>
                                                        </span>
                                                    </span>
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a class="nav-link py-2" data-bs-toggle="tab" href="#addrInfo">
                                                    <span class="d-flex align-items-center justify-content-center">
                                                        <i class="ti ti-truck fs-24"></i>
                                                        <span class="ms-2 text-truncate">
                                                            <span class="mb-0 lh-base d-block fw-semibold text-body fs-md">Shipping Info</span>
                                                        </span>
                                                    </span>
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a class="nav-link py-2" data-bs-toggle="tab" href="#courseInfo">
                                                    <span class="d-flex align-items-center justify-content-center">
                                                        <i class="ti ti-credit-card fs-24"></i>
                                                        <span class="ms-2 text-truncate">
                                                            <span class="mb-0 lh-base d-block fw-semibold text-body fs-md">Payment Info</span>
                                                        </span>
                                                    </span>
                                                </a>
                                            </li>
                                            <li class="nav-item">
                                                <a class="nav-link py-2" data-bs-toggle="tab" href="#parentInfo">
                                                    <span class="d-flex align-items-center justify-content-center">
                                                        <i class="ti ti-checks fs-24"></i>
                                                        <span class="ms-2 text-truncate">
                                                            <span class="mb-0 lh-base d-block fw-semibold text-body fs-md">Finish</span>
                                                        </span>
                                                    </span>
                                                </a>
                                            </li>
                                        </ul>
                                        <!-- Content -->
                                        <div class="tab-content pt-3" data-wizard-content="">
                                            <!-- Step 1: Billing Info -->
                                            <div class="tab-pane fade show active" id="stuInfo">
                                                <h5 class="my-1 fs-md">Billing Information</h5>
                                                <p class="text-muted fs-sm mb-4">Fill the form below in order to send you the order's invoice.</p>
                                                <form>
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="mb-3">
                                                                <label class="form-label" for="billing-first-name">First Name</label>
                                                                <input class="form-control" id="billing-first-name" placeholder="Enter your first name" type="text" />
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="mb-3">
                                                                <label class="form-label" for="billing-last-name">Last Name</label>
                                                                <input class="form-control" id="billing-last-name" placeholder="Enter your last name" type="text" />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- end row -->
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="mb-3">
                                                                <label class="form-label" for="billing-email-address">
                                                                    Email
                                                                    <span class="text-danger">*</span>
                                                                </label>
                                                                <input class="form-control" id="billing-email-address" placeholder="Enter your email" type="email" />
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="mb-3">
                                                                <label class="form-label" for="billing-phone">
                                                                    Phone
                                                                    <span class="text-danger">*</span>
                                                                </label>
                                                                <input class="form-control" id="billing-phone" placeholder="(xx) xxx xxxx xxx" type="text" />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- end row -->
                                                    <div class="row">
                                                        <div class="col-12">
                                                            <div class="mb-3">
                                                                <label class="form-label" for="billing-address">
                                                                    Address
                                                                    <span class="text-danger">*</span>
                                                                </label>
                                                                <textarea class="form-control" id="billing-address" placeholder="Enter your address" rows="2"></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- end row -->
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                            <div class="mb-3">
                                                                <label class="form-label" for="billing-town-city">Town / City</label>
                                                                <input class="form-control" id="billing-town-city" placeholder="Enter your city name" type="text" />
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="mb-3">
                                                                <label class="form-label" for="billing-state">State</label>
                                                                <input class="form-control" id="billing-state" placeholder="Enter your state" type="text" />
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="mb-3">
                                                                <label class="form-label" for="billing-zip-postal">Zip / Postal Code</label>
                                                                <input class="form-control" id="billing-zip-postal" placeholder="Enter your zip code" type="text" />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- end row -->
                                                    <div class="row">
                                                        <div class="col-12">
                                                            <div class="mb-3">
                                                                <label class="form-label">Country</label>
                                                                <select class="form-select">
                                                                    <option value="0">Select Country</option>
                                                                    <option value="AF">Afghanistan</option>
                                                                    <option value="AL">Albania</option>
                                                                    <option value="DZ">Algeria</option>
                                                                    <option value="AS">American Samoa</option>
                                                                    <option value="AD">Andorra</option>
                                                                    <option value="AO">Angola</option>
                                                                    <option value="AI">Anguilla</option>
                                                                    <option value="AQ">Antarctica</option>
                                                                    <option value="AR">Argentina</option>
                                                                    <option value="AM">Armenia</option>
                                                                    <option value="AW">Aruba</option>
                                                                    <option value="AU">Australia</option>
                                                                    <option value="AT">Austria</option>
                                                                    <option value="AZ">Azerbaijan</option>
                                                                    <option value="BS">Bahamas</option>
                                                                    <option value="BH">Bahrain</option>
                                                                    <option value="BD">Bangladesh</option>
                                                                    <option value="BB">Barbados</option>
                                                                    <option value="BY">Belarus</option>
                                                                    <option value="BE">Belgium</option>
                                                                    <option value="BZ">Belize</option>
                                                                    <option value="BJ">Benin</option>
                                                                    <option value="BM">Bermuda</option>
                                                                    <option value="BT">Bhutan</option>
                                                                    <option value="BO">Bolivia</option>
                                                                    <option value="BW">Botswana</option>
                                                                    <option value="BV">Bouvet Island</option>
                                                                    <option value="BR">Brazil</option>
                                                                    <option value="BN">Brunei Darussalam</option>
                                                                    <option value="BG">Bulgaria</option>
                                                                    <option value="BF">Burkina Faso</option>
                                                                    <option value="BI">Burundi</option>
                                                                    <option value="KH">Cambodia</option>
                                                                    <option value="CM">Cameroon</option>
                                                                    <option value="CA">Canada</option>
                                                                    <option value="CV">Cape Verde</option>
                                                                    <option value="KY">Cayman Islands</option>
                                                                    <option value="CF">Central African Republic</option>
                                                                    <option value="TD">Chad</option>
                                                                    <option value="CL">Chile</option>
                                                                    <option value="CN">China</option>
                                                                    <option value="CX">Christmas Island</option>
                                                                    <option value="CC">Cocos (Keeling) Islands</option>
                                                                    <option value="CO">Colombia</option>
                                                                    <option value="KM">Comoros</option>
                                                                    <option value="CG">Congo</option>
                                                                    <option value="CK">Cook Islands</option>
                                                                    <option value="CR">Costa Rica</option>
                                                                    <option value="CI">Cote d'Ivoire</option>
                                                                    <option value="HR">Croatia (Hrvatska)</option>
                                                                    <option value="CU">Cuba</option>
                                                                    <option value="CY">Cyprus</option>
                                                                    <option value="CZ">Czech Republic</option>
                                                                    <option value="DK">Denmark</option>
                                                                    <option value="DJ">Djibouti</option>
                                                                    <option value="DM">Dominica</option>
                                                                    <option value="DO">Dominican Republic</option>
                                                                    <option value="EC">Ecuador</option>
                                                                    <option value="EG">Egypt</option>
                                                                    <option value="SV">El Salvador</option>
                                                                    <option value="GQ">Equatorial Guinea</option>
                                                                    <option value="ER">Eritrea</option>
                                                                    <option value="EE">Estonia</option>
                                                                    <option value="ET">Ethiopia</option>
                                                                    <option value="FK">Falkland Islands (Malvinas)</option>
                                                                    <option value="FO">Faroe Islands</option>
                                                                    <option value="FJ">Fiji</option>
                                                                    <option value="FI">Finland</option>
                                                                    <option value="FR">France</option>
                                                                    <option value="GF">French Guiana</option>
                                                                    <option value="PF">French Polynesia</option>
                                                                    <option value="GA">Gabon</option>
                                                                    <option value="GM">Gambia</option>
                                                                    <option value="GE">Georgia</option>
                                                                    <option value="DE">Germany</option>
                                                                    <option value="GH">Ghana</option>
                                                                    <option value="GI">Gibraltar</option>
                                                                    <option value="GR">Greece</option>
                                                                    <option value="GL">Greenland</option>
                                                                    <option value="GD">Grenada</option>
                                                                    <option value="GP">Guadeloupe</option>
                                                                    <option value="GU">Guam</option>
                                                                    <option value="GT">Guatemala</option>
                                                                    <option value="GN">Guinea</option>
                                                                    <option value="GW">Guinea-Bissau</option>
                                                                    <option value="GY">Guyana</option>
                                                                    <option value="HT">Haiti</option>
                                                                    <option value="HN">Honduras</option>
                                                                    <option value="HK">Hong Kong</option>
                                                                    <option value="HU">Hungary</option>
                                                                    <option value="IS">Iceland</option>
                                                                    <option value="IN">India</option>
                                                                    <option value="ID">Indonesia</option>
                                                                    <option value="IQ">Iraq</option>
                                                                    <option value="IE">Ireland</option>
                                                                    <option value="IL">Israel</option>
                                                                    <option value="IT">Italy</option>
                                                                    <option value="JM">Jamaica</option>
                                                                    <option value="JP">Japan</option>
                                                                    <option value="JO">Jordan</option>
                                                                    <option value="KZ">Kazakhstan</option>
                                                                    <option value="KE">Kenya</option>
                                                                    <option value="KI">Kiribati</option>
                                                                    <option value="KR">Korea, Republic of</option>
                                                                    <option value="KW">Kuwait</option>
                                                                    <option value="KG">Kyrgyzstan</option>
                                                                    <option value="LV">Latvia</option>
                                                                    <option value="LB">Lebanon</option>
                                                                    <option value="LS">Lesotho</option>
                                                                    <option value="LR">Liberia</option>
                                                                    <option value="LY">Libyan Arab Jamahiriya</option>
                                                                    <option value="LI">Liechtenstein</option>
                                                                    <option value="LT">Lithuania</option>
                                                                    <option value="LU">Luxembourg</option>
                                                                    <option value="MO">Macau</option>
                                                                    <option value="MG">Madagascar</option>
                                                                    <option value="MW">Malawi</option>
                                                                    <option value="MY">Malaysia</option>
                                                                    <option value="MV">Maldives</option>
                                                                    <option value="ML">Mali</option>
                                                                    <option value="MT">Malta</option>
                                                                    <option value="MH">Marshall Islands</option>
                                                                    <option value="MQ">Martinique</option>
                                                                    <option value="MR">Mauritania</option>
                                                                    <option value="MU">Mauritius</option>
                                                                    <option value="YT">Mayotte</option>
                                                                    <option value="MX">Mexico</option>
                                                                    <option value="MD">Moldova, Republic of</option>
                                                                    <option value="MC">Monaco</option>
                                                                    <option value="MN">Mongolia</option>
                                                                    <option value="MS">Montserrat</option>
                                                                    <option value="MA">Morocco</option>
                                                                    <option value="MZ">Mozambique</option>
                                                                    <option value="MM">Myanmar</option>
                                                                    <option value="NA">Namibia</option>
                                                                    <option value="NR">Nauru</option>
                                                                    <option value="NP">Nepal</option>
                                                                    <option value="NL">Netherlands</option>
                                                                    <option value="AN">Netherlands Antilles</option>
                                                                    <option value="NC">New Caledonia</option>
                                                                    <option value="NZ">New Zealand</option>
                                                                    <option value="NI">Nicaragua</option>
                                                                    <option value="NE">Niger</option>
                                                                    <option value="NG">Nigeria</option>
                                                                    <option value="NU">Niue</option>
                                                                    <option value="NF">Norfolk Island</option>
                                                                    <option value="MP">Northern Mariana Islands</option>
                                                                    <option value="NO">Norway</option>
                                                                    <option value="OM">Oman</option>
                                                                    <option value="PW">Palau</option>
                                                                    <option value="PA">Panama</option>
                                                                    <option value="PG">Papua New Guinea</option>
                                                                    <option value="PY">Paraguay</option>
                                                                    <option value="PE">Peru</option>
                                                                    <option value="PH">Philippines</option>
                                                                    <option value="PN">Pitcairn</option>
                                                                    <option value="PL">Poland</option>
                                                                    <option value="PT">Portugal</option>
                                                                    <option value="PR">Puerto Rico</option>
                                                                    <option value="QA">Qatar</option>
                                                                    <option value="RE">Reunion</option>
                                                                    <option value="RO">Romania</option>
                                                                    <option value="RU">Russian Federation</option>
                                                                    <option value="RW">Rwanda</option>
                                                                    <option value="KN">Saint Kitts and Nevis</option>
                                                                    <option value="LC">Saint LUCIA</option>
                                                                    <option value="WS">Samoa</option>
                                                                    <option value="SM">San Marino</option>
                                                                    <option value="ST">Sao Tome and Principe</option>
                                                                    <option value="SA">Saudi Arabia</option>
                                                                    <option value="SN">Senegal</option>
                                                                    <option value="SC">Seychelles</option>
                                                                    <option value="SL">Sierra Leone</option>
                                                                    <option value="SG">Singapore</option>
                                                                    <option value="SK">Slovakia (Slovak Republic)</option>
                                                                    <option value="SI">Slovenia</option>
                                                                    <option value="SB">Solomon Islands</option>
                                                                    <option value="SO">Somalia</option>
                                                                    <option value="ZA">South Africa</option>
                                                                    <option value="ES">Spain</option>
                                                                    <option value="LK">Sri Lanka</option>
                                                                    <option value="SH">St. Helena</option>
                                                                    <option value="PM">St. Pierre and Miquelon</option>
                                                                    <option value="SD">Sudan</option>
                                                                    <option value="SR">Suriname</option>
                                                                    <option value="SZ">Swaziland</option>
                                                                    <option value="SE">Sweden</option>
                                                                    <option value="CH">Switzerland</option>
                                                                    <option value="SY">Syrian Arab Republic</option>
                                                                    <option value="TW">Taiwan, Province of China</option>
                                                                    <option value="TJ">Tajikistan</option>
                                                                    <option value="TZ">Tanzania, United Republic of</option>
                                                                    <option value="TH">Thailand</option>
                                                                    <option value="TG">Togo</option>
                                                                    <option value="TK">Tokelau</option>
                                                                    <option value="TO">Tonga</option>
                                                                    <option value="TT">Trinidad and Tobago</option>
                                                                    <option value="TN">Tunisia</option>
                                                                    <option value="TR">Turkey</option>
                                                                    <option value="TM">Turkmenistan</option>
                                                                    <option value="TC">Turks and Caicos Islands</option>
                                                                    <option value="TV">Tuvalu</option>
                                                                    <option value="UG">Uganda</option>
                                                                    <option value="UA">Ukraine</option>
                                                                    <option value="AE">United Arab Emirates</option>
                                                                    <option value="GB">United Kingdom</option>
                                                                    <option value="US">United States</option>
                                                                    <option value="UY">Uruguay</option>
                                                                    <option value="UZ">Uzbekistan</option>
                                                                    <option value="VU">Vanuatu</option>
                                                                    <option value="VE">Venezuela</option>
                                                                    <option value="VN">Viet Nam</option>
                                                                    <option value="VG">Virgin Islands (British)</option>
                                                                    <option value="VI">Virgin Islands (U.S.)</option>
                                                                    <option value="WF">Wallis and Futuna Islands</option>
                                                                    <option value="EH">Western Sahara</option>
                                                                    <option value="YE">Yemen</option>
                                                                    <option value="ZM">Zambia</option>
                                                                    <option value="ZW">Zimbabwe</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- end row -->
                                                    <div class="row">
                                                        <div class="col-12">
                                                            <div class="mb-3">
                                                                <div class="form-check">
                                                                    <input class="form-check-input" id="customCheck2" type="checkbox" />
                                                                    <label class="form-check-label" for="customCheck2">Ship to different address ?</label>
                                                                </div>
                                                            </div>
                                                            <div class="mb-3 mt-3">
                                                                <label class="form-label" for="example-textarea">Order Notes:</label>
                                                                <textarea class="form-control" id="example-textarea" placeholder="Write some note.." rows="3"></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- end row -->
                                                </form>
                                                <div class="d-flex justify-content-end mt-3">
                                                    <button class="btn btn-primary" data-wizard-next="" type="button">
                                                        Proceed to Shipping
                                                        <i class="ti ti-truck ms-1 fs-lg"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            <!-- Step 2: Address Info -->
                                            <div class="tab-pane fade" id="addrInfo">
                                                <h5 class="my-1 fs-md">Saved Address</h5>
                                                <p class="text-muted fs-sm mb-4">Provide your address details to receive the order invoice.</p>
                                                <div class="row">
                                                    <div class="col-xl-6">
                                                        <div class="mb-3">
                                                            <div class="form-check card-radio card-radio-bordered">
                                                                <input checked="" class="form-check-input" id="add-home" name="deli-address" type="radio" />
                                                                <label class="form-check-label p-3 w-100" for="add-home">
                                                                    <span class="fw-bold text-muted mb-1 d-block text-uppercase">Home</span>
                                                                    <span class="fw-semibold d-block">Evelyn Carter</span>
                                                                    2418 Maple Street, Apt 12B
                                                                    <br />
                                                                    Brooklyn, NY 11215
                                                                    <br />
                                                                    <abbr title="Phone">P:</abbr>
                                                                    (917) 432-7784
                                                                    <br />
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-xl-6">
                                                        <div class="mb-3">
                                                            <div class="form-check card-radio card-radio-bordered">
                                                                <input class="form-check-input" id="add-office" name="deli-address" type="radio" />
                                                                <label class="form-check-label p-3 w-100" for="add-office">
                                                                    <span class="fw-bold text-muted mb-1 d-block text-uppercase">Office</span>
                                                                    <span class="fw-semibold d-block">Marcus Reynolds</span>
                                                                    500 Howard Street, Floor 8
                                                                    <br />
                                                                    San Francisco, CA 94105
                                                                    <br />
                                                                    <abbr title="Phone">P:</abbr>
                                                                    (415) 392-6400
                                                                    <br />
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <h5 class="my-1 fs-md">Add New Address</h5>
                                                <p class="text-muted fs-sm mb-4">Provide your address details to receive the order invoice.</p>
                                                <form>
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="mb-3">
                                                                <label class="form-label" for="shipping-add-first-name">First Name</label>
                                                                <input class="form-control" id="shipping-add-first-name" placeholder="Enter your first name" type="text" />
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="mb-3">
                                                                <label class="form-label" for="shipping-add-last-name">Last Name</label>
                                                                <input class="form-control" id="shipping-add-last-name" placeholder="Enter your last name" type="text" />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- end row -->
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="mb-3">
                                                                <label class="form-label" for="shipping-add-email-address">
                                                                    Email
                                                                    <span class="text-danger">*</span>
                                                                </label>
                                                                <input class="form-control" id="shipping-add-email-address" placeholder="Enter your email" type="email" />
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="mb-3">
                                                                <label class="form-label" for="shipping-add-phone">
                                                                    Phone
                                                                    <span class="text-danger">*</span>
                                                                </label>
                                                                <input class="form-control" id="shipping-add-phone" placeholder="(xx) xxx xxxx xxx" type="text" />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- end row -->
                                                    <div class="row">
                                                        <div class="col-12">
                                                            <div class="mb-3">
                                                                <label class="form-label" for="shipping-add-address">
                                                                    Address
                                                                    <span class="text-danger">*</span>
                                                                </label>
                                                                <textarea class="form-control" id="shipping-add-address" placeholder="Enter your address" rows="2"></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- end row -->
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                            <div class="mb-3">
                                                                <label class="form-label" for="shipping-add-town-city">Town / City</label>
                                                                <input class="form-control" id="shipping-add-town-city" placeholder="Enter your city name" type="text" />
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="mb-3">
                                                                <label class="form-label" for="shipping-add-state">State</label>
                                                                <input class="form-control" id="shipping-add-state" placeholder="Enter your state" type="text" />
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="mb-3">
                                                                <label class="form-label" for="shipping-add-zip-postal">Zip / Postal Code</label>
                                                                <input class="form-control" id="shipping-add-zip-postal" placeholder="Enter your zip code" type="text" />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- end row -->
                                                    <div class="row">
                                                        <div class="col-12">
                                                            <div class="mb-3">
                                                                <label class="form-label">Country</label>
                                                                <select class="form-select">
                                                                    <option value="0">Select Country</option>
                                                                    <option value="AF">Afghanistan</option>
                                                                    <option value="AL">Albania</option>
                                                                    <option value="DZ">Algeria</option>
                                                                    <option value="AS">American Samoa</option>
                                                                    <option value="AD">Andorra</option>
                                                                    <option value="AO">Angola</option>
                                                                    <option value="AI">Anguilla</option>
                                                                    <option value="AQ">Antarctica</option>
                                                                    <option value="AR">Argentina</option>
                                                                    <option value="AM">Armenia</option>
                                                                    <option value="AW">Aruba</option>
                                                                    <option value="AU">Australia</option>
                                                                    <option value="AT">Austria</option>
                                                                    <option value="AZ">Azerbaijan</option>
                                                                    <option value="BS">Bahamas</option>
                                                                    <option value="BH">Bahrain</option>
                                                                    <option value="BD">Bangladesh</option>
                                                                    <option value="BB">Barbados</option>
                                                                    <option value="BY">Belarus</option>
                                                                    <option value="BE">Belgium</option>
                                                                    <option value="BZ">Belize</option>
                                                                    <option value="BJ">Benin</option>
                                                                    <option value="BM">Bermuda</option>
                                                                    <option value="BT">Bhutan</option>
                                                                    <option value="BO">Bolivia</option>
                                                                    <option value="BW">Botswana</option>
                                                                    <option value="BV">Bouvet Island</option>
                                                                    <option value="BR">Brazil</option>
                                                                    <option value="BN">Brunei Darussalam</option>
                                                                    <option value="BG">Bulgaria</option>
                                                                    <option value="BF">Burkina Faso</option>
                                                                    <option value="BI">Burundi</option>
                                                                    <option value="KH">Cambodia</option>
                                                                    <option value="CM">Cameroon</option>
                                                                    <option value="CA">Canada</option>
                                                                    <option value="CV">Cape Verde</option>
                                                                    <option value="KY">Cayman Islands</option>
                                                                    <option value="CF">Central African Republic</option>
                                                                    <option value="TD">Chad</option>
                                                                    <option value="CL">Chile</option>
                                                                    <option value="CN">China</option>
                                                                    <option value="CX">Christmas Island</option>
                                                                    <option value="CC">Cocos (Keeling) Islands</option>
                                                                    <option value="CO">Colombia</option>
                                                                    <option value="KM">Comoros</option>
                                                                    <option value="CG">Congo</option>
                                                                    <option value="CK">Cook Islands</option>
                                                                    <option value="CR">Costa Rica</option>
                                                                    <option value="CI">Cote d'Ivoire</option>
                                                                    <option value="HR">Croatia (Hrvatska)</option>
                                                                    <option value="CU">Cuba</option>
                                                                    <option value="CY">Cyprus</option>
                                                                    <option value="CZ">Czech Republic</option>
                                                                    <option value="DK">Denmark</option>
                                                                    <option value="DJ">Djibouti</option>
                                                                    <option value="DM">Dominica</option>
                                                                    <option value="DO">Dominican Republic</option>
                                                                    <option value="EC">Ecuador</option>
                                                                    <option value="EG">Egypt</option>
                                                                    <option value="SV">El Salvador</option>
                                                                    <option value="GQ">Equatorial Guinea</option>
                                                                    <option value="ER">Eritrea</option>
                                                                    <option value="EE">Estonia</option>
                                                                    <option value="ET">Ethiopia</option>
                                                                    <option value="FK">Falkland Islands (Malvinas)</option>
                                                                    <option value="FO">Faroe Islands</option>
                                                                    <option value="FJ">Fiji</option>
                                                                    <option value="FI">Finland</option>
                                                                    <option value="FR">France</option>
                                                                    <option value="GF">French Guiana</option>
                                                                    <option value="PF">French Polynesia</option>
                                                                    <option value="GA">Gabon</option>
                                                                    <option value="GM">Gambia</option>
                                                                    <option value="GE">Georgia</option>
                                                                    <option value="DE">Germany</option>
                                                                    <option value="GH">Ghana</option>
                                                                    <option value="GI">Gibraltar</option>
                                                                    <option value="GR">Greece</option>
                                                                    <option value="GL">Greenland</option>
                                                                    <option value="GD">Grenada</option>
                                                                    <option value="GP">Guadeloupe</option>
                                                                    <option value="GU">Guam</option>
                                                                    <option value="GT">Guatemala</option>
                                                                    <option value="GN">Guinea</option>
                                                                    <option value="GW">Guinea-Bissau</option>
                                                                    <option value="GY">Guyana</option>
                                                                    <option value="HT">Haiti</option>
                                                                    <option value="HN">Honduras</option>
                                                                    <option value="HK">Hong Kong</option>
                                                                    <option value="HU">Hungary</option>
                                                                    <option value="IS">Iceland</option>
                                                                    <option value="IN">India</option>
                                                                    <option value="ID">Indonesia</option>
                                                                    <option value="IQ">Iraq</option>
                                                                    <option value="IE">Ireland</option>
                                                                    <option value="IL">Israel</option>
                                                                    <option value="IT">Italy</option>
                                                                    <option value="JM">Jamaica</option>
                                                                    <option value="JP">Japan</option>
                                                                    <option value="JO">Jordan</option>
                                                                    <option value="KZ">Kazakhstan</option>
                                                                    <option value="KE">Kenya</option>
                                                                    <option value="KI">Kiribati</option>
                                                                    <option value="KR">Korea, Republic of</option>
                                                                    <option value="KW">Kuwait</option>
                                                                    <option value="KG">Kyrgyzstan</option>
                                                                    <option value="LV">Latvia</option>
                                                                    <option value="LB">Lebanon</option>
                                                                    <option value="LS">Lesotho</option>
                                                                    <option value="LR">Liberia</option>
                                                                    <option value="LY">Libyan Arab Jamahiriya</option>
                                                                    <option value="LI">Liechtenstein</option>
                                                                    <option value="LT">Lithuania</option>
                                                                    <option value="LU">Luxembourg</option>
                                                                    <option value="MO">Macau</option>
                                                                    <option value="MG">Madagascar</option>
                                                                    <option value="MW">Malawi</option>
                                                                    <option value="MY">Malaysia</option>
                                                                    <option value="MV">Maldives</option>
                                                                    <option value="ML">Mali</option>
                                                                    <option value="MT">Malta</option>
                                                                    <option value="MH">Marshall Islands</option>
                                                                    <option value="MQ">Martinique</option>
                                                                    <option value="MR">Mauritania</option>
                                                                    <option value="MU">Mauritius</option>
                                                                    <option value="YT">Mayotte</option>
                                                                    <option value="MX">Mexico</option>
                                                                    <option value="MD">Moldova, Republic of</option>
                                                                    <option value="MC">Monaco</option>
                                                                    <option value="MN">Mongolia</option>
                                                                    <option value="MS">Montserrat</option>
                                                                    <option value="MA">Morocco</option>
                                                                    <option value="MZ">Mozambique</option>
                                                                    <option value="MM">Myanmar</option>
                                                                    <option value="NA">Namibia</option>
                                                                    <option value="NR">Nauru</option>
                                                                    <option value="NP">Nepal</option>
                                                                    <option value="NL">Netherlands</option>
                                                                    <option value="AN">Netherlands Antilles</option>
                                                                    <option value="NC">New Caledonia</option>
                                                                    <option value="NZ">New Zealand</option>
                                                                    <option value="NI">Nicaragua</option>
                                                                    <option value="NE">Niger</option>
                                                                    <option value="NG">Nigeria</option>
                                                                    <option value="NU">Niue</option>
                                                                    <option value="NF">Norfolk Island</option>
                                                                    <option value="MP">Northern Mariana Islands</option>
                                                                    <option value="NO">Norway</option>
                                                                    <option value="OM">Oman</option>
                                                                    <option value="PW">Palau</option>
                                                                    <option value="PA">Panama</option>
                                                                    <option value="PG">Papua New Guinea</option>
                                                                    <option value="PY">Paraguay</option>
                                                                    <option value="PE">Peru</option>
                                                                    <option value="PH">Philippines</option>
                                                                    <option value="PN">Pitcairn</option>
                                                                    <option value="PL">Poland</option>
                                                                    <option value="PT">Portugal</option>
                                                                    <option value="PR">Puerto Rico</option>
                                                                    <option value="QA">Qatar</option>
                                                                    <option value="RE">Reunion</option>
                                                                    <option value="RO">Romania</option>
                                                                    <option value="RU">Russian Federation</option>
                                                                    <option value="RW">Rwanda</option>
                                                                    <option value="KN">Saint Kitts and Nevis</option>
                                                                    <option value="LC">Saint LUCIA</option>
                                                                    <option value="WS">Samoa</option>
                                                                    <option value="SM">San Marino</option>
                                                                    <option value="ST">Sao Tome and Principe</option>
                                                                    <option value="SA">Saudi Arabia</option>
                                                                    <option value="SN">Senegal</option>
                                                                    <option value="SC">Seychelles</option>
                                                                    <option value="SL">Sierra Leone</option>
                                                                    <option value="SG">Singapore</option>
                                                                    <option value="SK">Slovakia (Slovak Republic)</option>
                                                                    <option value="SI">Slovenia</option>
                                                                    <option value="SB">Solomon Islands</option>
                                                                    <option value="SO">Somalia</option>
                                                                    <option value="ZA">South Africa</option>
                                                                    <option value="ES">Spain</option>
                                                                    <option value="LK">Sri Lanka</option>
                                                                    <option value="SH">St. Helena</option>
                                                                    <option value="PM">St. Pierre and Miquelon</option>
                                                                    <option value="SD">Sudan</option>
                                                                    <option value="SR">Suriname</option>
                                                                    <option value="SZ">Swaziland</option>
                                                                    <option value="SE">Sweden</option>
                                                                    <option value="CH">Switzerland</option>
                                                                    <option value="SY">Syrian Arab Republic</option>
                                                                    <option value="TW">Taiwan, Province of China</option>
                                                                    <option value="TJ">Tajikistan</option>
                                                                    <option value="TZ">Tanzania, United Republic of</option>
                                                                    <option value="TH">Thailand</option>
                                                                    <option value="TG">Togo</option>
                                                                    <option value="TK">Tokelau</option>
                                                                    <option value="TO">Tonga</option>
                                                                    <option value="TT">Trinidad and Tobago</option>
                                                                    <option value="TN">Tunisia</option>
                                                                    <option value="TR">Turkey</option>
                                                                    <option value="TM">Turkmenistan</option>
                                                                    <option value="TC">Turks and Caicos Islands</option>
                                                                    <option value="TV">Tuvalu</option>
                                                                    <option value="UG">Uganda</option>
                                                                    <option value="UA">Ukraine</option>
                                                                    <option value="AE">United Arab Emirates</option>
                                                                    <option value="GB">United Kingdom</option>
                                                                    <option value="US">United States</option>
                                                                    <option value="UY">Uruguay</option>
                                                                    <option value="UZ">Uzbekistan</option>
                                                                    <option value="VU">Vanuatu</option>
                                                                    <option value="VE">Venezuela</option>
                                                                    <option value="VN">Viet Nam</option>
                                                                    <option value="VG">Virgin Islands (British)</option>
                                                                    <option value="VI">Virgin Islands (U.S.)</option>
                                                                    <option value="WF">Wallis and Futuna Islands</option>
                                                                    <option value="EH">Western Sahara</option>
                                                                    <option value="YE">Yemen</option>
                                                                    <option value="ZM">Zambia</option>
                                                                    <option value="ZW">Zimbabwe</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- end row -->
                                                    <div class="d-flex justify-content-end">
                                                        <button class="btn btn-sm btn-success" type="button">Save</button>
                                                    </div>
                                                </form>
                                                <h5 class="my-1 fs-md">Shipping Method</h5>
                                                <p class="text-muted fs-sm mb-3">Choose your preferred shipping method to receive your order on time.</p>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="border p-3 rounded mb-3 mb-md-0">
                                                            <div class="form-check">
                                                                <input checked="" class="form-check-input" id="shippingMethodRadio1" name="shippingOptions" type="radio" />
                                                                <label class="form-check-label font-16 fw-bold" for="shippingMethodRadio1">Standard Delivery - FREE</label>
                                                            </div>
                                                            <p class="mb-0 ps-3 pt-1 text-muted">Estimated 5-7 days shipping (Duties and tax may be due upon delivery)</p>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="border p-3 rounded">
                                                            <div class="form-check">
                                                                <input class="form-check-input" id="shippingMethodRadio2" name="shippingOptions" type="radio" />
                                                                <label class="form-check-label font-16 fw-bold" for="shippingMethodRadio2">Fast Delivery - $25</label>
                                                            </div>
                                                            <p class="mb-0 ps-3 pt-1 text-muted">Estimated 1-2 days shipping (Duties and tax may be due upon delivery)</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- end row-->
                                                <div class="d-flex justify-content-between mt-3">
                                                    <button class="btn btn-secondary" data-wizard-prev="" type="button">← Billing Info</button>
                                                    <button class="btn btn-primary" data-wizard-next="" type="button">Payment Info →</button>
                                                </div>
                                            </div>
                                            <!-- Step 3: Course Info -->
                                            <div class="tab-pane fade" id="courseInfo">
                                                <h5 class="my-1 fs-md">Payment Method</h5>
                                                <p class="text-muted fs-sm mb-3">Select your preferred payment method to complete your purchase securely.</p>
                                                <!-- Pay with Paypal box-->
                                                <div class="border p-3 mb-3 rounded">
                                                    <div class="row">
                                                        <div class="col-sm-8">
                                                            <div class="form-check">
                                                                <input class="form-check-input" id="BillingOptRadio2" name="billingOptions" type="radio" />
                                                                <label class="form-check-label font-16 fw-bold" for="BillingOptRadio2">Pay with Paypal</label>
                                                            </div>
                                                            <p class="mb-0 ps-3 pt-1 text-muted">You will be redirected to PayPal website to complete your purchase securely.</p>
                                                        </div>
                                                        <div class="col-sm-4 text-sm-end mt-3 mt-sm-0">
                                                            <img alt="paypal-img" height="32" src="/images/cards/paypal.svg" />
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- end Pay with Paypal box-->
                                                <!-- Credit/Debit Card box-->
                                                <div class="border p-3 mb-3 rounded">
                                                    <div class="row">
                                                        <div class="col-sm-8">
                                                            <div class="form-check">
                                                                <input checked="" class="form-check-input" id="BillingOptRadio1" name="billingOptions" type="radio" />
                                                                <label class="form-check-label font-16 fw-bold" for="BillingOptRadio1">Credit / Debit Card</label>
                                                            </div>
                                                            <p class="mb-0 ps-3 pt-1 text-muted">Safe money transfer using your bank account. We support Mastercard, Visa, Discover and Stripe.</p>
                                                        </div>
                                                        <div class="col-sm-4 text-sm-end mt-3 mt-sm-0">
                                                            <img alt="master-card-img" height="32" src="/images/cards/mastercard.svg" />
                                                            <img alt="discover-card-img" height="32" src="/images/cards/discover-card.svg" />
                                                            <img alt="visa-card-img" height="32" src="/images/cards/visa.svg" />
                                                            <img alt="stripe-card-img" height="32" src="/images/cards/stripe.svg" />
                                                        </div>
                                                    </div>
                                                    <!-- end row -->
                                                    <div class="row mt-4">
                                                        <div class="col-md-12">
                                                            <div class="alert alert-warning fs-xs py-2">
                                                                Enjoy an extra
                                                                <span class="fw-bold">10% discount</span>
                                                                when you pay with your
                                                                <span class="fw-bold">Credit Card</span>
                                                                .
                                                            </div>
                                                            <div class="mb-3">
                                                                <label class="form-label" for="card-number">Card Number</label>
                                                                <input class="form-control" data-mask-format="0000 0000 0000 0000" data-toggle="input-mask" id="card-number" placeholder="4242 4242 4242 4242" type="text" />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- end row -->
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="mb-3 mb-md-0">
                                                                <label class="form-label" for="card-name-on">Name on card</label>
                                                                <input class="form-control" id="card-name-on" placeholder="Master Dhanu" type="text" />
                                                            </div>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <div class="mb-3 mb-md-0">
                                                                <label class="form-label" for="card-expiry-date">Expiry date</label>
                                                                <input class="form-control" data-mask-format="00/00" data-toggle="input-mask" id="card-expiry-date" placeholder="MM/YY" type="text" />
                                                            </div>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <div class="mb-0">
                                                                <label class="form-label" for="card-cvv">CVV code</label>
                                                                <input class="form-control" data-mask-format="000" data-toggle="input-mask" id="card-cvv" placeholder="012" type="text" />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- end row -->
                                                </div>
                                                <!-- end Credit/Debit Card box-->
                                                <!-- Pay with Payoneer box-->
                                                <div class="border p-3 mb-3 rounded">
                                                    <div class="row">
                                                        <div class="col-sm-8">
                                                            <div class="form-check">
                                                                <input class="form-check-input" id="BillingOptRadio3" name="billingOptions" type="radio" />
                                                                <label class="form-check-label font-16 fw-bold" for="BillingOptRadio3">Pay with Payoneer</label>
                                                            </div>
                                                            <p class="mb-0 ps-3 pt-1 text-muted">You will be redirected to Payoneer website to complete your purchase securely.</p>
                                                        </div>
                                                        <div class="col-sm-4 text-sm-end mt-3 mt-sm-0">
                                                            <img alt="payoneer" height="32" src="/images/cards/payoneer.svg" />
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- end Pay with Payoneer box-->
                                                <!-- Cash on Delivery box-->
                                                <div class="border p-3 mb-3 rounded">
                                                    <div class="row">
                                                        <div class="col-sm-8">
                                                            <div class="form-check">
                                                                <input class="form-check-input" id="BillingOptRadio4" name="billingOptions" type="radio" />
                                                                <label class="form-check-label font-16 fw-bold" for="BillingOptRadio4">Cash on Delivery</label>
                                                            </div>
                                                            <p class="mb-0 ps-3 pt-1 text-muted">Pay with cash when your order is delivered.</p>
                                                        </div>
                                                        <div class="col-sm-4 text-sm-end mt-3 mt-sm-0">
                                                            <img alt="COD-img" height="24" src="/images/cards/cod.png" />
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- end Cash on Delivery box-->
                                                <div class="d-flex justify-content-between mt-3">
                                                    <button class="btn btn-secondary" data-wizard-prev="" type="button">← Shipping Info</button>
                                                    <button class="btn btn-primary" data-wizard-next="" type="button">Proceed →</button>
                                                </div>
                                            </div>
                                            <!-- Step 4: Parent Info -->
                                            <div class="tab-pane fade" id="parentInfo">
                                                <div class="p-4">
                                                    <div class="d-flex align-items-center gap-3 mb-3">
                                                        <div class="avatar-md flex-shrink-0">
                                                            <span class="avatar-title text-bg-success rounded-circle fs-22">
                                                                <i class="ti ti-check"></i>
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <p class="text-muted mb-0">Order #234000</p>
                                                            <h4 class="m-0">Thank you for your order!</h4>
                                                        </div>
                                                        <a class="link-reset text-decoration-underline link-offset-2 fw-semibold ms-auto" href="#">Track Order</a>
                                                    </div>
                                                    <hr class="border-top border-dashed" />
                                                    <div class="mt-4">
                                                        <h6 class="text-uppercase text-muted fw-bold">Delivery Address</h6>
                                                        <span class="fw-semibold d-block mb-1">Marcus Reynolds</span>
                                                        500 Howard Street, Floor 8
                                                        <br />
                                                        San Francisco, CA 94105
                                                        <br />
                                                        <abbr title="Phone">P:</abbr>
                                                        (415) 392-6400
                                                        <br />
                                                    </div>
                                                    <div class="mt-4">
                                                        <h6 class="text-uppercase text-muted fw-bold">Payment Info</h6>
                                                        <p>Credit card: xxxx xxxx xxxx 8521</p>
                                                    </div>
                                                    <div class="mt-4">
                                                        <a class="btn btn-success" href="#!">
                                                            <i class="ti ti-download me-1"></i>
                                                            Download Invoice
                                                        </a>
                                                        <a class="btn btn-link fw-semibold text-muted" href="/apps-ecommerce-products-grid">
                                                            <i class="ti ti-arrow-left me-1"></i>
                                                            Continue Shopping
                                                        </a>
                                                    </div>
                                                    <div class="p-4 alert alert-info mt-4 mb-0">
                                                        <h4 class="text-center pb-2 mb-1 text-dark">🎁 Great News! You’ve unlocked 25% off your next order!</h4>
                                                        <p class="text-center fst-italic mb-4">Apply the code below at checkout or find it anytime in your account.</p>
                                                        <div class="d-flex gap-2 mx-auto">
                                                            <input class="form-control border-0" readonly="" type="text" value="SAVE25NOW" />
                                                            <button class="btn btn-dark text-nowrap" type="button">Copy Code</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- tab-content -->
                                    </div>
                                    <!-- ins-wizard -->
                                </div>
                            </div>
                        </div>
                        <!-- Order Summary -->
                        <div class="col-lg-4">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Order Summary</h4>
                                    <span class="badge badge-soft-success ms-auto">03 Items</span>
                                </div>
                                <div class="card-body">
                                    <div class="d-flex align-items-center gap-3 mb-3">
                                        <img alt="MacBook Air" class="me-1 rounded" src="/images/products/2.png" width="42" />
                                        <div>
                                            <p class="mb-1 fw-semibold">
                                                <a class="link-reset" href="/apps-ecommerce-product-details">Apple MacBook Air M3 13”</a>
                                            </p>
                                            <p class="text-muted d-block mb-0">1 x $1,199</p>
                                        </div>
                                        <h5 class="mb-0 ms-auto">$1,199</h5>
                                    </div>
                                    <div class="d-flex align-items-center gap-3 mb-3">
                                        <img alt="Sony Headphones" class="me-1 rounded" src="/images/products/5.png" width="42" />
                                        <div>
                                            <p class="mb-1 fw-semibold">
                                                <a class="link-reset" href="/apps-ecommerce-product-details">Sony WH-1000XM5 Wireless Headphones</a>
                                            </p>
                                            <p class="text-muted d-block mb-0">1 x $349</p>
                                        </div>
                                        <h5 class="mb-0 ms-auto">$349</h5>
                                    </div>
                                    <div class="d-flex align-items-center gap-3">
                                        <img alt="Apple Watch" class="me-1 rounded" src="/images/products/7.png" width="42" />
                                        <div>
                                            <p class="mb-1 fw-semibold">
                                                <a class="link-reset" href="/apps-ecommerce-product-details">Apple Watch Series 9 GPS</a>
                                            </p>
                                            <p class="text-muted d-block mb-0">1 x $399</p>
                                        </div>
                                        <h5 class="mb-0 ms-auto">$399</h5>
                                    </div>
                                    <hr />
                                    <ul class="list-unstyled mb-0">
                                        <li class="d-flex justify-content-between mb-2">
                                            <span class="text-muted">Subtotal:</span>
                                            <span>$1,947.00</span>
                                        </li>
                                        <li class="d-flex justify-content-between mb-2">
                                            <span class="text-muted">Discount:</span>
                                            <span class="text-danger">- $120.00</span>
                                        </li>
                                        <li class="d-flex justify-content-between mb-2">
                                            <span class="text-muted">Tax collected:</span>
                                            <span>$65.85</span>
                                        </li>
                                        <li class="d-flex justify-content-between border-bottom pb-3 mb-3">
                                            <span class="text-muted">Shipping:</span>
                                            <span>Free</span>
                                        </li>
                                        <li class="d-flex justify-content-between align-items-center">
                                            <h6 class="text-uppercase text-muted mb-0">Estimated total:</h6>
                                            <h4 class="fw-bold mb-0">$1,892.85</h4>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <!-- Promo -->
                            <div class="card">
                                <div class="card-body">
                                    <p class="text-muted mb-0">
                                        🎉 Congratulations! You’ve earned
                                        <span class="fw-bold text-success">239 bonus points</span>
                                        !
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- InputMask Plugin js -->
        <script src="/plugins/inputmask/inputmask.min.js"></script>
        <!-- Inputmask Demo js -->
        <script src="/js/pages/form-inputmask.js"></script>
        <!-- Wizard Form Demo js -->
        <script src="/js/pages/form-wizard.js"></script>
    </body>
</html>
