<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Create/Edit Order')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Ecommerce', 'title' => 'Add/Edit Order')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title mb-0">Create Order</h4>
                                </div>
                                <div class="card-body">
                                    <form id="orderForm">
                                        <div class="row g-3">
                                            <!-- Order ID -->
                                            <div class="col-md-6">
                                                <label class="form-label">Order ID</label>
                                                <input class="form-control" disabled="" id="orderId" placeholder="#WB20100" type="text" />
                                            </div>
                                            <!-- Order Date -->
                                            <div class="col-md-6">
                                                <label class="form-label">Order Date</label>
                                                <input class="form-control flatpickr-input" data-altformat="F j, Y" data-provider="flatpickr" id="orderDate" required="" type="datetime-local" />
                                            </div>
                                            <!-- Customer Name -->
                                            <div class="col-md-6">
                                                <label class="form-label">Customer Name</label>
                                                <input class="form-control" id="customerName" placeholder="Mason Carter" required="" type="text" />
                                            </div>
                                            <!-- Customer Email -->
                                            <div class="col-md-6">
                                                <label class="form-label">Customer Email</label>
                                                <input class="form-control" id="customerEmail" placeholder="mason.carter@shopmail.com" required="" type="email" />
                                            </div>
                                            <!-- Product Name -->
                                            <div class="col-md-6">
                                                <label class="form-label">Product Name</label>
                                                <select class="form-select" id="productName" required="">
                                                    <option disabled="" selected="" value="">Select Product</option>
                                                    <option value="iPhone 15 Pro">iPhone 15 Pro</option>
                                                    <option value="MacBook Air M3">MacBook Air M3</option>
                                                    <option value="iPad Pro 13″ (M4)">iPad Pro 13″ (M4)</option>
                                                    <option value="Apple Watch Ultra 2">Apple Watch Ultra 2</option>
                                                    <option value="AirPods Pro (2nd Gen)">AirPods Pro (2nd Gen)</option>
                                                </select>
                                            </div>
                                            <!-- Quantity -->
                                            <div class="col-md-6">
                                                <label class="form-label">Quantity</label>
                                                <input class="form-control" id="quantity" min="1" required="" type="number" value="1" />
                                            </div>
                                            <!-- Amount -->
                                            <div class="col-md-6">
                                                <label class="form-label">Amount ($)</label>
                                                <input class="form-control" id="amount" placeholder="129.45" required="" step="0.01" type="number" />
                                            </div>
                                            <!-- Payment Status -->
                                            <div class="col-md-6">
                                                <label class="form-label">Payment Status</label>
                                                <select class="form-select" id="paymentStatus" required="">
                                                    <option value="Paid">Paid</option>
                                                    <option value="Pending">Pending</option>
                                                    <option value="Failed">Failed</option>
                                                </select>
                                            </div>
                                            <!-- Order Status -->
                                            <div class="col-md-6">
                                                <label class="form-label">Order Status</label>
                                                <select class="form-select" id="orderStatus" required="">
                                                    <option value="Ordered">Ordered</option>
                                                    <option value="Processing">Processing</option>
                                                    <option value="Delivered">Delivered</option>
                                                    <option value="Cancelled">Cancelled</option>
                                                    <option value="Returned">Returned</option>
                                                </select>
                                            </div>
                                            <!-- Payment Method -->
                                            <div class="col-md-6">
                                                <label class="form-label">Payment Method</label>
                                                <select class="form-select" id="paymentMethod" required="">
                                                    <option value="Visa">Visa</option>
                                                    <option value="Mastercard">Mastercard</option>
                                                    <option value="PayPal">PayPal</option>
                                                    <option value="COD">Cash on Delivery</option>
                                                </select>
                                            </div>
                                            <!-- Card Number -->
                                            <div class="col-md-6">
                                                <label class="form-label">Card Last 4 Digits</label>
                                                <input class="form-control" id="cardNumber" maxlength="4" placeholder="7832" type="text" />
                                            </div>
                                            <!-- Action Buttons -->
                                            <div class="col-12 text-center">
                                                <button class="btn btn-light me-2" data-bs-dismiss="modal" type="button">Cancel</button>
                                                <button class="btn btn-primary" type="submit">Save Order</button>
                                            </div>
                                        </div>
                                        <!-- end row -->
                                    </form>
                                </div>
                                <!-- end card-body-->
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>
    </body>
</html>
