<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Product Views')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Ecommerce', 'title' => 'Product Views')) ?>

                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="card" data-table="" data-table-rows-per-page="8">
                                <div class="card-header border-light justify-content-between">
                                    <div class="d-flex gap-2">
                                        <div class="app-search">
                                            <input class="form-control" data-table-search="" placeholder="Search report..." type="search" />
                                            <i class="ti ti-search app-search-icon text-muted"></i>
                                        </div>
                                        <button class="btn btn-danger d-none" data-table-delete-selected="">Delete</button>
                                    </div>
                                    <div class="d-flex align-items-center gap-2">
                                        <span class="me-2 fw-semibold">Filter By:</span>
                                        <!-- Sales Performance Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-range-filter="performance">
                                                <option value="All">Sales Performance</option>
                                                <option value="1000+">Top Selling</option>
                                                <option value="1-1000">Low Selling</option>
                                                <option value="0">No Sales</option>
                                            </select>
                                            <i class="ti ti-trending-up app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Records Per Page -->
                                        <div>
                                            <select class="form-select form-control my-1 my-md-0" data-table-set-rows-per-page="">
                                                <option value="5">5</option>
                                                <option value="10">10</option>
                                                <option value="15">15</option>
                                                <option value="20">20</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-custom table-centered table-select table-hover w-100 mb-0">
                                        <thead class="bg-light align-middle bg-opacity-25 thead-sm">
                                            <tr class="text-uppercase fs-xxs">
                                                <th class="ps-3" style="width: 1%">
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" data-table-select-all="" id="select-all-products" type="checkbox" value="option" />
                                                </th>
                                                <th data-table-sort="product">Product</th>
                                                <th data-table-sort="">SKU</th>
                                                <th data-table-sort="">Price</th>
                                                <th data-table-sort="rating">Rating</th>
                                                <th data-table-sort="">Views</th>
                                                <th data-column="performance" data-table-sort="">Orders</th>
                                                <th data-table-sort="">Conversation</th>
                                                <th style="width: 1%">Report</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!-- Product Row -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar-md me-3">
                                                            <img alt="Product" class="img-fluid rounded" src="/images/products/2.png" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-0">
                                                                <a class="link-reset" data-sort="product" href="/apps-ecommerce-product-details">Smart Fitness Watch</a>
                                                            </h5>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>FW-54201</td>
                                                <td>$129.99</td>
                                                <td>
                                                    <span class="text-warning">
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star"></i>
                                                        <!-- one empty -->
                                                    </span>
                                                    <span class="ms-1"><a class="link-reset fw-semibold" data-sort="rating" href="/apps-ecommerce-reviews">(54)</a></span>
                                                </td>
                                                <td>45.2k</td>
                                                <td>820</td>
                                                <td>7.3%</td>
                                                <td>
                                                    <div data-chart="apex" data-chart-type="bar"></div>
                                                </td>
                                            </tr>
                                            <!-- Product Row -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar-md me-3">
                                                            <img alt="Product" class="img-fluid rounded" src="/images/products/3.png" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-0">
                                                                <a class="link-reset" data-sort="product" href="/apps-ecommerce-product-details">Portable Bluetooth Speaker</a>
                                                            </h5>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>BS-20894</td>
                                                <td>$79.50</td>
                                                <td>
                                                    <span class="text-warning">
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star"></i>
                                                        <i class="ti ti-star"></i>
                                                        <!-- two empty -->
                                                    </span>
                                                    <span class="ms-1"><a class="link-reset fw-semibold" data-sort="rating" href="/apps-ecommerce-reviews">(31)</a></span>
                                                </td>
                                                <td>28.9k</td>
                                                <td>410</td>
                                                <td>5.8%</td>
                                                <td>
                                                    <div data-chart="apex" data-chart-type="line"></div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar-md me-3">
                                                            <img alt="Product" class="img-fluid rounded" src="/images/products/4.png" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-0"><a class="link-reset" data-sort="product" href="/apps-ecommerce-product-details">Gaming Mouse</a></h5>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>GM-77215</td>
                                                <td>$49.99</td>
                                                <td>
                                                    <span class="text-warning">
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star"></i>
                                                    </span>
                                                    <span class="ms-1"><a class="link-reset fw-semibold" data-sort="rating" href="/apps-ecommerce-reviews">(67)</a></span>
                                                </td>
                                                <td>22.4k</td>
                                                <td>340</td>
                                                <td>6.4%</td>
                                                <td>
                                                    <div data-chart="apex" data-chart-type="bar"></div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar-md me-3">
                                                            <img alt="Product" class="img-fluid rounded" src="/images/products/5.png" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-0"><a class="link-reset" data-sort="product" href="/apps-ecommerce-product-details">Noise Cancelling Headphones</a></h5>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>NC-88321</td>
                                                <td>$199.00</td>
                                                <td>
                                                    <span class="text-warning">
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                    </span>
                                                    <span class="ms-1"><a class="link-reset fw-semibold" data-sort="rating" href="/apps-ecommerce-reviews">(128)</a></span>
                                                </td>
                                                <td>60.1k</td>
                                                <td>1500</td>
                                                <td>9.8%</td>
                                                <td>
                                                    <div data-chart="apex" data-chart-type="line"></div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar-md me-3">
                                                            <img alt="Product" class="img-fluid rounded" src="/images/products/6.png" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-0"><a class="link-reset" data-sort="product" href="/apps-ecommerce-product-details">4K Action Camera</a></h5>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>AC-90763</td>
                                                <td>$249.99</td>
                                                <td>
                                                    <span class="text-warning">
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star"></i>
                                                    </span>
                                                    <span class="ms-1"><a class="link-reset fw-semibold" data-sort="rating" href="/apps-ecommerce-reviews">(94)</a></span>
                                                </td>
                                                <td>18.9k</td>
                                                <td>610</td>
                                                <td>6.0%</td>
                                                <td>
                                                    <div data-chart="apex" data-chart-type="bar"></div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar-md me-3">
                                                            <img alt="Product" class="img-fluid rounded" src="/images/products/7.png" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-0"><a class="link-reset" data-sort="product" href="/apps-ecommerce-product-details">Wireless Charger Pad</a></h5>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>WC-23815</td>
                                                <td>$39.95</td>
                                                <td>
                                                    <span class="text-warning">
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star"></i>
                                                        <i class="ti ti-star"></i>
                                                    </span>
                                                    <span class="ms-1"><a class="link-reset fw-semibold" data-sort="rating" href="/apps-ecommerce-reviews">(41)</a></span>
                                                </td>
                                                <td>12.3k</td>
                                                <td>220</td>
                                                <td>4.1%</td>
                                                <td>
                                                    <div data-chart="apex" data-chart-type="line"></div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar-md me-3">
                                                            <img alt="Product" class="img-fluid rounded" src="/images/products/8.png" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-0"><a class="link-reset" data-sort="product" href="/apps-ecommerce-product-details">Mechanical Keyboard</a></h5>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>MK-48519</td>
                                                <td>$89.00</td>
                                                <td>
                                                    <span class="text-warning">
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star"></i>
                                                    </span>
                                                    <span class="ms-1"><a class="link-reset fw-semibold" data-sort="rating" href="/apps-ecommerce-reviews">(77)</a></span>
                                                </td>
                                                <td>30.5k</td>
                                                <td>540</td>
                                                <td>7.2%</td>
                                                <td>
                                                    <div data-chart="apex" data-chart-type="bar"></div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar-md me-3">
                                                            <img alt="Product" class="img-fluid rounded" src="/images/products/9.png" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-0"><a class="link-reset" data-sort="product" href="/apps-ecommerce-product-details">Drone with Camera</a></h5>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>DR-61208</td>
                                                <td>$399.00</td>
                                                <td>
                                                    <span class="text-warning">
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                    </span>
                                                    <span class="ms-1"><a class="link-reset fw-semibold" data-sort="rating" href="/apps-ecommerce-reviews">(189)</a></span>
                                                </td>
                                                <td>75.9k</td>
                                                <td>1900</td>
                                                <td>10.2%</td>
                                                <td>
                                                    <div data-chart="apex" data-chart-type="line"></div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar-md me-3">
                                                            <img alt="Product" class="img-fluid rounded" src="/images/products/10.png" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-0"><a class="link-reset" data-sort="product" href="/apps-ecommerce-product-details">Smart Home Hub</a></h5>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>SH-30051</td>
                                                <td>$149.99</td>
                                                <td>
                                                    <span class="text-warning">
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star"></i>
                                                        <i class="ti ti-star"></i>
                                                    </span>
                                                    <span class="ms-1"><a class="link-reset fw-semibold" data-sort="rating" href="/apps-ecommerce-reviews">(58)</a></span>
                                                </td>
                                                <td>21.7k</td>
                                                <td>470</td>
                                                <td>5.5%</td>
                                                <td>
                                                    <div data-chart="apex" data-chart-type="bar"></div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar-md me-3">
                                                            <img alt="Product" class="img-fluid rounded" src="/images/products/1.png" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-0"><a class="link-reset" data-sort="product" href="/apps-ecommerce-product-details">Mini Projector</a></h5>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>MP-12081</td>
                                                <td>$219.00</td>
                                                <td>
                                                    <span class="text-warning">
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star-filled"></i>
                                                        <i class="ti ti-star"></i>
                                                        <i class="ti ti-star"></i>
                                                    </span>
                                                    <span class="ms-1"><a class="link-reset fw-semibold" data-sort="rating" href="/apps-ecommerce-reviews">(35)</a></span>
                                                </td>
                                                <td>15.9k</td>
                                                <td>310</td>
                                                <td>4.7%</td>
                                                <td>
                                                    <div data-chart="apex" data-chart-type="line"></div>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="card-footer border-0">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div data-table-pagination-info="products"></div>
                                        <div data-table-pagination=""></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                    </div>
                    <!-- end row -->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Apex Charts js -->
        <script src="/plugins/apexcharts/apexcharts.min.js"></script>
        <!-- Custom table -->
        <script src="/js/pages/custom-table.js"></script>
        <!-- Ecommerce Products view Js -->
        <script src="/js/pages/ecommerce-product-views.js"></script>
    </body>
</html>
