<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Purchased Orders')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Ecommerce', 'title' => 'Purchased Orders')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card" data-table="" data-table-rows-per-page="10">
                                <div class="card-header border-light justify-content-between">
                                    <div class="d-flex gap-2">
                                        <div class="app-search">
                                            <input class="form-control" data-table-search="" placeholder="Search..." type="search" />
                                            <i class="ti ti-search app-search-icon text-muted"></i>
                                        </div>
                                        <button class="btn btn-danger d-none" data-table-delete-selected="">Delete</button>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                        <span class="me-2 fw-semibold">Filter By:</span>
                                        <!-- Payment Status Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="payment-status">
                                                <option value="All">Payment Status</option>
                                                <option value="Paid">Paid</option>
                                                <option value="Pending">Pending</option>
                                                <option value="Unpaid">Unpaid</option>
                                                <option value="Overdue">Overdue</option>
                                            </select>
                                            <i class="ti ti-credit-card app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Order Status Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="order-status">
                                                <option value="All">Order Status</option>
                                                <option value="Completed">Completed</option>
                                                <option value="Processing">Processing</option>
                                                <option value="Partially Received">Partially Received</option>
                                                <option value="Pending Delivery">Pending Delivery</option>
                                                <option value="Awaiting Delivery">Awaiting Delivery</option>
                                                <option value="Awaiting Shipment">Awaiting Shipment</option>
                                                <option value="Cancelled">Cancelled</option>
                                                <option value="In Progress">In Progress</option>
                                            </select>
                                            <i class="ti ti-truck app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Records Per Page -->
                                        <div>
                                            <select class="form-select form-control my-1 my-md-0" data-table-set-rows-per-page="">
                                                <option value="5">5</option>
                                                <option value="10">10</option>
                                                <option value="15">15</option>
                                                <option value="20">20</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="d-flex gap-1">
                                        <a class="btn btn-danger ms-1" data-bs-toggle="modal" href="#addPurchaseOrderModal">
                                            <i class="ti ti-plus fs-sm me-2"></i>
                                            Add New
                                        </a>
                                    </div>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-custom table-centered table-select table-hover w-100 mb-0">
                                        <thead class="bg-light align-middle bg-opacity-25 thead-sm">
                                            <tr class="text-uppercase fs-xxs">
                                                <th class="ps-3" style="width: 1%">
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" data-table-select-all="" id="select-all-orders" type="checkbox" />
                                                </th>
                                                <th data-table-sort="">PO Number</th>
                                                <th data-table-sort="">Supplier</th>
                                                <th data-table-sort="">Items</th>
                                                <th data-table-sort="">Order Date</th>
                                                <th data-table-sort="">Delivery Date</th>
                                                <th data-table-sort="">Total Amount</th>
                                                <th data-column="payment-status" data-table-sort="">Payment Status</th>
                                                <th data-column="order-status" data-table-sort="">Order Status</th>
                                                <th class="text-center" style="width: 1%">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!-- Purchase Order Row -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 order-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <a class="fw-semibold link-reset" href="#!">PO-2025-0148</a>
                                                </td>
                                                <td>
                                                    <div>
                                                        <h6 class="mb-0 fw-medium fs-base">TechVision Supplies</h6>
                                                        <p class="text-muted fs-xs mb-0">techvision@email.com</p>
                                                    </div>
                                                </td>
                                                <td>12 Items</td>
                                                <td>
                                                    05 Oct, 2025
                                                    <small class="text-muted">09:15 AM</small>
                                                </td>
                                                <td>
                                                    10 Oct, 2025
                                                    <small class="text-muted">Expected</small>
                                                </td>
                                                <td><h5 class="fs-base mb-0 fw-medium">$3,480.00</h5></td>
                                                <td>
                                                    <span class="badge badge-label badge-soft-success fs-xxs">Paid</span>
                                                </td>
                                                <td>
                                                    <span class="badge badge-label badge-soft-primary fs-xxs">Received</span>
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 1 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 order-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td><a class="fw-semibold link-reset" href="#!">PO-2025-0149</a></td>
                                                <td>
                                                    <div>
                                                        <h6 class="mb-0 fw-medium fs-base">Global Stationers</h6>
                                                        <p class="text-muted fs-xs mb-0">orders@globalstationers.com</p>
                                                    </div>
                                                </td>
                                                <td>8 Items</td>
                                                <td>
                                                    06 Oct, 2025
                                                    <small class="text-muted">02:45 PM</small>
                                                </td>
                                                <td>
                                                    12 Oct, 2025
                                                    <small class="text-muted">Expected</small>
                                                </td>
                                                <td><h5 class="fs-base mb-0 fw-medium">$1,260.00</h5></td>
                                                <td><span class="badge badge-label badge-soft-warning fs-xxs">Pending</span></td>
                                                <td><span class="badge badge-label badge-soft-info fs-xxs">Processing</span></td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 2 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 order-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td><a class="fw-semibold link-reset" href="#!">PO-2025-0150</a></td>
                                                <td>
                                                    <div>
                                                        <h6 class="mb-0 fw-medium fs-base">NextGen Components</h6>
                                                        <p class="text-muted fs-xs mb-0">support@nextgen.com</p>
                                                    </div>
                                                </td>
                                                <td>25 Items</td>
                                                <td>
                                                    02 Oct, 2025
                                                    <small class="text-muted">11:05 AM</small>
                                                </td>
                                                <td>
                                                    09 Oct, 2025
                                                    <small class="text-muted">Expected</small>
                                                </td>
                                                <td><h5 class="fs-base mb-0 fw-medium">$7,920.00</h5></td>
                                                <td><span class="badge badge-label badge-soft-success fs-xxs">Paid</span></td>
                                                <td><span class="badge badge-label badge-soft-warning fs-xxs">Partially Received</span></td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 3 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 order-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td><a class="fw-semibold link-reset" href="#!">PO-2025-0151</a></td>
                                                <td>
                                                    <div>
                                                        <h6 class="mb-0 fw-medium fs-base">EcoHome Essentials</h6>
                                                        <p class="text-muted fs-xs mb-0">contact@ecohome.com</p>
                                                    </div>
                                                </td>
                                                <td>5 Items</td>
                                                <td>
                                                    04 Oct, 2025
                                                    <small class="text-muted">03:30 PM</small>
                                                </td>
                                                <td>
                                                    09 Oct, 2025
                                                    <small class="text-muted">Delivered</small>
                                                </td>
                                                <td><h5 class="fs-base mb-0 fw-medium">$980.00</h5></td>
                                                <td><span class="badge badge-label badge-soft-danger fs-xxs">Unpaid</span></td>
                                                <td><span class="badge badge-label badge-soft-success fs-xxs">Completed</span></td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 4 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 order-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td><a class="fw-semibold link-reset" href="#!">PO-2025-0152</a></td>
                                                <td>
                                                    <div>
                                                        <h6 class="mb-0 fw-medium fs-base">BrightLine Textiles</h6>
                                                        <p class="text-muted fs-xs mb-0">info@brightline.com</p>
                                                    </div>
                                                </td>
                                                <td>16 Items</td>
                                                <td>
                                                    07 Oct, 2025
                                                    <small class="text-muted">08:20 AM</small>
                                                </td>
                                                <td>
                                                    14 Oct, 2025
                                                    <small class="text-muted">Expected</small>
                                                </td>
                                                <td><h5 class="fs-base mb-0 fw-medium">$4,250.00</h5></td>
                                                <td><span class="badge badge-label badge-soft-success fs-xxs">Paid</span></td>
                                                <td><span class="badge badge-label badge-soft-warning fs-xxs">Pending Delivery</span></td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 5 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 order-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td><a class="fw-semibold link-reset" href="#!">PO-2025-0153</a></td>
                                                <td>
                                                    <div>
                                                        <h6 class="mb-0 fw-medium fs-base">Urban Office Supplies</h6>
                                                        <p class="text-muted fs-xs mb-0">sales@urbanoffice.com</p>
                                                    </div>
                                                </td>
                                                <td>9 Items</td>
                                                <td>
                                                    03 Oct, 2025
                                                    <small class="text-muted">01:10 PM</small>
                                                </td>
                                                <td>
                                                    07 Oct, 2025
                                                    <small class="text-muted">Delivered</small>
                                                </td>
                                                <td><h5 class="fs-base mb-0 fw-medium">$2,340.00</h5></td>
                                                <td><span class="badge badge-label badge-soft-danger fs-xxs">Overdue</span></td>
                                                <td><span class="badge badge-label badge-soft-danger fs-xxs">Cancelled</span></td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 6 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 order-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td><a class="fw-semibold link-reset" href="#!">PO-2025-0154</a></td>
                                                <td>
                                                    <div>
                                                        <h6 class="mb-0 fw-medium fs-base">Northway Electronics</h6>
                                                        <p class="text-muted fs-xs mb-0">contact@northway.com</p>
                                                    </div>
                                                </td>
                                                <td>14 Items</td>
                                                <td>
                                                    08 Oct, 2025
                                                    <small class="text-muted">10:00 AM</small>
                                                </td>
                                                <td>
                                                    15 Oct, 2025
                                                    <small class="text-muted">Expected</small>
                                                </td>
                                                <td><h5 class="fs-base mb-0 fw-medium">$5,610.00</h5></td>
                                                <td><span class="badge badge-label badge-soft-warning fs-xxs">Pending</span></td>
                                                <td><span class="badge badge-label badge-soft-info fs-xxs">In Progress</span></td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 7 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 order-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td><a class="fw-semibold link-reset" href="#!">PO-2025-0155</a></td>
                                                <td>
                                                    <div>
                                                        <h6 class="mb-0 fw-medium fs-base">Apex Industrial Tools</h6>
                                                        <p class="text-muted fs-xs mb-0">sales@apextools.com</p>
                                                    </div>
                                                </td>
                                                <td>20 Items</td>
                                                <td>
                                                    01 Oct, 2025
                                                    <small class="text-muted">04:30 PM</small>
                                                </td>
                                                <td>
                                                    06 Oct, 2025
                                                    <small class="text-muted">Delivered</small>
                                                </td>
                                                <td><h5 class="fs-base mb-0 fw-medium">$9,875.00</h5></td>
                                                <td><span class="badge badge-label badge-soft-success fs-xxs">Paid</span></td>
                                                <td><span class="badge badge-label badge-soft-success fs-xxs">Completed</span></td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 8 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 order-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td><a class="fw-semibold link-reset" href="#!">PO-2025-0156</a></td>
                                                <td>
                                                    <div>
                                                        <h6 class="mb-0 fw-medium fs-base">GreenLeaf Packaging</h6>
                                                        <p class="text-muted fs-xs mb-0">hello@greenleafpack.com</p>
                                                    </div>
                                                </td>
                                                <td>7 Items</td>
                                                <td>
                                                    09 Oct, 2025
                                                    <small class="text-muted">11:50 AM</small>
                                                </td>
                                                <td>
                                                    15 Oct, 2025
                                                    <small class="text-muted">Expected</small>
                                                </td>
                                                <td><h5 class="fs-base mb-0 fw-medium">$2,120.00</h5></td>
                                                <td><span class="badge badge-label badge-soft-warning fs-xxs">Pending</span></td>
                                                <td><span class="badge badge-label badge-soft-secondary fs-xxs">Awaiting Shipment</span></td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 9 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 order-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td><a class="fw-semibold link-reset" href="#!">PO-2025-0157</a></td>
                                                <td>
                                                    <div>
                                                        <h6 class="mb-0 fw-medium fs-base">BlueSky Furnishings</h6>
                                                        <p class="text-muted fs-xs mb-0">orders@bluesky.com</p>
                                                    </div>
                                                </td>
                                                <td>10 Items</td>
                                                <td>
                                                    06 Oct, 2025
                                                    <small class="text-muted">09:40 AM</small>
                                                </td>
                                                <td>
                                                    11 Oct, 2025
                                                    <small class="text-muted">Expected</small>
                                                </td>
                                                <td><h5 class="fs-base mb-0 fw-medium">$3,950.00</h5></td>
                                                <td><span class="badge badge-label badge-soft-success fs-xxs">Paid</span></td>
                                                <td><span class="badge badge-label badge-soft-info fs-xxs">Awaiting Delivery</span></td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 10 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 order-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td><a class="fw-semibold link-reset" href="#!">PO-2025-0158</a></td>
                                                <td>
                                                    <div>
                                                        <h6 class="mb-0 fw-medium fs-base">PrimeTech Hardware</h6>
                                                        <p class="text-muted fs-xs mb-0">info@primetech.com</p>
                                                    </div>
                                                </td>
                                                <td>18 Items</td>
                                                <td>
                                                    05 Oct, 2025
                                                    <small class="text-muted">05:25 PM</small>
                                                </td>
                                                <td>
                                                    13 Oct, 2025
                                                    <small class="text-muted">Expected</small>
                                                </td>
                                                <td><h5 class="fs-base mb-0 fw-medium">$6,730.00</h5></td>
                                                <td><span class="badge badge-label badge-soft-danger fs-xxs">Overdue</span></td>
                                                <td><span class="badge badge-label badge-soft-danger fs-xxs">Cancelled</span></td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="card-footer border-0">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div data-table-pagination-info="products"></div>
                                        <div data-table-pagination=""></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                    </div>
                    <!-- end row -->
                    <!-- Add New Purchase Order Modal -->
                    <div aria-hidden="true" aria-labelledby="addPurchaseOrderModalLabel" class="modal fade" id="addPurchaseOrderModal" tabindex="-1">
                        <div class="modal-dialog modal-dialog-centered modal-lg">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title fw-semibold" id="addPurchaseOrderModalLabel">
                                        <i class="ti ti-file-text me-2 text-danger"></i>
                                        Add New Purchase Order
                                    </h5>
                                    <button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"></button>
                                </div>
                                <form action="#!" method="post">
                                    <div class="modal-body">
                                        <div class="row g-3">
                                            <!-- PO Number -->
                                            <div class="col-md-6">
                                                <label class="form-label fw-semibold" for="poNumber">PO Number</label>
                                                <input class="form-control" id="poNumber" placeholder="PO-2025-0149" type="text" />
                                            </div>
                                            <!-- Supplier Name -->
                                            <div class="col-md-6">
                                                <label class="form-label fw-semibold" for="supplierName">Supplier Name</label>
                                                <input class="form-control" id="supplierName" placeholder="Global Tech Supplies" type="text" />
                                            </div>
                                            <!-- Supplier Email -->
                                            <div class="col-md-6">
                                                <label class="form-label fw-semibold" for="supplierEmail">Supplier Email</label>
                                                <input class="form-control" id="supplierEmail" placeholder="globaltech@email.com" type="email" />
                                            </div>
                                            <!-- Items -->
                                            <div class="col-md-6">
                                                <label class="form-label fw-semibold" for="poItems">Items Count</label>
                                                <input class="form-control" id="poItems" placeholder="10" type="number" />
                                            </div>
                                            <!-- Order Date -->
                                            <div class="col-md-6">
                                                <label class="form-label fw-semibold" for="orderDate">Order Date</label>
                                                <input class="form-control" data-date-format="d M, Y" data-provider="flatpickr" id="orderDate" type="date" value="2025-10-05" />
                                            </div>
                                            <!-- Delivery Date -->
                                            <div class="col-md-6">
                                                <label class="form-label fw-semibold" for="deliveryDate">Delivery Date</label>
                                                <input class="form-control" data-date-format="d M, Y" data-provider="flatpickr" id="deliveryDate" type="date" value="2025-10-10" />
                                            </div>
                                            <!-- Total Amount -->
                                            <div class="col-md-6">
                                                <label class="form-label fw-semibold" for="totalAmount">Total Amount</label>
                                                <div class="input-group">
                                                    <span class="input-group-text">$</span>
                                                    <input class="form-control" id="totalAmount" placeholder="3480.00" step="0.01" type="number" />
                                                </div>
                                            </div>
                                            <!-- Payment Status -->
                                            <div class="col-md-6">
                                                <label class="form-label fw-semibold" for="paymentStatus">Payment Status</label>
                                                <select class="form-select" id="paymentStatus">
                                                    <option selected="">Paid</option>
                                                    <option>Pending</option>
                                                    <option>Partially Paid</option>
                                                    <option>Unpaid</option>
                                                </select>
                                            </div>
                                            <!-- Order Status -->
                                            <div class="col-md-6">
                                                <label class="form-label fw-semibold" for="orderStatus">Order Status</label>
                                                <select class="form-select" id="orderStatus">
                                                    <option selected="">Received</option>
                                                    <option>Processing</option>
                                                    <option>Dispatched</option>
                                                    <option>Cancelled</option>
                                                </select>
                                            </div>
                                            <!-- Notes -->
                                            <div class="col-md-12">
                                                <label class="form-label fw-semibold" for="poNotes">Additional Notes</label>
                                                <textarea class="form-control" id="poNotes" placeholder="Add any special instructions or remarks here..." rows="2"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button class="btn btn-light" data-bs-dismiss="modal" type="button">Cancel</button>
                                        <button class="btn btn-danger" type="submit">
                                            <i class="ti ti-check me-1"></i>
                                            Save Purchase Order
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Custom table -->
        <script src="/js/pages/custom-table.js"></script>
    </body>
</html>
