<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Expense Categories')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Finance', 'title' => 'Expense Categories')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card" data-table="" data-table-rows-per-page="8">
                                <div class="card-header border-light justify-content-between">
                                    <div class="d-flex gap-2">
                                        <!-- Search -->
                                        <div class="app-search">
                                            <input class="form-control" data-table-search="" placeholder="Search categories..." type="search" />
                                            <i class="ti ti-search app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Add New Category -->
                                        <button class="btn btn-primary" data-bs-target="#categoryModal" data-bs-toggle="modal">
                                            <i class="ti ti-plus me-1"></i>
                                            Add Category
                                        </button>
                                        <!-- Delete Selected -->
                                        <button class="btn btn-danger d-none" data-table-delete-selected="">Delete</button>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                        <span class="me-2 fw-semibold">Filter By:</span>
                                        <!-- Status Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="status">
                                                <option value="">Status</option>
                                                <option value="Active">Active</option>
                                                <option value="Inactive">Inactive</option>
                                            </select>
                                            <i class="ti ti-circle-check app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Records Per Page -->
                                        <div>
                                            <select class="form-select form-control my-1 my-md-0" data-table-set-rows-per-page="">
                                                <option value="5">5</option>
                                                <option selected="" value="10">10</option>
                                                <option value="15">15</option>
                                                <option value="20">20</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table table-custom table-centered table-select table-hover w-100 mb-0">
                                            <thead class="bg-light align-middle bg-opacity-25 thead-sm text-nowrap">
                                                <tr class="text-uppercase fs-xxs">
                                                    <th class="ps-3" style="width: 1%">
                                                        <input class="form-check-input form-check-input-light fs-14 mt-0" data-table-select-all="" type="checkbox" />
                                                    </th>
                                                    <th data-table-sort="">ID</th>
                                                    <th data-table-sort="">Category Name</th>
                                                    <th data-table-sort="">Total Expenses</th>
                                                    <th data-column="status" data-table-sort="">Status</th>
                                                    <th data-table-sort="">Last Updated</th>
                                                    <th class="text-center" style="width: 1%">Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody class="text-nowrap">
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#CAT-001</a></td>
                                                    <td>Office Supplies</td>
                                                    <td>$2,845.60</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Active</span></td>
                                                    <td>
                                                        10 Oct, 2025
                                                        <small class="text-muted">04:10 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#CAT-002</a></td>
                                                    <td>Travel</td>
                                                    <td>$5,920.00</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Active</span></td>
                                                    <td>
                                                        08 Oct, 2025
                                                        <small class="text-muted">11:00 AM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#CAT-003</a></td>
                                                    <td>Meals</td>
                                                    <td>$1,280.75</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Active</span></td>
                                                    <td>
                                                        05 Oct, 2025
                                                        <small class="text-muted">07:45 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#CAT-004</a></td>
                                                    <td>Entertainment</td>
                                                    <td>$2,140.20</td>
                                                    <td><span class="badge bg-warning-subtle text-warning badge-label">Inactive</span></td>
                                                    <td>
                                                        03 Oct, 2025
                                                        <small class="text-muted">09:25 AM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#CAT-005</a></td>
                                                    <td>Equipment</td>
                                                    <td>$4,580.00</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Active</span></td>
                                                    <td>
                                                        01 Oct, 2025
                                                        <small class="text-muted">03:15 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#CAT-006</a></td>
                                                    <td>Maintenance</td>
                                                    <td>$3,210.40</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Active</span></td>
                                                    <td>
                                                        28 Sep, 2025
                                                        <small class="text-muted">02:00 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#CAT-007</a></td>
                                                    <td>Training &amp; Events</td>
                                                    <td>$6,845.00</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Active</span></td>
                                                    <td>
                                                        25 Sep, 2025
                                                        <small class="text-muted">10:35 AM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#CAT-008</a></td>
                                                    <td>Subscriptions</td>
                                                    <td>$980.75</td>
                                                    <td><span class="badge bg-warning-subtle text-warning badge-label">Inactive</span></td>
                                                    <td>
                                                        21 Sep, 2025
                                                        <small class="text-muted">09:50 AM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#CAT-009</a></td>
                                                    <td>Marketing</td>
                                                    <td>$9,475.90</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Active</span></td>
                                                    <td>
                                                        18 Sep, 2025
                                                        <small class="text-muted">01:40 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#CAT-010</a></td>
                                                    <td>Insurance</td>
                                                    <td>$2,540.00</td>
                                                    <td><span class="badge bg-danger-subtle text-danger badge-label">Inactive</span></td>
                                                    <td>
                                                        15 Sep, 2025
                                                        <small class="text-muted">05:15 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    <!-- end table responsive -->
                                </div>
                                <!-- end card-body -->
                                <div class="card-footer border-0">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div data-table-pagination-info="Expense Categories"></div>
                                        <div data-table-pagination=""></div>
                                    </div>
                                </div>
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->
                    </div>
                    <!-- end row -->
                    <!-- Add / Edit Expense Category Modal -->
                    <div aria-hidden="true" aria-labelledby="categoryModalLabel" class="modal fade" id="categoryModal" tabindex="-1">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content border-0 shadow-sm">
                                <div class="modal-header bg-light border-bottom">
                                    <h5 class="modal-title fw-semibold" id="categoryModalLabel">
                                        <span class="me-1" data-icon="layers"></span>
                                        Add Expense Category
                                    </h5>
                                    <button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"></button>
                                </div>
                                <form id="categoryForm">
                                    <div class="modal-body">
                                        <div class="row g-3">
                                            <!-- Category Name -->
                                            <div class="col-12">
                                                <label class="form-label" for="categoryName">
                                                    Category Name
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <input class="form-control" id="categoryName" placeholder="Enter category name" required="" type="text" />
                                            </div>
                                            <!-- Description -->
                                            <div class="col-12">
                                                <label class="form-label" for="categoryDescription">Description</label>
                                                <textarea class="form-control" id="categoryDescription" placeholder="Optional notes about this category" rows="3"></textarea>
                                            </div>
                                            <!-- Status -->
                                            <div class="col-12">
                                                <label class="form-label" for="categoryStatus">Status</label>
                                                <select class="form-select" id="categoryStatus">
                                                    <option selected="" value="Active">Active</option>
                                                    <option value="Inactive">Inactive</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer border-top">
                                        <button class="btn btn-light" data-bs-dismiss="modal" type="button">Cancel</button>
                                        <button class="btn btn-primary" type="submit">
                                            <i class="ti ti-device-floppy me-1"></i>
                                            Save Category
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Custom table -->
        <script src="/js/pages/custom-table.js"></script>
    </body>
</html>
