<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Income')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Finance', 'title' => 'Income')) ?>

                    <div class="row row-cols-xxl-4 row-cols-md-2 row-cols-1">
                        <!-- Total Income Widget -->
                        <div class="col">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="avatar fs-60 avatar-img-size flex-shrink-0">
                                            <span class="avatar-title bg-primary-subtle text-primary rounded-circle fs-24">
                                                <i class="ti ti-currency-dollar"></i>
                                            </span>
                                        </div>
                                        <div class="text-end">
                                            <h3 class="mb-2 fw-normal">
                                                $
                                                <span data-target="45280">0</span>
                                            </h3>
                                            <p class="mb-0 text-muted"><span>Total Income</span></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                        <!-- Received Income Widget -->
                        <div class="col">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="avatar fs-60 avatar-img-size flex-shrink-0">
                                            <span class="avatar-title bg-success-subtle text-success rounded-circle fs-24">
                                                <i class="ti ti-wallet"></i>
                                            </span>
                                        </div>
                                        <div class="text-end">
                                            <h3 class="mb-2 fw-normal">
                                                $
                                                <span data-target="38560">0</span>
                                            </h3>
                                            <p class="mb-0 text-muted"><span>Received Income</span></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                        <!-- Pending Payments Widget -->
                        <div class="col">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="avatar fs-60 avatar-img-size flex-shrink-0">
                                            <span class="avatar-title bg-warning-subtle text-warning rounded-circle fs-24">
                                                <i class="ti ti-hourglass"></i>
                                            </span>
                                        </div>
                                        <div class="text-end">
                                            <h3 class="mb-2 fw-normal">
                                                $
                                                <span data-target="4860">0</span>
                                            </h3>
                                            <p class="mb-0 text-muted"><span>Pending Payments</span></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                        <!-- Refunded Income Widget -->
                        <div class="col">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="avatar fs-60 avatar-img-size flex-shrink-0">
                                            <span class="avatar-title bg-danger-subtle text-danger rounded-circle fs-24">
                                                <i class="ti ti-credit-card-refund"></i>
                                            </span>
                                        </div>
                                        <div class="text-end">
                                            <h3 class="mb-2 fw-normal">
                                                $
                                                <span data-target="1120">0</span>
                                            </h3>
                                            <p class="mb-0 text-muted"><span>Refunded Income</span></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                    </div>
                    <!-- end row -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card" data-table="" data-table-rows-per-page="8">
                                <div class="card-header border-light justify-content-between">
                                    <div class="d-flex gap-2">
                                        <!-- Search -->
                                        <div class="app-search">
                                            <input class="form-control" data-table-search="" placeholder="Search income..." type="search" />
                                            <i class="ti ti-search app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Add New Income -->
                                        <button class="btn btn-primary" data-bs-target="#incomeModal" data-bs-toggle="modal">
                                            <i class="ti ti-plus me-1"></i>
                                            Add Income
                                        </button>
                                        <!-- Delete Selected -->
                                        <button class="btn btn-danger d-none" data-table-delete-selected="">Delete</button>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                        <span class="me-2 fw-semibold">Filter By:</span>
                                        <!-- Source Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="income-source">
                                                <option value="">Source</option>
                                                <option value="Sales">Sales</option>
                                                <option value="Services">Services</option>
                                                <option value="Consulting">Consulting</option>
                                                <option value="Investments">Investments</option>
                                                <option value="Affiliate">Affiliate</option>
                                                <option value="Other">Other</option>
                                            </select>
                                            <i class="ti ti-briefcase app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Status Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="status">
                                                <option value="">Status</option>
                                                <option value="Received">Received</option>
                                                <option value="Pending">Pending</option>
                                                <option value="Failed">Failed</option>
                                                <option value="Refunded">Refunded</option>
                                            </select>
                                            <i class="ti ti-circle-check app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Records Per Page -->
                                        <div>
                                            <select class="form-select form-control my-1 my-md-0" data-table-set-rows-per-page="">
                                                <option value="5">5</option>
                                                <option selected="" value="10">10</option>
                                                <option value="15">15</option>
                                                <option value="20">20</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table table-custom table-centered table-select table-hover w-100 mb-0">
                                            <thead class="bg-light align-middle bg-opacity-25 thead-sm text-nowrap">
                                                <tr class="text-uppercase fs-xxs">
                                                    <th class="ps-3" style="width: 1%">
                                                        <input class="form-check-input form-check-input-light fs-14 mt-0" data-table-select-all="" type="checkbox" />
                                                    </th>
                                                    <th data-table-sort="">ID</th>
                                                    <th>Income Title</th>
                                                    <th data-column="income-source" data-table-sort="">Source</th>
                                                    <th>Payment Type</th>
                                                    <th data-table-sort="">Amount</th>
                                                    <th data-column="status" data-table-sort="">Status</th>
                                                    <th data-table-sort="">Date</th>
                                                    <th data-table-sort="">Received By</th>
                                                    <th class="text-center" style="width: 1%">Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody class="text-nowrap">
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#INC-1001</a></td>
                                                    <td>Website Development Payment</td>
                                                    <td data-column="income-source">Services</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="Visa" class="me-2" height="26" src="/images/cards/visa.svg" />
                                                            <span>**** 3294</span>
                                                        </div>
                                                    </td>
                                                    <td>$1,250.00</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Received</span></td>
                                                    <td>
                                                        03 Oct, 2025
                                                        <small class="text-muted">11:00 AM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Emily Clark" class="avatar-xs rounded-circle" src="/images/users/user-3.jpg" />
                                                            <span>Emily Clark</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!">
                                                                <i class="ti ti-eye fs-lg"></i>
                                                            </a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!">
                                                                <i class="ti ti-edit fs-lg"></i>
                                                            </a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                                <i class="ti ti-trash fs-lg"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#INC-1002</a></td>
                                                    <td>Consulting Fees (Q3)</td>
                                                    <td data-column="income-source">Consulting</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="MasterCard" class="me-2" height="26" src="/images/cards/mastercard.svg" />
                                                            <span>**** 8712</span>
                                                        </div>
                                                    </td>
                                                    <td>$780.00</td>
                                                    <td><span class="badge bg-warning-subtle text-warning badge-label">Pending</span></td>
                                                    <td>
                                                        01 Oct, 2025
                                                        <small class="text-muted">04:20 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Daniel Ray" class="avatar-xs rounded-circle" src="/images/users/user-7.jpg" />
                                                            <span>Daniel Ray</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!">
                                                                <i class="ti ti-eye fs-lg"></i>
                                                            </a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!">
                                                                <i class="ti ti-edit fs-lg"></i>
                                                            </a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                                <i class="ti ti-trash fs-lg"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#INC-1003</a></td>
                                                    <td>E-commerce Sales Revenue</td>
                                                    <td data-column="income-source">Sales</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="MasterCard" class="me-2" height="26" src="/images/cards/mastercard.svg" />
                                                            <span>**** 4511</span>
                                                        </div>
                                                    </td>
                                                    <td>$2,430.00</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Received</span></td>
                                                    <td>
                                                        04 Oct, 2025
                                                        <small class="text-muted">02:35 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Emma Johnson" class="avatar-xs rounded-circle" src="/images/users/user-4.jpg" />
                                                            <span>Emma Johnson</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#INC-1004</a></td>
                                                    <td>Affiliate Payout - September</td>
                                                    <td data-column="income-source">Affiliate</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="PayPal" class="me-2" height="26" src="/images/cards/paypal.svg" />
                                                            <span>PayPal</span>
                                                        </div>
                                                    </td>
                                                    <td>$645.25</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Received</span></td>
                                                    <td>
                                                        02 Oct, 2025
                                                        <small class="text-muted">09:30 AM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="David Wilson" class="avatar-xs rounded-circle" src="/images/users/user-6.jpg" />
                                                            <span>David Wilson</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#INC-1005</a></td>
                                                    <td>Software License Renewal</td>
                                                    <td data-column="income-source">Services</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="Visa" class="me-2" height="26" src="/images/cards/visa.svg" />
                                                            <span>**** 9987</span>
                                                        </div>
                                                    </td>
                                                    <td>$1,120.00</td>
                                                    <td><span class="badge bg-warning-subtle text-warning badge-label">Pending</span></td>
                                                    <td>
                                                        29 Sep, 2025
                                                        <small class="text-muted">01:15 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Lucas Martin" class="avatar-xs rounded-circle" src="/images/users/user-8.jpg" />
                                                            <span>Lucas Martin</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#INC-1006</a></td>
                                                    <td>Investment Dividend Q3</td>
                                                    <td data-column="income-source">Investments</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="Bank Transfer" class="me-2" height="26" src="/images/cards/note.svg" />
                                                            <span>Bank Transfer</span>
                                                        </div>
                                                    </td>
                                                    <td>$3,950.50</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Received</span></td>
                                                    <td>
                                                        27 Sep, 2025
                                                        <small class="text-muted">10:00 AM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Olivia Brown" class="avatar-xs rounded-circle" src="/images/users/user-9.jpg" />
                                                            <span>Olivia Brown</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#INC-1007</a></td>
                                                    <td>Advertising Revenue (Google Ads)</td>
                                                    <td data-column="income-source">Affiliate</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="PayPal" class="me-2" height="26" src="/images/cards/paypal.svg" />
                                                            <span>PayPal</span>
                                                        </div>
                                                    </td>
                                                    <td>$870.75</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Received</span></td>
                                                    <td>
                                                        25 Sep, 2025
                                                        <small class="text-muted">08:10 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Ethan Brooks" class="avatar-xs rounded-circle" src="/images/users/user-10.jpg" />
                                                            <span>Ethan Brooks</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#INC-1008</a></td>
                                                    <td>Monthly Retainer - Client A</td>
                                                    <td data-column="income-source">Consulting</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="MasterCard" class="me-2" height="26" src="/images/cards/mastercard.svg" />
                                                            <span>**** 4732</span>
                                                        </div>
                                                    </td>
                                                    <td>$2,200.00</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Received</span></td>
                                                    <td>
                                                        22 Sep, 2025
                                                        <small class="text-muted">12:30 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Liam Davis" class="avatar-xs rounded-circle" src="/images/users/user-7.jpg" />
                                                            <span>Liam Davis</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#INC-1009</a></td>
                                                    <td>Service Renewal - Hosting Plan</td>
                                                    <td data-column="income-source">Services</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="Visa" class="me-2" height="26" src="/images/cards/visa.svg" />
                                                            <span>**** 2318</span>
                                                        </div>
                                                    </td>
                                                    <td>$399.00</td>
                                                    <td><span class="badge bg-warning-subtle text-warning badge-label">Pending</span></td>
                                                    <td>
                                                        20 Sep, 2025
                                                        <small class="text-muted">04:05 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Sophia Turner" class="avatar-xs rounded-circle" src="/images/users/user-1.jpg" />
                                                            <span>Sophia Turner</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#INC-1010</a></td>
                                                    <td>Refund - Cancelled Subscription</td>
                                                    <td data-column="income-source">Other</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="Amex" class="me-2" height="26" src="/images/cards/american-express.svg" />
                                                            <span>**** 9812</span>
                                                        </div>
                                                    </td>
                                                    <td>$-125.00</td>
                                                    <td><span class="badge bg-danger-subtle text-danger badge-label">Refunded</span></td>
                                                    <td>
                                                        18 Sep, 2025
                                                        <small class="text-muted">05:45 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Noah Walker" class="avatar-xs rounded-circle" src="/images/users/user-2.jpg" />
                                                            <span>Noah Walker</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#INC-1011</a></td>
                                                    <td>Project Completion Payment - Client B</td>
                                                    <td data-column="income-source">Services</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="Bank Transfer" class="me-2" height="26" src="/images/cards/note.svg" />
                                                            <span>Bank Transfer</span>
                                                        </div>
                                                    </td>
                                                    <td>$3,580.00</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Received</span></td>
                                                    <td>
                                                        15 Sep, 2025
                                                        <small class="text-muted">03:20 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Grace Miller" class="avatar-xs rounded-circle" src="/images/users/user-4.jpg" />
                                                            <span>Grace Miller</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#INC-1012</a></td>
                                                    <td>Royalty Income - October</td>
                                                    <td data-column="income-source">Other</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="MasterCard" class="me-2" height="26" src="/images/cards/mastercard.svg" />
                                                            <span>**** 5454</span>
                                                        </div>
                                                    </td>
                                                    <td>$940.00</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Received</span></td>
                                                    <td>
                                                        12 Sep, 2025
                                                        <small class="text-muted">11:55 AM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Chloe Adams" class="avatar-xs rounded-circle" src="/images/users/user-5.jpg" />
                                                            <span>Chloe Adams</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    <!-- end table responsive-->
                                </div>
                                <!-- end card-body-->
                                <div class="card-footer border-0">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div data-table-pagination-info="Income Records"></div>
                                        <div data-table-pagination=""></div>
                                    </div>
                                </div>
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                    <!-- Add / Edit Income Modal -->
                    <div aria-hidden="true" aria-labelledby="incomeModalLabel" class="modal fade" id="incomeModal" tabindex="-1">
                        <div class="modal-dialog modal-dialog-centered modal-lg">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title fw-semibold" id="incomeModalLabel">Add New Income</h5>
                                    <button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"></button>
                                </div>
                                <form id="incomeForm">
                                    <div class="modal-body">
                                        <div class="row g-3">
                                            <!-- Income Title -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="incomeTitle">
                                                    Income Title
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <input class="form-control" id="incomeTitle" placeholder="Enter income title" required="" type="text" />
                                            </div>
                                            <!-- Amount -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="incomeAmount">
                                                    Amount ($)
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <input class="form-control" id="incomeAmount" placeholder="Enter amount" required="" step="0.01" type="number" />
                                            </div>
                                            <!-- Source -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="incomeSource">
                                                    Income Source
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <select class="form-select" id="incomeSource" required="">
                                                    <option value="">Select source</option>
                                                    <option value="Sales">Sales</option>
                                                    <option value="Services">Services</option>
                                                    <option value="Consulting">Consulting</option>
                                                    <option value="Investments">Investments</option>
                                                    <option value="Affiliate">Affiliate</option>
                                                    <option value="Other">Other</option>
                                                </select>
                                            </div>
                                            <!-- Payment Type -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="incomePayment">Payment Type</label>
                                                <select class="form-select" id="incomePayment">
                                                    <option value="">Select payment type</option>
                                                    <option value="Credit Card">Credit Card</option>
                                                    <option value="Debit Card">Debit Card</option>
                                                    <option value="Cash">Cash</option>
                                                    <option value="Bank Transfer">Bank Transfer</option>
                                                    <option value="PayPal">PayPal</option>
                                                </select>
                                            </div>
                                            <!-- Client Name -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="incomeClient">Client Name</label>
                                                <input class="form-control" id="incomeClient" placeholder="Enter client or company name" type="text" />
                                            </div>
                                            <!-- Status -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="incomeStatus">Status</label>
                                                <select class="form-select" id="incomeStatus">
                                                    <option selected="" value="Received">Received</option>
                                                    <option value="Pending">Pending</option>
                                                    <option value="Failed">Failed</option>
                                                    <option value="Refunded">Refunded</option>
                                                </select>
                                            </div>
                                            <!-- Date -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="incomeDate">Date &amp; Time</label>
                                                <input class="form-control" data-date-format="d M, Y" data-enable-time="" data-provider="flatpickr" id="incomeDate" type="text" />
                                            </div>
                                            <!-- Received By -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="incomeReceivedBy">Received By</label>
                                                <div class="d-flex align-items-center gap-2">
                                                    <img alt="user" class="avatar-xs rounded-circle" src="/images/users/user-5.jpg" />
                                                    <input class="form-control" id="incomeReceivedBy" placeholder="Enter receiver name" type="text" />
                                                </div>
                                            </div>
                                            <!-- Notes -->
                                            <div class="col-12">
                                                <label class="form-label" for="incomeNotes">Notes</label>
                                                <textarea class="form-control" id="incomeNotes" placeholder="Optional remarks or description" rows="3"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer border-top">
                                        <button class="btn btn-light" data-bs-dismiss="modal" type="button">Cancel</button>
                                        <button class="btn btn-primary" type="submit">
                                            <i class="ti ti-device-floppy me-1"></i>
                                            Save Income
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Custom table -->
        <script src="/js/pages/custom-table.js"></script>
    </body>
</html>
