<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Transactions')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Finance', 'title' => 'Transactions')) ?>

                    <div class="row row-cols-xxl-4 row-cols-md-2 row-cols-1">
                        <!-- Total Income Widget -->
                        <div class="col">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="avatar fs-60 avatar-img-size flex-shrink-0">
                                            <span class="avatar-title bg-primary-subtle text-primary rounded-circle fs-24">
                                                <i class="ti ti-currency-dollar"></i>
                                            </span>
                                        </div>
                                        <div class="text-end">
                                            <h3 class="mb-2 fw-normal">
                                                $
                                                <span data-target="56240">0</span>
                                            </h3>
                                            <p class="mb-0 text-muted"><span>Total Income</span></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                        <!-- Received Income Widget -->
                        <div class="col">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="avatar fs-60 avatar-img-size flex-shrink-0">
                                            <span class="avatar-title bg-success-subtle text-success rounded-circle fs-24">
                                                <i class="ti ti-wallet"></i>
                                            </span>
                                        </div>
                                        <div class="text-end">
                                            <h3 class="mb-2 fw-normal">
                                                $
                                                <span data-target="48920">0</span>
                                            </h3>
                                            <p class="mb-0 text-muted"><span>Received Income</span></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                        <!-- Pending Payments Widget -->
                        <div class="col">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="avatar fs-60 avatar-img-size flex-shrink-0">
                                            <span class="avatar-title bg-warning-subtle text-warning rounded-circle fs-24">
                                                <i class="ti ti-hourglass"></i>
                                            </span>
                                        </div>
                                        <div class="text-end">
                                            <h3 class="mb-2 fw-normal">
                                                $
                                                <span data-target="6530">0</span>
                                            </h3>
                                            <p class="mb-0 text-muted"><span>Pending Payments</span></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                        <!-- Refunded Income Widget -->
                        <div class="col">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="avatar fs-60 avatar-img-size flex-shrink-0">
                                            <span class="avatar-title bg-danger-subtle text-danger rounded-circle fs-24">
                                                <i class="ti ti-credit-card-refund"></i>
                                            </span>
                                        </div>
                                        <div class="text-end">
                                            <h3 class="mb-2 fw-normal">
                                                $
                                                <span data-target="1790">0</span>
                                            </h3>
                                            <p class="mb-0 text-muted"><span>Refunded Income</span></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                    </div>
                    <!-- end row -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card" data-table="" data-table-rows-per-page="8">
                                <div class="card-header border-light justify-content-between">
                                    <div class="d-flex gap-2">
                                        <!-- Search -->
                                        <div class="app-search">
                                            <input class="form-control" data-table-search="" placeholder="Search transactions..." type="search" />
                                            <i class="ti ti-search app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Add New Transaction -->
                                        <button class="btn btn-primary" data-bs-target="#transactionModal" data-bs-toggle="modal">
                                            <i class="ti ti-plus me-1"></i>
                                            Add Transaction
                                        </button>
                                        <!-- Delete Selected -->
                                        <button class="btn btn-danger d-none" data-table-delete-selected="">Delete</button>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                        <span class="me-2 fw-semibold">Filter By:</span>
                                        <!-- Type Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="transaction-type">
                                                <option value="">Type</option>
                                                <option value="Credit">Credit</option>
                                                <option value="Debit">Debit</option>
                                                <option value="Refund">Refund</option>
                                                <option value="Adjustment">Adjustment</option>
                                            </select>
                                            <i class="ti ti-transaction-dollar app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Status Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="status">
                                                <option value="">Status</option>
                                                <option value="Completed">Completed</option>
                                                <option value="Pending">Pending</option>
                                                <option value="Failed">Failed</option>
                                                <option value="Refunded">Refunded</option>
                                            </select>
                                            <i class="ti ti-circle-check app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Records Per Page -->
                                        <div>
                                            <select class="form-select form-control my-1 my-md-0" data-table-set-rows-per-page="">
                                                <option value="5">5</option>
                                                <option selected="" value="10">10</option>
                                                <option value="15">15</option>
                                                <option value="20">20</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table table-custom table-centered table-select table-hover w-100 mb-0">
                                            <thead class="bg-light align-middle bg-opacity-25 thead-sm text-nowrap">
                                                <tr class="text-uppercase fs-xxs">
                                                    <th class="ps-3" style="width: 1%">
                                                        <input class="form-check-input form-check-input-light fs-14 mt-0" data-table-select-all="" type="checkbox" />
                                                    </th>
                                                    <th data-table-sort="">ID</th>
                                                    <th>Description</th>
                                                    <th data-column="transaction-type" data-table-sort="">Type</th>
                                                    <th>Payment Method</th>
                                                    <th data-table-sort="">Amount</th>
                                                    <th data-table-sort="">Balance</th>
                                                    <th data-column="status" data-table-sort="">Status</th>
                                                    <th data-table-sort="">Date</th>
                                                    <th data-table-sort="">Processed By</th>
                                                    <th class="text-center" style="width: 1%">Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody class="text-nowrap">
                                                <!-- CREDIT TRANSACTION -->
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#TRX-2001</a></td>
                                                    <td>Product Sale - Online Store</td>
                                                    <td data-column="transaction-type">
                                                        <span class="badge bg-success-subtle text-success">Credit</span>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="MasterCard" class="me-2" height="26" src="/images/cards/mastercard.svg" />
                                                            <span>**** 5623</span>
                                                        </div>
                                                    </td>
                                                    <td class="fw-semibold text-success">+$450.00</td>
                                                    <td class="fw-semibold">$5,240.00</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Completed</span></td>
                                                    <td>
                                                        10 Oct, 2025
                                                        <small class="text-muted">01:20 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Emma Johnson" class="avatar-xs rounded-circle" src="/images/users/user-4.jpg" />
                                                            <span>Emma Johnson</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!">
                                                                <i class="ti ti-eye fs-lg"></i>
                                                            </a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!">
                                                                <i class="ti ti-edit fs-lg"></i>
                                                            </a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                                <i class="ti ti-trash fs-lg"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- DEBIT TRANSACTION -->
                                                <tr class="table-danger-subtle">
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#TRX-2002</a></td>
                                                    <td>Office Supplies Purchase</td>
                                                    <td data-column="transaction-type">
                                                        <span class="badge bg-danger-subtle text-danger">Debit</span>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="Visa" class="me-2" height="26" src="/images/cards/visa.svg" />
                                                            <span>**** 9381</span>
                                                        </div>
                                                    </td>
                                                    <td class="fw-semibold text-danger">−$120.00</td>
                                                    <td class="fw-semibold">$5,120.00</td>
                                                    <td><span class="badge bg-warning-subtle text-warning badge-label">Pending</span></td>
                                                    <td>
                                                        09 Oct, 2025
                                                        <small class="text-muted">04:10 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="David Wilson" class="avatar-xs rounded-circle" src="/images/users/user-6.jpg" />
                                                            <span>David Wilson</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!">
                                                                <i class="ti ti-eye fs-lg"></i>
                                                            </a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!">
                                                                <i class="ti ti-edit fs-lg"></i>
                                                            </a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                                <i class="ti ti-trash fs-lg"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- REFUND TRANSACTION -->
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#TRX-2003</a></td>
                                                    <td>Refund – Order #7845 (Return)</td>
                                                    <td data-column="transaction-type">
                                                        <span class="badge bg-info-subtle text-info">Refund</span>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="PayPal" class="me-2" height="24" src="/images/cards/paypal.svg" />
                                                            <span>PayPal</span>
                                                        </div>
                                                    </td>
                                                    <td class="fw-semibold text-success">+$89.99</td>
                                                    <td class="fw-semibold">$5,209.99</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Completed</span></td>
                                                    <td>
                                                        08 Oct, 2025
                                                        <small class="text-muted">02:45 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Sophia Lee" class="avatar-xs rounded-circle" src="/images/users/user-7.jpg" />
                                                            <span>Sophia Lee</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- ADJUSTMENT TRANSACTION -->
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#TRX-2004</a></td>
                                                    <td>Balance Adjustment (Manual)</td>
                                                    <td data-column="transaction-type">
                                                        <span class="badge bg-secondary-subtle text-secondary">Adjustment</span>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="Amex" class="me-2" height="24" src="/images/cards/american-express.svg" />
                                                            <span>**** 3478</span>
                                                        </div>
                                                    </td>
                                                    <td class="fw-semibold text-success">+$150.00</td>
                                                    <td class="fw-semibold">$5,359.99</td>
                                                    <td><span class="badge bg-info-subtle text-info badge-label">Adjusted</span></td>
                                                    <td>
                                                        07 Oct, 2025
                                                        <small class="text-muted">11:10 AM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Daniel Ray" class="avatar-xs rounded-circle" src="/images/users/user-2.jpg" />
                                                            <span>Daniel Ray</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- FAILED TRANSACTION -->
                                                <tr class="table-danger-subtle">
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#TRX-2005</a></td>
                                                    <td>Subscription Renewal Attempt</td>
                                                    <td data-column="transaction-type">
                                                        <span class="badge bg-danger-subtle text-danger">Debit</span>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="MasterCard" class="me-2" height="26" src="/images/cards/mastercard.svg" />
                                                            <span>**** 4412</span>
                                                        </div>
                                                    </td>
                                                    <td class="fw-semibold text-danger">−$49.99</td>
                                                    <td class="fw-semibold">$5,310.00</td>
                                                    <td><span class="badge bg-danger-subtle text-danger badge-label">Failed</span></td>
                                                    <td>
                                                        06 Oct, 2025
                                                        <small class="text-muted">08:35 AM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Liam Brown" class="avatar-xs rounded-circle" src="/images/users/user-9.jpg" />
                                                            <span>Liam Brown</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- CREDIT TRANSACTION -->
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#TRX-2006</a></td>
                                                    <td>Client Payment – Project Alpha</td>
                                                    <td data-column="transaction-type">
                                                        <span class="badge bg-success-subtle text-success">Credit</span>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="Visa" class="me-2" height="26" src="/images/cards/visa.svg" />
                                                            <span>**** 8890</span>
                                                        </div>
                                                    </td>
                                                    <td class="fw-semibold text-success">+$2,000.00</td>
                                                    <td class="fw-semibold">$7,310.00</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Completed</span></td>
                                                    <td>
                                                        05 Oct, 2025
                                                        <small class="text-muted">05:00 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="John Miller" class="avatar-xs rounded-circle" src="/images/users/user-5.jpg" />
                                                            <span>John Miller</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- DEBIT TRANSACTION -->
                                                <tr class="table-danger-subtle">
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#TRX-2007</a></td>
                                                    <td>Software Subscription Payment</td>
                                                    <td data-column="transaction-type">
                                                        <span class="badge bg-danger-subtle text-danger">Debit</span>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="Visa" class="me-2" height="26" src="/images/cards/visa.svg" />
                                                            <span>**** 2311</span>
                                                        </div>
                                                    </td>
                                                    <td class="fw-semibold text-danger">−$120.00</td>
                                                    <td class="fw-semibold">$7,190.00</td>
                                                    <td><span class="badge bg-warning-subtle text-warning badge-label">Pending</span></td>
                                                    <td>
                                                        04 Oct, 2025
                                                        <small class="text-muted">09:15 AM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Olivia Green" class="avatar-xs rounded-circle" src="/images/users/user-1.jpg" />
                                                            <span>Olivia Green</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- CREDIT TRANSACTION -->
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#TRX-2008</a></td>
                                                    <td>Freelance Payment – UI Design Project</td>
                                                    <td data-column="transaction-type">
                                                        <span class="badge bg-success-subtle text-success">Credit</span>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="MasterCard" class="me-2" height="26" src="/images/cards/mastercard.svg" />
                                                            <span>**** 7654</span>
                                                        </div>
                                                    </td>
                                                    <td class="fw-semibold text-success">+$1,500.00</td>
                                                    <td class="fw-semibold">$8,690.00</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Completed</span></td>
                                                    <td>
                                                        03 Oct, 2025
                                                        <small class="text-muted">04:25 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Mason Carter" class="avatar-xs rounded-circle" src="/images/users/user-8.jpg" />
                                                            <span>Mason Carter</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- DEBIT TRANSACTION -->
                                                <tr class="table-danger-subtle">
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#TRX-2009</a></td>
                                                    <td>Monthly Internet Bill</td>
                                                    <td data-column="transaction-type">
                                                        <span class="badge bg-danger-subtle text-danger">Debit</span>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="Visa" class="me-2" height="26" src="/images/cards/visa.svg" />
                                                            <span>**** 5582</span>
                                                        </div>
                                                    </td>
                                                    <td class="fw-semibold text-danger">−$80.00</td>
                                                    <td class="fw-semibold">$8,610.00</td>
                                                    <td><span class="badge bg-warning-subtle text-warning badge-label">Pending</span></td>
                                                    <td>
                                                        02 Oct, 2025
                                                        <small class="text-muted">01:10 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Emily Clark" class="avatar-xs rounded-circle" src="/images/users/user-3.jpg" />
                                                            <span>Emily Clark</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- REFUND TRANSACTION -->
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#TRX-2010</a></td>
                                                    <td>Refund – Cancelled Workshop Ticket</td>
                                                    <td data-column="transaction-type">
                                                        <span class="badge bg-info-subtle text-info">Refund</span>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="PayPal" class="me-2" height="24" src="/images/cards/paypal.svg" />
                                                            <span>PayPal</span>
                                                        </div>
                                                    </td>
                                                    <td class="fw-semibold text-success">+$120.00</td>
                                                    <td class="fw-semibold">$8,730.00</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Completed</span></td>
                                                    <td>
                                                        01 Oct, 2025
                                                        <small class="text-muted">03:35 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Liam Brown" class="avatar-xs rounded-circle" src="/images/users/user-9.jpg" />
                                                            <span>Liam Brown</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- ADJUSTMENT TRANSACTION -->
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#TRX-2011</a></td>
                                                    <td>Bank Service Fee Reversal</td>
                                                    <td data-column="transaction-type">
                                                        <span class="badge bg-secondary-subtle text-secondary">Adjustment</span>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="Amex" class="me-2" height="24" src="/images/cards/american-express.svg" />
                                                            <span>**** 9012</span>
                                                        </div>
                                                    </td>
                                                    <td class="fw-semibold text-success">+$30.00</td>
                                                    <td class="fw-semibold">$8,760.00</td>
                                                    <td><span class="badge bg-info-subtle text-info badge-label">Adjusted</span></td>
                                                    <td>
                                                        30 Sep, 2025
                                                        <small class="text-muted">10:25 AM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Sophia Lee" class="avatar-xs rounded-circle" src="/images/users/user-7.jpg" />
                                                            <span>Sophia Lee</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- DEBIT TRANSACTION -->
                                                <tr class="table-danger-subtle">
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#TRX-2012</a></td>
                                                    <td>Travel Expense – Client Meeting</td>
                                                    <td data-column="transaction-type">
                                                        <span class="badge bg-danger-subtle text-danger">Debit</span>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="MasterCard" class="me-2" height="26" src="/images/cards/mastercard.svg" />
                                                            <span>**** 5534</span>
                                                        </div>
                                                    </td>
                                                    <td class="fw-semibold text-danger">−$260.00</td>
                                                    <td class="fw-semibold">$8,500.00</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Completed</span></td>
                                                    <td>
                                                        29 Sep, 2025
                                                        <small class="text-muted">06:40 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Olivia Green" class="avatar-xs rounded-circle" src="/images/users/user-1.jpg" />
                                                            <span>Olivia Green</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    <!-- end table responsive -->
                                </div>
                                <!-- end card-body -->
                                <div class="card-footer border-0">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div data-table-pagination-info="Transactions"></div>
                                        <div data-table-pagination=""></div>
                                    </div>
                                </div>
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->
                    </div>
                    <!-- end row -->
                    <!-- Add / Edit Transaction Modal -->
                    <div aria-hidden="true" aria-labelledby="transactionModalLabel" class="modal fade" id="transactionModal" tabindex="-1">
                        <div class="modal-dialog modal-dialog-centered modal-lg">
                            <div class="modal-content">
                                <!-- Header -->
                                <div class="modal-header">
                                    <h5 class="modal-title fw-semibold" id="transactionModalLabel">
                                        <i class="ti ti-plus me-1 text-primary"></i>
                                        Add New Transaction
                                    </h5>
                                    <button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"></button>
                                </div>
                                <!-- Body -->
                                <div class="modal-body">
                                    <form id="transactionForm" novalidate="">
                                        <div class="row g-3">
                                            <!-- Transaction Type -->
                                            <div class="col-md-6">
                                                <label class="form-label fw-medium">Transaction Type</label>
                                                <select class="form-select" name="transactionType" required="">
                                                    <option value="">Select Type</option>
                                                    <option value="Credit">Credit</option>
                                                    <option value="Debit">Debit</option>
                                                    <option value="Refund">Refund</option>
                                                    <option value="Adjustment">Adjustment</option>
                                                </select>
                                            </div>
                                            <!-- Payment Method -->
                                            <div class="col-md-6">
                                                <label class="form-label fw-medium">Payment Method</label>
                                                <select class="form-select" name="paymentMethod" required="">
                                                    <option value="">Select Method</option>
                                                    <option value="Visa">Visa</option>
                                                    <option value="MasterCard">MasterCard</option>
                                                    <option value="PayPal">PayPal</option>
                                                    <option value="Amex">American Express</option>
                                                    <option value="Bank Transfer">Bank Transfer</option>
                                                </select>
                                            </div>
                                            <!-- Description -->
                                            <div class="col-12">
                                                <label class="form-label fw-medium">Description</label>
                                                <input class="form-control" name="description" placeholder="Enter transaction description" required="" type="text" />
                                            </div>
                                            <!-- Amount -->
                                            <div class="col-md-6">
                                                <label class="form-label fw-medium">Amount ($)</label>
                                                <input class="form-control" min="0" name="amount" placeholder="0.00" required="" step="0.01" type="number" />
                                            </div>
                                            <!-- Status -->
                                            <div class="col-md-6">
                                                <label class="form-label fw-medium">Status</label>
                                                <select class="form-select" name="status" required="">
                                                    <option value="">Select Status</option>
                                                    <option value="Completed">Completed</option>
                                                    <option value="Pending">Pending</option>
                                                    <option value="Failed">Failed</option>
                                                    <option value="Refunded">Refunded</option>
                                                </select>
                                            </div>
                                            <!-- Date -->
                                            <div class="col-md-6">
                                                <label class="form-label fw-medium">Date</label>
                                                <input class="form-control" data-date-format="d M, Y" data-enable-time="" data-provider="flatpickr" name="date" required="" type="text" />
                                            </div>
                                            <!-- Processed By -->
                                            <div class="col-md-6">
                                                <label class="form-label fw-medium">Processed By</label>
                                                <input class="form-control" name="processedBy" placeholder="Enter staff name" required="" type="text" />
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <!-- Footer -->
                                <div class="modal-footer border-0">
                                    <button class="btn btn-light" data-bs-dismiss="modal" type="button">
                                        <i class="ti ti-x me-1"></i>
                                        Cancel
                                    </button>
                                    <button class="btn btn-primary" form="transactionForm" type="submit">
                                        <i class="ti ti-device-floppy me-1"></i>
                                        Save Transaction
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- end modal-->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Custom table -->
        <script src="/js/pages/custom-table.js"></script>
    </body>
</html>
