<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Departments')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'HRM', 'title' => 'Departments')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card" data-table="" data-table-rows-per-page="8">
                                <div class="card-header border-light justify-content-between">
                                    <div class="d-flex gap-2">
                                        <div class="app-search">
                                            <input class="form-control" data-table-search="" placeholder="Search department..." type="text" />
                                            <i class="ti ti-search app-search-icon text-muted"></i>
                                        </div>
                                        <button class="btn btn-primary" data-bs-target="#addDepartmentModal" data-bs-toggle="modal">
                                            <i class="ti ti-plus me-1"></i>
                                            New Department
                                        </button>
                                        <button class="btn btn-danger d-none" data-table-delete-selected="">Delete</button>
                                    </div>
                                    <div class="d-flex align-items-center gap-2">
                                        <span class="me-2 fw-semibold">Filter By:</span>
                                        <!-- Status Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="dep-status">
                                                <option value="">Department Status</option>
                                                <option value="Active">Active</option>
                                                <option value="Inactive">Inactive</option>
                                                <option value="On Hold">On Hold</option>
                                                <option value="Restructuring">Restructuring</option>
                                            </select>
                                            <i class="ti ti-arrows-shuffle app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Records Per Page -->
                                        <div>
                                            <select class="form-select form-control my-1 my-md-0" data-table-set-rows-per-page="">
                                                <option value="5">5</option>
                                                <option value="10">10</option>
                                                <option value="15">15</option>
                                                <option value="20">20</option>
                                                <option value="50">50</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-custom table-centered table-hover w-100 mb-0">
                                        <thead class="bg-light bg-opacity-25 thead-sm">
                                            <tr class="text-uppercase fs-xxs">
                                                <th scope="col" style="width: 1%">
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" data-table-select-all="" id="checkAll" type="checkbox" />
                                                </th>
                                                <th data-table-sort="">Department Name</th>
                                                <th data-table-sort="">Department Code</th>
                                                <th>Head of Department (HOD)</th>
                                                <th data-table-sort="">Total Staff</th>
                                                <th data-table-sort="">Established</th>
                                                <th data-column="dep-status" data-table-sort="">Status</th>
                                                <th class="text-center">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>Human Resources</td>
                                                <td>HR-001</td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-xs"><img alt="" class="img-fluid rounded-circle" src="/images/users/user-3.jpg" /></div>
                                                        <span>Samantha Green</span>
                                                    </div>
                                                </td>
                                                <td>12</td>
                                                <td>Jan 15, 2021</td>
                                                <td><span class="badge bg-success-subtle text-success badge-label">Active</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>Finance</td>
                                                <td>FIN-002</td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-xs"><img alt="" class="img-fluid rounded-circle" src="/images/users/user-6.jpg" /></div>
                                                        <span>Ethan Johnson</span>
                                                    </div>
                                                </td>
                                                <td>9</td>
                                                <td>Mar 05, 2020</td>
                                                <td><span class="badge bg-success-subtle text-success badge-label">Active</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>Engineering</td>
                                                <td>ENG-003</td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-xs"><img alt="" class="img-fluid rounded-circle" src="/images/users/user-4.jpg" /></div>
                                                        <span>David Miller</span>
                                                    </div>
                                                </td>
                                                <td>24</td>
                                                <td>Aug 12, 2019</td>
                                                <td><span class="badge bg-success-subtle text-success badge-label">Active</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>Design</td>
                                                <td>DSN-004</td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-xs"><img alt="" class="img-fluid rounded-circle" src="/images/users/user-7.jpg" /></div>
                                                        <span>Olivia Brown</span>
                                                    </div>
                                                </td>
                                                <td>7</td>
                                                <td>Jun 25, 2022</td>
                                                <td><span class="badge bg-danger-subtle text-danger badge-label">Inactive</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>Marketing</td>
                                                <td>MKT-005</td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-xs"><img alt="" class="img-fluid rounded-circle" src="/images/users/user-5.jpg" /></div>
                                                        <span>Isabella Lee</span>
                                                    </div>
                                                </td>
                                                <td>10</td>
                                                <td>May 11, 2023</td>
                                                <td><span class="badge bg-warning-subtle text-warning badge-label">On Hold</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>Operations</td>
                                                <td>OPS-006</td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-xs"><img alt="" class="img-fluid rounded-circle" src="/images/users/user-8.jpg" /></div>
                                                        <span>Michael Scott</span>
                                                    </div>
                                                </td>
                                                <td>15</td>
                                                <td>Feb 17, 2020</td>
                                                <td><span class="badge bg-success-subtle text-success badge-label">Active</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>Sales</td>
                                                <td>SAL-007</td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-xs"><img alt="" class="img-fluid rounded-circle" src="/images/users/user-9.jpg" /></div>
                                                        <span>Emma Wilson</span>
                                                    </div>
                                                </td>
                                                <td>18</td>
                                                <td>Oct 08, 2021</td>
                                                <td><span class="badge bg-success-subtle text-success badge-label">Active</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>Customer Support</td>
                                                <td>SUP-008</td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-xs"><img alt="" class="img-fluid rounded-circle" src="/images/users/user-10.jpg" /></div>
                                                        <span>Daniel Harris</span>
                                                    </div>
                                                </td>
                                                <td>20</td>
                                                <td>Jul 02, 2022</td>
                                                <td><span class="badge bg-success-subtle text-success badge-label">Active</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>Research &amp; Development</td>
                                                <td>RND-009</td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-xs"><img alt="" class="img-fluid rounded-circle" src="/images/users/user-1.jpg" /></div>
                                                        <span>Lucas White</span>
                                                    </div>
                                                </td>
                                                <td>11</td>
                                                <td>Sep 13, 2021</td>
                                                <td><span class="badge bg-warning-subtle text-warning badge-label">On Hold</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>IT &amp; Infrastructure</td>
                                                <td>IT-010</td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-xs"><img alt="" class="img-fluid rounded-circle" src="/images/users/user-2.jpg" /></div>
                                                        <span>Andrew Parker</span>
                                                    </div>
                                                </td>
                                                <td>14</td>
                                                <td>Nov 27, 2018</td>
                                                <td><span class="badge bg-success-subtle text-success badge-label">Active</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="card-footer border-0">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div data-table-pagination-info="staffs"></div>
                                        <div data-table-pagination=""></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                    </div>
                    <!-- end row -->
                    <!-- Add Department Modal -->
                    <div aria-hidden="true" aria-labelledby="addDepartmentModalLabel" class="modal fade" id="addDepartmentModal" tabindex="-1">
                        <div class="modal-dialog modal-dialog-centered modal-lg">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title fw-semibold" id="addDepartmentModalLabel">Add New Department</h5>
                                    <button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"></button>
                                </div>
                                <form id="addDepartmentForm">
                                    <div class="modal-body">
                                        <div class="row g-3">
                                            <!-- Department Name -->
                                            <div class="col-md-6">
                                                <label class="form-label fw-semibold" for="departmentName">
                                                    Department Name
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <input class="form-control" id="departmentName" name="department_name" placeholder="Enter department name" required="" type="text" />
                                            </div>
                                            <!-- Department Code -->
                                            <div class="col-md-6">
                                                <label class="form-label fw-semibold" for="departmentCode">Department Code</label>
                                                <input class="form-control" id="departmentCode" name="department_code" placeholder="e.g. HR-001" type="text" />
                                            </div>
                                            <!-- Head of Department -->
                                            <div class="col-md-6">
                                                <label class="form-label fw-semibold" for="hodSelect">Head of Department (HOD)</label>
                                                <select class="form-select" id="hodSelect" name="hod">
                                                    <option value="">Select HOD</option>
                                                    <option value="Samantha Green">Samantha Green</option>
                                                    <option value="Ethan Johnson">Ethan Johnson</option>
                                                    <option value="David Miller">David Miller</option>
                                                    <option value="Olivia Brown">Olivia Brown</option>
                                                    <option value="Isabella Lee">Isabella Lee</option>
                                                    <option value="Michael Scott">Michael Scott</option>
                                                </select>
                                            </div>
                                            <!-- Department Type -->
                                            <div class="col-md-6">
                                                <label class="form-label fw-semibold" for="departmentType">Department Type</label>
                                                <select class="form-select" id="departmentType" name="department_type">
                                                    <option value="">Select Type</option>
                                                    <option value="Core">Core</option>
                                                    <option value="Support">Support</option>
                                                    <option value="Technical">Technical</option>
                                                    <option value="Creative">Creative</option>
                                                    <option value="Administrative">Administrative</option>
                                                </select>
                                            </div>
                                            <!-- Total Staff -->
                                            <div class="col-md-6">
                                                <label class="form-label fw-semibold" for="totalStaff">Total Staff</label>
                                                <input class="form-control" id="totalStaff" min="1" name="total_staff" placeholder="e.g. 15" type="number" />
                                            </div>
                                            <!-- Established Date -->
                                            <div class="col-md-6">
                                                <label class="form-label fw-semibold" for="establishedDate">Established Date</label>
                                                <input class="form-control" data-date-format="d M, Y" data-provider="flatpickr" id="establishedDate" name="established_date" type="date" />
                                            </div>
                                            <!-- Status -->
                                            <div class="col-md-6">
                                                <label class="form-label fw-semibold" for="statusSelect">Status</label>
                                                <select class="form-select" id="statusSelect" name="status">
                                                    <option value="Active">Active</option>
                                                    <option value="Inactive">Inactive</option>
                                                    <option value="On Hold">On Hold</option>
                                                    <option value="Restructuring">Restructuring</option>
                                                </select>
                                            </div>
                                            <!-- Description -->
                                            <div class="col-12">
                                                <label class="form-label fw-semibold" for="description">Description</label>
                                                <textarea class="form-control" id="description" name="description" placeholder="Brief overview of the department..." rows="3"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button class="btn btn-light" data-bs-dismiss="modal" type="button">Cancel</button>
                                        <button class="btn btn-primary" type="submit">
                                            <i class="ti ti-device-floppy me-1"></i>
                                            Save Department
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <!-- end modal-->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Custom table -->
        <script src="/js/pages/custom-table.js"></script>
    </body>
</html>
