<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Holidays')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'HRM', 'title' => 'Holidays')) ?>

                    <div class="row row-cols-2 row-cols-md-4 row-cols-xl-6 g-1 mb-1">
                        <!-- Total Holidays -->
                        <div class="col">
                            <div class="card p-3 mb-0">
                                <div class="d-flex align-items-center gap-3">
                                    <div class="avatar-lg rounded-circle text-bg-light d-flex align-items-center justify-content-center">
                                        <i class="ti ti-calendar fs-xxl"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <p class="mb-1 text-muted">Total Holidays</p>
                                        <h4 class="mb-0">14</h4>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Federal Holidays -->
                        <div class="col">
                            <div class="card p-3 mb-0">
                                <div class="d-flex align-items-center gap-3">
                                    <div class="avatar-lg rounded-circle text-bg-light d-flex align-items-center justify-content-center">
                                        <i class="ti ti-flag fs-xxl"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <p class="mb-1 text-muted">Federal Holidays</p>
                                        <h4 class="mb-0">11</h4>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Optional Holidays -->
                        <div class="col">
                            <div class="card p-3 mb-0">
                                <div class="d-flex align-items-center gap-3">
                                    <div class="avatar-lg rounded-circle text-bg-light d-flex align-items-center justify-content-center">
                                        <i class="ti ti-filter-2 fs-xxl"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <p class="mb-1 text-muted">Optional Holidays</p>
                                        <h4 class="mb-0">3</h4>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Upcoming Holidays -->
                        <div class="col">
                            <div class="card p-3 mb-0">
                                <div class="d-flex align-items-center gap-3">
                                    <div class="avatar-lg rounded-circle text-bg-light d-flex align-items-center justify-content-center">
                                        <i class="ti ti-calendar-clock fs-xxl"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <p class="mb-1 text-muted">Upcoming Holidays</p>
                                        <h4 class="mb-0">5</h4>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Active Holidays -->
                        <div class="col">
                            <div class="card p-3 mb-0">
                                <div class="d-flex align-items-center gap-3">
                                    <div class="avatar-lg rounded-circle text-success bg-success-subtle d-flex align-items-center justify-content-center">
                                        <i class="ti ti-circle-check fs-xxl"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <p class="mb-1 text-success">Active</p>
                                        <h4 class="mb-0 text-success">12</h4>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Inactive Holidays -->
                        <div class="col">
                            <div class="card p-3 mb-0">
                                <div class="d-flex align-items-center gap-3">
                                    <div class="avatar-lg rounded-circle text-danger bg-danger-subtle d-flex align-items-center justify-content-center">
                                        <i class="ti ti-minus fs-xxl"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <p class="mb-1 text-danger">Inactive</p>
                                        <h4 class="mb-0 text-danger">2</h4>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- end row-->
                    <div class="row">
                        <div class="col-12">
                            <div class="card" data-table="" data-table-rows-per-page="10">
                                <div class="card-header border-light justify-content-between">
                                    <div class="d-flex gap-2">
                                        <!-- Search -->
                                        <div class="app-search">
                                            <input class="form-control" data-table-search="" placeholder="Search holidays..." type="search" />
                                            <i class="ti ti-search app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Delete Selected -->
                                        <button class="btn btn-danger d-none" data-table-delete-selected="">Delete</button>
                                    </div>
                                    <div class="d-flex align-items-center gap-2">
                                        <!-- Add New Holiday -->
                                        <button class="btn btn-primary" data-bs-target="#addHolidayModal" data-bs-toggle="modal">
                                            <i class="ti ti-plus me-1"></i>
                                            Add Holiday
                                        </button>
                                        <!-- Records Per Page -->
                                        <div>
                                            <select class="form-select form-control my-1 my-md-0" data-table-set-rows-per-page="">
                                                <option value="5">5</option>
                                                <option selected="" value="10">10</option>
                                                <option value="15">15</option>
                                                <option value="20">20</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table table-custom table-centered table-hover w-100 mb-0">
                                            <thead class="bg-light align-middle bg-opacity-25 thead-sm text-nowrap">
                                                <tr class="text-uppercase fs-xxs">
                                                    <th scope="col" style="width: 1%">
                                                        <input class="form-check-input form-check-input-light fs-14 mt-0" data-table-select-all="" id="checkAll" type="checkbox" value="option" />
                                                    </th>
                                                    <th data-table-sort="">Holiday Name</th>
                                                    <th data-table-sort="">Date</th>
                                                    <th data-table-sort="">Day</th>
                                                    <th>Description</th>
                                                    <th data-table-sort="">Status</th>
                                                    <th data-table-sort="">Optional</th>
                                                    <th data-table-sort="">Created On</th>
                                                    <th data-table-sort="">Added By</th>
                                                    <th class="text-center" style="width: 1%">Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody class="text-nowrap">
                                                <!-- Record 1 -->
                                                <tr>
                                                    <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                    <td>New Year’s Day</td>
                                                    <td>01 Jan 2026</td>
                                                    <td>Thursday</td>
                                                    <td>Celebration of the first day of the year</td>
                                                    <td><span class="badge bg-success-subtle text-success">Active</span></td>
                                                    <td>No</td>
                                                    <td>15 Dec 2025</td>
                                                    <td>Admin</td>
                                                    <td class="text-center">
                                                        <div class="d-flex align-items-center justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#" title="Edit">
                                                                <i class="ti ti-edit fs-lg"></i>
                                                            </a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#" title="Delete">
                                                                <i class="ti ti-trash fs-lg"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- Record 2 -->
                                                <tr>
                                                    <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                    <td>Martin Luther King Jr. Day</td>
                                                    <td>19 Jan 2026</td>
                                                    <td>Monday</td>
                                                    <td>Honoring the civil rights leader Martin Luther King Jr.</td>
                                                    <td><span class="badge bg-success-subtle text-success">Active</span></td>
                                                    <td>No</td>
                                                    <td>03 Jan 2026</td>
                                                    <td>HR Dept</td>
                                                    <td class="text-center">
                                                        <div class="d-flex align-items-center justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#" title="Edit">
                                                                <i class="ti ti-edit fs-lg"></i>
                                                            </a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#" title="Delete">
                                                                <i class="ti ti-trash fs-lg"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- Record 3 -->
                                                <tr>
                                                    <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                    <td>Presidents’ Day</td>
                                                    <td>16 Feb 2026</td>
                                                    <td>Monday</td>
                                                    <td>Honoring George Washington and all U.S. presidents</td>
                                                    <td><span class="badge bg-success-subtle text-success">Active</span></td>
                                                    <td>No</td>
                                                    <td>10 Jan 2026</td>
                                                    <td>HR Admin</td>
                                                    <td class="text-center">
                                                        <div class="d-flex align-items-center justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#" title="Edit">
                                                                <i class="ti ti-edit fs-lg"></i>
                                                            </a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#" title="Delete">
                                                                <i class="ti ti-trash fs-lg"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- Record 4 -->
                                                <tr>
                                                    <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                    <td>Memorial Day</td>
                                                    <td>25 May 2026</td>
                                                    <td>Monday</td>
                                                    <td>Honoring U.S. military personnel who died in service</td>
                                                    <td><span class="badge bg-success-subtle text-success">Active</span></td>
                                                    <td>No</td>
                                                    <td>15 Apr 2026</td>
                                                    <td>Admin</td>
                                                    <td class="text-center">
                                                        <div class="d-flex align-items-center justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#" title="Edit">
                                                                <i class="ti ti-edit fs-lg"></i>
                                                            </a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#" title="Delete">
                                                                <i class="ti ti-trash fs-lg"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- Record 5 -->
                                                <tr>
                                                    <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                    <td>Juneteenth National Independence Day</td>
                                                    <td>19 Jun 2026</td>
                                                    <td>Friday</td>
                                                    <td>Commemorating the end of slavery in the United States</td>
                                                    <td><span class="badge bg-success-subtle text-success">Active</span></td>
                                                    <td>No</td>
                                                    <td>20 May 2026</td>
                                                    <td>HR Dept</td>
                                                    <td class="text-center">
                                                        <div class="d-flex align-items-center justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#" title="Edit">
                                                                <i class="ti ti-edit fs-lg"></i>
                                                            </a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#" title="Delete">
                                                                <i class="ti ti-trash fs-lg"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- Record 6 -->
                                                <tr>
                                                    <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                    <td>Independence Day</td>
                                                    <td>04 Jul 2026</td>
                                                    <td>Saturday</td>
                                                    <td>Celebration of U.S. independence from Great Britain</td>
                                                    <td><span class="badge bg-success-subtle text-success">Active</span></td>
                                                    <td>No</td>
                                                    <td>05 Jun 2026</td>
                                                    <td>HR Team</td>
                                                    <td class="text-center">
                                                        <div class="d-flex align-items-center justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#" title="Edit">
                                                                <i class="ti ti-edit fs-lg"></i>
                                                            </a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#" title="Delete">
                                                                <i class="ti ti-trash fs-lg"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- Record 7 -->
                                                <tr>
                                                    <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                    <td>Labor Day</td>
                                                    <td>07 Sep 2026</td>
                                                    <td>Monday</td>
                                                    <td>Honoring workers and labor rights</td>
                                                    <td><span class="badge bg-success-subtle text-success">Active</span></td>
                                                    <td>No</td>
                                                    <td>10 Aug 2026</td>
                                                    <td>HR Admin</td>
                                                    <td class="text-center">
                                                        <div class="d-flex align-items-center justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#" title="Edit">
                                                                <i class="ti ti-edit fs-lg"></i>
                                                            </a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#" title="Delete">
                                                                <i class="ti ti-trash fs-lg"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- Record 8 -->
                                                <tr>
                                                    <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                    <td>Columbus Day</td>
                                                    <td>12 Oct 2026</td>
                                                    <td>Monday</td>
                                                    <td>Commemorating the arrival of Christopher Columbus</td>
                                                    <td><span class="badge bg-success-subtle text-success">Active</span></td>
                                                    <td>Yes</td>
                                                    <td>15 Sep 2026</td>
                                                    <td>Admin</td>
                                                    <td class="text-center">
                                                        <div class="d-flex align-items-center justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#" title="Edit">
                                                                <i class="ti ti-edit fs-lg"></i>
                                                            </a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#" title="Delete">
                                                                <i class="ti ti-trash fs-lg"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- Record 9 -->
                                                <tr>
                                                    <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                    <td>Thanksgiving Day</td>
                                                    <td>26 Nov 2026</td>
                                                    <td>Thursday</td>
                                                    <td>National day of gratitude and family gatherings</td>
                                                    <td><span class="badge bg-success-subtle text-success">Active</span></td>
                                                    <td>No</td>
                                                    <td>01 Nov 2026</td>
                                                    <td>Admin</td>
                                                    <td class="text-center">
                                                        <div class="d-flex align-items-center justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#" title="Edit">
                                                                <i class="ti ti-edit fs-lg"></i>
                                                            </a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#" title="Delete">
                                                                <i class="ti ti-trash fs-lg"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- Record 10 -->
                                                <tr>
                                                    <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                    <td>Black Friday</td>
                                                    <td>27 Nov 2026</td>
                                                    <td>Friday</td>
                                                    <td>Day after Thanksgiving, observed in some companies</td>
                                                    <td><span class="badge bg-info-subtle text-info">Optional</span></td>
                                                    <td>Yes</td>
                                                    <td>05 Nov 2026</td>
                                                    <td>HR Dept</td>
                                                    <td class="text-center">
                                                        <div class="d-flex align-items-center justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#" title="Edit">
                                                                <i class="ti ti-edit fs-lg"></i>
                                                            </a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#" title="Delete">
                                                                <i class="ti ti-trash fs-lg"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- Record 11 -->
                                                <tr>
                                                    <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                    <td>Christmas Eve</td>
                                                    <td>24 Dec 2026</td>
                                                    <td>Thursday</td>
                                                    <td>Observed as an early company closure day</td>
                                                    <td><span class="badge bg-info-subtle text-info">Optional</span></td>
                                                    <td>Yes</td>
                                                    <td>01 Dec 2026</td>
                                                    <td>HR Admin</td>
                                                    <td class="text-center">
                                                        <div class="d-flex align-items-center justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#" title="Edit">
                                                                <i class="ti ti-edit fs-lg"></i>
                                                            </a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#" title="Delete">
                                                                <i class="ti ti-trash fs-lg"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- Record 12 -->
                                                <tr>
                                                    <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                    <td>Christmas Day</td>
                                                    <td>25 Dec 2026</td>
                                                    <td>Friday</td>
                                                    <td>Celebration of Christmas Day</td>
                                                    <td><span class="badge bg-success-subtle text-success">Active</span></td>
                                                    <td>No</td>
                                                    <td>10 Dec 2026</td>
                                                    <td>HR Team</td>
                                                    <td class="text-center">
                                                        <div class="d-flex align-items-center justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#" title="Edit">
                                                                <i class="ti ti-edit fs-lg"></i>
                                                            </a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#" title="Delete">
                                                                <i class="ti ti-trash fs-lg"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    <!-- end table-respo.-->
                                </div>
                                <!-- end card-body-->
                                <div class="card-footer border-0">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div data-table-pagination-info="records"></div>
                                        <div data-table-pagination=""></div>
                                    </div>
                                </div>
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                    <!-- Add Holiday Modal -->
                    <div aria-hidden="true" aria-labelledby="addHolidayModalLabel" class="modal fade" id="addHolidayModal" tabindex="-1">
                        <div class="modal-dialog modal-lg modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header border-bottom">
                                    <h5 class="modal-title" id="addHolidayModalLabel">Add New Holiday</h5>
                                    <button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"></button>
                                </div>
                                <form id="addHolidayForm">
                                    <div class="modal-body">
                                        <div class="row g-3">
                                            <!-- Holiday Name -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="holidayName">
                                                    Holiday Name
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <input class="form-control" id="holidayName" placeholder="Enter holiday name" required="" type="text" />
                                            </div>
                                            <!-- Date -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="holidayDate">
                                                    Date
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <input class="form-control" data-date-format="d M, Y" data-provider="flatpickr" id="holidayDate" required="" type="date" />
                                            </div>
                                            <!-- Day -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="holidayDay">
                                                    Day
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <select class="form-select" id="holidayDay" required="">
                                                    <option value="">Select day</option>
                                                    <option>Monday</option>
                                                    <option>Tuesday</option>
                                                    <option>Wednesday</option>
                                                    <option>Thursday</option>
                                                    <option>Friday</option>
                                                    <option>Saturday</option>
                                                    <option>Sunday</option>
                                                </select>
                                            </div>
                                            <!-- Optional Holiday -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="optionalHoliday">
                                                    Optional Holiday
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <select class="form-select" id="optionalHoliday" required="">
                                                    <option value="">Select option</option>
                                                    <option value="No">No (Federal)</option>
                                                    <option value="Yes">Yes (Optional)</option>
                                                </select>
                                            </div>
                                            <!-- Description -->
                                            <div class="col-md-12">
                                                <label class="form-label" for="holidayDescription">
                                                    Description
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <textarea class="form-control" id="holidayDescription" placeholder="Enter holiday description" required="" rows="3"></textarea>
                                            </div>
                                            <!-- Added By -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="holidayAddedBy">
                                                    Added By
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <input class="form-control" id="holidayAddedBy" placeholder="Enter admin name" required="" type="text" />
                                            </div>
                                            <!-- Status -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="holidayStatus">
                                                    Status
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <select class="form-select" id="holidayStatus" required="">
                                                    <option value="">Select status</option>
                                                    <option value="Active">Active</option>
                                                    <option value="Inactive">Inactive</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer border-top">
                                        <button class="btn btn-light" data-bs-dismiss="modal" type="button">Cancel</button>
                                        <button class="btn btn-primary" type="submit">
                                            <i class="ti ti-device-floppy me-1"></i>
                                            Save Holiday
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Custom table -->
        <script src="/js/pages/custom-table.js"></script>
    </body>
</html>
