<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Add Leave')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'HRM', 'title' => 'Add Leave')) ?>

                    <div class="container-xxl">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header border-light">
                                        <h4 class="card-title mb-0">
                                            <i class="ti ti-calendar-plus me-1"></i>
                                            Apply for Leave
                                        </h4>
                                    </div>
                                    <div class="card-body">
                                        <form id="applyLeaveForm">
                                            <div class="row g-3">
                                                <!-- Employee Info -->
                                                <div class="col-md-4">
                                                    <label class="form-label" for="employeeId">
                                                        Employee ID
                                                        <span class="text-danger">*</span>
                                                    </label>
                                                    <input class="form-control" id="employeeId" placeholder="e.g., EMP-1035" required="" type="text" />
                                                </div>
                                                <div class="col-md-4">
                                                    <label class="form-label" for="employeeName">
                                                        Full Name
                                                        <span class="text-danger">*</span>
                                                    </label>
                                                    <input class="form-control" id="employeeName" placeholder="Enter full name" required="" type="text" />
                                                </div>
                                                <div class="col-md-4">
                                                    <label class="form-label" for="department">
                                                        Department
                                                        <span class="text-danger">*</span>
                                                    </label>
                                                    <select class="form-select" id="department" required="">
                                                        <option value="">Select Department</option>
                                                        <option>HR</option>
                                                        <option>Finance</option>
                                                        <option>IT</option>
                                                        <option>Design</option>
                                                        <option>Marketing</option>
                                                        <option>Operations</option>
                                                    </select>
                                                </div>
                                                <!-- Leave Dates -->
                                                <div class="col-md-4">
                                                    <label class="form-label" for="leaveFrom">
                                                        From Date
                                                        <span class="text-danger">*</span>
                                                    </label>
                                                    <input class="form-control" data-date-format="d F, Y" data-provider="flatpickr" id="leaveFrom" required="" type="date" />
                                                </div>
                                                <div class="col-md-4">
                                                    <label class="form-label" for="leaveTo">
                                                        To Date
                                                        <span class="text-danger">*</span>
                                                    </label>
                                                    <input class="form-control" data-date-format="d F, Y" data-provider="flatpickr" id="leaveTo" required="" type="date" />
                                                </div>
                                                <div class="col-md-4">
                                                    <label class="form-label" for="leaveType">
                                                        Leave Type
                                                        <span class="text-danger">*</span>
                                                    </label>
                                                    <select class="form-select" id="leaveType" required="">
                                                        <option value="">Select Leave Type</option>
                                                        <option>Sick Leave</option>
                                                        <option>Casual Leave</option>
                                                        <option>Paid Leave</option>
                                                        <option>Unpaid Leave</option>
                                                        <option>Maternity Leave</option>
                                                        <option>Half Day Leave</option>
                                                    </select>
                                                </div>
                                                <!-- Reason -->
                                                <div class="col-md-12">
                                                    <label class="form-label" for="reason">
                                                        Reason
                                                        <span class="text-danger">*</span>
                                                    </label>
                                                    <textarea class="form-control" id="reason" placeholder="Explain your reason for leave" required="" rows="3"></textarea>
                                                </div>
                                                <!-- Contact Details During Leave -->
                                                <div class="col-md-6">
                                                    <label class="form-label" for="contactNumber">
                                                        Contact Number
                                                        <span class="text-danger">*</span>
                                                    </label>
                                                    <input class="form-control" id="contactNumber" placeholder="+1 234 567 890" required="" type="text" />
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label" for="emergencyContact">
                                                        Emergency Contact Person
                                                        <span class="text-danger">*</span>
                                                    </label>
                                                    <input class="form-control" id="emergencyContact" placeholder="Name of emergency contact" required="" type="text" />
                                                </div>
                                                <!-- Supporting Document -->
                                                <div class="col-md-12">
                                                    <label class="form-label" for="supportDoc">Supporting Document (optional)</label>
                                                    <input accept=".pdf,.jpg,.jpeg,.png" class="form-control" id="supportDoc" type="file" />
                                                    <small class="text-muted">Attach medical certificate or proof if required (PDF/JPG/PNG).</small>
                                                </div>
                                                <!-- Remarks -->
                                                <div class="col-md-12">
                                                    <label class="form-label" for="remarks">Additional Remarks</label>
                                                    <textarea class="form-control" id="remarks" placeholder="Optional comments..." rows="3"></textarea>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                    <!-- end card-body-->
                                    <div class="card-footer border-light d-flex justify-content-end gap-2">
                                        <button class="btn btn-light" type="reset">
                                            <i class="ti ti-refresh me-1"></i>
                                            Reset
                                        </button>
                                        <button class="btn btn-primary" form="applyLeaveForm" type="submit">
                                            <i class="ti ti-send-2 me-1"></i>
                                            Submit Application
                                        </button>
                                    </div>
                                    <!-- end card-footer-->
                                </div>
                                <!-- end card-->
                            </div>
                            <!-- end col-->
                        </div>
                        <!-- end row-->
                    </div>
                    <!-- end container-->
                </div>
                <!-- container-fluid -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>
    </body>
</html>
