<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Payroll')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'HRM', 'title' => 'Payroll')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card" data-table="" data-table-rows-per-page="10">
                                <div class="card-header border-light justify-content-between">
                                    <div class="d-flex gap-2">
                                        <!-- Search -->
                                        <div class="app-search">
                                            <input class="form-control" data-table-search="" placeholder="Search payroll records..." type="text" />
                                            <i class="ti ti-search app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Add New Payroll -->
                                        <button class="btn btn-primary" data-bs-target="#addPayrollModal" data-bs-toggle="modal">
                                            <i class="ti ti-plus me-1"></i>
                                            New Payroll
                                        </button>
                                        <!-- Delete Selected -->
                                        <button class="btn btn-danger d-none" data-table-delete-selected="">Delete</button>
                                    </div>
                                    <div class="d-flex align-items-center gap-2">
                                        <span class="me-2 fw-semibold">Filter By:</span>
                                        <!-- Department Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="department">
                                                <option value="">Department</option>
                                                <option value="Human Resources">Human Resources</option>
                                                <option value="Finance">Finance</option>
                                                <option value="IT">IT</option>
                                                <option value="Operations">Operations</option>
                                                <option value="Marketing">Marketing</option>
                                                <option value="Design">Design</option>
                                                <option value="Sales">Sales</option>
                                                <option value="Customer Support">Customer Support</option>
                                                <option value="Research &amp; Development">Research &amp; Development</option>
                                            </select>
                                            <i class="ti ti-layout app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Pay Status Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="status">
                                                <option value="">Status</option>
                                                <option value="Paid">Paid</option>
                                                <option value="Processing">Processing</option>
                                                <option value="On Hold">On Hold</option>
                                                <option value="Pending Review">Pending Review</option>
                                            </select>
                                            <i class="ti ti-arrows-shuffle app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Pay Period Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="period">
                                                <option value="">Pay Period</option>
                                                <option value="Oct 2025">October 2025</option>
                                                <option value="Sep 2025">September 2025</option>
                                                <option value="Aug 2025">August 2025</option>
                                                <option value="Jul 2025">July 2025</option>
                                            </select>
                                            <i class="ti ti-calendar app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Records Per Page -->
                                        <div>
                                            <select class="form-select form-control my-1 my-md-0" data-table-set-rows-per-page="">
                                                <option value="5">5</option>
                                                <option selected="" value="10">10</option>
                                                <option value="15">15</option>
                                                <option value="20">20</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-custom table-centered table-select table-hover w-100 mb-0">
                                        <thead class="bg-light bg-opacity-25 thead-sm">
                                            <tr class="text-uppercase fs-xxs">
                                                <th scope="col" style="width: 1%">
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" data-table-select-all="" id="checkAll" type="checkbox" value="option" />
                                                </th>
                                                <th data-table-sort="">Employee ID</th>
                                                <th data-table-sort="">Employee Name</th>
                                                <th data-column="department" data-table-sort="">Department</th>
                                                <th data-table-sort="">Designation</th>
                                                <th data-table-sort="">Pay Period</th>
                                                <th data-table-sort="">Base Salary</th>
                                                <th data-table-sort="">Allowances</th>
                                                <th data-table-sort="">Actual Salary</th>
                                                <th data-table-sort="">Deductions</th>
                                                <th data-table-sort="">Net Pay</th>
                                                <th data-column="status" data-table-sort="">Status</th>
                                                <th class="text-center">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!-- PAY-001 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>PAY-001</td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="" class="img-fluid rounded-circle" src="/images/users/user-3.jpg" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base"><a class="link-reset" href="#!">Samantha Green</a></h5>
                                                            <p class="text-muted fs-xs mb-0">samantha.green@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>Human Resources</td>
                                                <td>HR Manager</td>
                                                <td>Oct 2025</td>
                                                <td>$6,200</td>
                                                <td>$500</td>
                                                <td><strong>$6,700</strong></td>
                                                <td>$150</td>
                                                <td><strong>$6,550</strong></td>
                                                <td><span class="badge bg-success-subtle text-success">Paid</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- PAY-002 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>PAY-002</td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="" class="img-fluid rounded-circle" src="/images/users/user-6.jpg" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base"><a class="link-reset" href="#!">David Lee</a></h5>
                                                            <p class="text-muted fs-xs mb-0">david.lee@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>IT</td>
                                                <td>Software Engineer</td>
                                                <td>Oct 2025</td>
                                                <td>$5,000</td>
                                                <td>$400</td>
                                                <td><strong>$5,400</strong></td>
                                                <td>$100</td>
                                                <td><strong>$5,300</strong></td>
                                                <td><span class="badge bg-warning-subtle text-warning">Processing</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- PAY-003 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>PAY-003</td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="" class="img-fluid rounded-circle" src="/images/users/user-8.jpg" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base"><a class="link-reset" href="#!">Maria Smith</a></h5>
                                                            <p class="text-muted fs-xs mb-0">maria.smith@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>Finance</td>
                                                <td>Accountant</td>
                                                <td>Oct 2025</td>
                                                <td>$4,800</td>
                                                <td>$250</td>
                                                <td><strong>$5,050</strong></td>
                                                <td>$100</td>
                                                <td><strong>$4,950</strong></td>
                                                <td><span class="badge bg-danger-subtle text-danger">On Hold</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- PAY-004 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>PAY-004</td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="" class="img-fluid rounded-circle" src="/images/users/user-4.jpg" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base"><a class="link-reset" href="#!">Michael Adams</a></h5>
                                                            <p class="text-muted fs-xs mb-0">michael.adams@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>Marketing</td>
                                                <td>Marketing Executive</td>
                                                <td>Oct 2025</td>
                                                <td>$4,200</td>
                                                <td>$300</td>
                                                <td><strong>$4,500</strong></td>
                                                <td>$120</td>
                                                <td><strong>$4,380</strong></td>
                                                <td><span class="badge bg-success-subtle text-success">Paid</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- PAY-005 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>PAY-005</td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="" class="img-fluid rounded-circle" src="/images/users/user-1.jpg" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base"><a class="link-reset" href="#!">Olivia Brown</a></h5>
                                                            <p class="text-muted fs-xs mb-0">olivia.brown@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>Design</td>
                                                <td>UI/UX Designer</td>
                                                <td>Oct 2025</td>
                                                <td>$4,600</td>
                                                <td>$400</td>
                                                <td><strong>$5,000</strong></td>
                                                <td>$80</td>
                                                <td><strong>$4,920</strong></td>
                                                <td><span class="badge bg-success-subtle text-success">Paid</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- PAY-006 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>PAY-006</td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="" class="img-fluid rounded-circle" src="/images/users/user-2.jpg" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base"><a class="link-reset" href="#!">Daniel Carter</a></h5>
                                                            <p class="text-muted fs-xs mb-0">daniel.carter@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>Operations</td>
                                                <td>Operations Lead</td>
                                                <td>Oct 2025</td>
                                                <td>$5,500</td>
                                                <td>$600</td>
                                                <td><strong>$6,100</strong></td>
                                                <td>$200</td>
                                                <td><strong>$5,900</strong></td>
                                                <td><span class="badge bg-success-subtle text-success">Paid</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- PAY-007 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>PAY-007</td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="" class="img-fluid rounded-circle" src="/images/users/user-5.jpg" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base"><a class="link-reset" href="#!">Emily Davis</a></h5>
                                                            <p class="text-muted fs-xs mb-0">emily.davis@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>Admin</td>
                                                <td>Office Administrator</td>
                                                <td>Oct 2025</td>
                                                <td>$3,800</td>
                                                <td>$250</td>
                                                <td><strong>$4,050</strong></td>
                                                <td>$50</td>
                                                <td><strong>$4,000</strong></td>
                                                <td><span class="badge bg-warning-subtle text-warning">Processing</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- PAY-008 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>PAY-008</td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="" class="img-fluid rounded-circle" src="/images/users/user-9.jpg" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base"><a class="link-reset" href="#!">James Walker</a></h5>
                                                            <p class="text-muted fs-xs mb-0">james.walker@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>Sales</td>
                                                <td>Sales Manager</td>
                                                <td>Oct 2025</td>
                                                <td>$6,000</td>
                                                <td>$800</td>
                                                <td><strong>$6,800</strong></td>
                                                <td>$200</td>
                                                <td><strong>$6,600</strong></td>
                                                <td><span class="badge bg-success-subtle text-success">Paid</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- PAY-009 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>PAY-009</td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="" class="img-fluid rounded-circle" src="/images/users/user-7.jpg" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base"><a class="link-reset" href="#!">Sophia Martinez</a></h5>
                                                            <p class="text-muted fs-xs mb-0">sophia.martinez@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>Customer Support</td>
                                                <td>Support Specialist</td>
                                                <td>Oct 2025</td>
                                                <td>$3,900</td>
                                                <td>$150</td>
                                                <td><strong>$4,050</strong></td>
                                                <td>$70</td>
                                                <td><strong>$3,980</strong></td>
                                                <td><span class="badge bg-warning-subtle text-warning">Processing</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- PAY-010 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>PAY-010</td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="" class="img-fluid rounded-circle" src="/images/users/user-10.jpg" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base"><a class="link-reset" href="#!">Henry Clark</a></h5>
                                                            <p class="text-muted fs-xs mb-0">henry.clark@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>Logistics</td>
                                                <td>Warehouse Supervisor</td>
                                                <td>Oct 2025</td>
                                                <td>$4,400</td>
                                                <td>$200</td>
                                                <td><strong>$4,600</strong></td>
                                                <td>$80</td>
                                                <td><strong>$4,520</strong></td>
                                                <td><span class="badge bg-success-subtle text-success">Paid</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Record 11 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>PAY-011</td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="" class="img-fluid rounded-circle" src="/images/users/user-7.jpg" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base">
                                                                <a class="link-reset" href="#!">Isabella Johnson</a>
                                                            </h5>
                                                            <p class="text-muted fs-xs mb-0">isabella.johnson@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>Legal</td>
                                                <td>Legal Advisor</td>
                                                <td>Oct 2025</td>
                                                <td>$5,800</td>
                                                <td>$350</td>
                                                <td><strong>$6,150</strong></td>
                                                <td>$180</td>
                                                <td><strong>$5,970</strong></td>
                                                <td><span class="badge bg-success-subtle text-success">Paid</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#" title="View Payslip"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#" title="Edit Record"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#" title="Delete"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Record 12 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>PAY-012</td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="" class="img-fluid rounded-circle" src="/images/users/user-2.jpg" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base">
                                                                <a class="link-reset" href="#!">Liam Turner</a>
                                                            </h5>
                                                            <p class="text-muted fs-xs mb-0">liam.turner@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>Engineering</td>
                                                <td>QA Engineer</td>
                                                <td>Oct 2025</td>
                                                <td>$4,700</td>
                                                <td>$200</td>
                                                <td><strong>$4,900</strong></td>
                                                <td>$90</td>
                                                <td><strong>$4,810</strong></td>
                                                <td><span class="badge bg-warning-subtle text-warning">Processing</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#" title="View Payslip"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#" title="Edit Record"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#" title="Delete"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Record 13 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>PAY-013</td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="" class="img-fluid rounded-circle" src="/images/users/user-9.jpg" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base">
                                                                <a class="link-reset" href="#!">Charlotte Evans</a>
                                                            </h5>
                                                            <p class="text-muted fs-xs mb-0">charlotte.evans@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>Public Relations</td>
                                                <td>PR Manager</td>
                                                <td>Oct 2025</td>
                                                <td>$5,200</td>
                                                <td>$300</td>
                                                <td><strong>$5,500</strong></td>
                                                <td>$120</td>
                                                <td><strong>$5,380</strong></td>
                                                <td><span class="badge bg-danger-subtle text-danger">On Hold</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#" title="View Payslip"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#" title="Edit Record"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#" title="Delete"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Record 14 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>PAY-014</td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="" class="img-fluid rounded-circle" src="/images/users/user-4.jpg" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base">
                                                                <a class="link-reset" href="#!">Benjamin Scott</a>
                                                            </h5>
                                                            <p class="text-muted fs-xs mb-0">benjamin.scott@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>Procurement</td>
                                                <td>Purchase Officer</td>
                                                <td>Oct 2025</td>
                                                <td>$4,300</td>
                                                <td>$250</td>
                                                <td><strong>$4,550</strong></td>
                                                <td>$70</td>
                                                <td><strong>$4,480</strong></td>
                                                <td><span class="badge bg-success-subtle text-success">Paid</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#" title="View Payslip"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#" title="Edit Record"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#" title="Delete"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Record 15 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>PAY-015</td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="" class="img-fluid rounded-circle" src="/images/users/user-10.jpg" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base">
                                                                <a class="link-reset" href="#!">Grace Mitchell</a>
                                                            </h5>
                                                            <p class="text-muted fs-xs mb-0">grace.mitchell@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>Research &amp; Development</td>
                                                <td>Data Scientist</td>
                                                <td>Oct 2025</td>
                                                <td>$6,700</td>
                                                <td>$600</td>
                                                <td><strong>$7,300</strong></td>
                                                <td>$250</td>
                                                <td><strong>$7,050</strong></td>
                                                <td><span class="badge bg-success-subtle text-success">Paid</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#" title="View Payslip"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#" title="Edit Record"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#" title="Delete"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="card-footer border-0">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div data-table-pagination-info="records"></div>
                                        <div data-table-pagination=""></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                    </div>
                    <!-- end row -->
                    <!-- Add Payroll Modal -->
                    <div aria-hidden="true" aria-labelledby="addPayrollModalLabel" class="modal fade" id="addPayrollModal" tabindex="-1">
                        <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
                            <div class="modal-content">
                                <div class="modal-header border-bottom">
                                    <h5 class="modal-title fw-semibold" id="addPayrollModalLabel">
                                        <i class="ti ti-plus me-1"></i>
                                        Add Payroll Record
                                    </h5>
                                    <button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"></button>
                                </div>
                                <form id="addPayrollForm">
                                    <div class="modal-body">
                                        <div class="row g-3">
                                            <!-- Employee Name -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="employeeName">
                                                    Employee Name
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <select class="form-select" id="employeeName" required="">
                                                    <option value="">Select Employee</option>
                                                    <option value="1">Samantha Green</option>
                                                    <option value="2">David Lee</option>
                                                    <option value="3">Maria Smith</option>
                                                    <option value="4">Michael Adams</option>
                                                    <option value="5">Olivia Brown</option>
                                                    <option value="6">Daniel Carter</option>
                                                    <option value="7">Emily Davis</option>
                                                    <option value="8">James Walker</option>
                                                    <option value="9">Sophia Martinez</option>
                                                    <option value="10">Henry Clark</option>
                                                </select>
                                            </div>
                                            <!-- Department -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="department">
                                                    Department
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <select class="form-select" id="department" required="">
                                                    <option value="">Select Department</option>
                                                    <option>Human Resources</option>
                                                    <option>Finance</option>
                                                    <option>IT</option>
                                                    <option>Operations</option>
                                                    <option>Marketing</option>
                                                    <option>Design</option>
                                                    <option>Sales</option>
                                                    <option>Customer Support</option>
                                                    <option>Research &amp; Development</option>
                                                </select>
                                            </div>
                                            <!-- Role / Position -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="role">
                                                    Role / Position
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <input class="form-control" id="role" placeholder="Enter position title" required="" type="text" />
                                            </div>
                                            <!-- Pay Period -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="payPeriod">
                                                    Pay Period
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <select class="form-select" id="payPeriod" required="">
                                                    <option value="">Select Period</option>
                                                    <option>October 2025</option>
                                                    <option>September 2025</option>
                                                    <option>August 2025</option>
                                                    <option>July 2025</option>
                                                </select>
                                            </div>
                                            <!-- Base Salary -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="baseSalary">
                                                    Base Salary ($)
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <input class="form-control" id="baseSalary" min="0" placeholder="e.g., 5000" required="" type="number" />
                                            </div>
                                            <!-- Allowances -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="allowances">Allowances ($)</label>
                                                <input class="form-control" id="allowances" min="0" placeholder="e.g., 300" type="number" />
                                            </div>
                                            <!-- Total Earnings (auto-calculated) -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="totalEarnings">Total Earnings ($)</label>
                                                <input class="form-control" id="totalEarnings" placeholder="Auto-calculated" readonly="" type="number" />
                                            </div>
                                            <!-- Deductions -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="deductions">Deductions ($)</label>
                                                <input class="form-control" id="deductions" min="0" placeholder="e.g., 100" type="number" />
                                            </div>
                                            <!-- Net Pay (auto-calculated) -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="netPay">Net Pay ($)</label>
                                                <input class="form-control" id="netPay" placeholder="Auto-calculated" readonly="" type="number" />
                                            </div>
                                            <!-- Pay Status -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="pay-status">
                                                    Pay Status
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <select class="form-select" id="pay-status" required="">
                                                    <option value="">Select Status</option>
                                                    <option value="Paid">Paid</option>
                                                    <option value="Processing">Processing</option>
                                                    <option value="On Hold">On Hold</option>
                                                    <option value="Pending Review">Pending Review</option>
                                                </select>
                                            </div>
                                            <!-- Remarks -->
                                            <div class="col-12">
                                                <label class="form-label" for="remarks">Remarks</label>
                                                <textarea class="form-control" id="remarks" placeholder="Optional remarks or notes" rows="2"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer border-top">
                                        <button class="btn btn-light" data-bs-dismiss="modal" type="button">Cancel</button>
                                        <button class="btn btn-primary" type="submit">
                                            <i class="ti ti-device-floppy me-1"></i>
                                            Save Payroll
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <!-- end modal-->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Custom table -->
        <script src="/js/pages/custom-table.js"></script>
    </body>
</html>
