<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Staffs List')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'HRM', 'title' => 'Staffs')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card" data-table="" data-table-rows-per-page="10">
                                <div class="card-header border-light justify-content-between">
                                    <div class="d-flex gap-2">
                                        <div class="app-search">
                                            <input class="form-control" data-table-search="" placeholder="Search staff..." type="text" />
                                            <i class="ti ti-search app-search-icon text-muted"></i>
                                        </div>
                                        <button class="btn btn-primary" data-bs-target="#addStaffModal" data-bs-toggle="modal">
                                            <i class="ti ti-plus me-1"></i>
                                            New Staff
                                        </button>
                                        <button class="btn btn-danger d-none" data-table-delete-selected="">Delete</button>
                                    </div>
                                    <div class="d-flex align-items-center gap-2">
                                        <span class="me-2 fw-semibold">Filter By:</span>
                                        <!-- Department Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="department">
                                                <option value="All">Department</option>
                                                <option value="Human Resources">Human Resources</option>
                                                <option value="IT Department">IT Department</option>
                                                <option value="Operations">Operations</option>
                                                <option value="Marketing">Marketing</option>
                                                <option value="Finance">Finance</option>
                                                <option value="Design">Design</option>
                                                <option value="Analytics">Analytics</option>
                                                <option value="Product">Product</option>
                                                <option value="Quality Assurance">Quality Assurance</option>
                                            </select>
                                            <i class="ti ti-layout app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Status Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="status">
                                                <option value="">Employment Status</option>
                                                <option value="Active">Active</option>
                                                <option value="On Leave">On Leave</option>
                                                <option value="Probation">Probation</option>
                                                <option value="Suspended">Suspended</option>
                                                <option value="Review Pending">Review Pending</option>
                                            </select>
                                            <i class="ti ti-arrows-shuffle app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Records Per Page -->
                                        <div>
                                            <select class="form-select form-control my-1 my-md-0" data-table-set-rows-per-page="">
                                                <option value="5">5</option>
                                                <option value="10">10</option>
                                                <option value="15">15</option>
                                                <option value="20">20</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-custom table-centered table-select table-hover w-100 mb-0">
                                        <thead class="bg-light bg-opacity-25 thead-sm">
                                            <tr class="text-uppercase fs-xxs">
                                                <th scope="col" style="width: 1%">
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" data-table-select-all="" id="checkAll" type="checkbox" value="option" />
                                                </th>
                                                <th data-table-sort="">Staff ID</th>
                                                <th data-table-sort="">Staff Name</th>
                                                <th data-table-sort="">Phone</th>
                                                <th data-table-sort="">Country</th>
                                                <th data-table-sort="">Joined</th>
                                                <th data-table-sort="">Role</th>
                                                <th data-column="department" data-table-sort="">Department</th>
                                                <th data-column="status" data-table-sort="">Status</th>
                                                <th class="text-center">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!-- STF-001 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td><a class="fw-semibold link-reset" href="/apps-hrm-staff-profile">STF-001</a></td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm"><img alt="" class="img-fluid rounded-circle" src="/images/users/user-3.jpg" /></div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base"><a class="link-reset" href="/apps-hrm-staff-profile">Samantha Green</a></h5>
                                                            <p class="text-muted fs-xs mb-0">samantha.green@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>+1 202 555 0147</td>
                                                <td>
                                                    <span class="badge p-1 text-bg-light fs-sm">
                                                        <img class="rounded-circle me-1" height="12" src="/images/flags/us.svg" />
                                                        US
                                                    </span>
                                                </td>
                                                <td>Feb 10, 2024</td>
                                                <td>HR Manager</td>
                                                <td>Human Resources</td>
                                                <td><span class="badge bg-success-subtle text-success badge-label">Active</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- STF-002 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td><a class="fw-semibold link-reset" href="/apps-hrm-staff-profile">STF-002</a></td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm"><img alt="" class="img-fluid rounded-circle" src="/images/users/user-5.jpg" /></div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base"><a class="link-reset" href="/apps-hrm-staff-profile">Liam Johnson</a></h5>
                                                            <p class="text-muted fs-xs mb-0">liam.johnson@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>+44 7700 900123</td>
                                                <td>
                                                    <span class="badge p-1 text-bg-light fs-sm">
                                                        <img class="rounded-circle me-1" height="12" src="/images/flags/gb.svg" />
                                                        UK
                                                    </span>
                                                </td>
                                                <td>Jan 25, 2024</td>
                                                <td>Software Engineer</td>
                                                <td>IT Department</td>
                                                <td><span class="badge bg-warning-subtle text-warning badge-label">On Leave</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- STF-003 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td><a class="fw-semibold link-reset" href="/apps-hrm-staff-profile">STF-003</a></td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm"><img alt="" class="img-fluid rounded-circle" src="/images/users/user-7.jpg" /></div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base"><a class="link-reset" href="/apps-hrm-staff-profile">Noah Martinez</a></h5>
                                                            <p class="text-muted fs-xs mb-0">noah.martinez@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>+61 401 222 890</td>
                                                <td>
                                                    <span class="badge p-1 text-bg-light fs-sm">
                                                        <img class="rounded-circle me-1" height="12" src="/images/flags/au.svg" />
                                                        AU
                                                    </span>
                                                </td>
                                                <td>Mar 05, 2024</td>
                                                <td>Project Coordinator</td>
                                                <td>Operations</td>
                                                <td><span class="badge bg-danger-subtle text-danger badge-label">Suspended</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- STF-004 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td><a class="fw-semibold link-reset" href="/apps-hrm-staff-profile">STF-004</a></td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm"><img alt="" class="img-fluid rounded-circle" src="/images/users/user-8.jpg" /></div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base"><a class="link-reset" href="/apps-hrm-staff-profile">Emily Davis</a></h5>
                                                            <p class="text-muted fs-xs mb-0">emily.davis@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>+1 303 555 0172</td>
                                                <td>
                                                    <span class="badge p-1 text-bg-light fs-sm">
                                                        <img class="rounded-circle me-1" height="12" src="/images/flags/ca.svg" />
                                                        CA
                                                    </span>
                                                </td>
                                                <td>Apr 18, 2024</td>
                                                <td>Marketing Lead</td>
                                                <td>Marketing</td>
                                                <td><span class="badge bg-success-subtle text-success badge-label">Active</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- STF-005 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td><a class="fw-semibold link-reset" href="/apps-hrm-staff-profile">STF-005</a></td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm"><img alt="" class="img-fluid rounded-circle" src="/images/users/user-9.jpg" /></div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base"><a class="link-reset" href="/apps-hrm-staff-profile">Lucas Brown</a></h5>
                                                            <p class="text-muted fs-xs mb-0">lucas.brown@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>+49 1512 345678</td>
                                                <td>
                                                    <span class="badge p-1 text-bg-light fs-sm">
                                                        <img class="rounded-circle me-1" height="12" src="/images/flags/de.svg" />
                                                        GE
                                                    </span>
                                                </td>
                                                <td>May 12, 2024</td>
                                                <td>Financial Analyst</td>
                                                <td>Finance</td>
                                                <td><span class="badge bg-success-subtle text-success badge-label">Active</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- STF-006 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td><a class="fw-semibold link-reset" href="/apps-hrm-staff-profile">STF-006</a></td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm"><img alt="" class="img-fluid rounded-circle" src="/images/users/user-10.jpg" /></div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base"><a class="link-reset" href="/apps-hrm-staff-profile">Olivia Wilson</a></h5>
                                                            <p class="text-muted fs-xs mb-0">olivia.wilson@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>+33 6 12 34 56 78</td>
                                                <td>
                                                    <span class="badge p-1 text-bg-light fs-sm">
                                                        <img class="rounded-circle me-1" height="12" src="/images/flags/fr.svg" />
                                                        FR
                                                    </span>
                                                </td>
                                                <td>Jun 02, 2024</td>
                                                <td>UX Designer</td>
                                                <td>Design</td>
                                                <td><span class="badge bg-warning-subtle text-warning badge-label">Probation</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- STF-007 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td><a class="fw-semibold link-reset" href="/apps-hrm-staff-profile">STF-007</a></td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm"><img alt="" class="img-fluid rounded-circle" src="/images/users/user-1.jpg" /></div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base"><a class="link-reset" href="/apps-hrm-staff-profile">Isabella Moore</a></h5>
                                                            <p class="text-muted fs-xs mb-0">isabella.moore@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>+34 612 345 678</td>
                                                <td>
                                                    <span class="badge p-1 text-bg-light fs-sm">
                                                        <img class="rounded-circle me-1" height="12" src="/images/flags/es.svg" />
                                                        SP
                                                    </span>
                                                </td>
                                                <td>Jul 21, 2024</td>
                                                <td>Data Analyst</td>
                                                <td>Analytics</td>
                                                <td><span class="badge bg-success-subtle text-success badge-label">Active</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- STF-008 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td><a class="fw-semibold link-reset" href="/apps-hrm-staff-profile">STF-008</a></td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm"><img alt="" class="img-fluid rounded-circle" src="/images/users/user-2.jpg" /></div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base"><a class="link-reset" href="/apps-hrm-staff-profile">Ethan Clark</a></h5>
                                                            <p class="text-muted fs-xs mb-0">ethan.clark@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>+39 347 123 4567</td>
                                                <td>
                                                    <span class="badge p-1 text-bg-light fs-sm">
                                                        <img class="rounded-circle me-1" height="12" src="/images/flags/it.svg" />
                                                        IT
                                                    </span>
                                                </td>
                                                <td>Aug 08, 2024</td>
                                                <td>QA Tester</td>
                                                <td>Quality Assurance</td>
                                                <td><span class="badge bg-warning-subtle text-warning badge-label">Review Pending</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- STF-009 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td><a class="fw-semibold link-reset" href="/apps-hrm-staff-profile">STF-009</a></td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm"><img alt="" class="img-fluid rounded-circle" src="/images/users/user-4.jpg" /></div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base"><a class="link-reset" href="/apps-hrm-staff-profile">Charlotte Turner</a></h5>
                                                            <p class="text-muted fs-xs mb-0">charlotte.turner@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>+41 79 123 4567</td>
                                                <td>
                                                    <span class="badge p-1 text-bg-light fs-sm">
                                                        <img class="rounded-circle me-1" height="12" src="/images/flags/ch.svg" />
                                                        SW
                                                    </span>
                                                </td>
                                                <td>Sep 15, 2024</td>
                                                <td>Legal Advisor</td>
                                                <td>Legal</td>
                                                <td><span class="badge bg-success-subtle text-success badge-label">Active</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- STF-010 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td><a class="fw-semibold link-reset" href="/apps-hrm-staff-profile">STF-010</a></td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm"><img alt="" class="img-fluid rounded-circle" src="/images/users/user-9.jpg" /></div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base"><a class="link-reset" href="/apps-hrm-staff-profile">Amelia Walker</a></h5>
                                                            <p class="text-muted fs-xs mb-0">amelia.walker@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>+65 8123 4567</td>
                                                <td>
                                                    <span class="badge p-1 text-bg-light fs-sm">
                                                        <img class="rounded-circle me-1" height="12" src="/images/flags/sg.svg" />
                                                        SI
                                                    </span>
                                                </td>
                                                <td>Oct 04, 2024</td>
                                                <td>Sales Executive</td>
                                                <td>Sales</td>
                                                <td><span class="badge bg-warning-subtle text-warning badge-label">Probation</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- STF-011 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td><a class="fw-semibold link-reset" href="/apps-hrm-staff-profile">STF-011</a></td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm"><img alt="" class="img-fluid rounded-circle" src="/images/users/user-7.jpg" /></div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base"><a class="link-reset" href="/apps-hrm-staff-profile">Benjamin Scott</a></h5>
                                                            <p class="text-muted fs-xs mb-0">benjamin.scott@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>+31 6 12 34 56 78</td>
                                                <td>
                                                    <span class="badge p-1 text-bg-light fs-sm">
                                                        <img class="rounded-circle me-1" height="12" src="/images/flags/nl.svg" />
                                                        NE
                                                    </span>
                                                </td>
                                                <td>Nov 11, 2024</td>
                                                <td>Network Administrator</td>
                                                <td>IT Department</td>
                                                <td><span class="badge bg-success-subtle text-success badge-label">Active</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- STF-012 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td><a class="fw-semibold link-reset" href="/apps-hrm-staff-profile">STF-012</a></td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm"><img alt="" class="img-fluid rounded-circle" src="/images/users/user-6.jpg" /></div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base"><a class="link-reset" href="/apps-hrm-staff-profile">Henry Lewis</a></h5>
                                                            <p class="text-muted fs-xs mb-0">henry.lewis@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>+353 86 123 4567</td>
                                                <td>
                                                    <span class="badge p-1 text-bg-light fs-sm">
                                                        <img class="rounded-circle me-1" height="12" src="/images/flags/ie.svg" />
                                                        IR
                                                    </span>
                                                </td>
                                                <td>Dec 02, 2024</td>
                                                <td>Content Strategist</td>
                                                <td>Marketing</td>
                                                <td><span class="badge bg-warning-subtle text-warning badge-label">Review Pending</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- STF-013 -->
                                            <tr>
                                                <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td><a class="fw-semibold link-reset" href="/apps-hrm-staff-profile">STF-013</a></td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm"><img alt="" class="img-fluid rounded-circle" src="/images/users/user-1.jpg" /></div>
                                                        <div>
                                                            <h5 class="mb-0 lh-base fs-base"><a class="link-reset" href="/apps-hrm-staff-profile">Grace Adams</a></h5>
                                                            <p class="text-muted fs-xs mb-0">grace.adams@company.com</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>+351 912 345 678</td>
                                                <td>
                                                    <span class="badge p-1 text-bg-light fs-sm">
                                                        <img class="rounded-circle me-1" height="12" src="/images/flags/pt.svg" />
                                                        PO
                                                    </span>
                                                </td>
                                                <td>Dec 18, 2024</td>
                                                <td>Product Manager</td>
                                                <td>Product</td>
                                                <td><span class="badge bg-success-subtle text-success badge-label">Active</span></td>
                                                <td class="text-center">
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <!-- end table -->
                                </div>
                                <div class="card-footer border-0">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div data-table-pagination-info="staffs"></div>
                                        <div data-table-pagination=""></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                    </div>
                    <!-- end row -->
                    <!-- Add Staff Modal -->
                    <div aria-hidden="true" aria-labelledby="addStaffModalLabel" class="modal fade" id="addStaffModal" tabindex="-1">
                        <div class="modal-dialog modal-lg modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title fw-semibold" id="addStaffModalLabel">
                                        <i class="ti ti-user-plus me-1"></i>
                                        Add New Staff
                                    </h5>
                                    <button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"></button>
                                </div>
                                <form id="addStaffForm">
                                    <div class="modal-body">
                                        <div class="row g-3">
                                            <div class="col-md-6">
                                                <label class="form-label" for="staffName">Full Name</label>
                                                <input class="form-control" id="staffName" placeholder="Enter full name" required="" type="text" />
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label" for="staffEmail">Email</label>
                                                <input class="form-control" id="staffEmail" placeholder="name@example.com" required="" type="email" />
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label" for="staffPhone">Phone</label>
                                                <input class="form-control" id="staffPhone" placeholder="+1 202 555 0123" type="text" />
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label" for="staffCountry">Country</label>
                                                <select class="form-select" id="staffCountry">
                                                    <option value="">Select country</option>
                                                    <option value="USA">United States</option>
                                                    <option value="UK">United Kingdom</option>
                                                    <option value="Canada">Canada</option>
                                                    <option value="Germany">Germany</option>
                                                    <option value="France">France</option>
                                                    <option value="Australia">Australia</option>
                                                    <option value="India">India</option>
                                                </select>
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label" for="staffRole">Role</label>
                                                <input class="form-control" id="staffRole" placeholder="e.g. Software Engineer" type="text" />
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label" for="staffDepartment">Department</label>
                                                <select class="form-select" id="staffDepartment">
                                                    <option value="">Select department</option>
                                                    <option value="Human Resources">Human Resources</option>
                                                    <option value="IT Department">IT Department</option>
                                                    <option value="Operations">Operations</option>
                                                    <option value="Marketing">Marketing</option>
                                                    <option value="Finance">Finance</option>
                                                    <option value="Design">Design</option>
                                                    <option value="Analytics">Analytics</option>
                                                    <option value="Product">Product</option>
                                                    <option value="Quality Assurance">Quality Assurance</option>
                                                </select>
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label" for="staffStatus">Status</label>
                                                <select class="form-select" id="staffStatus">
                                                    <option value="Active">Active</option>
                                                    <option value="On Leave">On Leave</option>
                                                    <option value="Probation">Probation</option>
                                                    <option value="Suspended">Suspended</option>
                                                    <option value="Review Pending">Review Pending</option>
                                                </select>
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label" for="staffJoinDate">Join Date</label>
                                                <input class="form-control" data-date-format="d M, Y" data-provider="flatpickr" id="staffJoinDate" type="date" />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button class="btn btn-light" data-bs-dismiss="modal" type="button">Cancel</button>
                                        <button class="btn btn-primary" type="submit">
                                            <i class="ti ti-check me-1"></i>
                                            Save Staff
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <!-- end modal-->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Custom table -->
        <script src="/js/pages/custom-table.js"></script>
    </body>
</html>
