<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Kanban Board')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Projects', 'title' => 'Kanban Board')) ?>

                    <div class="outlook-box kanban-app">
                        <div class="card h-100 mb-0 flex-grow-1">
                            <div class="card-header border-light align-items-center gap-2">
                                <!-- Search Bar -->
                                <div class="app-search">
                                    <input class="form-control" placeholder="Search by task name, assignee..." type="search" />
                                    <i class="ti ti-search app-search-icon text-muted"></i>
                                </div>
                                <!-- Filter Controls -->
                                <div class="d-flex flex-wrap align-items-center gap-2">
                                    <!-- Team Filter -->
                                    <div class="app-search">
                                        <select class="form-select form-control">
                                            <option selected="">Team</option>
                                            <option value="Product">Product</option>
                                            <option value="Engineering">Engineering</option>
                                            <option value="UX Design">UX Design</option>
                                            <option value="Customer Success">Customer Success</option>
                                            <option value="Support">Support</option>
                                        </select>
                                        <i class="ti ti-users app-search-icon text-muted"></i>
                                    </div>
                                    <!-- Priority Filter -->
                                    <div class="app-search">
                                        <select class="form-select form-control">
                                            <option selected="">Priority</option>
                                            <option value="Normal">Normal</option>
                                            <option value="Medium">Medium</option>
                                            <option value="High">High</option>
                                            <option value="Urgent">Urgent</option>
                                        </select>
                                        <i class="ti ti-flag app-search-icon text-muted"></i>
                                    </div>
                                    <!-- Status Filter -->
                                    <div class="app-search">
                                        <select class="form-select form-control">
                                            <option selected="">Status</option>
                                            <option value="To Do">To Do</option>
                                            <option value="In Progress">In Progress</option>
                                            <option value="Review">Review</option>
                                            <option value="Completed">Completed</option>
                                        </select>
                                        <i class="ti ti-circle-check app-search-icon text-muted"></i>
                                    </div>
                                </div>
                                <!-- Add New Card Button -->
                                <button class="btn btn-primary ms-lg-auto" data-bs-target="#addTaskModal" data-bs-toggle="modal" type="button">
                                    <i class="ti ti-plus me-1"></i>
                                    Add New Task
                                </button>
                            </div>
                            <div class="card-body p-0">
                                <div class="kanban-content bg-light bg-opacity-40">
                                    <!-- TODO Data-->
                                    <div class="kanban-board">
                                        <div class="kanban-item py-2 px-3 d-flex align-items-center">
                                            <h5 class="m-0">To Do (5)</h5>
                                            <a class="ms-auto btn btn-sm btn-icon rounded-circle btn-primary" href="#!">
                                                <i class="ti ti-plus"></i>
                                            </a>
                                        </div>
                                        <div class="kanban-board-group px-2" data-simplebar="" data-simplebar-md="">
                                            <ul data-plugins="sortable">
                                                <li class="kanban-item">
                                                    <div class="card mb-2 border border-light">
                                                        <div class="card-body">
                                                            <div class="d-flex align-items-center mb-2">
                                                                <span class="badge bg-danger-subtle text-danger badge-label">High</span>
                                                                <div class="ms-auto mt-n2">
                                                                    <div class="dropdown">
                                                                        <a class="btn btn-icon btn-sm btn-ghost-light text-muted" data-bs-toggle="dropdown" href="#">
                                                                            <i class="ti ti-dots-vertical fs-lg"></i>
                                                                        </a>
                                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-share me-2"></i>
                                                                                    Share
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-edit me-2"></i>
                                                                                    Edit
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item text-danger" href="#">
                                                                                    <i class="ti ti-trash me-2"></i>
                                                                                    Delete
                                                                                </a>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <h5 class="mb-2">
                                                                <a class="link-reset" href="#!">Design onboarding flow for new user sign-up journey.</a>
                                                            </h5>
                                                            <div class="d-flex align-items-center mb-2">
                                                                <img alt="" class="rounded-circle me-2" height="28" src="/images/users/user-5.jpg" width="28" />
                                                                <span class="text-muted fw-medium">Ava Mitchell</span>
                                                            </div>
                                                            <div class="d-flex justify-content-between align-items-center mb-n1 text-muted">
                                                                <span>4 Days</span>
                                                                <span>
                                                                    <i class="ti ti-list-check"></i>
                                                                    3
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-link"></i>
                                                                    2
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-messages"></i>
                                                                    9
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <!-- end kanban item-->
                                                <li class="kanban-item">
                                                    <div class="card mb-2 border border-light">
                                                        <div class="card-body">
                                                            <div class="d-flex align-items-center mb-2">
                                                                <span class="badge bg-success-subtle text-success badge-label">Normal</span>
                                                                <div class="ms-auto mt-n2">
                                                                    <div class="dropdown">
                                                                        <a class="btn btn-icon btn-sm btn-ghost-light text-muted" data-bs-toggle="dropdown" href="#">
                                                                            <i class="ti ti-dots-vertical fs-lg"></i>
                                                                        </a>
                                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-share me-2"></i>
                                                                                    Share
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-edit me-2"></i>
                                                                                    Edit
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item text-danger" href="#">
                                                                                    <i class="ti ti-trash me-2"></i>
                                                                                    Delete
                                                                                </a>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <h5 class="mb-2"><a class="link-reset" href="#!">Create dark/light theme switcher with local storage.</a></h5>
                                                            <div class="d-flex align-items-center mb-2">
                                                                <img class="rounded-circle me-2" height="28" src="/images/users/user-8.jpg" width="28" />
                                                                <span class="text-muted fw-medium">Mia Johnson</span>
                                                            </div>
                                                            <div class="d-flex justify-content-between align-items-center mb-n1 text-muted">
                                                                <span>2 Days</span>
                                                                <span>
                                                                    <i class="ti ti-list-check"></i>
                                                                    4
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-link"></i>
                                                                    1
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-messages"></i>
                                                                    6
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li class="kanban-item">
                                                    <div class="card mb-2 border border-light">
                                                        <div class="card-body">
                                                            <div class="d-flex align-items-center mb-2">
                                                                <span class="badge bg-warning-subtle text-warning badge-label">Medium</span>
                                                                <div class="ms-auto mt-n2">
                                                                    <div class="dropdown">
                                                                        <a class="btn btn-icon btn-sm btn-ghost-light text-muted" data-bs-toggle="dropdown" href="#">
                                                                            <i class="ti ti-dots-vertical fs-lg"></i>
                                                                        </a>
                                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-share me-2"></i>
                                                                                    Share
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-edit me-2"></i>
                                                                                    Edit
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item text-danger" href="#">
                                                                                    <i class="ti ti-trash me-2"></i>
                                                                                    Delete
                                                                                </a>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <h5 class="mb-2"><a class="link-reset" href="#!">Write documentation for project setup and deployment.</a></h5>
                                                            <div class="d-flex align-items-center mb-2">
                                                                <img class="rounded-circle me-2" height="28" src="/images/users/user-9.jpg" width="28" />
                                                                <span class="text-muted fw-medium">Emma Scott</span>
                                                            </div>
                                                            <div class="d-flex justify-content-between align-items-center mb-n1 text-muted">
                                                                <span>6 Days</span>
                                                                <span>
                                                                    <i class="ti ti-list-check"></i>
                                                                    3
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-link"></i>
                                                                    1
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-messages"></i>
                                                                    10
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li class="kanban-item">
                                                    <div class="card mb-2 border border-light">
                                                        <div class="card-body">
                                                            <div class="d-flex align-items-center mb-2">
                                                                <span class="badge bg-danger-subtle text-danger badge-label">High</span>
                                                                <div class="ms-auto mt-n2">
                                                                    <div class="dropdown">
                                                                        <a class="btn btn-icon btn-sm btn-ghost-light text-muted" data-bs-toggle="dropdown" href="#">
                                                                            <i class="ti ti-dots-vertical fs-lg"></i>
                                                                        </a>
                                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-share me-2"></i>
                                                                                    Share
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-edit me-2"></i>
                                                                                    Edit
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item text-danger" href="#">
                                                                                    <i class="ti ti-trash me-2"></i>
                                                                                    Delete
                                                                                </a>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <h5 class="mb-2"><a class="link-reset" href="#!">Fix payment failed callback issue in checkout API.</a></h5>
                                                            <div class="d-flex align-items-center mb-2">
                                                                <img class="rounded-circle me-2" height="28" src="/images/users/user-3.jpg" width="28" />
                                                                <span class="text-muted fw-medium">Noah Parker</span>
                                                            </div>
                                                            <div class="d-flex justify-content-between align-items-center mb-n1 text-muted">
                                                                <span>1 Day</span>
                                                                <span>
                                                                    <i class="ti ti-list-check"></i>
                                                                    5
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-link"></i>
                                                                    2
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-messages"></i>
                                                                    14
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li class="kanban-item">
                                                    <div class="card mb-2 border border-light">
                                                        <div class="card-body">
                                                            <div class="d-flex align-items-center mb-2">
                                                                <span class="badge bg-danger text-white badge-label">Urgent</span>
                                                                <div class="ms-auto mt-n2">
                                                                    <div class="dropdown">
                                                                        <a class="btn btn-icon btn-sm btn-ghost-light text-muted" data-bs-toggle="dropdown" href="#">
                                                                            <i class="ti ti-dots-vertical fs-lg"></i>
                                                                        </a>
                                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-share me-2"></i>
                                                                                    Share
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-edit me-2"></i>
                                                                                    Edit
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item text-danger" href="#">
                                                                                    <i class="ti ti-trash me-2"></i>
                                                                                    Delete
                                                                                </a>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <h5 class="mb-2"><a class="link-reset" href="#!">Resolve server downtime and restore access logs.</a></h5>
                                                            <div class="d-flex align-items-center mb-2">
                                                                <img class="rounded-circle me-2" height="28" src="/images/users/user-7.jpg" width="28" />
                                                                <span class="text-muted fw-medium">Lucas Martin</span>
                                                            </div>
                                                            <div class="d-flex justify-content-between align-items-center mb-n1 text-muted">
                                                                <span>8 Hours</span>
                                                                <span>
                                                                    <i class="ti ti-list-check"></i>
                                                                    7
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-link"></i>
                                                                    3
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-messages"></i>
                                                                    18
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                    <!-- end TODO Data-->
                                    <!-- IN Progress Data-->
                                    <div class="kanban-board">
                                        <div class="py-2 px-3 d-flex align-items-center">
                                            <h5 class="m-0">In Progress (3)</h5>
                                            <a class="ms-auto btn btn-sm btn-icon rounded-circle btn-primary" href="#!">
                                                <i class="ti ti-plus"></i>
                                            </a>
                                        </div>
                                        <div class="kanban-board-group px-2" data-simplebar="" data-simplebar-md="">
                                            <ul data-plugins="sortable">
                                                <li class="kanban-item">
                                                    <div class="card mb-2 border border-light">
                                                        <div class="card-body">
                                                            <div class="d-flex align-items-center mb-2">
                                                                <span class="badge bg-danger-subtle text-danger badge-label">High</span>
                                                                <div class="ms-auto mt-n2">
                                                                    <div class="dropdown">
                                                                        <a class="btn btn-icon btn-sm btn-ghost-light text-muted" data-bs-toggle="dropdown" href="#">
                                                                            <i class="ti ti-dots-vertical fs-lg"></i>
                                                                        </a>
                                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-share me-2"></i>
                                                                                    Share
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-edit me-2"></i>
                                                                                    Edit
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item text-danger" href="#">
                                                                                    <i class="ti ti-trash me-2"></i>
                                                                                    Delete
                                                                                </a>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <h5 class="mb-2"><a class="link-reset" href="#!">Implement role-based access control for admin panel.</a></h5>
                                                            <div class="d-flex align-items-center mb-2">
                                                                <img class="rounded-circle me-2" height="28" src="/images/users/user-4.jpg" width="28" />
                                                                <span class="text-muted fw-medium">Sophia Wilson</span>
                                                            </div>
                                                            <div class="d-flex justify-content-between align-items-center mb-n1 text-muted">
                                                                <span>3 Days</span>
                                                                <span>
                                                                    <i class="ti ti-list-check"></i>
                                                                    5
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-link"></i>
                                                                    4
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-messages"></i>
                                                                    11
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <!-- end kanban item-->
                                                <li class="kanban-item">
                                                    <div class="card mb-2 border border-light">
                                                        <div class="card-body">
                                                            <div class="d-flex align-items-center mb-2">
                                                                <span class="badge bg-warning-subtle text-warning badge-label">Medium</span>
                                                                <div class="ms-auto mt-n2">
                                                                    <div class="dropdown">
                                                                        <a class="btn btn-icon btn-sm btn-ghost-light text-muted" data-bs-toggle="dropdown" href="#">
                                                                            <i class="ti ti-dots-vertical fs-lg"></i>
                                                                        </a>
                                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-share me-2"></i>
                                                                                    Share
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-edit me-2"></i>
                                                                                    Edit
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item text-danger" href="#">
                                                                                    <i class="ti ti-trash me-2"></i>
                                                                                    Delete
                                                                                </a>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <h5 class="mb-2"><a class="link-reset" href="#!">Refactor project directory structure for clarity.</a></h5>
                                                            <div class="d-flex align-items-center mb-2">
                                                                <img class="rounded-circle me-2" height="28" src="/images/users/user-7.jpg" width="28" />
                                                                <span class="text-muted fw-medium">Hannah Green</span>
                                                            </div>
                                                            <div class="d-flex justify-content-between align-items-center mb-n1 text-muted">
                                                                <span>5 Days</span>
                                                                <span>
                                                                    <i class="ti ti-list-check"></i>
                                                                    3
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-link"></i>
                                                                    1
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-messages"></i>
                                                                    7
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li class="kanban-item">
                                                    <div class="card mb-2 border border-light">
                                                        <div class="card-body">
                                                            <div class="d-flex align-items-center mb-2">
                                                                <span class="badge bg-danger text-white badge-label">Urgent</span>
                                                                <div class="ms-auto mt-n2">
                                                                    <div class="dropdown">
                                                                        <a class="btn btn-icon btn-sm btn-ghost-light text-muted" data-bs-toggle="dropdown" href="#">
                                                                            <i class="ti ti-dots-vertical fs-lg"></i>
                                                                        </a>
                                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-share me-2"></i>
                                                                                    Share
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-edit me-2"></i>
                                                                                    Edit
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item text-danger" href="#">
                                                                                    <i class="ti ti-trash me-2"></i>
                                                                                    Delete
                                                                                </a>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <h5 class="mb-2"><a class="link-reset" href="#!">Resolve 500 errors occurring on user authentication.</a></h5>
                                                            <div class="d-flex align-items-center mb-2">
                                                                <img class="rounded-circle me-2" height="28" src="/images/users/user-9.jpg" width="28" />
                                                                <span class="text-muted fw-medium">Evelyn Clark</span>
                                                            </div>
                                                            <div class="d-flex justify-content-between align-items-center mb-n1 text-muted">
                                                                <span>6 Hours</span>
                                                                <span>
                                                                    <i class="ti ti-list-check"></i>
                                                                    8
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-link"></i>
                                                                    5
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-messages"></i>
                                                                    21
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                    <!-- end IN Progress Data-->
                                    <!-- In Review Data-->
                                    <div class="kanban-board">
                                        <div class="kanban-item py-2 px-3 d-flex align-items-center">
                                            <h5 class="m-0">In Review (4)</h5>
                                            <a class="ms-auto btn btn-sm btn-icon rounded-circle btn-primary" href="#!">
                                                <i class="ti ti-plus"></i>
                                            </a>
                                        </div>
                                        <div class="kanban-board-group px-2" data-simplebar="" data-simplebar-md="">
                                            <ul data-plugins="sortable">
                                                <li class="kanban-item">
                                                    <div class="card mb-2 border border-light">
                                                        <div class="card-body">
                                                            <div class="d-flex align-items-center mb-2">
                                                                <span class="badge bg-warning-subtle text-warning badge-label">Medium</span>
                                                                <div class="ms-auto mt-n2">
                                                                    <div class="dropdown">
                                                                        <a class="btn btn-icon btn-sm btn-ghost-light text-muted" data-bs-toggle="dropdown" href="#">
                                                                            <i class="ti ti-dots-vertical fs-lg"></i>
                                                                        </a>
                                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-share me-2"></i>
                                                                                    Share
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-edit me-2"></i>
                                                                                    Edit
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item text-danger" href="#">
                                                                                    <i class="ti ti-trash me-2"></i>
                                                                                    Delete
                                                                                </a>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <h5 class="mb-2"><a class="link-reset" href="#!">Add placeholder loading animations (skeleton screens).</a></h5>
                                                            <div class="d-flex align-items-center mb-2">
                                                                <img class="rounded-circle me-2" height="28" src="/images/users/user-10.jpg" width="28" />
                                                                <span class="text-muted fw-medium">Benjamin Hill</span>
                                                            </div>
                                                            <div class="d-flex justify-content-between align-items-center mb-n1 text-muted">
                                                                <span>4 Days</span>
                                                                <span>
                                                                    <i class="ti ti-list-check"></i>
                                                                    4
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-link"></i>
                                                                    0
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-messages"></i>
                                                                    8
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li class="kanban-item">
                                                    <div class="card mb-2 border border-light">
                                                        <div class="card-body">
                                                            <div class="d-flex align-items-center mb-2">
                                                                <span class="badge bg-success-subtle text-success badge-label">Normal</span>
                                                                <div class="ms-auto mt-n2">
                                                                    <div class="dropdown">
                                                                        <a class="btn btn-icon btn-sm btn-ghost-light text-muted" data-bs-toggle="dropdown" href="#">
                                                                            <i class="ti ti-dots-vertical fs-lg"></i>
                                                                        </a>
                                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-share me-2"></i>
                                                                                    Share
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-edit me-2"></i>
                                                                                    Edit
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item text-danger" href="#">
                                                                                    <i class="ti ti-trash me-2"></i>
                                                                                    Delete
                                                                                </a>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <h5 class="mb-2"><a class="link-reset" href="#!">Improve success/error toast notification styles.</a></h5>
                                                            <div class="d-flex align-items-center mb-2">
                                                                <img class="rounded-circle me-2" height="28" src="/images/users/user-6.jpg" width="28" />
                                                                <span class="text-muted fw-medium">Andrew Carter</span>
                                                            </div>
                                                            <div class="d-flex justify-content-between align-items-center mb-n1 text-muted">
                                                                <span>5 Days</span>
                                                                <span>
                                                                    <i class="ti ti-list-check"></i>
                                                                    1
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-link"></i>
                                                                    0
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-messages"></i>
                                                                    3
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li class="kanban-item">
                                                    <div class="card mb-2 border border-light">
                                                        <div class="card-body">
                                                            <div class="d-flex align-items-center mb-2">
                                                                <span class="badge bg-danger-subtle text-danger badge-label">High</span>
                                                                <div class="ms-auto mt-n2">
                                                                    <div class="dropdown">
                                                                        <a class="btn btn-icon btn-sm btn-ghost-light text-muted" data-bs-toggle="dropdown" href="#">
                                                                            <i class="ti ti-dots-vertical fs-lg"></i>
                                                                        </a>
                                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-share me-2"></i>
                                                                                    Share
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-edit me-2"></i>
                                                                                    Edit
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item text-danger" href="#">
                                                                                    <i class="ti ti-trash me-2"></i>
                                                                                    Delete
                                                                                </a>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <h5 class="mb-2"><a class="link-reset" href="#!">Integrate analytics dashboard with real-time API data.</a></h5>
                                                            <div class="d-flex align-items-center mb-2">
                                                                <img class="rounded-circle me-2" height="28" src="/images/users/user-7.jpg" width="28" />
                                                                <span class="text-muted fw-medium">Logan Brooks</span>
                                                            </div>
                                                            <div class="d-flex justify-content-between align-items-center mb-n1 text-muted">
                                                                <span>3 Days</span>
                                                                <span>
                                                                    <i class="ti ti-list-check"></i>
                                                                    6
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-link"></i>
                                                                    3
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-messages"></i>
                                                                    12
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li class="kanban-item">
                                                    <div class="card mb-2 border border-light">
                                                        <div class="card-body">
                                                            <div class="d-flex align-items-center mb-2">
                                                                <span class="badge bg-warning-subtle text-warning badge-label">Medium</span>
                                                                <div class="ms-auto mt-n2">
                                                                    <div class="dropdown">
                                                                        <a class="btn btn-icon btn-sm btn-ghost-light text-muted" data-bs-toggle="dropdown" href="#">
                                                                            <i class="ti ti-dots-vertical fs-lg"></i>
                                                                        </a>
                                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-share me-2"></i>
                                                                                    Share
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-edit me-2"></i>
                                                                                    Edit
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item text-danger" href="#">
                                                                                    <i class="ti ti-trash me-2"></i>
                                                                                    Delete
                                                                                </a>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <h5 class="mb-2"><a class="link-reset" href="#!">Add pagination support to activity feed list.</a></h5>
                                                            <div class="d-flex align-items-center mb-2">
                                                                <img class="rounded-circle me-2" height="28" src="/images/users/user-1.jpg" width="28" />
                                                                <span class="text-muted fw-medium">Mark Evans</span>
                                                            </div>
                                                            <div class="d-flex justify-content-between text-muted">
                                                                <span>4 Days</span>
                                                                <span>
                                                                    <i class="ti ti-list-check"></i>
                                                                    3
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-link"></i>
                                                                    1
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-messages"></i>
                                                                    5
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <!-- end kanban item-->
                                            </ul>
                                        </div>
                                    </div>
                                    <!-- end In Review Data-->
                                    <!-- Done Data-->
                                    <div class="kanban-board">
                                        <div class="py-2 px-3 d-flex align-items-center">
                                            <h5 class="m-0">Done (2)</h5>
                                            <a class="ms-auto btn btn-sm btn-icon rounded-circle btn-primary" href="#!">
                                                <i class="ti ti-plus"></i>
                                            </a>
                                        </div>
                                        <div class="kanban-board-group px-2" data-simplebar="" data-simplebar-md="">
                                            <ul data-plugins="sortable">
                                                <li class="kanban-item">
                                                    <div class="card mb-2 border border-light">
                                                        <div class="card-body">
                                                            <div class="d-flex align-items-center mb-2">
                                                                <span class="badge bg-success-subtle text-success badge-label">Completed</span>
                                                                <div class="ms-auto mt-n2">
                                                                    <div class="dropdown">
                                                                        <a class="btn btn-icon btn-sm btn-ghost-light text-muted" data-bs-toggle="dropdown" href="#">
                                                                            <i class="ti ti-dots-vertical fs-lg"></i>
                                                                        </a>
                                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-share me-2"></i>
                                                                                    Share
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-edit me-2"></i>
                                                                                    Edit
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item text-danger" href="#">
                                                                                    <i class="ti ti-trash me-2"></i>
                                                                                    Delete
                                                                                </a>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <h5 class="mb-2"><a class="link-reset" href="#!">Completed UI redesign for profile settings page.</a></h5>
                                                            <div class="d-flex align-items-center mb-2">
                                                                <img class="rounded-circle me-2" height="28" src="/images/users/user-3.jpg" width="28" />
                                                                <span class="text-muted fw-medium">Harper Lee</span>
                                                            </div>
                                                            <div class="d-flex justify-content-between align-items-center text-muted">
                                                                <span>Completed</span>
                                                                <span>
                                                                    <i class="ti ti-list-check"></i>
                                                                    4
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-link"></i>
                                                                    1
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-messages"></i>
                                                                    3
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <li class="kanban-item">
                                                    <div class="card mb-2 border border-light">
                                                        <div class="card-body">
                                                            <div class="d-flex align-items-center mb-2">
                                                                <span class="badge bg-success-subtle text-success badge-label">Completed</span>
                                                                <div class="ms-auto mt-n2">
                                                                    <div class="dropdown">
                                                                        <a class="btn btn-icon btn-sm btn-ghost-light text-muted" data-bs-toggle="dropdown" href="#">
                                                                            <i class="ti ti-dots-vertical fs-lg"></i>
                                                                        </a>
                                                                        <ul class="dropdown-menu dropdown-menu-end">
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-share me-2"></i>
                                                                                    Share
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item" href="#">
                                                                                    <i class="ti ti-edit me-2"></i>
                                                                                    Edit
                                                                                </a>
                                                                            </li>
                                                                            <li>
                                                                                <a class="dropdown-item text-danger" href="#">
                                                                                    <i class="ti ti-trash me-2"></i>
                                                                                    Delete
                                                                                </a>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <h5 class="mb-2"><a class="link-reset" href="#!">Launched new email notification templating system.</a></h5>
                                                            <div class="d-flex align-items-center mb-2">
                                                                <img class="rounded-circle me-2" height="28" src="/images/users/user-5.jpg" width="28" />
                                                                <span class="text-muted fw-medium">Jacob Miller</span>
                                                            </div>
                                                            <div class="d-flex justify-content-between align-items-center text-muted">
                                                                <span>Completed</span>
                                                                <span>
                                                                    <i class="ti ti-list-check"></i>
                                                                    5
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-link"></i>
                                                                    0
                                                                </span>
                                                                <span>
                                                                    <i class="ti ti-messages"></i>
                                                                    2
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </li>
                                                <!-- end kanban item-->
                                            </ul>
                                        </div>
                                    </div>
                                    <!-- end Done Data-->
                                </div>
                                <!-- End Kanban-content-->
                            </div>
                            <!-- end card-body-->
                        </div>
                        <!-- end card-->
                    </div>
                    <!-- end row-->
                    <div aria-hidden="true" aria-labelledby="addTaskModalLabel" class="modal fade" id="addTaskModal" tabindex="-1">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title fw-semibold" id="addTaskModalLabel">Add New Task</h5>
                                    <button class="btn-close" data-bs-dismiss="modal" type="button"></button>
                                </div>
                                <div class="modal-body">
                                    <form id="taskForm">
                                        <!-- Task Title -->
                                        <div class="mb-3">
                                            <label class="form-label">Task Title</label>
                                            <input class="form-control" placeholder="Enter task name..." required="" type="text" />
                                        </div>
                                        <!-- Assignee -->
                                        <div class="mb-3">
                                            <label class="form-label">Assign To</label>
                                            <select class="form-select">
                                                <option disabled="" selected="">Select user</option>
                                                <option value="Liam Carter">Liam Carter</option>
                                                <option value="Ava Mitchell">Ava Mitchell</option>
                                                <option value="Noah Parker">Noah Parker</option>
                                                <option value="Emma Scott">Emma Scott</option>
                                                <option value="Logan Brooks">Logan Brooks</option>
                                            </select>
                                        </div>
                                        <!-- Priority -->
                                        <div class="mb-3">
                                            <label class="form-label">Priority</label>
                                            <select class="form-select">
                                                <option selected="" value="Normal">Normal</option>
                                                <option value="Medium">Medium</option>
                                                <option value="High">High</option>
                                                <option value="Urgent">Urgent</option>
                                            </select>
                                        </div>
                                        <!-- Due Date -->
                                        <div class="mb-3">
                                            <label class="form-label">Due Date</label>
                                            <input class="form-control" data-date-format="d M, Y" data-provider="flatpickr" type="date" />
                                        </div>
                                        <!-- Description -->
                                        <div class="mb-3">
                                            <label class="form-label">Description</label>
                                            <textarea class="form-control" placeholder="Brief details..." rows="3"></textarea>
                                        </div>
                                    </form>
                                </div>
                                <div class="modal-footer">
                                    <button class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
                                    <button class="btn btn-primary">
                                        <i class="ti ti-check me-1"></i>
                                        Save Task
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Sortable js -->
        <script src="/plugins/sortablejs/Sortable.min.js"></script>
        <!-- Kanban Page js -->
        <script src="/js/pages/apps-kanban.js"></script>
    </body>
</html>
