<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Projects List')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Apps', 'title' => 'Projects List')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card" data-table="" data-table-rows-per-page="8">
                                <div class="card-header border-light justify-content-between">
                                    <div class="d-flex gap-2">
                                        <div class="app-search">
                                            <input class="form-control" data-table-search="" placeholder="Search project name..." type="search" />
                                            <i class="ti ti-search app-search-icon text-muted"></i>
                                        </div>
                                        <button class="btn btn-danger d-none" data-table-delete-selected="">Delete</button>
                                    </div>
                                    <div class="d-flex align-items-center gap-2">
                                        <span class="me-2 fw-semibold">Filter By:</span>
                                        <!-- Status Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="status">
                                                <option value="All">Status</option>
                                                <option value="In Progress">In Progress</option>
                                                <option value="Pending Review">Pending Review</option>
                                                <option value="Overdue">Overdue</option>
                                                <option value="In Review">In Review</option>
                                                <option value="Completed">Completed</option>
                                                <option value="Scheduled">Scheduled</option>
                                                <option value="On Hold">On Hold</option>
                                                <option value="Pending">Pending</option>
                                            </select>
                                            <i class="ti ti-activity app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Deadline Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-range-filter="date">
                                                <option value="All">Deadline</option>
                                                <option value="Today">Today</option>
                                                <option value="Last 7 Days">Last 7 Days</option>
                                                <option value="Last 30 Days">Last 30 Days</option>
                                                <option value="This Year">This Year</option>
                                            </select>
                                            <i class="ti ti-calendar-clock app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Records Per Page -->
                                        <div>
                                            <select class="form-select form-control my-1 my-md-0" data-table-set-rows-per-page="">
                                                <option value="5">5</option>
                                                <option value="10">10</option>
                                                <option value="15">15</option>
                                                <option value="20">20</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="d-flex gap-1">
                                        <a class="btn btn-soft-primary btn-icon" href="/apps-projects-grid">
                                            <i class="ti ti-category fs-lg"></i>
                                        </a>
                                        <a class="btn btn-primary btn-icon" href="/apps-projects-list">
                                            <i class="ti ti-list-check fs-lg"></i>
                                        </a>
                                    </div>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-custom table-centered table-select table-hover w-100 mb-0">
                                        <thead class="bg-light align-middle bg-opacity-25 thead-sm">
                                            <tr class="text-uppercase fs-xxs">
                                                <th class="ps-3" style="width: 1%">
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" data-table-select-all="" id="select-all-files" type="checkbox" value="option" />
                                                </th>
                                                <th data-table-sort="project">Project</th>
                                                <th>Members</th>
                                                <th data-column="status" data-table-sort="">Status</th>
                                                <th>Tasks</th>
                                                <th>Progress</th>
                                                <th>Attachments</th>
                                                <th>Comments</th>
                                                <th data-column="date" data-table-sort="">Due Date</th>
                                                <th class="text-center" style="width: 1%">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!-- Row 1 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 file-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <div class="d-flex">
                                                        <div class="avatar-md me-3">
                                                            <span class="avatar-title text-bg-light rounded">
                                                                <i class="ti ti-code fs-20 text-muted"></i>
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-1 d-flex align-items-center">
                                                                <a class="link-reset" data-sort="project" href="/apps-projects-details">AI Analytics Dashboard</a>
                                                            </h5>
                                                            <p class="text-muted mb-0 fs-xxs">Updated 5 minutes ago</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="avatar-group avatar-group-xs">
                                                        <div class="avatar">
                                                            <img alt="" class="rounded-circle avatar-xs" src="/images/users/user-2.jpg" />
                                                        </div>
                                                        <div class="avatar">
                                                            <img alt="" class="rounded-circle avatar-xs" src="/images/users/user-3.jpg" />
                                                        </div>
                                                        <div class="avatar">
                                                            <img alt="" class="rounded-circle avatar-xs" src="/images/users/user-5.jpg" />
                                                        </div>
                                                        <div class="avatar">
                                                            <img alt="" class="rounded-circle avatar-xs" src="/images/users/user-1.jpg" />
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <span class="badge badge-soft-success fs-xxs badge-label">In Progress</span>
                                                </td>
                                                <td>
                                                    <h5 class="fs-base mb-0 fw-medium">
                                                        18/60
                                                        <span class="badge bg-secondary">+4 New</span>
                                                    </h5>
                                                </td>
                                                <td>
                                                    <div class="progress" style="height: 5px">
                                                        <div class="progress-bar bg-success" style="width: 65%"></div>
                                                    </div>
                                                </td>
                                                <td>15 Files</td>
                                                <td>5 Comments</td>
                                                <td>10 May, 2025</td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 2 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 file-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <div class="d-flex">
                                                        <div class="avatar-md me-3">
                                                            <span class="avatar-title text-bg-light rounded">
                                                                <i class="ti ti-device-desktop fs-20 text-muted"></i>
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-1 d-flex align-items-center">
                                                                <a class="link-reset" data-sort="project" href="/apps-projects-details">E-commerce Platform</a>
                                                            </h5>
                                                            <p class="text-muted mb-0 fs-xxs">Updated 12 minutes ago</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="avatar-group avatar-group-xs">
                                                        <div class="avatar">
                                                            <img alt="user-img" class="rounded-circle avatar-xs" src="/images/users/user-6.jpg" />
                                                        </div>
                                                        <div class="avatar">
                                                            <img alt="user-img" class="rounded-circle avatar-xs" src="/images/users/user-8.jpg" />
                                                        </div>
                                                        <div class="avatar">
                                                            <img alt="user-img" class="rounded-circle avatar-xs" src="/images/users/user-7.jpg" />
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <span class="badge badge-soft-warning fs-xxs badge-label">Pending Review</span>
                                                </td>
                                                <td>
                                                    <h5 class="fs-base mb-0 fw-medium">10/40</h5>
                                                </td>
                                                <td>
                                                    <div class="progress" style="height: 5px">
                                                        <div class="progress-bar bg-warning" style="width: 25%"></div>
                                                    </div>
                                                </td>
                                                <td>8 Files</td>
                                                <td>3 Comments</td>
                                                <td>12 May, 2025</td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 3 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 file-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <div class="d-flex">
                                                        <div class="avatar-md me-3">
                                                            <span class="avatar-title text-bg-light rounded">
                                                                <i class="ti ti-brush fs-20 text-muted"></i>
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-1 d-flex align-items-center">
                                                                <a class="link-reset" data-sort="project" href="/apps-projects-details">UI Kit Design</a>
                                                            </h5>
                                                            <p class="text-muted mb-0 fs-xxs">Updated 30 minutes ago</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="avatar-group avatar-group-xs">
                                                        <div class="avatar">
                                                            <img alt="user-img" class="rounded-circle avatar-xs" src="/images/users/user-4.jpg" />
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <span class="badge badge-soft-danger fs-xxs badge-label">Overdue</span>
                                                </td>
                                                <td>
                                                    <h5 class="fs-base mb-0 fw-medium">20/40</h5>
                                                </td>
                                                <td>
                                                    <div class="progress" style="height: 5px">
                                                        <div class="progress-bar bg-danger" style="width: 50%"></div>
                                                    </div>
                                                </td>
                                                <td>12 Files</td>
                                                <td>7 Comments</td>
                                                <td>5 May, 2025</td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 4 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 file-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <div class="d-flex">
                                                        <div class="avatar-md me-3">
                                                            <span class="avatar-title text-bg-light rounded">
                                                                <i class="ti ti-world fs-20 text-muted"></i>
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-1 d-flex align-items-center">
                                                                <a class="link-reset" data-sort="project" href="/apps-projects-details">Website Redesign</a>
                                                            </h5>
                                                            <p class="text-muted mb-0 fs-xxs">Updated 1 hour ago</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="avatar-group avatar-group-xs">
                                                        <div class="avatar">
                                                            <img alt="user-img" class="rounded-circle avatar-xs" src="/images/users/user-2.jpg" />
                                                        </div>
                                                        <div class="avatar">
                                                            <img alt="user-img" class="rounded-circle avatar-xs" src="/images/users/user-7.jpg" />
                                                        </div>
                                                        <div class="avatar">
                                                            <img alt="user-img" class="rounded-circle avatar-xs" src="/images/users/user-9.jpg" />
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <span class="badge badge-soft-info fs-xxs badge-label">In Review</span>
                                                </td>
                                                <td>
                                                    <h5 class="fs-base mb-0 fw-medium">
                                                        15/30
                                                        <span class="badge bg-secondary">+1 New</span>
                                                    </h5>
                                                </td>
                                                <td>
                                                    <div class="progress" style="height: 5px">
                                                        <div class="progress-bar bg-info" style="width: 50%"></div>
                                                    </div>
                                                </td>
                                                <td>6 Files</td>
                                                <td>2 Comments</td>
                                                <td>18 May, 2025</td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 5 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 file-item-check mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <div class="d-flex">
                                                        <div class="avatar-md me-3">
                                                            <span class="avatar-title text-bg-light rounded">
                                                                <i class="ti ti-chart-bar fs-20 text-muted"></i>
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-1 d-flex align-items-center">
                                                                <a class="link-reset" data-sort="project" href="/apps-projects-details">Marketing Report</a>
                                                            </h5>
                                                            <p class="text-muted mb-0 fs-xxs">Updated 2 hours ago</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="avatar-group avatar-group-xs">
                                                        <div class="avatar">
                                                            <img alt="user-img" class="rounded-circle avatar-xs" src="/images/users/user-5.jpg" />
                                                        </div>
                                                        <div class="avatar">
                                                            <img alt="user-img" class="rounded-circle avatar-xs" src="/images/users/user-10.jpg" />
                                                        </div>
                                                        <div class="avatar">
                                                            <img alt="user-img" class="rounded-circle avatar-xs" src="/images/users/user-8.jpg" />
                                                        </div>
                                                        <div class="avatar">
                                                            <img alt="user-img" class="rounded-circle avatar-xs" src="/images/users/user-2.jpg" />
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <span class="badge badge-soft-primary fs-xxs badge-label">Completed</span>
                                                </td>
                                                <td>
                                                    <h5 class="fs-base mb-0 fw-medium">
                                                        40/40
                                                        <span class="badge bg-success">✓</span>
                                                    </h5>
                                                </td>
                                                <td>
                                                    <div class="progress" style="height: 5px">
                                                        <div class="progress-bar bg-primary" style="width: 100%"></div>
                                                    </div>
                                                </td>
                                                <td>20 Files</td>
                                                <td>10 Comments</td>
                                                <td>1 May, 2025</td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 6 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 file-item-check mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <div class="d-flex">
                                                        <div class="avatar-md me-3">
                                                            <span class="avatar-title text-bg-light rounded">
                                                                <i class="ti ti-bulb fs-20 text-muted"></i>
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-1 d-flex align-items-center">
                                                                <a class="link-reset" data-sort="project" href="/apps-projects-details">Sales Pitch Deck</a>
                                                            </h5>
                                                            <p class="text-muted mb-0 fs-xxs">Updated 45 minutes ago</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="avatar-group avatar-group-xs">
                                                        <div class="avatar">
                                                            <img alt="user-img" class="rounded-circle avatar-xs" src="/images/users/user-9.jpg" />
                                                        </div>
                                                        <div class="avatar">
                                                            <img alt="user-img" class="rounded-circle avatar-xs" src="/images/users/user-10.jpg" />
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <span class="badge badge-soft-info fs-xxs badge-label">In Review</span>
                                                </td>
                                                <td>
                                                    <h5 class="fs-base mb-0 fw-medium">
                                                        9/12
                                                        <span class="badge bg-secondary">+1 New</span>
                                                    </h5>
                                                </td>
                                                <td>
                                                    <div class="progress" style="height: 5px">
                                                        <div class="progress-bar bg-info" style="width: 75%"></div>
                                                    </div>
                                                </td>
                                                <td>5 Files</td>
                                                <td>1 Comment</td>
                                                <td>9 May, 2025</td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 7 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 file-item-check mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <div class="d-flex">
                                                        <div class="avatar-md me-3">
                                                            <span class="avatar-title text-bg-light rounded">
                                                                <i class="ti ti-speakerphone fs-20 text-muted"></i>
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-1 d-flex align-items-center">
                                                                <a class="link-reset" data-sort="project" href="/apps-projects-details">Mobile UI Mockups</a>
                                                            </h5>
                                                            <p class="text-muted mb-0 fs-xxs">Updated yesterday</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="avatar-group avatar-group-xs">
                                                        <div class="avatar">
                                                            <img alt="user-img" class="rounded-circle avatar-xs" src="/images/users/user-7.jpg" />
                                                        </div>
                                                        <div class="avatar">
                                                            <img alt="user-img" class="rounded-circle avatar-xs" src="/images/users/user-4.jpg" />
                                                        </div>
                                                        <div class="avatar">
                                                            <img alt="user-img" class="rounded-circle avatar-xs" src="/images/users/user-5.jpg" />
                                                        </div>
                                                        <div class="avatar">
                                                            <img alt="user-img" class="rounded-circle avatar-xs" src="/images/users/user-1.jpg" />
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <span class="badge badge-soft-success fs-xxs badge-label">In Progress</span>
                                                </td>
                                                <td>
                                                    <h5 class="fs-base mb-0 fw-medium">
                                                        6/10
                                                        <span class="badge bg-secondary">+3 New</span>
                                                    </h5>
                                                </td>
                                                <td>
                                                    <div class="progress" style="height: 5px">
                                                        <div class="progress-bar bg-success" style="width: 60%"></div>
                                                    </div>
                                                </td>
                                                <td>7 Files</td>
                                                <td>0 Comments</td>
                                                <td>6 May, 2025</td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 8 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 file-item-check mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <div class="d-flex">
                                                        <div class="avatar-md me-3">
                                                            <span class="avatar-title text-bg-light rounded">
                                                                <i class="ti ti-database fs-20 text-muted"></i>
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-1 d-flex align-items-center">
                                                                <a class="link-reset" data-sort="project" href="/apps-projects-details">Server Maintenance</a>
                                                            </h5>
                                                            <p class="text-muted mb-0 fs-xxs">Updated 3 days ago</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="avatar-group avatar-group-xs">
                                                        <div class="avatar">
                                                            <img alt="user-img" class="rounded-circle avatar-xs" src="/images/users/user-6.jpg" />
                                                        </div>
                                                        <div class="avatar">
                                                            <img alt="user-img" class="rounded-circle avatar-xs" src="/images/users/user-5.jpg" />
                                                        </div>
                                                        <div class="avatar">
                                                            <img alt="user-img" class="rounded-circle avatar-xs" src="/images/users/user-9.jpg" />
                                                        </div>
                                                        <div class="avatar">
                                                            <img alt="user-img" class="rounded-circle avatar-xs" src="/images/users/user-10.jpg" />
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <span class="badge badge-soft-secondary fs-xxs badge-label">Scheduled</span>
                                                </td>
                                                <td>
                                                    <h5 class="fs-base mb-0 fw-medium">
                                                        3/3
                                                        <span class="badge bg-success">✓</span>
                                                    </h5>
                                                </td>
                                                <td>
                                                    <div class="progress" style="height: 5px">
                                                        <div class="progress-bar bg-secondary" style="width: 100%"></div>
                                                    </div>
                                                </td>
                                                <td>2 Files</td>
                                                <td>1 Comment</td>
                                                <td>3 May, 2025</td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 9 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 file-item-check mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <div class="d-flex">
                                                        <div class="avatar-md me-3">
                                                            <span class="avatar-title text-bg-light rounded">
                                                                <i class="ti ti-bug fs-20 text-muted"></i>
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-1 d-flex align-items-center">
                                                                <a class="link-reset" data-sort="project" href="/apps-projects-details">Security Audit</a>
                                                            </h5>
                                                            <p class="text-muted mb-0 fs-xxs">Updated last week</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="avatar-group avatar-group-xs">
                                                        <div class="avatar">
                                                            <img alt="user-img" class="rounded-circle avatar-xs" src="/images/users/user-7.jpg" />
                                                        </div>
                                                        <div class="avatar">
                                                            <img alt="user-img" class="rounded-circle avatar-xs" src="/images/users/user-9.jpg" />
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <span class="badge badge-soft-dark fs-xxs badge-label">On Hold</span>
                                                </td>
                                                <td>
                                                    <h5 class="fs-base mb-0 fw-medium">
                                                        5/10
                                                        <span class="badge bg-secondary">+1 New</span>
                                                    </h5>
                                                </td>
                                                <td>
                                                    <div class="progress" style="height: 5px">
                                                        <div class="progress-bar bg-dark" style="width: 50%"></div>
                                                    </div>
                                                </td>
                                                <td>6 Files</td>
                                                <td>4 Comments</td>
                                                <td>2 May, 2025</td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 10 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 file-item-check mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <div class="d-flex">
                                                        <div class="avatar-md me-3">
                                                            <span class="avatar-title text-bg-light rounded">
                                                                <i class="ti ti-settings-2 fs-20 text-muted"></i>
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-1 d-flex align-items-center">
                                                                <a class="link-reset" data-sort="project" href="/apps-projects-details">Plugin Development</a>
                                                            </h5>
                                                            <p class="text-muted mb-0 fs-xxs">Updated 4 days ago</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="avatar-group avatar-group-xs">
                                                        <div class="avatar">
                                                            <img alt="user-img" class="rounded-circle avatar-xs" src="/images/users/user-3.jpg" />
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <span class="badge badge-soft-warning fs-xxs badge-label">Pending</span>
                                                </td>
                                                <td>
                                                    <h5 class="fs-base mb-0 fw-medium">
                                                        2/6
                                                        <span class="badge bg-secondary">+1 New</span>
                                                    </h5>
                                                </td>
                                                <td>
                                                    <div class="progress" style="height: 5px">
                                                        <div class="progress-bar bg-warning" style="width: 33%"></div>
                                                    </div>
                                                </td>
                                                <td>4 Files</td>
                                                <td>2 Comments</td>
                                                <td>7 May, 2025</td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="card-footer border-0">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div data-table-pagination-info="projects"></div>
                                        <div data-table-pagination=""></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                    </div>
                    <!-- end row -->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Custom table -->
        <script src="/js/pages/custom-table.js"></script>
    </body>
</html>
