<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Team Board')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="d-flex align-items-sm-center flex-sm-row flex-column my-3">
                                <div class="flex-grow-1">
                                    <h4 class="fs-xl mb-1">Manage Teams</h4>
                                    <p class="text-muted mb-0">Assign roles to streamline teamwork and secure access.</p>
                                </div>
                                <div class="text-end">
                                    <a class="btn btn-success" data-bs-target="#addTeamModal" data-bs-toggle="modal" href="javascript:void(0);">
                                        <i class="ti ti-plus me-1"></i>
                                        Add New Team
                                    </a>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 col-lg-4">
                                    <div class="card card-h-100">
                                        <div class="card-header">
                                            <h4 class="card-title">
                                                IT-01 - Design Team
                                                <span class="ms-2 badge badge-label text-bg-primary">New</span>
                                            </h4>
                                            <div class="dropdown ms-auto">
                                                <a class="text-muted fs-xl" data-bs-toggle="dropdown" href="#">
                                                    <i class="ti ti-dots-vertical"></i>
                                                </a>
                                                <ul class="dropdown-menu dropdown-menu-end">
                                                    <li>
                                                        <a class="dropdown-item" href="#">
                                                            <i class="ti ti-eye me-2"></i>
                                                            View
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="#">
                                                            <i class="ti ti-edit me-2"></i>
                                                            Edit
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item text-danger" href="#">
                                                            <i class="ti ti-trash me-2"></i>
                                                            Remove
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="card-body d-flex flex-column justify-content-between">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <p class="mb-2 text-muted">Total 4 members</p>
                                                    <div class="avatar-group avatar-group-sm mb-3">
                                                        <div class="avatar">
                                                            <img alt="" class="rounded-circle avatar-sm" src="/images/users/user-7.jpg" />
                                                        </div>
                                                        <div class="avatar">
                                                            <img alt="" class="rounded-circle avatar-sm" src="/images/users/user-8.jpg" />
                                                        </div>
                                                        <div class="avatar">
                                                            <img alt="" class="rounded-circle avatar-sm" src="/images/users/user-9.jpg" />
                                                        </div>
                                                        <div class="avatar">
                                                            <img alt="" class="rounded-circle avatar-sm" src="/images/users/user-10.jpg" />
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="d-flex gap-2">
                                                        <div class="avatar-sm flex-shrink-0">
                                                            <span class="avatar-title text-bg-light rounded-circle">
                                                                <i class="ti ti-medal fs-lg"></i>
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <h6 class="mb-1 text-muted text-uppercase">Ranking</h6>
                                                            <p class="fw-medium mb-0">#5</p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="mb-3">
                                                <p class="text-muted">The Design Team focuses on creating intuitive user experiences and visually appealing interfaces. We handle UI/UX design, prototyping, and brand consistency across all digital products.</p>
                                            </div>
                                            <div class="mb-3">
                                                <div class="d-flex align-items-center justify-content-between mb-2">
                                                    <p class="mb-0 text-muted fw-medium">Status of current project</p>
                                                    <p class="fw-semibold mb-0">65%</p>
                                                </div>
                                                <div class="progress progress-sm">
                                                    <div class="progress-bar" style="width: 65%"></div>
                                                </div>
                                            </div>
                                            <div class="d-flex justify-content-between align-items-center">
                                                <span class="text-muted fs-xs">
                                                    <i class="ti ti-clock me-1"></i>
                                                    Updated 1 hour ago
                                                </span>
                                                <a class="btn btn-sm btn-primary rounded-pill" href="#">Details</a>
                                            </div>
                                        </div>
                                        <!-- end card-body-->
                                    </div>
                                    <!-- end card-->
                                </div>
                                <!-- end col-->
                                <div class="col-md-6 col-lg-4">
                                    <div class="card card-h-100">
                                        <div class="card-header d-flex align-items-center">
                                            <h4 class="card-title mb-0">
                                                IT-02 - Development Team
                                                <span class="ms-2 badge badge-label text-bg-success">Active</span>
                                            </h4>
                                            <div class="dropdown ms-auto">
                                                <a class="text-muted fs-xl" data-bs-toggle="dropdown" href="#"><i class="ti ti-dots-vertical"></i></a>
                                                <ul class="dropdown-menu dropdown-menu-end">
                                                    <li>
                                                        <a class="dropdown-item" href="#">
                                                            <i class="ti ti-eye me-2"></i>
                                                            View
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="#">
                                                            <i class="ti ti-edit me-2"></i>
                                                            Edit
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item text-danger" href="#">
                                                            <i class="ti ti-trash me-2"></i>
                                                            Remove
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="card-body d-flex flex-column justify-content-between">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <p class="mb-2 text-muted">Total 6 members</p>
                                                    <div class="avatar-group avatar-group-sm mb-3">
                                                        <div class="avatar"><img class="rounded-circle avatar-sm" src="/images/users/user-1.jpg" /></div>
                                                        <div class="avatar"><img class="rounded-circle avatar-sm" src="/images/users/user-2.jpg" /></div>
                                                        <div class="avatar"><img class="rounded-circle avatar-sm" src="/images/users/user-3.jpg" /></div>
                                                        <div class="avatar"><img class="rounded-circle avatar-sm" src="/images/users/user-4.jpg" /></div>
                                                        <div class="avatar"><img class="rounded-circle avatar-sm" src="/images/users/user-5.jpg" /></div>
                                                        <div class="avatar avatar-sm">
                                                            <span class="avatar-title text-bg-primary rounded-circle fw-bold">1+</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="d-flex gap-2">
                                                        <div class="avatar-sm flex-shrink-0">
                                                            <span class="avatar-title text-bg-light rounded-circle"><i class="ti ti-medal fs-lg"></i></span>
                                                        </div>
                                                        <div>
                                                            <h6 class="mb-1 text-muted text-uppercase">Ranking</h6>
                                                            <p class="fw-medium mb-0">#2</p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <p class="text-muted mb-3">Responsible for application logic, backend development, API integration, and performance optimization across platforms.</p>
                                            <div class="mb-3">
                                                <div class="d-flex align-items-center justify-content-between mb-2">
                                                    <p class="mb-0 text-muted fw-medium">Current Sprint Progress</p>
                                                    <p class="fw-semibold mb-0">82%</p>
                                                </div>
                                                <div class="progress progress-sm">
                                                    <div class="progress-bar" style="width: 82%"></div>
                                                </div>
                                            </div>
                                            <div class="d-flex justify-content-between align-items-center">
                                                <span class="text-muted fs-xs">
                                                    <i class="ti ti-clock me-1"></i>
                                                    Updated 3 hours ago
                                                </span>
                                                <a class="btn btn-sm btn-primary rounded-pill" href="#">Details</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end col-->
                                <div class="col-md-6 col-lg-4">
                                    <div class="card card-h-100">
                                        <div class="card-header d-flex align-items-center">
                                            <h4 class="card-title mb-0">
                                                IT-03 - QA Team
                                                <span class="ms-2 badge badge-label text-bg-warning">Ongoing</span>
                                            </h4>
                                            <div class="dropdown ms-auto">
                                                <a class="text-muted fs-xl" data-bs-toggle="dropdown" href="#"><i class="ti ti-dots-vertical"></i></a>
                                                <ul class="dropdown-menu dropdown-menu-end">
                                                    <li>
                                                        <a class="dropdown-item">
                                                            <i class="ti ti-eye me-2"></i>
                                                            View
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item">
                                                            <i class="ti ti-edit me-2"></i>
                                                            Edit
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item text-danger">
                                                            <i class="ti ti-trash me-2"></i>
                                                            Remove
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="card-body d-flex flex-column justify-content-between">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <p class="mb-2 text-muted">Total 5 members</p>
                                                    <div class="avatar-group avatar-group-sm mb-3">
                                                        <div class="avatar"><img class="rounded-circle avatar-sm" src="/images/users/user-10.jpg" /></div>
                                                        <div class="avatar"><img class="rounded-circle avatar-sm" src="/images/users/user-9.jpg" /></div>
                                                        <div class="avatar"><img class="rounded-circle avatar-sm" src="/images/users/user-8.jpg" /></div>
                                                        <div class="avatar"><img class="rounded-circle avatar-sm" src="/images/users/user-7.jpg" /></div>
                                                        <div class="avatar"><img class="rounded-circle avatar-sm" src="/images/users/user-6.jpg" /></div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="d-flex gap-2">
                                                        <div class="avatar-sm flex-shrink-0">
                                                            <span class="avatar-title text-bg-light rounded-circle"><i class="ti ti-medal fs-lg"></i></span>
                                                        </div>
                                                        <div>
                                                            <h6 class="mb-1 text-muted text-uppercase">Ranking</h6>
                                                            <p class="fw-medium mb-0">#3</p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <p class="text-muted mb-3">Ensures software stability, conducts manual &amp; automated tests, maintains bug reports &amp; release validation.</p>
                                            <div class="mb-3">
                                                <div class="d-flex justify-content-between align-items-center mb-2">
                                                    <p class="mb-0 text-muted fw-medium">Testing Cycle Progress</p>
                                                    <p class="fw-semibold mb-0">74%</p>
                                                </div>
                                                <div class="progress progress-sm">
                                                    <div class="progress-bar" style="width: 74%"></div>
                                                </div>
                                            </div>
                                            <div class="d-flex justify-content-between align-items-center">
                                                <span class="text-muted fs-xs">
                                                    <i class="ti ti-clock me-1"></i>
                                                    Updated yesterday
                                                </span>
                                                <a class="btn btn-sm btn-primary rounded-pill" href="#">Details</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end col-->
                                <div class="col-md-6 col-lg-4">
                                    <div class="card card-h-100">
                                        <div class="card-header d-flex align-items-center">
                                            <h4 class="card-title mb-0">
                                                MK-01 - Marketing Team
                                                <span class="ms-2 badge badge-label text-bg-info">Active</span>
                                            </h4>
                                            <div class="dropdown ms-auto">
                                                <a class="text-muted fs-xl" data-bs-toggle="dropdown" href="#"><i class="ti ti-dots-vertical"></i></a>
                                                <ul class="dropdown-menu dropdown-menu-end">
                                                    <li>
                                                        <a class="dropdown-item">
                                                            <i class="ti ti-eye me-2"></i>
                                                            View
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item">
                                                            <i class="ti ti-edit me-2"></i>
                                                            Edit
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item text-danger">
                                                            <i class="ti ti-trash me-2"></i>
                                                            Remove
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="card-body d-flex flex-column justify-content-between">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <p class="mb-2 text-muted">Total 8 members</p>
                                                    <div class="avatar-group avatar-group-sm mb-3">
                                                        <div class="avatar"><img class="rounded-circle avatar-sm" src="/images/users/user-3.jpg" /></div>
                                                        <div class="avatar"><img class="rounded-circle avatar-sm" src="/images/users/user-5.jpg" /></div>
                                                        <div class="avatar"><img class="rounded-circle avatar-sm" src="/images/users/user-7.jpg" /></div>
                                                        <div class="avatar"><img class="rounded-circle avatar-sm" src="/images/users/user-9.jpg" /></div>
                                                        <div class="avatar"><img class="rounded-circle avatar-sm" src="/images/users/user-1.jpg" /></div>
                                                        <div class="avatar avatar-sm">
                                                            <span class="avatar-title text-bg-primary rounded-circle fw-bold">3+</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="d-flex gap-2">
                                                        <div class="avatar-sm flex-shrink-0">
                                                            <span class="avatar-title text-bg-light rounded-circle"><i class="ti ti-medal fs-lg"></i></span>
                                                        </div>
                                                        <div>
                                                            <h6 class="mb-1 text-muted text-uppercase">Ranking</h6>
                                                            <p class="fw-medium mb-0">#4</p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <p class="text-muted mb-3">Handles brand messaging, campaigns, email automation, awareness growth &amp; product launch communication.</p>
                                            <div class="mb-3">
                                                <div class="d-flex justify-content-between mb-2">
                                                    <p class="mb-0 text-muted fw-medium">Campaign Performance</p>
                                                    <p class="fw-semibold mb-0">58%</p>
                                                </div>
                                                <div class="progress progress-sm">
                                                    <div class="progress-bar" style="width: 58%"></div>
                                                </div>
                                            </div>
                                            <div class="d-flex justify-content-between">
                                                <span class="text-muted fs-xs">
                                                    <i class="ti ti-clock"></i>
                                                    Updated 5 hours ago
                                                </span>
                                                <a class="btn btn-sm btn-primary rounded-pill" href="#">Details</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end col-->
                                <div class="col-md-6 col-lg-4">
                                    <div class="card card-h-100">
                                        <div class="card-header d-flex align-items-center">
                                            <h4 class="card-title mb-0">
                                                FN-01 - Finance Team
                                                <span class="ms-2 badge badge-label text-bg-secondary">Stable</span>
                                            </h4>
                                            <div class="dropdown ms-auto">
                                                <a class="text-muted fs-xl" data-bs-toggle="dropdown" href="#"><i class="ti ti-dots-vertical"></i></a>
                                                <ul class="dropdown-menu dropdown-menu-end">
                                                    <li>
                                                        <a class="dropdown-item">
                                                            <i class="ti ti-eye me-2"></i>
                                                            View
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item">
                                                            <i class="ti ti-edit me-2"></i>
                                                            Edit
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item text-danger">
                                                            <i class="ti ti-trash me-2"></i>
                                                            Remove
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="card-body d-flex flex-column justify-content-between">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <p class="mb-2 text-muted">Total 3 members</p>
                                                    <div class="avatar-group avatar-group-sm mb-3">
                                                        <div class="avatar"><img class="rounded-circle avatar-sm" src="/images/users/user-7.jpg" /></div>
                                                        <div class="avatar"><img class="rounded-circle avatar-sm" src="/images/users/user-9.jpg" /></div>
                                                        <div class="avatar"><img class="rounded-circle avatar-sm" src="/images/users/user-6.jpg" /></div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="d-flex gap-2">
                                                        <div class="avatar-sm flex-shrink-0">
                                                            <span class="avatar-title text-bg-light rounded-circle"><i class="ti ti-medal fs-lg"></i></span>
                                                        </div>
                                                        <div>
                                                            <h6 class="mb-1 text-muted text-uppercase">Ranking</h6>
                                                            <p class="fw-medium mb-0">#1</p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <p class="text-muted mb-3">Maintains accounts, revenue reporting, budgeting, compliance tracking &amp; payroll processing.</p>
                                            <div class="mb-3">
                                                <div class="d-flex justify-content-between mb-2">
                                                    <p class="mb-0 text-muted fw-medium">Quarterly Closure Progress</p>
                                                    <p class="fw-semibold mb-0">91%</p>
                                                </div>
                                                <div class="progress progress-sm">
                                                    <div class="progress-bar" style="width: 91%"></div>
                                                </div>
                                            </div>
                                            <div class="d-flex justify-content-between">
                                                <span class="text-muted fs-xs">
                                                    <i class="ti ti-clock"></i>
                                                    Updated 2 days ago
                                                </span>
                                                <a class="btn btn-sm btn-primary rounded-pill" href="#">Details</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end col-->
                                <div class="col-md-6 col-lg-4">
                                    <div class="card card-h-100">
                                        <div class="card-header d-flex align-items-center">
                                            <h4 class="card-title mb-0">
                                                CS-01 - Customer Success Team
                                                <span class="ms-2 badge badge-label text-bg-danger">Busy</span>
                                            </h4>
                                            <div class="dropdown ms-auto">
                                                <a class="text-muted fs-xl" data-bs-toggle="dropdown" href="#"><i class="ti ti-dots-vertical"></i></a>
                                                <ul class="dropdown-menu dropdown-menu-end">
                                                    <li>
                                                        <a class="dropdown-item">
                                                            <i class="ti ti-eye me-2"></i>
                                                            View
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item">
                                                            <i class="ti ti-edit me-2"></i>
                                                            Edit
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item text-danger">
                                                            <i class="ti ti-trash me-2"></i>
                                                            Remove
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                        <div class="card-body d-flex flex-column justify-content-between">
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <p class="mb-2 text-muted">Total 7 members</p>
                                                    <div class="avatar-group avatar-group-sm mb-3">
                                                        <div class="avatar"><img class="rounded-circle avatar-sm" src="/images/users/user-7.jpg" /></div>
                                                        <div class="avatar"><img class="rounded-circle avatar-sm" src="/images/users/user-4.jpg" /></div>
                                                        <div class="avatar"><img class="rounded-circle avatar-sm" src="/images/users/user-2.jpg" /></div>
                                                        <div class="avatar"><img class="rounded-circle avatar-sm" src="/images/users/user-1.jpg" /></div>
                                                        <div class="avatar"><img class="rounded-circle avatar-sm" src="/images/users/user-10.jpg" /></div>
                                                        <div class="avatar avatar-sm">
                                                            <span class="avatar-title text-bg-primary rounded-circle fw-bold">2+</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="d-flex gap-2">
                                                        <div class="avatar-sm flex-shrink-0">
                                                            <span class="avatar-title text-bg-light rounded-circle"><i class="ti ti-medal fs-lg"></i></span>
                                                        </div>
                                                        <div>
                                                            <h6 class="mb-1 text-muted text-uppercase">Ranking</h6>
                                                            <p class="fw-medium mb-0">#6</p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <p class="text-muted mb-3">Onboards new clients, resolves customer issues, monitors usage retention &amp; improves satisfaction scores.</p>
                                            <div class="mb-3">
                                                <div class="d-flex justify-content-between mb-2">
                                                    <p class="mb-0 text-muted fw-medium">SLA Response Performance</p>
                                                    <p class="fw-semibold mb-0">48%</p>
                                                </div>
                                                <div class="progress progress-sm">
                                                    <div class="progress-bar" style="width: 48%"></div>
                                                </div>
                                            </div>
                                            <div class="d-flex justify-content-between">
                                                <span class="text-muted fs-xs">
                                                    <i class="ti ti-clock"></i>
                                                    Updated 4 hours ago
                                                </span>
                                                <a class="btn btn-sm btn-primary rounded-pill" href="#">Details</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end col-->
                            </div>
                            <!-- end row-->
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                    <div aria-hidden="true" aria-labelledby="addTeamModalLabel" class="modal fade" id="addTeamModal" tabindex="-1">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title fw-semibold" id="addTeamModalLabel">Add New Team</h5>
                                    <button class="btn-close" data-bs-dismiss="modal" type="button"></button>
                                </div>
                                <div class="modal-body">
                                    <form id="teamForm">
                                        <!-- Team Name -->
                                        <div class="mb-3">
                                            <label class="form-label">Team Name</label>
                                            <input class="form-control" placeholder="e.g., Creative Design Team" required="" type="text" />
                                        </div>
                                        <!-- Team Code / Short Label -->
                                        <div class="mb-3">
                                            <label class="form-label">Team Code</label>
                                            <input class="form-control" placeholder="e.g., IT-01" required="" type="text" />
                                        </div>
                                        <!-- Team Status -->
                                        <div class="mb-3">
                                            <label class="form-label">Status</label>
                                            <select class="form-select">
                                                <option selected="" value="New">New</option>
                                                <option value="Active">Active</option>
                                                <option value="Ongoing">Ongoing</option>
                                                <option value="Busy">Busy</option>
                                                <option value="Stable">Stable</option>
                                            </select>
                                        </div>
                                        <!-- Members -->
                                        <div class="mb-3">
                                            <label class="form-label">Team Members</label>
                                            <select class="form-select" multiple="">
                                                <option value="1">Liam Carter</option>
                                                <option value="2">Ava Mitchell</option>
                                                <option value="3">Noah Parker</option>
                                                <option value="4">Emma Scott</option>
                                                <option value="5">Logan Brooks</option>
                                                <option value="6">Sophie Adams</option>
                                                <option value="7">Ethan Hall</option>
                                            </select>
                                            <div class="form-text">Hold Ctrl (Windows) or Cmd (Mac) to select multiple users.</div>
                                        </div>
                                        <!-- Description -->
                                        <div class="mb-0">
                                            <label class="form-label">Description</label>
                                            <textarea class="form-control" placeholder="Brief team responsibilities..." rows="3"></textarea>
                                        </div>
                                    </form>
                                </div>
                                <div class="modal-footer">
                                    <button class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
                                    <button class="btn btn-success">
                                        <i class="ti ti-check me-1"></i>
                                        Save Team
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>
    </body>
</html>
