<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Discounts')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Promo', 'title' => 'Discounts')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card" data-table="" data-table-rows-per-page="10">
                                <div class="card-header border-light justify-content-between">
                                    <div class="d-flex gap-2">
                                        <!-- Search -->
                                        <div class="app-search">
                                            <input class="form-control" data-table-search="" placeholder="Search discount..." type="search" />
                                            <i class="ti ti-search app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Delete Selected -->
                                        <button class="btn btn-danger d-none" data-table-delete-selected="">Delete</button>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                        <span class="me-2 fw-semibold">Filter By:</span>
                                        <!-- Status Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="discount-status">
                                                <option value="All">Discount Status</option>
                                                <option value="Active">Active</option>
                                                <option value="Scheduled">Scheduled</option>
                                                <option value="Expired">Expired</option>
                                                <option value="Disabled">Disabled</option>
                                            </select>
                                            <i class="ti ti-circle-check app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Type Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="discount-type">
                                                <option value="All">Discount Type</option>
                                                <option value="Percentage">Percentage</option>
                                                <option value="Flat">Flat Amount</option>
                                                <option value="BOGO">Buy One Get One (BOGO)</option>
                                                <option value="Bundle">Bundle Offer</option>
                                            </select>
                                            <i class="ti ti-tag app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Records Per Page -->
                                        <div>
                                            <select class="form-select form-control my-1 my-md-0" data-table-set-rows-per-page="">
                                                <option value="5">5</option>
                                                <option selected="" value="10">10</option>
                                                <option value="15">15</option>
                                                <option value="20">20</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="d-flex gap-1">
                                        <button class="btn btn-danger" data-bs-target="#addDiscountModal" data-bs-toggle="modal">
                                            <i class="ti ti-plus me-1"></i>
                                            Add Discount
                                        </button>
                                    </div>
                                </div>
                                <!-- /.card-header -->
                                <div class="table-responsive">
                                    <table class="table table-custom table-centered table-select table-hover w-100 mb-0">
                                        <thead class="bg-light align-middle bg-opacity-25 thead-sm">
                                            <tr class="text-uppercase fs-xxs">
                                                <th class="ps-3" style="width: 1%">
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" data-table-select-all="" type="checkbox" />
                                                </th>
                                                <th data-table-sort="">Discount Name</th>
                                                <th data-column="discount-type" data-table-sort="">Discount Type</th>
                                                <th data-table-sort="">Discount Value</th>
                                                <th data-table-sort="">Start Date</th>
                                                <th data-table-sort="">End Date</th>
                                                <th data-table-sort="">Min Purchase</th>
                                                <th data-table-sort="">Max Discount</th>
                                                <th data-column="discount-status" data-table-sort="">Status</th>
                                                <th class="text-center" style="width: 1%">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!-- Row 1 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <h5 class="fs-sm mb-0">
                                                        <a class="link-reset" href="#!">Summer Sale</a>
                                                    </h5>
                                                    <small class="text-muted">Applicable on all summer collection items</small>
                                                </td>
                                                <td><span class="badge badge-label fs-xs badge-soft-primary">Percentage</span></td>
                                                <td>25%</td>
                                                <td>1 May, 2025</td>
                                                <td>31 May, 2025</td>
                                                <td>$50</td>
                                                <td>$150</td>
                                                <td class="text-success fw-semibold">
                                                    <i class="ti ti-circle-filled fs-sm me-1"></i>
                                                    Active
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="/apps-ecommerce-discount-edit"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 2 -->
                                            <tr>
                                                <td class="ps-3"><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>
                                                    <h5 class="fs-sm mb-0"><a class="link-reset" href="#!">New User Offer</a></h5>
                                                    <small class="text-muted">Only for first purchase customers</small>
                                                </td>
                                                <td><span class="badge badge-label fs-xs badge-soft-success">Flat</span></td>
                                                <td>$10</td>
                                                <td>10 Mar, 2025</td>
                                                <td>31 Dec, 2025</td>
                                                <td>$30</td>
                                                <td>$10</td>
                                                <td class="text-success fw-semibold">
                                                    <i class="ti ti-circle-filled fs-sm me-1"></i>
                                                    Active
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 3 -->
                                            <tr>
                                                <td class="ps-3"><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>
                                                    <h5 class="fs-sm mb-0"><a class="link-reset" href="#!">Weekend Special</a></h5>
                                                    <small class="text-muted">Valid only on Saturdays and Sundays</small>
                                                </td>
                                                <td><span class="badge badge-label fs-xs badge-soft-primary">Percentage</span></td>
                                                <td>15%</td>
                                                <td>1 Jun, 2025</td>
                                                <td>30 Sep, 2025</td>
                                                <td>$20</td>
                                                <td>$100</td>
                                                <td class="text-warning fw-semibold">
                                                    <i class="ti ti-circle-filled fs-sm me-1"></i>
                                                    Scheduled
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 4 -->
                                            <tr>
                                                <td class="ps-3"><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>
                                                    <h5 class="fs-sm mb-0"><a class="link-reset" href="#!">Black Friday Mega Deal</a></h5>
                                                    <small class="text-muted">Sitewide discount for limited period</small>
                                                </td>
                                                <td><span class="badge badge-label fs-xs badge-soft-primary">Percentage</span></td>
                                                <td>40%</td>
                                                <td>25 Nov, 2025</td>
                                                <td>28 Nov, 2025</td>
                                                <td>$100</td>
                                                <td>$300</td>
                                                <td class="text-danger fw-semibold">
                                                    <i class="ti ti-circle-filled fs-sm me-1"></i>
                                                    Expired
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 5 -->
                                            <tr>
                                                <td class="ps-3"><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>
                                                    <h5 class="fs-sm mb-0"><a class="link-reset" href="#!">Holiday Bundle Offer</a></h5>
                                                    <small class="text-muted">Buy 2 get 1 free — auto-applied at checkout</small>
                                                </td>
                                                <td><span class="badge badge-label fs-xs badge-soft-info">BOGO</span></td>
                                                <td>-</td>
                                                <td>15 Dec, 2025</td>
                                                <td>31 Dec, 2025</td>
                                                <td>$0</td>
                                                <td>-</td>
                                                <td class="text-success fw-semibold">
                                                    <i class="ti ti-circle-filled fs-sm me-1"></i>
                                                    Active
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 6 -->
                                            <tr>
                                                <td class="ps-3"><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>
                                                    <h5 class="fs-sm mb-0"><a class="link-reset" href="#!">Flash Friday</a></h5>
                                                    <small class="text-muted">Limited-time 24-hour deal</small>
                                                </td>
                                                <td><span class="badge badge-label fs-xs badge-soft-primary">Percentage</span></td>
                                                <td>30%</td>
                                                <td>7 Feb, 2025</td>
                                                <td>7 Feb, 2025</td>
                                                <td>$20</td>
                                                <td>$120</td>
                                                <td class="text-success fw-semibold">
                                                    <i class="ti ti-circle-filled fs-sm me-1"></i>
                                                    Active
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 7 -->
                                            <tr>
                                                <td class="ps-3"><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>
                                                    <h5 class="fs-sm mb-0"><a class="link-reset" href="#!">New Year Celebration</a></h5>
                                                    <small class="text-muted">Applicable sitewide for 2025</small>
                                                </td>
                                                <td><span class="badge badge-label fs-xs badge-soft-success">Flat</span></td>
                                                <td>$25</td>
                                                <td>30 Dec, 2024</td>
                                                <td>5 Jan, 2025</td>
                                                <td>$50</td>
                                                <td>$25</td>
                                                <td class="text-success fw-semibold">
                                                    <i class="ti ti-circle-filled fs-sm me-1"></i>
                                                    Active
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 8 -->
                                            <tr>
                                                <td class="ps-3"><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>
                                                    <h5 class="fs-sm mb-0"><a class="link-reset" href="#!">Student Discount</a></h5>
                                                    <small class="text-muted">For verified student accounts</small>
                                                </td>
                                                <td><span class="badge badge-label fs-xs badge-soft-primary">Percentage</span></td>
                                                <td>10%</td>
                                                <td>1 Jan, 2025</td>
                                                <td>31 Dec, 2025</td>
                                                <td>$10</td>
                                                <td>$50</td>
                                                <td class="text-success fw-semibold">
                                                    <i class="ti ti-circle-filled fs-sm me-1"></i>
                                                    Active
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 9 -->
                                            <tr>
                                                <td class="ps-3"><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>
                                                    <h5 class="fs-sm mb-0"><a class="link-reset" href="#!">Referral Reward</a></h5>
                                                    <small class="text-muted">Applies on both referrer &amp; referee</small>
                                                </td>
                                                <td><span class="badge badge-label fs-xs badge-soft-primary">Flat</span></td>
                                                <td>$15</td>
                                                <td>1 Feb, 2025</td>
                                                <td>31 Jul, 2025</td>
                                                <td>$0</td>
                                                <td>$15</td>
                                                <td class="text-success fw-semibold">
                                                    <i class="ti ti-circle-filled fs-sm me-1"></i>
                                                    Active
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 10 -->
                                            <tr>
                                                <td class="ps-3"><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>
                                                    <h5 class="fs-sm mb-0"><a class="link-reset" href="#!">Clearance Offer</a></h5>
                                                    <small class="text-muted">Applies on clearance and end-of-season items</small>
                                                </td>
                                                <td><span class="badge badge-label fs-xs badge-soft-primary">Percentage</span></td>
                                                <td>40%</td>
                                                <td>1 Aug, 2025</td>
                                                <td>31 Aug, 2025</td>
                                                <td>$0</td>
                                                <td>$200</td>
                                                <td class="text-danger fw-semibold">
                                                    <i class="ti ti-circle-filled fs-sm me-1"></i>
                                                    Expired
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 11 -->
                                            <tr>
                                                <td class="ps-3"><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>
                                                    <h5 class="fs-sm mb-0"><a class="link-reset" href="#!">App Exclusive</a></h5>
                                                    <small class="text-muted">Only for purchases via mobile app</small>
                                                </td>
                                                <td><span class="badge badge-label fs-xs badge-soft-secondary">Flat</span></td>
                                                <td>$5</td>
                                                <td>15 Mar, 2025</td>
                                                <td>15 Sep, 2025</td>
                                                <td>$25</td>
                                                <td>$5</td>
                                                <td class="text-success fw-semibold">
                                                    <i class="ti ti-circle-filled fs-sm me-1"></i>
                                                    Active
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 12 -->
                                            <tr>
                                                <td class="ps-3"><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>
                                                    <h5 class="fs-sm mb-0"><a class="link-reset" href="#!">Weekend Flash Sale</a></h5>
                                                    <small class="text-muted">Automatically applied every Friday–Sunday</small>
                                                </td>
                                                <td><span class="badge badge-label fs-xs badge-soft-primary">Percentage</span></td>
                                                <td>18%</td>
                                                <td>1 Jul, 2025</td>
                                                <td>31 Dec, 2025</td>
                                                <td>$30</td>
                                                <td>$90</td>
                                                <td class="text-warning fw-semibold">
                                                    <i class="ti ti-circle-filled fs-sm me-1"></i>
                                                    Scheduled
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <!-- /.table-responsive -->
                                <div class="card-footer border-0">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div data-table-pagination-info="Discounts"></div>
                                        <div data-table-pagination=""></div>
                                    </div>
                                </div>
                                <!-- /.card-footer -->
                            </div>
                            <!-- /.card -->
                        </div>
                        <!-- /.col -->
                    </div>
                    <!-- /.row -->
                    <!-- Add Discount Modal -->
                    <div aria-hidden="true" aria-labelledby="addDiscountModalLabel" class="modal fade" id="addDiscountModal" tabindex="-1">
                        <div class="modal-dialog modal-lg modal-dialog-centered">
                            <div class="modal-content border-0 shadow">
                                <!-- Modal Header -->
                                <div class="modal-header bg-light">
                                    <h5 class="modal-title fw-semibold" id="addDiscountModalLabel">
                                        <i class="ti ti-discount me-2 text-primary"></i>
                                        Add New Discount
                                    </h5>
                                    <button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"></button>
                                </div>
                                <!-- Modal Form -->
                                <form id="addDiscountForm">
                                    <div class="modal-body">
                                        <div class="row g-3">
                                            <!-- Discount Name -->
                                            <div class="col-md-6">
                                                <label class="form-label">
                                                    Discount Name
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <input class="form-control" name="discount_name" placeholder="e.g., Summer Sale" required="" type="text" />
                                            </div>
                                            <!-- Discount Code -->
                                            <div class="col-md-6">
                                                <label class="form-label">
                                                    Discount Code
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <input class="form-control" name="discount_code" placeholder="e.g., SUMMER25" required="" type="text" />
                                            </div>
                                            <!-- Discount Type -->
                                            <div class="col-md-6">
                                                <label class="form-label">
                                                    Discount Type
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <select class="form-select" name="discount_type" required="">
                                                    <option value="">Select Type</option>
                                                    <option value="Percentage">Percentage</option>
                                                    <option value="Flat">Flat Amount</option>
                                                    <option value="BOGO">Buy One Get One (BOGO)</option>
                                                    <option value="Bundle">Bundle Offer</option>
                                                </select>
                                            </div>
                                            <!-- Discount Value -->
                                            <div class="col-md-6">
                                                <label class="form-label">
                                                    Discount Value
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <input class="form-control" name="discount_value" placeholder="e.g., 25 (for 25%) or 50 (for $50)" required="" type="number" />
                                            </div>
                                            <!-- Minimum Purchase -->
                                            <div class="col-md-6">
                                                <label class="form-label">Minimum Purchase ($)</label>
                                                <input class="form-control" name="min_purchase" placeholder="e.g., 100" type="number" />
                                            </div>
                                            <!-- Maximum Discount -->
                                            <div class="col-md-6">
                                                <label class="form-label">Maximum Discount ($)</label>
                                                <input class="form-control" name="max_discount" placeholder="e.g., 300" type="number" />
                                            </div>
                                            <!-- Start Date -->
                                            <div class="col-md-6">
                                                <label class="form-label">
                                                    Start Date
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <input class="form-control" data-date-format="d M, Y" data-provider="flatpickr" name="start_date" placeholder="Select start date" required="" type="text" />
                                            </div>
                                            <!-- End Date -->
                                            <div class="col-md-6">
                                                <label class="form-label">
                                                    End Date
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <input class="form-control" data-date-format="d M, Y" data-provider="flatpickr" name="end_date" placeholder="Select end date" required="" type="text" />
                                            </div>
                                            <!-- Description -->
                                            <div class="col-12">
                                                <label class="form-label">Description</label>
                                                <textarea class="form-control" name="discount_description" placeholder="Short description about this discount..." rows="2"></textarea>
                                            </div>
                                            <!-- Toggles -->
                                            <div class="col-12">
                                                <div class="d-flex flex-wrap gap-3 mt-2">
                                                    <div class="form-check form-switch">
                                                        <input checked="" class="form-check-input" id="isDiscountActive" type="checkbox" />
                                                        <label class="form-check-label" for="isDiscountActive">Active</label>
                                                    </div>
                                                    <div class="form-check form-switch">
                                                        <input class="form-check-input" id="isDiscountAutoApply" type="checkbox" />
                                                        <label class="form-check-label" for="isDiscountAutoApply">Auto Apply at Checkout</label>
                                                    </div>
                                                    <div class="form-check form-switch">
                                                        <input class="form-check-input" id="isDiscountFirstPurchase" type="checkbox" />
                                                        <label class="form-check-label" for="isDiscountFirstPurchase">Only for First Purchase</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- /.row -->
                                    </div>
                                    <!-- /.modal-body -->
                                    <!-- Modal Footer -->
                                    <div class="modal-footer">
                                        <button class="btn btn-light" data-bs-dismiss="modal" type="button">Cancel</button>
                                        <button class="btn btn-primary" type="submit">
                                            <i class="ti ti-plus me-1"></i>
                                            Add Discount
                                        </button>
                                    </div>
                                </form>
                                <!-- /form -->
                            </div>
                            <!-- /.modal-content -->
                        </div>
                        <!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Custom table -->
        <script src="/js/pages/custom-table.js"></script>
    </body>
</html>
