<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Gift Cards')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Promo', 'title' => 'Gift Cards')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card" data-table="" data-table-rows-per-page="8">
                                <!-- Table Header -->
                                <div class="card-header border-light justify-content-between">
                                    <div class="d-flex gap-2">
                                        <div class="app-search">
                                            <input class="form-control" data-table-search="" placeholder="Search gift card..." type="search" />
                                            <i class="ti ti-search app-search-icon text-muted"></i>
                                        </div>
                                        <button class="btn btn-danger d-none" data-table-delete-selected="">Delete</button>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                        <span class="me-2 fw-semibold">Filter By:</span>
                                        <!-- Status Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="gift-status">
                                                <option value="All">Status</option>
                                                <option value="Active">Active</option>
                                                <option value="Redeemed">Redeemed</option>
                                                <option value="Expired">Expired</option>
                                                <option value="Pending">Pending</option>
                                            </select>
                                            <i class="ti ti-activity app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Type Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="gift-type">
                                                <option value="All">Type</option>
                                                <option value="Digital">Digital</option>
                                                <option value="Physical">Physical</option>
                                            </select>
                                            <i class="ti ti-gift app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Records Per Page -->
                                        <div>
                                            <select class="form-select form-control my-1 my-md-0" data-table-set-rows-per-page="">
                                                <option value="5">5</option>
                                                <option selected="" value="10">10</option>
                                                <option value="15">15</option>
                                                <option value="20">20</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="d-flex gap-1">
                                        <a class="btn btn-primary ms-1" data-bs-target="#addGiftCardModal" data-bs-toggle="modal" href="#">
                                            <i class="ti ti-plus fs-sm me-2"></i>
                                            Add Gift Card
                                        </a>
                                    </div>
                                </div>
                                <!-- Table -->
                                <div class="table-responsive">
                                    <table class="table table-custom table-centered table-select table-hover w-100 mb-0">
                                        <thead class="bg-light align-middle bg-opacity-25 thead-sm">
                                            <tr class="text-uppercase fs-xxs">
                                                <th class="ps-3" style="width: 1%">
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" data-table-select-all="" type="checkbox" />
                                                </th>
                                                <th data-table-sort="">Card Code</th>
                                                <th data-table-sort="">Recipient</th>
                                                <th data-column="gift-type" data-table-sort="">Type</th>
                                                <th data-table-sort="">Value</th>
                                                <th data-table-sort="">Balance</th>
                                                <th data-column="gift-status" data-table-sort="">Status</th>
                                                <th data-table-sort="">Issued On</th>
                                                <th data-table-sort="">Expires On</th>
                                                <th class="text-center" style="width: 1%">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!-- Row 1 -->
                                            <tr>
                                                <td class="ps-3"><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>
                                                    <h5 class="fs-sm mb-0"><a class="link-reset" href="#">GFT-A1001</a></h5>
                                                </td>
                                                <td>
                                                    Olivia Jenkins
                                                    <br />
                                                    <small class="text-muted">olivia.jenkins@mail.com</small>
                                                </td>
                                                <td><span class="badge badge-label fs-xs badge-soft-primary">Digital</span></td>
                                                <td>$100</td>
                                                <td>$45</td>
                                                <td class="text-success fw-semibold">
                                                    <i class="ti ti-circle-filled fs-sm"></i>
                                                    Active
                                                </td>
                                                <td>12 Apr 2025</td>
                                                <td>12 Apr 2026</td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 2 -->
                                            <tr>
                                                <td class="ps-3"><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>
                                                    <h5 class="fs-sm mb-0"><a class="link-reset" href="#">GFT-A1002</a></h5>
                                                </td>
                                                <td>
                                                    Liam Henderson
                                                    <br />
                                                    <small class="text-muted">liam.henderson@mail.com</small>
                                                </td>
                                                <td><span class="badge badge-label fs-xs badge-soft-secondary">Physical</span></td>
                                                <td>$50</td>
                                                <td>$0</td>
                                                <td class="text-muted fw-semibold">
                                                    <i class="ti ti-circle-filled fs-sm"></i>
                                                    Redeemed
                                                </td>
                                                <td>5 Feb 2025</td>
                                                <td>5 Feb 2026</td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 3 -->
                                            <tr>
                                                <td class="ps-3"><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>
                                                    <h5 class="fs-sm mb-0"><a class="link-reset" href="#">GFT-A1003</a></h5>
                                                </td>
                                                <td>
                                                    Emma Wallace
                                                    <br />
                                                    <small class="text-muted">emma.wallace@mail.com</small>
                                                </td>
                                                <td><span class="badge badge-label fs-xs badge-soft-primary">Digital</span></td>
                                                <td>$200</td>
                                                <td>$200</td>
                                                <td class="text-warning fw-semibold">
                                                    <i class="ti ti-circle-filled fs-sm"></i>
                                                    Pending
                                                </td>
                                                <td>20 May 2025</td>
                                                <td>20 May 2026</td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 4 -->
                                            <tr>
                                                <td class="ps-3"><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>
                                                    <h5 class="fs-sm mb-0"><a class="link-reset" href="#">GFT-A1004</a></h5>
                                                </td>
                                                <td>
                                                    Noah Parker
                                                    <br />
                                                    <small class="text-muted">noah.parker@mail.com</small>
                                                </td>
                                                <td><span class="badge badge-label fs-xs badge-soft-secondary">Physical</span></td>
                                                <td>$150</td>
                                                <td>$75</td>
                                                <td class="text-success fw-semibold">
                                                    <i class="ti ti-circle-filled fs-sm"></i>
                                                    Active
                                                </td>
                                                <td>2 Mar 2025</td>
                                                <td>2 Mar 2026</td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 5 -->
                                            <tr>
                                                <td class="ps-3"><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>
                                                    <h5 class="fs-sm mb-0"><a class="link-reset" href="#">GFT-A1005</a></h5>
                                                </td>
                                                <td>
                                                    Ava Reed
                                                    <br />
                                                    <small class="text-muted">ava.reed@mail.com</small>
                                                </td>
                                                <td><span class="badge badge-label fs-xs badge-soft-primary">Digital</span></td>
                                                <td>$75</td>
                                                <td>$0</td>
                                                <td class="text-danger fw-semibold">
                                                    <i class="ti ti-circle-filled fs-sm"></i>
                                                    Expired
                                                </td>
                                                <td>10 Jan 2024</td>
                                                <td>10 Jan 2025</td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 6 -->
                                            <tr>
                                                <td class="ps-3"><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>
                                                    <h5 class="fs-sm mb-0"><a class="link-reset" href="#">GFT-A1006</a></h5>
                                                </td>
                                                <td>
                                                    Lucas Gray
                                                    <br />
                                                    <small class="text-muted">lucas.gray@mail.com</small>
                                                </td>
                                                <td><span class="badge badge-label fs-xs badge-soft-primary">Digital</span></td>
                                                <td>$100</td>
                                                <td>$100</td>
                                                <td class="text-warning fw-semibold">
                                                    <i class="ti ti-circle-filled fs-sm"></i>
                                                    Pending
                                                </td>
                                                <td>25 May 2025</td>
                                                <td>25 May 2026</td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 7 -->
                                            <tr>
                                                <td class="ps-3"><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>
                                                    <h5 class="fs-sm mb-0"><a class="link-reset" href="#">GFT-A1007</a></h5>
                                                </td>
                                                <td>
                                                    Isabella Moore
                                                    <br />
                                                    <small class="text-muted">isabella.moore@mail.com</small>
                                                </td>
                                                <td><span class="badge badge-label fs-xs badge-soft-secondary">Physical</span></td>
                                                <td>$250</td>
                                                <td>$75</td>
                                                <td class="text-success fw-semibold">
                                                    <i class="ti ti-circle-filled fs-sm"></i>
                                                    Active
                                                </td>
                                                <td>15 Mar 2025</td>
                                                <td>15 Mar 2026</td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 8 -->
                                            <tr>
                                                <td class="ps-3"><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>
                                                    <h5 class="fs-sm mb-0"><a class="link-reset" href="#">GFT-A1008</a></h5>
                                                </td>
                                                <td>
                                                    Elijah Bennett
                                                    <br />
                                                    <small class="text-muted">elijah.bennett@mail.com</small>
                                                </td>
                                                <td><span class="badge badge-label fs-xs badge-soft-primary">Digital</span></td>
                                                <td>$75</td>
                                                <td>$0</td>
                                                <td class="text-muted fw-semibold">
                                                    <i class="ti ti-circle-filled fs-sm"></i>
                                                    Redeemed
                                                </td>
                                                <td>5 Feb 2025</td>
                                                <td>5 Feb 2026</td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 9 -->
                                            <tr>
                                                <td class="ps-3"><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>
                                                    <h5 class="fs-sm mb-0"><a class="link-reset" href="#">GFT-A1009</a></h5>
                                                </td>
                                                <td>
                                                    Harper Collins
                                                    <br />
                                                    <small class="text-muted">harper.collins@mail.com</small>
                                                </td>
                                                <td><span class="badge badge-label fs-xs badge-soft-secondary">Physical</span></td>
                                                <td>$120</td>
                                                <td>$40</td>
                                                <td class="text-success fw-semibold">
                                                    <i class="ti ti-circle-filled fs-sm"></i>
                                                    Active
                                                </td>
                                                <td>18 Apr 2025</td>
                                                <td>18 Apr 2026</td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 10 -->
                                            <tr>
                                                <td class="ps-3"><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>
                                                    <h5 class="fs-sm mb-0"><a class="link-reset" href="#">GFT-A1010</a></h5>
                                                </td>
                                                <td>
                                                    Sophia Adams
                                                    <br />
                                                    <small class="text-muted">sophia.adams@mail.com</small>
                                                </td>
                                                <td><span class="badge badge-label fs-xs badge-soft-primary">Digital</span></td>
                                                <td>$200</td>
                                                <td>$0</td>
                                                <td class="text-danger fw-semibold">
                                                    <i class="ti ti-circle-filled fs-sm"></i>
                                                    Expired
                                                </td>
                                                <td>1 Mar 2024</td>
                                                <td>1 Mar 2025</td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 11 -->
                                            <tr>
                                                <td class="ps-3"><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>
                                                    <h5 class="fs-sm mb-0"><a class="link-reset" href="#">GFT-A1011</a></h5>
                                                </td>
                                                <td>
                                                    Jack Thompson
                                                    <br />
                                                    <small class="text-muted">jack.thompson@mail.com</small>
                                                </td>
                                                <td><span class="badge badge-label fs-xs badge-soft-secondary">Physical</span></td>
                                                <td>$300</td>
                                                <td>$260</td>
                                                <td class="text-success fw-semibold">
                                                    <i class="ti ti-circle-filled fs-sm"></i>
                                                    Active
                                                </td>
                                                <td>8 Jan 2025</td>
                                                <td>8 Jan 2026</td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Row 12 -->
                                            <tr>
                                                <td class="ps-3"><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                <td>
                                                    <h5 class="fs-sm mb-0"><a class="link-reset" href="#">GFT-A1012</a></h5>
                                                </td>
                                                <td>
                                                    Ella Johnson
                                                    <br />
                                                    <small class="text-muted">ella.johnson@mail.com</small>
                                                </td>
                                                <td><span class="badge badge-label fs-xs badge-soft-primary">Digital</span></td>
                                                <td>$150</td>
                                                <td>$0</td>
                                                <td class="text-muted fw-semibold">
                                                    <i class="ti ti-circle-filled fs-sm"></i>
                                                    Redeemed
                                                </td>
                                                <td>15 Feb 2025</td>
                                                <td>15 Feb 2026</td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <!-- Footer -->
                                <div class="card-footer border-0">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div data-table-pagination-info="giftcards"></div>
                                        <div data-table-pagination=""></div>
                                    </div>
                                </div>
                            </div>
                            <!-- /.card -->
                        </div>
                        <!-- /.col -->
                    </div>
                    <!-- /.row -->
                    <!-- /.row -->
                    <!-- Add Gift Card Modal -->
                    <div aria-hidden="true" aria-labelledby="addGiftCardModalLabel" class="modal fade" id="addGiftCardModal" tabindex="-1">
                        <div class="modal-dialog modal-lg modal-dialog-centered">
                            <div class="modal-content border-0 shadow">
                                <!-- Modal Header -->
                                <div class="modal-header bg-light">
                                    <h5 class="modal-title fw-semibold" id="addGiftCardModalLabel">
                                        <i class="ti ti-gift me-2 text-primary"></i>
                                        Add New Gift Card
                                    </h5>
                                    <button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"></button>
                                </div>
                                <!-- Modal Form -->
                                <form id="addGiftCardForm">
                                    <div class="modal-body">
                                        <div class="row g-3">
                                            <!-- Gift Card Code -->
                                            <div class="col-md-6">
                                                <label class="form-label">
                                                    Gift Card Code
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <input class="form-control" name="gift_code" placeholder="e.g., GFT-A2025" required="" type="text" />
                                            </div>
                                            <!-- Gift Card Type -->
                                            <div class="col-md-6">
                                                <label class="form-label">
                                                    Type
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <select class="form-select" name="gift_type" required="">
                                                    <option value="">Select Type</option>
                                                    <option value="digital">Digital</option>
                                                    <option value="physical">Physical</option>
                                                </select>
                                            </div>
                                            <!-- Value -->
                                            <div class="col-md-6">
                                                <label class="form-label">
                                                    Gift Card Value ($)
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <input class="form-control" name="gift_value" placeholder="e.g., 100" required="" type="number" />
                                            </div>
                                            <!-- Initial Balance -->
                                            <div class="col-md-6">
                                                <label class="form-label">Initial Balance</label>
                                                <input class="form-control" name="gift_balance" placeholder="e.g., 100" type="number" />
                                            </div>
                                            <!-- Recipient Name -->
                                            <div class="col-md-6">
                                                <label class="form-label">
                                                    Recipient Name
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <input class="form-control" name="recipient_name" placeholder="e.g., John Doe" required="" type="text" />
                                            </div>
                                            <!-- Recipient Email -->
                                            <div class="col-md-6">
                                                <label class="form-label">
                                                    Recipient Email
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <input class="form-control" name="recipient_email" placeholder="e.g., john.doe@mail.com" required="" type="email" />
                                            </div>
                                            <!-- Message -->
                                            <div class="col-12">
                                                <label class="form-label">Personal Message</label>
                                                <textarea class="form-control" name="gift_message" placeholder="Write a short message to include with the gift card" rows="2"></textarea>
                                            </div>
                                            <!-- Issue Date -->
                                            <div class="col-md-6">
                                                <label class="form-label">
                                                    Issue Date
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <input class="form-control" data-date-format="d M, Y" data-provider="flatpickr" name="issue_date" placeholder="Select issue date" required="" type="text" />
                                            </div>
                                            <!-- Expiry Date -->
                                            <div class="col-md-6">
                                                <label class="form-label">
                                                    Expiry Date
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <input class="form-control" data-date-format="d M, Y" data-provider="flatpickr" name="expiry_date" placeholder="Select expiry date" required="" type="text" />
                                            </div>
                                            <!-- Toggles -->
                                            <div class="col-12">
                                                <div class="d-flex flex-wrap gap-3 mt-2">
                                                    <div class="form-check form-switch">
                                                        <input checked="" class="form-check-input" id="isGiftCardActive" type="checkbox" />
                                                        <label class="form-check-label" for="isGiftCardActive">Active</label>
                                                    </div>
                                                    <div class="form-check form-switch">
                                                        <input class="form-check-input" id="isGiftCardDelivered" type="checkbox" />
                                                        <label class="form-check-label" for="isGiftCardDelivered">Send via Email</label>
                                                    </div>
                                                    <div class="form-check form-switch">
                                                        <input class="form-check-input" id="isGiftCardPhysical" type="checkbox" />
                                                        <label class="form-check-label" for="isGiftCardPhysical">Physical Delivery</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- /.row -->
                                    </div>
                                    <!-- /.modal-body -->
                                    <!-- Modal Footer -->
                                    <div class="modal-footer">
                                        <button class="btn btn-light" data-bs-dismiss="modal" type="button">Cancel</button>
                                        <button class="btn btn-primary" type="submit">
                                            <i class="ti ti-plus me-1"></i>
                                            Add Gift Card
                                        </button>
                                    </div>
                                </form>
                                <!-- /form -->
                            </div>
                            <!-- /.modal-content -->
                        </div>
                        <!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Custom table -->
        <script src="/js/pages/custom-table.js"></script>
    </body>
</html>
