<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Create New Task')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Tasks', 'title' => 'Create Task')) ?>

                    <!-- Container -->
                    <div class="container-xxl">
                        <!-- Card -->
                        <div class="card">
                            <!-- Card Body -->
                            <div class="card-body">
                                <!-- Form -->
                                <form>
                                    <!-- Task Title -->
                                    <div class="mb-3">
                                        <label class="form-label" for="taskTitle">
                                            Task Title
                                            <span class="text-danger">*</span>
                                        </label>
                                        <input class="form-control" id="taskTitle" placeholder="Enter task title" required="" type="text" />
                                    </div>
                                    <!-- End Task Title -->
                                    <!-- Task Description -->
                                    <div class="mb-3">
                                        <label class="form-label" for="taskDescription">Description</label>
                                        <textarea class="form-control" id="taskDescription" placeholder="Write a short task description..." rows="4"></textarea>
                                    </div>
                                    <!-- End Task Description -->
                                    <!-- Dates -->
                                    <div class="row mb-3">
                                        <!-- Start Date -->
                                        <div class="col-md-6">
                                            <label class="form-label" for="startDate">Start Date</label>
                                            <input class="form-control" data-date-format="d M, Y" data-provider="flatpickr" id="startDate" type="text" />
                                        </div>
                                        <!-- End Start Date -->
                                        <!-- Due Date -->
                                        <div class="col-md-6">
                                            <label class="form-label" for="dueDate">Due Date</label>
                                            <input class="form-control" data-date-format="d M, Y" data-provider="flatpickr" id="dueDate" type="text" />
                                        </div>
                                        <!-- End Due Date -->
                                    </div>
                                    <!-- End Dates -->
                                    <!-- Assigned To -->
                                    <div class="mb-3">
                                        <label class="form-label" for="assignedTo">Assigned To</label>
                                        <select class="form-select" id="assignedTo">
                                            <option disabled="" selected="">Choose member</option>
                                            <option value="1">Cruise</option>
                                            <option value="2">Maria</option>
                                            <option value="3">Chris</option>
                                            <option value="4">Alex</option>
                                        </select>
                                    </div>
                                    <!-- End Assigned To -->
                                    <!-- Priority and Status -->
                                    <div class="row mb-3">
                                        <!-- Priority -->
                                        <div class="col-md-6">
                                            <label class="form-label" for="priority">Priority</label>
                                            <select class="form-select" id="priority">
                                                <option disabled="" selected="">Select priority</option>
                                                <option value="High">High</option>
                                                <option value="Medium">Medium</option>
                                                <option value="Low">Low</option>
                                            </select>
                                        </div>
                                        <!-- End Priority -->
                                        <!-- Status -->
                                        <div class="col-md-6">
                                            <label class="form-label" for="task-status">Status</label>
                                            <select class="form-select" id="task-status">
                                                <option selected="" value="New">New</option>
                                                <option value="In Progress">In Progress</option>
                                                <option value="On Hold">On Hold</option>
                                                <option value="Completed">Completed</option>
                                            </select>
                                        </div>
                                        <!-- End Status -->
                                    </div>
                                    <!-- End Priority and Status -->
                                    <!-- Attachment -->
                                    <div class="mb-3">
                                        <label class="form-label" for="fileUpload">Attachment</label>
                                        <input class="form-control" id="fileUpload" type="file" />
                                    </div>
                                    <!-- End Attachment -->
                                    <!-- Buttons -->
                                    <div class="d-flex justify-content-end mt-4">
                                        <button class="btn btn-light me-2" type="reset">Cancel</button>
                                        <button class="btn btn-primary" type="submit">
                                            <i class="ti ti-plus me-1"></i>
                                            Create Task
                                        </button>
                                    </div>
                                    <!-- End Buttons -->
                                </form>
                                <!-- End Form -->
                            </div>
                            <!-- End Card Body -->
                        </div>
                        <!-- End Card -->
                    </div>
                    <!-- End Container -->
                </div>
                <!-- container-fluid -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>
    </body>
</html>
