<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Todo List App')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Apps', 'title' => 'Todo List')) ?>

                    <div class="outlook-box gap-1">
                        <div class="offcanvas-lg offcanvas-start outlook-left-menu outlook-left-menu-lg" id="emailSidebaroffcanvas" tabindex="-1">
                            <div class="card h-100 mb-0 rounded-end-0" data-simplebar="">
                                <div class="card-body">
                                    <button class="btn btn-success fw-medium w-100" data-bs-target="#addTaskModal" data-bs-toggle="modal">
                                        Create New
                                        <i class="ti ti-plus ms-1"></i>
                                    </button>
                                    <div class="my-3">
                                        <label class="form-label" for="taskDate">Select Date</label>
                                        <input class="form-control flatpickr-input" data-altformat="F j, Y" data-provider="flatpickr" id="taskDate" placeholder="Select Date" type="text" />
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label" for="taskPriority">Select Priority</label>
                                        <select class="form-select" id="taskPriority">
                                            <option selected="" value="all">All</option>
                                            <option value="High">High</option>
                                            <option value="Normal">Medium</option>
                                            <option value="Low">Low</option>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label" for="taskStatus">Select Status</label>
                                        <select class="form-select" id="taskStatus">
                                            <option selected="" value="all">All</option>
                                            <option value="New">New</option>
                                            <option value="Pending">Pending</option>
                                            <option value="Inprogress">Inprogress</option>
                                            <option value="Completed">Completed</option>
                                            <option value="Urgent">Urgent</option>
                                            <option value="Scheduled">Scheduled</option>
                                        </select>
                                    </div>
                                </div>
                                <!-- end card-body-->
                            </div>
                            <!-- end card-->
                        </div>
                        <div class="card h-100 mb-0 rounded-start-0 flex-grow-1 border-start-0" data-table="" data-table-rows-per-page="15">
                            <div class="card-header d-lg-none d-flex gap-2">
                                <button aria-controls="emailSidebaroffcanvas" class="btn btn-default btn-icon" data-bs-target="#emailSidebaroffcanvas" data-bs-toggle="offcanvas" type="button">
                                    <i class="ti ti-menu-4 fs-lg"></i>
                                </button>
                                <div class="app-search">
                                    <input class="form-control" placeholder="Search here..." type="text" />
                                    <i class="ti ti-search app-search-icon text-muted"></i>
                                </div>
                            </div>
                            <div class="card-header card-bg justify-content-between">
                                <h4 class="card-title">Tasks</h4>
                                <div class="app-search">
                                    <input class="form-control" placeholder="Search here..." type="text" />
                                    <i class="ti ti-search app-search-icon text-muted"></i>
                                </div>
                            </div>
                            <div class="card-body p-0" data-simplebar="" data-simplebar-md="" style="height: calc(100% - 100px)">
                                <div class="nested-sortable-handle">
                                    <div class="border-bottom py-2 px-3 d-flex gap-2 align-items-center">
                                        <i class="ti ti-grip-horizontal align-middle sort-handle"></i>
                                        <input class="form-check-input rounded-circle mt-0 fs-16" id="task1" type="checkbox" />
                                        <a class="link-reset fw-medium" data-bs-target="#taskDetailsModal" data-bs-toggle="modal" href="#">Complete Presentation Slides for Meeting</a>
                                        <div class="d-flex align-items-center gap-3 flex-wrap justify-content-md-end ms-auto">
                                            <div class="avatar-group avatar-group-sm flex-shrink-0">
                                                <div class="avatar" data-bs-custom-class="tooltip-secondary" data-bs-placement="top" data-bs-toggle="tooltip" title="Cruise ⚒️">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-2.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-custom-class="tooltip-secondary" data-bs-placement="top" data-bs-toggle="tooltip" title="Kevin">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-3.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-custom-class="tooltip-secondary" data-bs-placement="top" data-bs-toggle="tooltip" title="Thomas 🏠">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-4.jpg" />
                                                </div>
                                            </div>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-outline-warning">New</span>
                                            </div>
                                            <ul class="list-inline fs-13 text-end flex-shrink-0 mb-0">
                                                <li class="list-inline-item">
                                                    <i class="ti ti-calendar text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-semibold">Today</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-list-details text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">3/7</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-messages text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">21</span>
                                                </li>
                                            </ul>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-soft-danger p-1">High</span>
                                            </div>
                                        </div>
                                        <!-- end d-flex-->
                                    </div>
                                    <!-- end task -->
                                    <div class="border-bottom py-2 px-3 d-flex gap-2 align-items-center">
                                        <i class="ti ti-grip-horizontal align-middle sort-handle"></i>
                                        <input class="form-check-input rounded-circle mt-0 fs-16" id="task2" type="checkbox" />
                                        <a class="link-reset fw-medium" data-bs-target="#taskDetailsModal" data-bs-toggle="modal" href="#">Finalize Product Roadmap for Launch</a>
                                        <div class="d-flex align-items-center gap-3 flex-wrap justify-content-md-end ms-auto">
                                            <div class="avatar-group avatar-group-sm flex-shrink-0">
                                                <div class="avatar" data-bs-custom-class="tooltip-secondary" data-bs-placement="top" data-bs-toggle="tooltip" title="Maria 💻">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-5.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-custom-class="tooltip-secondary" data-bs-placement="top" data-bs-toggle="tooltip" title="James">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-6.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-custom-class="tooltip-secondary" data-bs-placement="top" data-bs-toggle="tooltip" title="Sophia 🚀">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-7.jpg" />
                                                </div>
                                            </div>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-outline-success">In Progress</span>
                                            </div>
                                            <ul class="list-inline fs-13 text-end flex-shrink-0 mb-0">
                                                <li class="list-inline-item">
                                                    <i class="ti ti-calendar text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-semibold">Tomorrow</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-list-details text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">5/10</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-messages text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">14</span>
                                                </li>
                                            </ul>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-soft-warning p-1">Medium</span>
                                            </div>
                                        </div>
                                        <!-- end d-flex-->
                                    </div>
                                    <!-- end task-->
                                    <div class="border-bottom py-2 px-3 d-flex gap-2 align-items-center">
                                        <i class="ti ti-grip-horizontal align-middle sort-handle"></i>
                                        <input class="form-check-input rounded-circle mt-0 fs-16" id="task3" type="checkbox" />
                                        <a class="link-reset fw-medium" data-bs-target="#taskDetailsModal" data-bs-toggle="modal" href="#">Design Marketing Assets for Campaign</a>
                                        <div class="d-flex align-items-center gap-3 flex-wrap justify-content-md-end ms-auto">
                                            <div class="avatar-group avatar-group-sm flex-shrink-0">
                                                <div class="avatar" data-bs-custom-class="tooltip-secondary" data-bs-placement="top" data-bs-toggle="tooltip" title="Olivia 🎨">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-8.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-custom-class="tooltip-secondary" data-bs-placement="top" data-bs-toggle="tooltip" title="Daniel">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-9.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-custom-class="tooltip-secondary" data-bs-placement="top" data-bs-toggle="tooltip" title="Liam 📷">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-10.jpg" />
                                                </div>
                                            </div>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-outline-warning">Pending</span>
                                            </div>
                                            <ul class="list-inline fs-13 text-end flex-shrink-0 mb-0">
                                                <li class="list-inline-item">
                                                    <i class="ti ti-calendar text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-semibold">Next Week</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-list-details text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">2/8</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-messages text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">8</span>
                                                </li>
                                            </ul>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-soft-danger p-1">High</span>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- end task -->
                                    <div class="border-bottom py-2 px-3 d-flex gap-2 align-items-center">
                                        <i class="ti ti-grip-horizontal align-middle sort-handle"></i>
                                        <input class="form-check-input rounded-circle mt-0 fs-16" id="task4" type="checkbox" />
                                        <a class="link-reset fw-medium" data-bs-target="#taskDetailsModal" data-bs-toggle="modal" href="#">Prepare Financial Report for Q3 Review</a>
                                        <div class="d-flex align-items-center gap-3 flex-wrap justify-content-md-end ms-auto">
                                            <div class="avatar-group avatar-group-sm flex-shrink-0">
                                                <div class="avatar" data-bs-custom-class="tooltip-secondary" data-bs-placement="top" data-bs-toggle="tooltip" title="Emma 💼">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-1.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-custom-class="tooltip-secondary" data-bs-placement="top" data-bs-toggle="tooltip" title="Michael">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-2.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-custom-class="tooltip-secondary" data-bs-placement="top" data-bs-toggle="tooltip" title="Chloe 📊">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-4.jpg" />
                                                </div>
                                            </div>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-outline-success">In Progress</span>
                                            </div>
                                            <ul class="list-inline fs-13 text-end flex-shrink-0 mb-0">
                                                <li class="list-inline-item">
                                                    <i class="ti ti-calendar text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-semibold">Friday</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-list-details text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">6/12</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-messages text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">18</span>
                                                </li>
                                            </ul>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-soft-warning p-1">Medium</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="border-bottom py-2 px-3 d-flex gap-2 align-items-center">
                                        <i class="ti ti-grip-horizontal align-middle sort-handle"></i>
                                        <input class="form-check-input rounded-circle mt-0 fs-16" id="task5" type="checkbox" />
                                        <a class="link-reset fw-medium" data-bs-target="#taskDetailsModal" data-bs-toggle="modal" href="#">Organize Client Feedback Workshop</a>
                                        <div class="d-flex align-items-center gap-3 flex-wrap justify-content-md-end ms-auto">
                                            <div class="avatar-group avatar-group-sm flex-shrink-0">
                                                <div class="avatar" data-bs-custom-class="tooltip-secondary" data-bs-placement="top" data-bs-toggle="tooltip" title="Isabella 📝">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-3.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-custom-class="tooltip-secondary" data-bs-placement="top" data-bs-toggle="tooltip" title="Lucas">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-5.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-custom-class="tooltip-secondary" data-bs-placement="top" data-bs-toggle="tooltip" title="Noah 🎤">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-7.jpg" />
                                                </div>
                                            </div>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-outline-primary">Scheduled</span>
                                            </div>
                                            <ul class="list-inline fs-13 text-end flex-shrink-0 mb-0">
                                                <li class="list-inline-item">
                                                    <i class="ti ti-calendar text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-semibold">Next Monday</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-list-details text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">1/5</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-messages text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">4</span>
                                                </li>
                                            </ul>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-soft-success p-1">Low</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="border-bottom py-2 px-3 d-flex gap-2 align-items-center">
                                        <i class="ti ti-grip-horizontal align-middle sort-handle"></i>
                                        <input class="form-check-input rounded-circle mt-0 fs-16" id="task6" type="checkbox" />
                                        <a class="link-reset fw-medium" data-bs-target="#taskDetailsModal" data-bs-toggle="modal" href="#">Update Company Website Content</a>
                                        <div class="d-flex align-items-center gap-3 flex-wrap justify-content-md-end ms-auto">
                                            <div class="avatar-group avatar-group-sm flex-shrink-0">
                                                <div class="avatar" data-bs-custom-class="tooltip-secondary" data-bs-placement="top" data-bs-toggle="tooltip" title="Mason 🌐">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-6.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-custom-class="tooltip-secondary" data-bs-placement="top" data-bs-toggle="tooltip" title="Ava">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-8.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-custom-class="tooltip-secondary" data-bs-placement="top" data-bs-toggle="tooltip" title="Ethan 🖋">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-10.jpg" />
                                                </div>
                                            </div>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-outline-danger">Urgent</span>
                                            </div>
                                            <ul class="list-inline fs-13 text-end flex-shrink-0 mb-0">
                                                <li class="list-inline-item">
                                                    <i class="ti ti-calendar text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-semibold">Today</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-list-details text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">9/15</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-messages text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">27</span>
                                                </li>
                                            </ul>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-soft-danger p-1">High</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="border-bottom py-2 px-3 d-flex gap-2 align-items-center">
                                        <i class="ti ti-grip-horizontal align-middle sort-handle"></i>
                                        <input class="form-check-input rounded-circle mt-0 fs-16" id="task7" type="checkbox" />
                                        <a class="link-reset fw-medium" data-bs-target="#taskDetailsModal" data-bs-toggle="modal" href="#">Conduct Security Audit for New App</a>
                                        <div class="d-flex align-items-center gap-3 flex-wrap justify-content-md-end ms-auto">
                                            <div class="avatar-group avatar-group-sm flex-shrink-0">
                                                <div class="avatar" data-bs-toggle="tooltip" title="Alice 🔒">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-1.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-toggle="tooltip" title="David">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-2.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-toggle="tooltip" title="Sophia">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-3.jpg" />
                                                </div>
                                            </div>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-outline-danger">Urgent</span>
                                            </div>
                                            <ul class="list-inline fs-13 text-end flex-shrink-0 mb-0">
                                                <li class="list-inline-item">
                                                    <i class="ti ti-calendar text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-semibold">15 Sep, 2025</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-list-details text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">4/12</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-messages text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">9</span>
                                                </li>
                                            </ul>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-soft-danger p-1">High</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="border-bottom py-2 px-3 d-flex gap-2 align-items-center">
                                        <i class="ti ti-grip-horizontal align-middle sort-handle"></i>
                                        <input class="form-check-input rounded-circle mt-0 fs-16" id="task8" type="checkbox" />
                                        <a class="link-reset fw-medium" data-bs-target="#taskDetailsModal" data-bs-toggle="modal" href="#">Draft Press Release for Product Launch</a>
                                        <div class="d-flex align-items-center gap-3 flex-wrap justify-content-md-end ms-auto">
                                            <div class="avatar-group avatar-group-sm flex-shrink-0">
                                                <div class="avatar" data-bs-toggle="tooltip" title="Ben 📰">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-4.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-toggle="tooltip" title="Chloe">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-5.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-toggle="tooltip" title="Olivia">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-6.jpg" />
                                                </div>
                                            </div>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-outline-success">In Progress</span>
                                            </div>
                                            <ul class="list-inline fs-13 text-end flex-shrink-0 mb-0">
                                                <li class="list-inline-item">
                                                    <i class="ti ti-calendar text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-semibold">16 Sep, 2025</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-list-details text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">3/6</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-messages text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">5</span>
                                                </li>
                                            </ul>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-soft-warning p-1">Medium</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="border-bottom py-2 px-3 d-flex gap-2 align-items-center">
                                        <i class="ti ti-grip-horizontal align-middle sort-handle"></i>
                                        <input class="form-check-input rounded-circle mt-0 fs-16" id="task9" type="checkbox" />
                                        <a class="link-reset fw-medium" data-bs-target="#taskDetailsModal" data-bs-toggle="modal" href="#">Update CRM Database Records</a>
                                        <div class="d-flex align-items-center gap-3 flex-wrap justify-content-md-end ms-auto">
                                            <div class="avatar-group avatar-group-sm flex-shrink-0">
                                                <div class="avatar" data-bs-toggle="tooltip" title="Liam 📁">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-7.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-toggle="tooltip" title="Emily">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-8.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-toggle="tooltip" title="Nathan">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-9.jpg" />
                                                </div>
                                            </div>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-outline-warning">Pending</span>
                                            </div>
                                            <ul class="list-inline fs-13 text-end flex-shrink-0 mb-0">
                                                <li class="list-inline-item">
                                                    <i class="ti ti-calendar text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-semibold">17 Sep, 2025</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-list-details text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">8/20</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-messages text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">11</span>
                                                </li>
                                            </ul>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-soft-danger p-1">High</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="border-bottom py-2 px-3 d-flex gap-2 align-items-center">
                                        <i class="ti ti-grip-horizontal align-middle sort-handle"></i>
                                        <input class="form-check-input rounded-circle mt-0 fs-16" id="task10" type="checkbox" />
                                        <a class="link-reset fw-medium" data-bs-target="#taskDetailsModal" data-bs-toggle="modal" href="#">Plan Internal Team Training Session</a>
                                        <div class="d-flex align-items-center gap-3 flex-wrap justify-content-md-end ms-auto">
                                            <div class="avatar-group avatar-group-sm flex-shrink-0">
                                                <div class="avatar" data-bs-toggle="tooltip" title="Sophie 🎓">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-10.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-toggle="tooltip" title="Jack">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-1.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-toggle="tooltip" title="Ava">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-2.jpg" />
                                                </div>
                                            </div>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-outline-primary">Scheduled</span>
                                            </div>
                                            <ul class="list-inline fs-13 text-end flex-shrink-0 mb-0">
                                                <li class="list-inline-item">
                                                    <i class="ti ti-calendar text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-semibold">18 Sep, 2025</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-list-details text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">2/7</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-messages text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">3</span>
                                                </li>
                                            </ul>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-soft-success p-1">Low</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="border-bottom py-2 px-3 d-flex gap-2 align-items-center">
                                        <i class="ti ti-grip-horizontal align-middle sort-handle"></i>
                                        <input class="form-check-input rounded-circle mt-0 fs-16" id="task11" type="checkbox" />
                                        <a class="link-reset fw-medium" data-bs-target="#taskDetailsModal" data-bs-toggle="modal" href="#">Review Supplier Contract Renewals</a>
                                        <div class="d-flex align-items-center gap-3 flex-wrap justify-content-md-end ms-auto">
                                            <div class="avatar-group avatar-group-sm flex-shrink-0">
                                                <div class="avatar" data-bs-toggle="tooltip" title="Ella 📑">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-3.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-toggle="tooltip" title="Henry">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-4.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-toggle="tooltip" title="Mia">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-5.jpg" />
                                                </div>
                                            </div>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-outline-warning">Pending</span>
                                            </div>
                                            <ul class="list-inline fs-13 text-end flex-shrink-0 mb-0">
                                                <li class="list-inline-item">
                                                    <i class="ti ti-calendar text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-semibold">19 Sep, 2025</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-list-details text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">5/15</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-messages text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">7</span>
                                                </li>
                                            </ul>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-soft-warning p-1">Medium</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="border-bottom py-2 px-3 d-flex gap-2 align-items-center">
                                        <i class="ti ti-grip-horizontal align-middle sort-handle"></i>
                                        <input class="form-check-input rounded-circle mt-0 fs-16" id="task12" type="checkbox" />
                                        <a class="link-reset fw-medium" data-bs-target="#taskDetailsModal" data-bs-toggle="modal" href="#">Compile Monthly Marketing Metrics</a>
                                        <div class="d-flex align-items-center gap-3 flex-wrap justify-content-md-end ms-auto">
                                            <div class="avatar-group avatar-group-sm flex-shrink-0">
                                                <div class="avatar" data-bs-toggle="tooltip" title="Noah 📈">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-6.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-toggle="tooltip" title="Grace">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-7.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-toggle="tooltip" title="Leo">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-8.jpg" />
                                                </div>
                                            </div>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-outline-success">In Progress</span>
                                            </div>
                                            <ul class="list-inline fs-13 text-end flex-shrink-0 mb-0">
                                                <li class="list-inline-item">
                                                    <i class="ti ti-calendar text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-semibold">20 Sep, 2025</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-list-details text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">6/10</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-messages text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">15</span>
                                                </li>
                                            </ul>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-soft-success p-1">Low</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="border-bottom py-2 px-3 d-flex gap-2 align-items-center">
                                        <i class="ti ti-grip-horizontal align-middle sort-handle"></i>
                                        <input class="form-check-input rounded-circle mt-0 fs-16" id="task13" type="checkbox" />
                                        <a class="link-reset fw-medium" data-bs-target="#taskDetailsModal" data-bs-toggle="modal" href="#">Prepare Year-End Performance Review</a>
                                        <div class="d-flex align-items-center gap-3 flex-wrap justify-content-md-end ms-auto">
                                            <div class="avatar-group avatar-group-sm flex-shrink-0">
                                                <div class="avatar" data-bs-toggle="tooltip" title="Lucas 📝">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-9.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-toggle="tooltip" title="Avery">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-10.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-toggle="tooltip" title="Ella">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-1.jpg" />
                                                </div>
                                            </div>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-outline-primary">Scheduled</span>
                                            </div>
                                            <ul class="list-inline fs-13 text-end flex-shrink-0 mb-0">
                                                <li class="list-inline-item">
                                                    <i class="ti ti-calendar text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-semibold">21 Sep, 2025</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-list-details text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">1/3</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-messages text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">2</span>
                                                </li>
                                            </ul>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-soft-warning p-1">Medium</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="border-bottom py-2 px-3 d-flex gap-2 align-items-center">
                                        <i class="ti ti-grip-horizontal align-middle sort-handle"></i>
                                        <input class="form-check-input rounded-circle mt-0 fs-16" id="task14" type="checkbox" />
                                        <a class="link-reset fw-medium" data-bs-target="#taskDetailsModal" data-bs-toggle="modal" href="#">Coordinate Social Media Influencer Outreach</a>
                                        <div class="d-flex align-items-center gap-3 flex-wrap justify-content-md-end ms-auto">
                                            <div class="avatar-group avatar-group-sm flex-shrink-0">
                                                <div class="avatar" data-bs-toggle="tooltip" title="Maya 📱">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-2.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-toggle="tooltip" title="Oliver">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-3.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-toggle="tooltip" title="Zoe">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-4.jpg" />
                                                </div>
                                            </div>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-outline-warning">Pending</span>
                                            </div>
                                            <ul class="list-inline fs-13 text-end flex-shrink-0 mb-0">
                                                <li class="list-inline-item">
                                                    <i class="ti ti-calendar text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-semibold">22 Sep, 2025</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-list-details text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">3/8</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-messages text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">6</span>
                                                </li>
                                            </ul>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-soft-danger p-1">High</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="border-bottom py-2 px-3 d-flex gap-2 align-items-center">
                                        <i class="ti ti-grip-horizontal align-middle sort-handle"></i>
                                        <input class="form-check-input rounded-circle mt-0 fs-16" id="task15" type="checkbox" />
                                        <a class="link-reset fw-medium" data-bs-target="#taskDetailsModal" data-bs-toggle="modal" href="#">Test and Deploy New Checkout System</a>
                                        <div class="d-flex align-items-center gap-3 flex-wrap justify-content-md-end ms-auto">
                                            <div class="avatar-group avatar-group-sm flex-shrink-0">
                                                <div class="avatar" data-bs-toggle="tooltip" title="Harper 🧪">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-5.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-toggle="tooltip" title="Ethan">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-6.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-toggle="tooltip" title="Amelia">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-7.jpg" />
                                                </div>
                                            </div>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-outline-danger">Urgent</span>
                                            </div>
                                            <ul class="list-inline fs-13 text-end flex-shrink-0 mb-0">
                                                <li class="list-inline-item">
                                                    <i class="ti ti-calendar text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-semibold">23 Sep, 2025</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-list-details text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">7/14</span>
                                                </li>
                                                <li class="list-inline-item ms-1">
                                                    <i class="ti ti-messages text-muted fs-16 me-1 align-middle"></i>
                                                    <span class="fw-medium">19</span>
                                                </li>
                                            </ul>
                                            <div class="flex-shrink-0">
                                                <span class="badge badge-soft-danger p-1">High</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="d-flex align-items-center justify-content-center gap-2 p-3">
                                    <strong>Loading...</strong>
                                    <div aria-hidden="true" class="spinner-border spinner-border-sm text-danger" role="status"></div>
                                </div>
                            </div>
                            <!-- end card-body-->
                        </div>
                        <!-- end card-->
                    </div>
                    <!-- end row-->
                    <div aria-hidden="true" aria-labelledby="taskDetailsModalLabel" class="modal fade" id="taskDetailsModal" tabindex="-1">
                        <div class="modal-dialog modal-lg modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="taskDetailsModalLabel">Finalize Product Roadmap for Launch</h5>
                                    <button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"></button>
                                </div>
                                <div class="modal-body pb-0">
                                    <div class="d-flex align-items-center mb-4">
                                        <div class="avatar me-2" data-bs-toggle="tooltip" title="Assigned by Alex Johnson">
                                            <img alt="" class="rounded-circle avatar-img-size" src="/images/users/user-8.jpg" style="width: 40px; height: 40px" />
                                        </div>
                                        <div>
                                            <span class="fw-semibold">Assigned by:</span>
                                            Alex Johnson
                                        </div>
                                    </div>
                                    <div class="row g-3">
                                        <div class="col-md-4">
                                            <label class="text-uppercase d-block fw-semibold fs-xs text-muted mb-1">Status</label>
                                            <span class="badge badge-outline-success">In Progress</span>
                                        </div>
                                        <div class="col-md-4">
                                            <label class="text-uppercase d-block fw-semibold fs-xs text-muted mb-1">Priority</label>
                                            <span class="badge badge-soft-primary p-1">Medium</span>
                                        </div>
                                        <div class="col-md-4">
                                            <label class="text-uppercase d-block fw-semibold fs-xs text-muted mb-1">Due Date</label>
                                            <span class="fw-semibold">Tomorrow</span>
                                        </div>
                                        <div class="col-md-4">
                                            <label class="text-uppercase d-block fw-semibold fs-xs text-muted mb-1">Progress</label>
                                            <span class="fw-medium">5/10</span>
                                        </div>
                                        <div class="col-md-4">
                                            <label class="text-uppercase d-block fw-semibold fs-xs text-muted mb-1">Assigned To</label>
                                            <div class="avatar-group avatar-group-sm">
                                                <div class="avatar" data-bs-toggle="tooltip" title="Maria 💻">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-5.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-toggle="tooltip" title="James">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-6.jpg" />
                                                </div>
                                                <div class="avatar" data-bs-toggle="tooltip" title="Sophia 🚀">
                                                    <img alt="" class="rounded-circle fs-24 avatar-img-size" src="/images/users/user-7.jpg" />
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <label class="text-uppercase d-block fw-semibold fs-xs text-muted mb-1">Description</label>
                                            <p class="mb-0">Preparing and finalizing the product roadmap for the upcoming launch with clear milestones and dependencies.</p>
                                        </div>
                                        <!-- Comments -->
                                        <div class="col-12">
                                            <div class="bg-light-subtle mx-n3 p-3 border-top border-bottom border-dashed">
                                                <div class="d-flex align-items-start">
                                                    <img alt="Generic placeholder image" class="me-2 avatar-sm rounded-circle" src="/images/users/user-5.jpg" />
                                                    <div class="w-100 fs-sm">
                                                        <h6 class="mt-0 mb-1">
                                                            <a class="link-reset" href="#!">Ethan Reynolds</a>
                                                            <small class="text-muted fw-normal float-end">20 minutes ago</small>
                                                        </h6>
                                                        Loved your recent project! Really curious to see how you implemented the animations.
                                                        <br />
                                                        <a class="text-muted font-13 d-inline-block mt-2" href="javascript:void(0);">
                                                            <i class="ti ti-corner-up-left"></i>
                                                            Reply
                                                        </a>
                                                        <div class="d-flex align-items-start mt-3">
                                                            <a class="pe-2" href="#">
                                                                <img alt="Generic placeholder image" class="avatar-sm rounded-circle" src="/images/users/user-6.jpg" />
                                                            </a>
                                                            <div class="w-100">
                                                                <h6 class="mt-0 mb-1">
                                                                    <a class="link-reset" href="#!">Mia Thompson</a>
                                                                    <small class="text-muted fw-normal float-end">12 minutes ago</small>
                                                                </h6>
                                                                I created something similar in Angular last month — would love to swap tips!
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="d-flex align-items-start mt-3">
                                                    <a class="pe-2" href="#">
                                                        <img alt="Generic placeholder image" class="rounded-circle" height="31" src="/images/users/user-3.jpg" />
                                                    </a>
                                                    <div class="w-100">
                                                        <input class="form-control form-control-sm" id="simpleinput" placeholder="Add a comment..." type="text" />
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer border-top-0">
                                    <button class="btn btn-secondary" data-bs-dismiss="modal" type="button">Close</button>
                                    <button class="btn btn-primary" type="button">Mark as Complete</button>
                                </div>
                            </div>
                            <!-- end modal-content-->
                        </div>
                        <!-- end modal-dialog-->
                    </div>
                    <!-- end modal-->
                    <div aria-hidden="true" aria-labelledby="addTaskModalLabel" class="modal fade" id="addTaskModal" tabindex="-1">
                        <div class="modal-dialog modal-lg modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="addTaskModalLabel">Add New Task</h5>
                                    <button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"></button>
                                </div>
                                <form id="addTaskForm">
                                    <div class="modal-body">
                                        <div class="mb-3">
                                            <label class="form-label fw-semibold">Task Title</label>
                                            <input class="form-control" name="taskTitle" placeholder="Enter task title" required="" type="text" />
                                        </div>
                                        <div class="row g-3">
                                            <!-- Due Date -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="DueDate">Due Date</label>
                                                <input class="form-control" data-date-format="d M, Y" data-provider="flatpickr" id="DueDate" required="" type="date" />
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label fw-semibold">Priority</label>
                                                <select class="form-select" name="taskPriority">
                                                    <option value="badge-soft-success p-1">Low</option>
                                                    <option value="badge-soft-primary p-1">Medium</option>
                                                    <option selected="" value="badge-soft-danger p-1">High</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="mt-3">
                                            <label class="form-label fw-semibold">Status</label>
                                            <select class="form-select" name="taskStatus">
                                                <option value="badge-outline-warning">New</option>
                                                <option value="badge-outline-success">In Progress</option>
                                                <option value="badge-outline-primary">Scheduled</option>
                                                <option value="badge-outline-danger">Urgent</option>
                                            </select>
                                        </div>
                                        <div class="mt-3">
                                            <label class="form-label fw-semibold">Assign To</label>
                                            <input class="form-control" name="taskAvatars" placeholder="Comma-separated user IDs" type="text" />
                                            <small class="text-muted">set @username</small>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button class="btn btn-secondary" data-bs-dismiss="modal" type="button">Cancel</button>
                                        <button class="btn btn-primary" type="submit">Add Task</button>
                                    </div>
                                </form>
                            </div>
                            <!-- end modal-content-->
                        </div>
                        <!-- end modal-dialog-->
                    </div>
                    <!-- end modal-->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- sortablejs -->
        <script src="/plugins/sortablejs/Sortable.min.js"></script>
        <!-- Todo Init Js -->
        <script src="/js/pages/apps-todo.js"></script>
    </body>
</html>
