<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Account Settings')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Pages', 'title' => 'Account Settings')) ?>

                    <div class="row">
                        <div class="col-12">
                            <article class="card overflow-hidden mb-0">
                                <div class="position-relative card-side-img overflow-hidden" style="min-height: 300px; background-image: url(/images/profile-bg.jpg)">
                                    <div class="p-4 card-img-overlay rounded-start-0 auth-overlay d-flex align-items-center flex-column justify-content-center">
                                        <h3 class="text-white mb-0 fst-italic">
                                            "Designing the future, one template at a time"
                                            <a href="#!"><i class="ti ti-edit"></i></a>
                                        </h3>
                                        <button class="btn btn-sm btn-danger mt-2" type="button">Change Background</button>
                                    </div>
                                </div>
                            </article>
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                    <div class="px-3 mt-n4">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <form>
                                            <!-- Personal Info -->
                                            <h5 class="mb-3 text-uppercase bg-light-subtle p-1 border-dashed border rounded border-light d-flex justify-content-center align-items-center gap-1">
                                                <i class="ti ti-user-circle fs-lg"></i>
                                                Personal Info
                                            </h5>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="firstname">First Name</label>
                                                        <input class="form-control" id="firstname" placeholder="Enter first name" type="text" />
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="lastname">Last Name</label>
                                                        <input class="form-control" id="lastname" placeholder="Enter last name" type="text" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="jobtitle">Job Title</label>
                                                        <input class="form-control" id="jobtitle" placeholder="e.g. UI Developer, Designer" type="text" />
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="phone">Phone Number</label>
                                                        <input class="form-control" id="phone" placeholder="+1 234 567 8901" type="text" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label" for="userbio">Bio</label>
                                                <textarea class="form-control" id="userbio" placeholder="Write something about yourself..." rows="4"></textarea>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="useremail">Email Address</label>
                                                        <input class="form-control" id="useremail" placeholder="Enter email" type="email" />
                                                        <span class="form-text fs-xs fst-italic text-muted">
                                                            <a class="link-reset" href="#">Click here to change your email</a>
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="userpassword">Password</label>
                                                        <input class="form-control" id="userpassword" placeholder="Enter new password" type="password" />
                                                        <span class="form-text fs-xs fst-italic text-muted">
                                                            <a class="link-reset" href="#">Click here to change your password</a>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="mb-4">
                                                <label class="form-label" for="profilephoto">Profile Photo</label>
                                                <input class="form-control" id="profilephoto" type="file" />
                                            </div>
                                            <!-- Address Info -->
                                            <h5 class="mb-3 text-uppercase bg-light-subtle p-1 border-dashed border rounded border-light d-flex justify-content-center align-items-center gap-1">
                                                <i class="ti ti-map-pin fs-lg"></i>
                                                Address Info
                                            </h5>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="address-line1">Address Line 1</label>
                                                        <input class="form-control" id="address-line1" placeholder="Street, Apartment, Unit, etc." type="text" />
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="address-line2">Address Line 2</label>
                                                        <input class="form-control" id="address-line2" placeholder="Optional" type="text" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="city">City</label>
                                                        <input class="form-control" id="city" placeholder="City" type="text" />
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="state">State / Province</label>
                                                        <input class="form-control" id="state" placeholder="State or Province" type="text" />
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="zipcode">Postal / ZIP Code</label>
                                                        <input class="form-control" id="zipcode" placeholder="Postal Code" type="text" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="country">Country</label>
                                                        <input class="form-control" id="country" placeholder="Country" type="text" />
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Company Info -->
                                            <h5 class="mb-3 text-uppercase bg-light-subtle p-1 border-dashed border rounded border-light d-flex justify-content-center align-items-center gap-1">
                                                <i class="ti ti-building fs-lg"></i>
                                                Company Info
                                            </h5>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="companyname">Company Name</label>
                                                        <input class="form-control" id="companyname" placeholder="Enter company name" type="text" />
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label" for="cwebsite">Website</label>
                                                        <input class="form-control" id="cwebsite" placeholder="https://yourcompany.com" type="text" />
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Social -->
                                            <h5 class="mb-3 text-uppercase bg-light-subtle p-1 border-dashed border rounded border-light d-flex justify-content-center align-items-center gap-1">
                                                <i class="ti ti-world fs-lg"></i>
                                                Social
                                            </h5>
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <label class="form-label" for="social-fb">Facebook</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">
                                                            <svg
                                                                class="icon icon-tabler icons-tabler-outline icon-tabler-brand-facebook"
                                                                fill="none"
                                                                height="16"
                                                                stroke="currentColor"
                                                                stroke-linecap="round"
                                                                stroke-linejoin="round"
                                                                stroke-width="2"
                                                                viewbox="0 0 24 24"
                                                                width="16"
                                                                xmlns="http://www.w3.org/2000/svg"
                                                            >
                                                                <path d="M0 0h24v24H0z" fill="none" stroke="none"></path>
                                                                <path d="M7 10v4h3v7h4v-7h3l1 -4h-4v-2a1 1 0 0 1 1 -1h3v-4h-3a5 5 0 0 0 -5 5v2h-3"></path>
                                                            </svg>
                                                        </span>
                                                        <input class="form-control" id="social-fb" placeholder="Facebook URL" type="text" />
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label" for="social-tw">Twitter X</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">
                                                            <svg
                                                                class="icon icon-tabler icons-tabler-outline icon-tabler-brand-x"
                                                                fill="none"
                                                                height="16"
                                                                stroke="currentColor"
                                                                stroke-linecap="round"
                                                                stroke-linejoin="round"
                                                                stroke-width="2"
                                                                viewbox="0 0 24 24"
                                                                width="16"
                                                                xmlns="http://www.w3.org/2000/svg"
                                                            >
                                                                <path d="M0 0h24v24H0z" fill="none" stroke="none"></path>
                                                                <path d="M4 4l11.733 16h4.267l-11.733 -16z"></path>
                                                                <path d="M4 20l6.768 -6.768m2.46 -2.46l6.772 -6.772"></path>
                                                            </svg>
                                                        </span>
                                                        <input class="form-control" id="social-tw" placeholder="@username" type="text" />
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label" for="social-insta">Instagram</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">
                                                            <svg
                                                                class="icon icon-tabler icons-tabler-outline icon-tabler-brand-instagram"
                                                                fill="none"
                                                                height="16"
                                                                stroke="currentColor"
                                                                stroke-linecap="round"
                                                                stroke-linejoin="round"
                                                                stroke-width="2"
                                                                viewbox="0 0 24 24"
                                                                width="16"
                                                                xmlns="http://www.w3.org/2000/svg"
                                                            >
                                                                <path d="M0 0h24v24H0z" fill="none" stroke="none"></path>
                                                                <path d="M4 8a4 4 0 0 1 4 -4h8a4 4 0 0 1 4 4v8a4 4 0 0 1 -4 4h-8a4 4 0 0 1 -4 -4z"></path>
                                                                <path d="M9 12a3 3 0 1 0 6 0a3 3 0 0 0 -6 0"></path>
                                                                <path d="M16.5 7.5v.01"></path>
                                                            </svg>
                                                        </span>
                                                        <input class="form-control" id="social-insta" placeholder="Instagram URL" type="text" />
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label" for="social-lin">LinkedIn</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">
                                                            <svg
                                                                class="icon icon-tabler icons-tabler-outline icon-tabler-brand-linkedin"
                                                                fill="none"
                                                                height="16"
                                                                stroke="currentColor"
                                                                stroke-linecap="round"
                                                                stroke-linejoin="round"
                                                                stroke-width="2"
                                                                viewbox="0 0 24 24"
                                                                width="16"
                                                                xmlns="http://www.w3.org/2000/svg"
                                                            >
                                                                <path d="M0 0h24v24H0z" fill="none" stroke="none"></path>
                                                                <path d="M8 11v5"></path>
                                                                <path d="M8 8v.01"></path>
                                                                <path d="M12 16v-5"></path>
                                                                <path d="M16 16v-3a2 2 0 1 0 -4 0"></path>
                                                                <path d="M3 7a4 4 0 0 1 4 -4h10a4 4 0 0 1 4 4v10a4 4 0 0 1 -4 4h-10a4 4 0 0 1 -4 -4z"></path>
                                                            </svg>
                                                        </span>
                                                        <input class="form-control" id="social-lin" placeholder="LinkedIn Profile" type="text" />
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label" for="social-gh">GitHub</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">
                                                            <svg
                                                                class="icon icon-tabler icons-tabler-outline icon-tabler-brand-github"
                                                                fill="none"
                                                                height="16"
                                                                stroke="currentColor"
                                                                stroke-linecap="round"
                                                                stroke-linejoin="round"
                                                                stroke-width="2"
                                                                viewbox="0 0 24 24"
                                                                width="16"
                                                                xmlns="http://www.w3.org/2000/svg"
                                                            >
                                                                <path d="M0 0h24v24H0z" fill="none" stroke="none"></path>
                                                                <path
                                                                    d="M9 19c-4.3 1.4 -4.3 -2.5 -6 -3m12 5v-3.5c0 -1 .1 -1.4 -.5 -2c2.8 -.3 5.5 -1.4 5.5 -6a4.6 4.6 0 0 0 -1.3 -3.2a4.2 4.2 0 0 0 -.1 -3.2s-1.1 -.3 -3.5 1.3a12.3 12.3 0 0 0 -6.2 0c-2.4 -1.6 -3.5 -1.3 -3.5 -1.3a4.2 4.2 0 0 0 -.1 3.2a4.6 4.6 0 0 0 -1.3 3.2c0 4.6 2.7 5.7 5.5 6c-.6 .6 -.6 1.2 -.5 2v3.5"
                                                                ></path>
                                                            </svg>
                                                        </span>
                                                        <input class="form-control" id="social-gh" placeholder="GitHub Username" type="text" />
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label" for="social-sky">Dribbble</label>
                                                    <div class="input-group">
                                                        <span class="input-group-text">
                                                            <svg
                                                                class="icon icon-tabler icons-tabler-outline icon-tabler-brand-dribbble"
                                                                fill="none"
                                                                height="16"
                                                                stroke="currentColor"
                                                                stroke-linecap="round"
                                                                stroke-linejoin="round"
                                                                stroke-width="2"
                                                                viewbox="0 0 24 24"
                                                                width="16"
                                                                xmlns="http://www.w3.org/2000/svg"
                                                            >
                                                                <path d="M0 0h24v24H0z" fill="none" stroke="none"></path>
                                                                <path d="M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0"></path>
                                                                <path d="M9 3.6c5 6 7 10.5 7.5 16.2"></path>
                                                                <path d="M6.4 19c3.5 -3.5 6 -6.5 14.5 -6.4"></path>
                                                                <path d="M3.1 10.75c5 0 9.814 -.38 15.314 -5"></path>
                                                            </svg>
                                                        </span>
                                                        <input class="form-control" id="social-sky" placeholder="@username" type="text" />
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Submit -->
                                            <div class="text-end mt-4">
                                                <button class="btn btn-success" type="submit">Save Changes</button>
                                            </div>
                                        </form>
                                    </div>
                                    <!-- end card-body-->
                                </div>
                                <!-- end card-->
                            </div>
                            <!-- end col-->
                        </div>
                        <!-- end row-->
                    </div>
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>
    </body>
</html>
