<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Reset Password')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <div class="auth-box p-0 w-100">
            <div class="row w-100 g-0">
                <div class="col-md-auto">
                    <!--Auth Box content -->
                    <div class="card auth-box-form border-0 mb-0">
                        <div class="position-absolute top-0 end-0" style="width: 180px">
                            <img alt="auth-card-bg" class="auth-card-bg-img" src="/images/auth-card-bg.svg" />
                        </div>
                        <div class="card-body min-vh-100 position-relative d-flex flex-column justify-content-center">
                            <div class="auth-brand mb-0 text-center">
                                <a class="logo-dark" href="/">
                                    <img alt="dark logo" src="/images/logo-black.png" />
                                </a>
                                <a class="logo-light" href="/">
                                    <img alt="logo" src="/images/logo.png" />
                                </a>
                            </div>
                            <div class="mt-auto">
                                <p class="text-muted text-center auth-sub-text mx-auto">Enter your email address and we'll send you a link to reset your password.</p>
                                <form class="mt-4">
                                    <div class="mb-3">
                                        <label class="form-label" for="userEmail">
                                            Email address
                                            <span class="text-danger">*</span>
                                        </label>
                                        <div class="app-search">
                                            <input class="form-control" id="userEmail" placeholder="you@example.com" required="" type="email" />
                                            <i class="ti ti-mail app-search-icon text-muted"></i>
                                        </div>
                                    </div>
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <div class="form-check">
                                            <input class="form-check-input form-check-input-light fs-14" id="termAndPolicy" type="checkbox" />
                                            <label class="form-check-label" for="termAndPolicy">Agree the Terms &amp; Policy</label>
                                        </div>
                                    </div>
                                    <div class="d-grid">
                                        <button class="btn btn-primary fw-semibold py-2" type="submit">Send Request</button>
                                    </div>
                                </form>
                            </div>
                            <p class="text-muted text-center mt-4 mb-0">
                                Return to
                                <a class="text-decoration-underline link-offset-3 fw-semibold" href="/auth-split-sign-in">Sign in</a>
                            </p>
                            <p class="text-center text-muted mt-auto mb-0">
                                ©
                                <script>
                                    document.write(new Date().getFullYear())
                                </script>
                                Paces — by
                                <span class="fw-bold">Coderthemes</span>
                            </p>
                        </div>
                    </div>
                    <!-- End Auth Box Content -->
                </div>
                <div class="col">
                    <div class="h-100 position-relative card-side-img rounded-0 overflow-hidden" style="background-image: url(/images/auth.jpg)">
                        <div class="p-4 card-img-overlay auth-overlay d-flex align-items-end justify-content-center"></div>
                    </div>
                </div>
            </div>
        </div>

        <?= $this->include('partials/footer-scripts') ?>
    </body>
</html>
