<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Sparkline Apexcharts')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Charts', 'title' => 'Sparkline Apexcharts')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row g-3" dir="ltr">
                                        <div class="col-md-4">
                                            <div class="apex-charts" id="spark1"></div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="apex-charts" id="spark2"></div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="apex-charts" id="spark3"></div>
                                        </div>
                                    </div>
                                    <!-- end row -->
                                </div>
                                <!-- end card body-->
                                <div class="row">
                                    <div class="col-12">
                                        <div class="table-responsive">
                                            <table class="table table-centered table-custom mb-0">
                                                <thead class="bg-light bg-opacity-50 fs-xxs thead-sm text-uppercase">
                                                    <tr>
                                                        <th>Total Value</th>
                                                        <th>Percentage of Portfolio</th>
                                                        <th>Last 10 days</th>
                                                        <th>Volume</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>$32,554</td>
                                                        <td>15%</td>
                                                        <td>
                                                            <div id="chart1"></div>
                                                        </td>
                                                        <td>
                                                            <div id="chart5"></div>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>$23,533</td>
                                                        <td>7%</td>
                                                        <td>
                                                            <div id="chart2"></div>
                                                        </td>
                                                        <td>
                                                            <div id="chart6"></div>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>$54,276</td>
                                                        <td>9%</td>
                                                        <td>
                                                            <div id="chart3"></div>
                                                        </td>
                                                        <td>
                                                            <div id="chart7"></div>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>$11,533</td>
                                                        <td>2%</td>
                                                        <td>
                                                            <div id="chart4"></div>
                                                        </td>
                                                        <td>
                                                            <div id="chart8"></div>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                        <!-- end table-responsive -->
                                    </div>
                                    <!-- end col -->
                                </div>
                                <!-- end row-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Apex Charts js -->
        <script src="/plugins/apexcharts/apexcharts.min.js"></script>
        <!-- Apex Chart Sparkline Demo js -->
        <script src="/js/pages/chart-apex-sparklines.js"></script>
    </body>
</html>
