<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Bar Charts')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Charts', 'title' => 'Bar Charts')) ?>

                    <div class="row">
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Basic Bar</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="basic-bar-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Border Radius</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="border-radius-bar-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Floating</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="floating-bar-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Horizontal</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="horizontal-bar-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Stacked</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="stacked-bar-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Stacked with Groups</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="stacked-groups-bar-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Vertical</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="vertical-bar-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- ChartJs Plugin Js -->
        <script src="/plugins/chartjs/chart.umd.js"></script>
        <!-- Area chart Demo js -->
        <script src="/js/pages/chartjs-bar.js"></script>
    </body>
</html>
