<?= $this->extend('app') ?>

<?= $this->section('styles') ?>


<?= $this->endSection() ?>

<?= $this->section('content') ?>

<div class="card">
    <div class="card-header">
        <h4 class="card-title">Nuevo cliente</h4>
    </div>
    <!-- end card header -->
    <div class="card-body">
        <form id="newClientForm">
            <div class="row g-3">
                <!-- Username -->
                <div class="col-lg-6">
                    <div class="form-floating">
                        <input class="form-control"
                           id="nameInput"
                           name="name"
                           placeholder="Beatriz"
                           type="text"
                           required/>
                        <label for="nameInput">Nombre(s)</label>
                    </div>
                </div>
                <!-- Full Name -->
                <div class="col-lg-6">
                    <div class="form-floating">
                        <input class="form-control"
                           id="lastnameInput"
                           name="last_name"
                           placeholder="Pinzón"
                           type="text"
                           required/>
                        <label for="lastnameInput">Apellidos</label>
                    </div>
                </div>
                <!-- Phone Number -->
                <div class="col-lg-6">
                    <div class="form-floating">
                        <input class="form-control"
                           id="phoneInput"
                           name="phone"
                           placeholder="Enter phone number"
                           type="tel"
                           required/>
                        <label for="phoneInput">Celular</label>
                    </div>
                </div>
                <!-- Email -->
                <div class="col-lg-6">
                    <div class="form-floating">
                        <input class="form-control"
                               id="emailInput"
                               name="email"
                               placeholder="Enter email"
                               type="email" />
                        <label for="emailInput">Correo</label>
                    </div>
                </div>

                <!-- Submit -->
                <div class="col-lg-12">
                    <button class="btn btn-success">Guardar</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header justify-content-between">
                <h4 class="card-title">Relación de clientes</h4>
            </div>
            <div class="card-body">
                <table class="table table-striped dt-responsive align-middle mb-0" id="datatables-ajax">
                    <thead class="thead-sm text-uppercase fs-xxs">
                    <tr>
                        <th># Cliente</th>
                        <th>Nombre(s)</th>
                        <th>Apellidos</th>
                        <th>Celular</th>
                        <th>Correo</th>
                        <th>Acciones</th>
                    </tr>
                    </thead>
                </table>
            </div>
            <!-- end card-body-->
        </div>
        <!-- end card-->
    </div>
</div>

<?= $this->include('modals/editClient')?>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
    <script src="/plugins/datatables/dataTables.min.js"></script>
    <script src="/plugins/datatables/dataTables.bootstrap5.min.js"></script>
    <script src="/plugins/datatables/dataTables.responsive.min.js"></script>
    <script src="/plugins/datatables/responsive.bootstrap5.min.js"></script>
    <script>
        console.log('Client script loaded!');
        var tableElement = document.getElementById("datatables-ajax"), dt_table;
        $(function(){

            // Client form
            $("#newClientForm").on("submit",function(e){
                e.preventDefault();
                let clientData = $(this).serializeArray();
                console.log(clientData);
                $.ajax({
                    method: "POST",
                    url: "/client",
                    dataType: "JSON",
                    data: clientData,
                    success: function(){
                        showToast('success', 'Cliente registrado');
                        $('#newClientForm')[0].reset();
                        dt_table.ajax.reload();
                    },
                    error: function(error){
                        showToast('danger', 'Ups, algo falló. Intentalo de nuevo');
                        console.log(error);
                    }
                }).done(function(){});
            });

            //Clients table
            if (tableElement) {
                dt_table = new DataTable(tableElement, {
                    ajax: {
                        url: '/client',
                        dataSrc: ""
                    },
                    processing: true,
                    order: [[0, "desc"]],
                    columns: [
                        { data: "id" },
                        { data: "name" },
                        { data: "last_name" },
                        { data: "phone" },
                        { data: "email" },
                        { data: "id", render: function (data, type, full){
                                let clientJson = JSON.stringify(full);
                                return `
                                        <a class="btn btn-light btn-icon btn-sm rounded-circle"
                                            data-bs-target="#editClient-modal"
                                            data-bs-toggle="modal"
                                            onclick='openModalEditClient(${clientJson})'>
                                            <i class="ti ti-edit fs-lg"></i>
                                        </a>
                                        <a class="btn btn-light btn-icon btn-sm rounded-circle"
                                            onclick="deleteThing(${full.id}, '/client')">
                                            <i class="ti ti-trash fs-lg"></i>
                                        </a>
                                    </div>
                                `;
                            }
                        }
                    ],
                    language: {
                        paginate: {
                            first: '<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M11 7l-5 5l5 5" /><path d="M17 7l-5 5l5 5" /></svg>',
                            previous:
                                '<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M15 6l-6 6l6 6" /></svg>',
                            next: '<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M9 6l6 6l-6 6" /></svg>',
                            last: '<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M7 7l5 5l-5 5" /><path d="M13 7l5 5l-5 5" /></svg>',
                        },
                        lengthMenu: "_MENU_ clientes por página",
                        info: 'Mostrando <span class="fw-semibold">_START_</span> a <span class="fw-semibold">_END_</span> de <span class="fw-semibold">_TOTAL_</span> clientes',
                    },
                })
            }
        });

        function openModalEditClient(client){
            $('#nameInputEdit').val(client.name);
            $('#lastnameInputEdit').val(client.last_name);
            $('#phoneInputEdit').val(client.phone);
            $('#emailInputEdit').val(client.email);
            $('#idClientEdit').val(client.id);

            setupEditClientInputs();
        }

        function setupEditClientInputs() {
            const inputs = document.querySelectorAll('.editClientInput');
            let clientID = $('#idClientEdit').val();
            inputs.forEach(input => {
                input.addEventListener('change', function() {
                    const inputName = this.name || this.id;
                    const inputValue = this.value;

                    const data = {
                        [inputName]: inputValue
                    };

                    editThing(clientID, data, '/client')
                });
            });
        }



    </script>
<?= $this->endSection() ?>
