<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Finance Dashboard')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Dashboard', 'title' => 'Finance')) ?>

                    <div class="alert alert-primary alert-dismissible d-flex align-items-center" role="alert">
                        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button"></button>
                        <i class="ti ti-lifebuoy fs-24 me-1"></i>
                        <div>
                            <strong>Dear David Dev -</strong>
                            We kindly encourage you to review your recent transactions and financial commitments to ensure that your account is in good standing.
                        </div>
                        <a class="text-reset text-decoration-underline ms-auto link-offset-2" href="#!"><b>Action Now</b></a>
                    </div>
                    <div class="row">
                        <div class="col-xxl-4">
                            <div class="card card-h-100">
                                <div class="card-header border-0 justify-content-between">
                                    <h4 class="card-title">Total Balance</h4>
                                    <div class="dropdown ms-auto">
                                        <a class="btn btn-sm btn-default btn-icon" data-bs-toggle="dropdown" href="#">
                                            <i class="ti ti-dots-vertical fs-lg"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-end">
                                            <li>
                                                <a class="dropdown-item" href="#">
                                                    <i class="ti ti-wallet me-2"></i>
                                                    Add Funds
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="#">
                                                    <i class="ti ti-cash-banknote-move-back me-2"></i>
                                                    Withdraw Funds
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="#">
                                                    <i class="ti ti-transaction-dollar me-2"></i>
                                                    Transaction History
                                                </a>
                                            </li>
                                            <li>
                                                <hr class="dropdown-divider" />
                                            </li>
                                            <li>
                                                <a class="dropdown-item text-danger" href="#">
                                                    <i class="ti ti-lock me-2"></i>
                                                    Freeze Account
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="card-body pt-0">
                                    <h2 class="fw-bold" id="user-balance-data">
                                        <span id="user-balance-number">$76,852.36</span>
                                        <span data-toggler="off" id="user-b-show-hide">
                                            <a class="d-none" data-toggler-on="" href="#">
                                                <i class="ti ti-eye text-warning fs-xxl"></i>
                                            </a>
                                            <a data-toggler-off="" href="#">
                                                <i class="ti ti-eye-off text-muted fs-xxl"></i>
                                            </a>
                                        </span>
                                    </h2>
                                    <div class="p-2 bg-light bg-opacity-50 rounded mt-3 gap-2 d-flex align-items-center">
                                        <img alt="" class="rounded me-1" height="36" src="/images/debit-card.png" />
                                        <div>
                                            <p class="mb-0 fw-semibold">
                                                $
                                                <span data-target="59,258.25">0</span>
                                            </p>
                                            <p class="text-muted fs-12 mb-0">**** **** **** 3698</p>
                                        </div>
                                        <a class="btn btn-link fw-medium text-reset ms-auto text-decoration-underline link-offset-2" href="#!">Details</a>
                                    </div>
                                    <div class="row g-2 mt-3">
                                        <div class="col">
                                            <a class="btn btn-secondary bg-gradient w-100" href="#!">
                                                <i class="ti ti-coin me-1"></i>
                                                Transfer
                                            </a>
                                        </div>
                                        <div class="col">
                                            <a class="btn btn-info bg-gradient w-100" href="#!">
                                                <i class="ti ti-coin me-1"></i>
                                                Request
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card-body -->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->
                        <div class="col-xxl-8">
                            <div class="row">
                                <div class="col-xl-3 col-md-6">
                                    <div class="card">
                                        <div class="card-body">
                                            <iconify-icon class="fs-36 text-success" icon="solar:leaf-bold-duotone"></iconify-icon>
                                            <h3 class="fw-bold mt-3 mb-1">
                                                $
                                                <span data-target="51.68">0</span>
                                                k
                                            </h3>
                                            <p class="text-muted">Total Income</p>
                                            <span class="badge fs-12 badge-soft-success">
                                                <i class="ti ti-arrow-badge-up"></i>
                                                8.72%
                                            </span>
                                            <div class="mt-3" id="total-income-chart"></div>
                                        </div>
                                        <!-- end card-body -->
                                    </div>
                                    <!-- end card -->
                                </div>
                                <!-- end col -->
                                <div class="col-xl-3 col-md-6">
                                    <div class="card">
                                        <div class="card-body">
                                            <iconify-icon class="fs-36 text-info" icon="solar:wallet-money-bold-duotone"></iconify-icon>
                                            <h3 class="fw-bold mt-3 mb-1">
                                                $
                                                <span data-target="24.03">0</span>
                                                k
                                            </h3>
                                            <p class="text-muted">Total Expenses</p>
                                            <span class="badge fs-12 badge-soft-danger">
                                                <i class="ti ti-arrow-badge-down"></i>
                                                3.28%
                                            </span>
                                            <div class="mt-3" id="total-expenses-chart"></div>
                                        </div>
                                        <!-- end card-body -->
                                    </div>
                                    <!-- end card -->
                                </div>
                                <!-- end col -->
                                <div class="col-xl-3 col-md-6">
                                    <div class="card">
                                        <div class="card-body">
                                            <iconify-icon class="fs-36 text-warning" icon="solar:chart-2-bold-duotone"></iconify-icon>
                                            <h3 class="fw-bold mt-3 mb-1">
                                                $
                                                <span data-target="48.21">0</span>
                                                k
                                            </h3>
                                            <p class="text-muted">Investments</p>
                                            <span class="badge fs-12 badge-soft-danger">
                                                <i class="ti ti-arrow-badge-down"></i>
                                                5.69%
                                            </span>
                                            <div class="mt-3" id="investments-chart"></div>
                                        </div>
                                        <!-- end card-body -->
                                    </div>
                                    <!-- end card -->
                                </div>
                                <!-- end col -->
                                <div class="col-xl-3 col-md-6">
                                    <div class="card">
                                        <div class="card-body">
                                            <iconify-icon class="fs-36 text-secondary" icon="solar:hand-money-bold"></iconify-icon>
                                            <h3 class="fw-bold mt-3 mb-1">
                                                $
                                                <span data-target="11.65">0</span>
                                                k
                                            </h3>
                                            <p class="text-muted">Savings</p>
                                            <span class="badge fs-12 badge-soft-success">
                                                <i class="ti ti-arrow-badge-up"></i>
                                                10.58%
                                            </span>
                                            <div class="mt-3" id="savings-chart"></div>
                                        </div>
                                        <!-- end card-body -->
                                    </div>
                                    <!-- end card -->
                                </div>
                                <!-- end col -->
                            </div>
                        </div>
                    </div>
                    <!-- end row -->
                    <div class="row">
                        <div class="col-xl-8">
                            <div class="card card-h-100">
                                <div class="card-header border-0 justify-content-between">
                                    <h4 class="card-title">Financial Overview</h4>
                                    <div class="dropdown ms-auto">
                                        <a class="btn btn-sm btn-default btn-icon" data-bs-toggle="dropdown" href="#">
                                            <i class="ti ti-dots-vertical fs-lg"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-end">
                                            <li>
                                                <a class="dropdown-item" href="#">
                                                    <i class="ti ti-refresh me-2"></i>
                                                    Refresh Data
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="#">
                                                    <i class="ti ti-chart-bar me-2"></i>
                                                    View Analytics
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="#">
                                                    <i class="ti ti-filter-2 me-2"></i>
                                                    Filter Report
                                                </a>
                                            </li>
                                            <li>
                                                <hr class="dropdown-divider" />
                                            </li>
                                            <li>
                                                <a class="dropdown-item text-danger" href="#">
                                                    <i class="ti ti-download me-2"></i>
                                                    Export Data
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="card-body p-0">
                                    <div class="bg-light bg-opacity-40">
                                        <div class="row text-center">
                                            <div class="col">
                                                <p class="text-muted mt-3 mb-1">Revenue</p>
                                                <h4 class="mb-3">
                                                    <span class="ti ti-square-rounded-arrow-down text-success me-1"></span>
                                                    <span>
                                                        $
                                                        <span data-target="29.56">0</span>
                                                        k
                                                    </span>
                                                </h4>
                                            </div>
                                            <div class="col">
                                                <p class="text-muted mt-3 mb-1">Expenses</p>
                                                <h4 class="mb-3">
                                                    <span class="ti ti-square-rounded-arrow-up text-danger me-1"></span>
                                                    <span>
                                                        $
                                                        <span data-target="15.08">0</span>
                                                        k
                                                    </span>
                                                </h4>
                                            </div>
                                            <div class="col">
                                                <p class="text-muted mt-3 mb-1">Investment</p>
                                                <h4 class="mb-3">
                                                    <span class="ti ti-chart-infographic me-1"></span>
                                                    <span>
                                                        $
                                                        <span data-target="3.67">0</span>
                                                        k
                                                    </span>
                                                </h4>
                                            </div>
                                            <div class="col">
                                                <p class="text-muted mt-3 mb-1">Savings</p>
                                                <h4 class="mb-3">
                                                    <span class="ti ti-pig me-1"></span>
                                                    <span>
                                                        $
                                                        <span data-target="6.72">0</span>
                                                        k
                                                    </span>
                                                </h4>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="p-2">
                                        <div dir="ltr">
                                            <div class="apex-charts" id="financial-overview-chart"></div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card-body-->
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                        <div class="col-xl-4">
                            <div class="card bg-secondary bg-gradient">
                                <div class="card-body" style="background-image: url(/images/flower-style.svg); background-size: contain; background-repeat: no-repeat; background-position: right bottom">
                                    <h4 class="text-white">Investment Growth</h4>
                                    <p class="text-white text-opacity-75">Track performance and see where your money is heading.</p>
                                    <a class="btn btn-sm rounded-pill btn-info bg-gradient" href="#!">View Portfolio</a>
                                </div>
                                <!-- end card-body-->
                            </div>
                            <!-- end card-->
                            <div class="card">
                                <div class="card-header justify-content-between">
                                    <h4 class="card-title">
                                        Quick Transfer
                                        <i class="ti ti-info-octagon text-muted ms-1" data-bs-placement="top" data-bs-title="Quickly send money to your saved contacts." data-bs-toggle="tooltip"></i>
                                    </h4>
                                    <div class="dropdown ms-auto">
                                        <a class="btn btn-sm btn-default btn-icon" data-bs-toggle="dropdown" href="#">
                                            <i class="ti ti-dots-vertical fs-lg"></i>
                                        </a>
                                        <div class="dropdown-menu dropdown-menu-end">
                                            <a class="dropdown-item" href="#!">
                                                <span class="me-2 ti ti-user-plus"></span>
                                                Add Recipient
                                            </a>
                                            <a class="dropdown-item" href="#!">
                                                <span class="me-2 ti ti-history"></span>
                                                Recent Transfers
                                            </a>
                                            <a class="dropdown-item" href="#!">
                                                <span class="me-2 ti ti-download"></span>
                                                Export Transfers
                                            </a>
                                            <a class="dropdown-item text-danger" href="#!">
                                                <span class="me-2 ti ti-trash"></span>
                                                Remove All
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="d-flex gap-2 justify-content-center">
                                        <input autocomplete="off" checked="" class="btn-check" id="rec1" name="recipient" type="radio" />
                                        <label class="avatar-label" data-bs-title="Alexa Newsome" data-bs-toggle="tooltip" for="rec1">
                                            <img alt="" class="rounded-circle img-thumbnail avatar-lg" src="/images/users/user-4.jpg" />
                                        </label>
                                        <input autocomplete="off" class="btn-check" id="rec2" name="recipient" type="radio" />
                                        <label class="avatar-label" data-bs-title="Shelly Dorey" data-bs-toggle="tooltip" for="rec2">
                                            <img alt="" class="rounded-circle img-thumbnail avatar-lg" src="/images/users/user-5.jpg" />
                                        </label>
                                        <input autocomplete="off" class="btn-check" id="rec3" name="recipient" type="radio" />
                                        <label class="avatar-label" data-bs-title="Fredrick Arnett" data-bs-toggle="tooltip" for="rec3">
                                            <img alt="" class="rounded-circle img-thumbnail avatar-lg" src="/images/users/user-3.jpg" />
                                        </label>
                                        <input autocomplete="off" class="btn-check" id="rec4" name="recipient" type="radio" />
                                        <label class="avatar-label" data-bs-title="Barbara Frink" data-bs-toggle="tooltip" for="rec4">
                                            <img alt="" class="rounded-circle img-thumbnail avatar-lg" src="/images/users/user-8.jpg" />
                                        </label>
                                        <input autocomplete="off" class="btn-check" id="rec5" name="recipient" type="radio" />
                                        <label class="avatar-label" data-bs-title="Adam M" data-bs-toggle="tooltip" for="rec5">
                                            <img alt="" class="rounded-circle img-thumbnail avatar-lg" src="/images/users/user-2.jpg" />
                                        </label>
                                    </div>
                                    <div class="my-3">
                                        <label class="form-label" for="sendFrom">Send From</label>
                                        <select class="form-select" id="sendFrom">
                                            <option value="visa">Visa •••• 3698</option>
                                            <option value="mastercard">Mastercard •••• 1425</option>
                                            <option value="paypal">PayPal Wallet</option>
                                        </select>
                                    </div>
                                    <div class="row g-3 mb-2">
                                        <div class="col-12 col-md-6">
                                            <label class="form-label" for="currency">Currency</label>
                                            <select class="form-select" id="currency">
                                                <option value="USD">$ USD — US Dollar</option>
                                                <option value="EUR">€ EUR — Euro</option>
                                                <option value="GBP">£ GBP — British Pound</option>
                                                <option value="INR">₹ INR — Indian Rupee</option>
                                            </select>
                                        </div>
                                        <div class="col-12 col-md-6">
                                            <label class="form-label" for="enterAmount">Amount</label>
                                            <input class="form-control" id="enterAmount" min="1" placeholder="0.00" step="0.01" type="number" />
                                        </div>
                                    </div>
                                    <div class="row g-2 mt-3">
                                        <div class="col">
                                            <a class="btn btn-primary w-100" href="#!">Send Money</a>
                                        </div>
                                        <div class="col">
                                            <a class="btn btn-outline-secondary w-100" href="#!">Save as Draft</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- end row -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card" data-table="" data-table-rows-per-page="8">
                                <div class="card-header border-light justify-content-between">
                                    <h4 class="card-title">
                                        Recent Transactions
                                        <span class="text-muted fw-normal fs-14">(95.6k+ Transactions)</span>
                                    </h4>
                                    <div class="d-flex align-items-center gap-2">
                                        <span class="me-2 fw-semibold">Filter By:</span>
                                        <!-- Transaction Status Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="transaction-status">
                                                <option value="All">All Status</option>
                                                <option value="Success">Success</option>
                                                <option value="Pending">Pending</option>
                                                <option value="Failed">Failed</option>
                                                <option value="Processing">Processing</option>
                                                <option value="Onhold">On Hold</option>
                                            </select>
                                            <i class="ti ti-filter-2 app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Search Transactions -->
                                        <div class="app-search">
                                            <input class="form-control" data-table-search="" placeholder="Search transactions..." type="search" />
                                            <i class="ti ti-search app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Records Per Page -->
                                        <div>
                                            <select class="form-select form-control my-1 my-md-0" data-table-set-rows-per-page="">
                                                <option value="5">5</option>
                                                <option selected="" value="10">10</option>
                                                <option value="15">15</option>
                                                <option value="20">20</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-custom table-nowrap table-centered table-select table-hover w-100 mb-0">
                                        <thead class="bg-light align-middle bg-opacity-25 thead-sm">
                                            <tr class="text-uppercase fs-xxs">
                                                <th class="text-muted" data-table-sort="">ID</th>
                                                <th class="text-muted" data-table-sort="">Name / Business</th>
                                                <th class="text-muted">Description</th>
                                                <th class="text-muted" data-table-sort="">Amount</th>
                                                <th class="text-muted" data-table-sort="">Timestamp</th>
                                                <th class="text-muted" data-table-sort="">Type</th>
                                                <th class="text-muted" data-table-sort="">Payment Method</th>
                                                <th class="text-muted" data-column="transaction-status" data-table-sort="">Status</th>
                                                <th class="text-muted">•••</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td><a class="fw-medium text-reset" href="#!">#TX901</a></td>
                                                <td>
                                                    <img alt="" class="avatar-xs rounded-circle me-1" src="/images/users/user-5.jpg" />
                                                    <span class="align-middle text-reset">Sophia Miller</span>
                                                </td>
                                                <td>Subscription Renewal</td>
                                                <td class="text-success">USD $299.00</td>
                                                <td>
                                                    22 Nov,25
                                                    <small class="text-muted">08:24 am</small>
                                                </td>
                                                <td>Credit</td>
                                                <td>
                                                    <img class="me-1" height="24" src="/images/cards/visa.svg" />
                                                    *4321
                                                </td>
                                                <td><span class="badge bg-success-subtle text-success p-1">Success</span></td>
                                                <td>
                                                    <a class="text-muted fs-20" href="#!"><i class="ti ti-eye"></i></a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><a class="fw-medium text-reset" href="#!">#TX900</a></td>
                                                <td>
                                                    <img alt="" class="avatar-xs rounded-circle me-1" src="/images/users/user-2.jpg" />
                                                    <span class="align-middle">James Carter</span>
                                                </td>
                                                <td>Refund Processed</td>
                                                <td class="text-danger">-USD $150.50</td>
                                                <td>
                                                    21 Nov,25
                                                    <small class="text-muted">07:40 pm</small>
                                                </td>
                                                <td>Debit</td>
                                                <td>
                                                    <img class="me-1" height="24" src="/images/cards/mastercard.svg" />
                                                    *9333
                                                </td>
                                                <td><span class="badge bg-warning-subtle text-warning p-1">Pending</span></td>
                                                <td>
                                                    <a class="text-muted fs-20" href="#!"><i class="ti ti-eye"></i></a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><a class="fw-medium text-reset" href="#!">#TX899</a></td>
                                                <td>
                                                    <div class="avatar-xs d-inline-block me-1">
                                                        <span class="avatar-title bg-secondary-subtle text-secondary fw-semibold rounded-circle">W</span>
                                                    </div>
                                                    WavePay
                                                </td>
                                                <td>Wallet Top-Up</td>
                                                <td class="text-success">USD $620.00</td>
                                                <td>
                                                    21 Nov,25
                                                    <small class="text-muted">03:12 pm</small>
                                                </td>
                                                <td>Credit</td>
                                                <td>
                                                    <img class="me-1" height="24" src="/images/cards/paypal.svg" />
                                                    PayPal
                                                </td>
                                                <td><span class="badge bg-success-subtle text-success p-1">Success</span></td>
                                                <td>
                                                    <a class="text-muted fs-20" href="#!"><i class="ti ti-eye"></i></a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><a class="fw-medium text-reset" href="#!">#TX898</a></td>
                                                <td>
                                                    <img alt="" class="avatar-xs rounded-circle me-1" src="/images/users/user-3.jpg" />
                                                    <span class="align-middle">Liam Thompson</span>
                                                </td>
                                                <td>Service Charge</td>
                                                <td class="text-danger">-USD $19.99</td>
                                                <td>
                                                    20 Nov,25
                                                    <small class="text-muted">11:09 am</small>
                                                </td>
                                                <td>Debit</td>
                                                <td>
                                                    <img class="me-1" height="24" src="/images/cards/stripe.svg" />
                                                    Stripe
                                                </td>
                                                <td><span class="badge bg-danger-subtle text-danger p-1">Failed</span></td>
                                                <td>
                                                    <a class="text-muted fs-20" href="#!"><i class="ti ti-eye"></i></a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><a class="fw-medium text-reset" href="#!">#TX897</a></td>
                                                <td>
                                                    <img alt="" class="avatar-xs rounded-circle me-1" src="/images/users/user-4.jpg" />
                                                    <span class="align-middle">Emma Stone</span>
                                                </td>
                                                <td>Invoice #2112</td>
                                                <td class="text-success">EUR €420.72</td>
                                                <td>
                                                    18 Nov,25
                                                    <small class="text-muted">09:51 pm</small>
                                                </td>
                                                <td>Credit</td>
                                                <td>
                                                    <img class="me-1" height="24" src="/images/cards/mastercard.svg" />
                                                    *2112
                                                </td>
                                                <td><span class="badge bg-success-subtle text-success p-1">Success</span></td>
                                                <td>
                                                    <a class="text-muted fs-20" href="#!"><i class="ti ti-eye"></i></a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><a class="fw-medium text-reset" href="#!">#TX896</a></td>
                                                <td>
                                                    <div class="avatar-xs d-inline-block me-1">
                                                        <span class="avatar-title bg-warning-subtle text-warning fw-semibold rounded-circle">S</span>
                                                    </div>
                                                    StorePay
                                                </td>
                                                <td>Point of Sale Payment</td>
                                                <td class="text-danger">-GBP £15.00</td>
                                                <td>
                                                    17 Nov,25
                                                    <small class="text-muted">02:10 pm</small>
                                                </td>
                                                <td>Debit</td>
                                                <td>
                                                    <img class="me-1" height="24" src="/images/cards/unionpay.svg" />
                                                    *5510
                                                </td>
                                                <td><span class="badge bg-success-subtle text-success p-1">Success</span></td>
                                                <td>
                                                    <a class="text-muted fs-20" href="#!"><i class="ti ti-eye"></i></a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><a class="fw-medium text-reset" href="#!">#TX895</a></td>
                                                <td>
                                                    <img alt="" class="avatar-xs rounded-circle me-1" src="/images/users/user-8.jpg" />
                                                    <span class="align-middle">Olivia Brown</span>
                                                </td>
                                                <td>Personal Transfer</td>
                                                <td class="text-success">USD $250.00</td>
                                                <td>
                                                    16 Nov,25
                                                    <small class="text-muted">07:48 am</small>
                                                </td>
                                                <td>Credit</td>
                                                <td>
                                                    <img class="me-1" height="24" src="/images/cards/visa.svg" />
                                                    *0244
                                                </td>
                                                <td><span class="badge bg-success-subtle text-success p-1">Success</span></td>
                                                <td>
                                                    <a class="text-muted fs-20" href="#!"><i class="ti ti-eye"></i></a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><a class="fw-medium text-reset" href="#!">#TX894</a></td>
                                                <td>
                                                    <img alt="" class="avatar-xs rounded-circle me-1" src="/images/users/user-1.jpg" />
                                                    <span class="align-middle">David Chen</span>
                                                </td>
                                                <td>ATM Withdrawal</td>
                                                <td class="text-danger">-USD $180.00</td>
                                                <td>
                                                    15 Nov,25
                                                    <small class="text-muted">04:33 pm</small>
                                                </td>
                                                <td>Debit</td>
                                                <td>
                                                    <img class="me-1" height="24" src="/images/cards/mastercard.svg" />
                                                    *7780
                                                </td>
                                                <td><span class="badge bg-warning-subtle text-warning p-1">Processing</span></td>
                                                <td>
                                                    <a class="text-muted fs-20" href="#!"><i class="ti ti-eye"></i></a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><a class="fw-medium text-reset" href="#!">#TX893</a></td>
                                                <td>
                                                    <img alt="" class="avatar-xs rounded-circle me-1" src="/images/users/user-6.jpg" />
                                                    <span class="align-middle">Marcus Lee</span>
                                                </td>
                                                <td>Online Purchase</td>
                                                <td class="text-danger">-USD $65.49</td>
                                                <td>
                                                    14 Nov,24
                                                    <small class="text-muted">02:09 pm</small>
                                                </td>
                                                <td>Debit</td>
                                                <td>
                                                    <img class="me-1" height="24" src="/images/cards/stripe.svg" />
                                                    Stripe
                                                </td>
                                                <td><span class="badge bg-success-subtle text-success p-1">Success</span></td>
                                                <td>
                                                    <a class="text-muted fs-20" href="#!"><i class="ti ti-eye"></i></a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><a class="fw-medium text-reset" href="#!">#TX892</a></td>
                                                <td>
                                                    <div class="avatar-xs d-inline-block me-1">
                                                        <span class="avatar-title bg-danger-subtle text-danger fw-semibold rounded-circle">U</span>
                                                    </div>
                                                    Utility Co.
                                                </td>
                                                <td>Electricity Bill</td>
                                                <td class="text-danger">-GBP £72.10</td>
                                                <td>
                                                    12 Nov,24
                                                    <small class="text-muted">09:30 am</small>
                                                </td>
                                                <td>Debit</td>
                                                <td>
                                                    <img class="me-1" height="24" src="/images/cards/visa.svg" />
                                                    *1188
                                                </td>
                                                <td><span class="badge bg-success-subtle text-success p-1">Success</span></td>
                                                <td>
                                                    <a class="text-muted fs-20" href="#!"><i class="ti ti-eye"></i></a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><a class="fw-medium text-reset" href="#!">#TX891</a></td>
                                                <td>
                                                    <img alt="" class="avatar-xs rounded-circle me-1" src="/images/users/user-7.jpg" />
                                                    <span class="align-middle">Henry Walker</span>
                                                </td>
                                                <td>Loan EMI Payment</td>
                                                <td class="text-danger">-USD $320.00</td>
                                                <td>
                                                    11 Nov,24
                                                    <small class="text-muted">04:55 pm</small>
                                                </td>
                                                <td>Debit</td>
                                                <td>
                                                    <img class="me-1" height="24" src="/images/cards/mastercard.svg" />
                                                    *9982
                                                </td>
                                                <td><span class="badge bg-success-subtle text-success p-1">Success</span></td>
                                                <td>
                                                    <a class="text-muted fs-20" href="#!"><i class="ti ti-eye"></i></a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><a class="fw-medium text-reset" href="#!">#TX890</a></td>
                                                <td>
                                                    <div class="avatar-xs d-inline-block me-1">
                                                        <span class="avatar-title bg-primary-subtle text-primary fw-semibold rounded-circle">G</span>
                                                    </div>
                                                    Google Services
                                                </td>
                                                <td>Cloud Subscription</td>
                                                <td class="text-danger">-USD $12.99</td>
                                                <td>
                                                    10 Nov,24
                                                    <small class="text-muted">08:12 am</small>
                                                </td>
                                                <td>Debit</td>
                                                <td>
                                                    <img class="me-1" height="24" src="/images/cards/stripe.svg" />
                                                    Stripe
                                                </td>
                                                <td><span class="badge bg-warning-subtle text-warning p-1">Pending</span></td>
                                                <td>
                                                    <a class="text-muted fs-20" href="#!"><i class="ti ti-eye"></i></a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td><a class="fw-medium text-reset" href="#!">#TX889</a></td>
                                                <td>
                                                    <img alt="" class="avatar-xs rounded-circle me-1" src="/images/users/user-3.jpg" />
                                                    <span class="align-middle">Emily Frost</span>
                                                </td>
                                                <td>Client Invoice #2455</td>
                                                <td class="text-success">USD $980.00</td>
                                                <td>
                                                    09 Nov,24
                                                    <small class="text-muted">11:21 am</small>
                                                </td>
                                                <td>Credit</td>
                                                <td>
                                                    <img class="me-1" height="24" src="/images/cards/paypal.svg" />
                                                    PayPal
                                                </td>
                                                <td><span class="badge bg-success-subtle text-success p-1">Success</span></td>
                                                <td>
                                                    <a class="text-muted fs-20" href="#!"><i class="ti ti-eye"></i></a>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="card-footer border-0">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div data-table-pagination-info="transactions"></div>
                                        <div data-table-pagination=""></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row -->
                    <div class="d-flex align-items-center mb-3 mt-2">
                        <h4 class="fw-bold fs-md">My Targets &amp; Goals</h4>
                        <a class="text-decoration-underline fw-semibold fs-15 ms-auto link-offset-2 link-dark" href="#!">See All</a>
                    </div>
                    <div class="row row-cols-1 row-cols-sm-2 row-cols-lg-3 row-cols-xxl-5">
                        <div class="col">
                            <div class="card border-0 rounded-3 text-white" style="background-image: url(/images/stock/small-1.jpg); background-size: cover">
                                <div class="card-body bg-gradient bg-primary bg-opacity-90 rounded-3">
                                    <iconify-icon class="fs-36" icon="solar:bus-bold-duotone"></iconify-icon>
                                    <p class="text-white text-opacity-75 mb-1 text-uppercase">Goal</p>
                                    <h3 class="fw-semibold mb-2 fs-20 text-white">New Car</h3>
                                    <h4 class="fw-medium fs-16 mb-1 text-white">
                                        $
                                        <span data-target="25000">0</span>
                                    </h4>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                        <div class="col">
                            <div class="card border-0 rounded-3 text-white" style="background-image: url(/images/stock/small-2.jpg); background-size: cover">
                                <div class="card-body bg-gradient bg-secondary bg-opacity-90 rounded-3">
                                    <iconify-icon class="fs-36" icon="solar:globus-bold-duotone"></iconify-icon>
                                    <p class="text-white text-opacity-75 mb-1 text-uppercase">Goal</p>
                                    <h3 class="fw-semibold mb-2 fs-20 text-white">Vacation Trip</h3>
                                    <h4 class="fw-medium fs-16 mb-1 text-white">
                                        $
                                        <span data-target="7500">0</span>
                                    </h4>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                        <div class="col">
                            <div class="card border-0 rounded-3 text-white" style="background-image: url(/images/stock/small-3.jpg); background-size: cover">
                                <div class="card-body bg-gradient bg-warning bg-opacity-90 rounded-3">
                                    <iconify-icon class="fs-36" icon="solar:square-academic-cap-2-bold-duotone"></iconify-icon>
                                    <p class="text-white text-opacity-75 mb-1 text-uppercase">Goal</p>
                                    <h3 class="fw-semibold mb-2 fs-20 text-white">Education</h3>
                                    <h4 class="fw-medium fs-16 mb-1 text-white">
                                        $
                                        <span data-target="15200">0</span>
                                    </h4>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                        <div class="col">
                            <div class="card border-0 rounded-3 text-white" style="background-image: url(/images/stock/small-4.jpg); background-size: cover">
                                <div class="card-body bg-gradient bg-danger bg-opacity-90 rounded-3">
                                    <iconify-icon class="fs-36" icon="solar:home-2-bold-duotone"></iconify-icon>
                                    <p class="text-white text-opacity-75 mb-1 text-uppercase">Goal</p>
                                    <h3 class="fw-semibold mb-2 fs-20 text-white">New Home</h3>
                                    <h4 class="fw-medium fs-16 mb-1 text-white">
                                        $
                                        <span data-target="120000">0</span>
                                    </h4>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                        <div class="col">
                            <div class="card border-0 rounded-3 text-white" style="background-image: url(/images/stock/small-5.jpg); background-size: cover">
                                <div class="card-body bg-gradient bg-info bg-opacity-90 rounded-3">
                                    <iconify-icon class="fs-36" icon="solar:banknote-2-bold-duotone"></iconify-icon>
                                    <p class="text-white text-opacity-75 mb-1 text-uppercase">Goal</p>
                                    <h3 class="fw-semibold mb-2 fs-20 text-white">Emergency Fund</h3>
                                    <h4 class="fw-medium fs-16 mb-1 text-white">
                                        $
                                        <span data-target="10000">0</span>
                                    </h4>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                    </div>
                    <!-- end row-->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Apex Chart js -->
        <script src="/plugins/apexcharts/apexcharts.min.js"></script>
        <!-- Custom table -->
        <script src="/js/pages/custom-table.js"></script>
        <!-- Dashboard js -->
        <script src="/js/pages/dashboard-finance.js"></script>
    </body>
</html>
