<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Image Cropper')) ?>

        <!-- Cropper Plugin CSS -->
        <link href="/plugins/cropperjs/cropper.min.css" rel="stylesheet" type="text/css" />

        <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Forms', 'title' => 'Image Cropper')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card shadow-sm">
                                <div class="card-header d-flex align-items-center gap-2">
                                    <h5 class="mb-0">Upload &amp; Crop Image</h5>
                                    <span class="ms-auto small text-muted">Default demo image is used until user uploads.</span>
                                </div>
                                <div class="card-body">
                                    <div class="row g-3 align-items-end">
                                        <div class="col-lg-8">
                                            <label class="form-label" for="fileInput">Choose an image</label>
                                            <input accept="image/*" class="form-control" id="fileInput" type="file" />
                                        </div>
                                        <div class="col-lg-4 d-grid gap-2">
                                            <button class="btn btn-outline-secondary" id="useDemoBtn">Use Demo Image</button>
                                            <button class="btn btn-outline-light border" id="clearInputBtn">Clear File Input</button>
                                        </div>
                                    </div>
                                    <div class="row g-4 mt-1">
                                        <div class="col-lg-8">
                                            <div class="ratio ratio-4x3 bg-white border rounded">
                                                <!-- Default demo image -->
                                                <img alt="Upload to crop" id="image" src="/images/stock/small-1.jpg" />
                                            </div>
                                        </div>
                                        <div class="col-lg-4">
                                            <div class="d-flex flex-wrap gap-2">
                                                <button class="btn btn-outline-primary" id="zoomInBtn">Zoom In</button>
                                                <button class="btn btn-outline-primary" id="zoomOutBtn">Zoom Out</button>
                                                <button class="btn btn-outline-primary" id="rotateLeftBtn">Rotate -45°</button>
                                                <button class="btn btn-outline-primary" id="rotateRightBtn">Rotate +45°</button>
                                                <button class="btn btn-outline-secondary" id="resetBtn">Reset</button>
                                                <div class="ms-auto d-flex align-items-center gap-2">
                                                    <label class="form-label mb-0" for="aspect">Aspect:</label>
                                                    <select class="form-select form-select-sm" id="aspect" style="width: auto">
                                                        <option selected="" value="NaN">Free</option>
                                                        <option value="1">1:1</option>
                                                        <option value="16/9">16:9</option>
                                                        <option value="4/3">4:3</option>
                                                        <option value="3/4">3:4</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <p class="fw-semibold mt-4">Live Preview</p>
                                            <div class="cropper-img-preview"></div>
                                            <div class="mt-4 d-none" id="croppedResult">
                                                <p class="fw-semibold mb-2">Cropped Output</p>
                                                <img alt="Cropped result will appear here" class="img-thumbnail" />
                                            </div>
                                            <div class="mt-4 d-grid gap-2">
                                                <button class="btn btn-primary" id="cropBtn">Crop &amp; Preview</button>
                                                <a class="btn btn-outline-secondary disabled" download="cropped.png" id="downloadBtn">Download Cropped</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Image Cropper Plugin Js -->
        <script src="/plugins/cropperjs/cropper.min.js"></script>
        <!-- Color Picker Demo Js -->
        <script src="/js/pages/form-image-cropper.js"></script>
    </body>
</html>
