<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Boxicons Icons')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Icons', 'title' => 'Boxicons')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header d-block">
                                    <h4 class="card-title mb-1 d-flex align-items-center gap-2">Overview</h4>
                                    <p class="mb-0 text-muted">Simple Open Source icons carefully crafted for designers &amp; developers</p>
                                </div>
                                <div class="card-body">
                                    <h4 class="mt-0 fs-base mb-1">Usage</h4>
                                    <code>&lt;i class="bx bx-xxx"&gt;&lt;/i&gt;</code>
                                    <div class="d-flex align-items-center gap-2 mt-3">
                                        <i class="bx bx-camera fs-3"></i>
                                        <i class="bx bx-heart fs-3"></i>
                                        <i class="bx bx-star fs-3"></i>
                                        <i class="bx bx-check fs-3"></i>
                                        <i class="bx bx-bell fs-3"></i>
                                        <i class="bx bx-cloud fs-3"></i>
                                        <i class="bx bx-user fs-3"></i>
                                    </div>
                                </div>
                                <div class="card-body border-top border-dashed">
                                    <h4 class="mt-0 fs-base mb-1">Colors</h4>
                                    <code>&lt;i class="bx bx-xxx text-xx"&gt;&lt;/i&gt;</code>
                                    <div class="d-flex align-items-center gap-2 mt-3">
                                        <i class="bx bx-home fs-3 text-primary"></i>
                                        <i class="bx bx-cog fs-3 text-secondary"></i>
                                        <i class="bx bx-calendar fs-3 text-success"></i>
                                        <i class="bx bx-message fs-3 text-info"></i>
                                        <i class="bx bx-flag fs-3 text-warning"></i>
                                        <i class="bx bx-folder fs-3 text-danger"></i>
                                        <i class="bx bx-globe fs-3 text-light"></i>
                                        <i class="bx bx-key fs-3 text-dark"></i>
                                        <i class="bx bx-layer fs-3 text-purple"></i>
                                    </div>
                                </div>
                                <div class="card-body border-top border-dashed">
                                    <h4 class="mt-0 fs-base mb-1">Solid Icons Style</h4>
                                    <code>&lt;i class="bxs-xxx text-xx"&gt;&lt;/i&gt;</code>
                                    <div class="d-flex align-items-center gap-2 mt-3">
                                        <i class="bx bxs-star fs-3 text-primary"></i>
                                        <i class="bx bxs-user fs-3 text-secondary"></i>
                                        <i class="bx bxs-check-circle fs-3 text-success"></i>
                                        <i class="bx bxs-bell fs-3 text-info"></i>
                                        <i class="bx bxs-error-circle fs-3 text-warning"></i>
                                        <i class="bx bxs-file fs-3 text-danger"></i>
                                        <i class="bx bxs-tv fs-3 text-light"></i>
                                        <i class="bx bxs-lock fs-3 text-dark"></i>
                                        <i class="bx bxs-data fs-3 text-purple"></i>
                                    </div>
                                </div>
                                <div class="card-body border-top border-dashed">
                                    <h4 class="mt-0 fs-base mb-1">Sizes</h4>
                                    <code>&lt;i class="bx bx-xxxx fs-xx"&gt;&lt;/i&gt;</code>
                                    <div class="d-flex align-items-center gap-2 mt-3">
                                        <i class="bx bx-phone fs-1"></i>
                                        <i class="bx bx-purchase-tag fs-2"></i>
                                        <i class="bx bx-laptop fs-3"></i>
                                        <i class="bx bx-devices fs-4"></i>
                                        <i class="bx bx-game fs-5"></i>
                                        <i class="bx bx-timer fs-6"></i>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 mt-3">
                                        <i class="bx bx-timer"></i>
                                        <i class="bx bx-timer fs-sm"></i>
                                        <i class="bx bx-timer fs-lg"></i>
                                        <i class="bx bx-timer fs-xl"></i>
                                        <i class="bx bx-timer fs-xxl"></i>
                                        <i class="bx bx-timer fs-24"></i>
                                        <i class="bx bx-timer fs-32"></i>
                                        <i class="bx bx-timer fs-36"></i>
                                        <i class="bx bx-timer fs-42"></i>
                                        <i class="bx bx-timer fs-60"></i>
                                    </div>
                                </div>
                                <div class="card-body border-top border-dashed">
                                    <h4 class="mt-0 mb-3">Icons</h4>
                                    <div class="d-flex flex-wrap align-items-center text-center gap-2">
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-phone fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Phone</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bxs-balloon fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Balloon</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-headphone fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Headphones</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-camera fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Camera</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-microphone fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Microphone</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-game fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Gamepad</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-printer fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Printer</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-data fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Database</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-cloud fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Cloud</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-wifi fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Wi-Fi</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-lock-alt fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Lock</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-key fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Key</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-shield fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Shield</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-envelope fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Mail</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-user fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">User</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-group fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Users</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-cart fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Cart</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-briefcase fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Briefcase</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-file fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">File</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-book fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Book</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-search fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Search</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-bell fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Notification</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-cog fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Settings</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-calendar fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Calendar</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-flag fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Flag</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-music fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Music</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-film fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Movie</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-upload fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Upload</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-download fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Download</span>
                                            </span>
                                        </div>
                                        <!-- Brands -->
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bxl-facebook-circle fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Facebook</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bxl-twitter fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Twitter</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bxl-instagram fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Instagram</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bxl-linkedin-square fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">LinkedIn</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bxl-github fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">GitHub</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bxl-youtube fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">YouTube</span>
                                            </span>
                                        </div>
                                        <!-- Map / Actions / Status -->
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-map fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Location</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-send fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Send</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-chat fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Chat</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-like fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Like</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-error fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Warning</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-check-double fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Done</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="bx bx-child fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Child</span>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="text-center mt-3">
                                        <a class="btn btn-danger" href="https://v2.boxicons.com/" target="_blank">View All Icons</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>
    </body>
</html>
