<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Remix Icons')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Icons', 'title' => 'Remix')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header d-block">
                                    <h4 class="card-title mb-1 d-flex align-items-center gap-2">Overview</h4>
                                    <p class="mb-0 text-muted">Open-source neutral-style system symbols elaborately crafted for designers and developers. All of the icons are free for both personal and commercial use.</p>
                                </div>
                                <div class="card-body">
                                    <h4 class="mt-0 fs-base mb-1">Usage</h4>
                                    <code>&lt;i class="ri-xxx-line"&gt;&lt;/i&gt;</code>
                                    <div class="d-flex align-items-center gap-2 mt-3">
                                        <i class="ri-camera-line fs-3"></i>
                                        <i class="ri-heart-line fs-3"></i>
                                        <i class="ri-star-line fs-3"></i>
                                        <i class="ri-check-line fs-3"></i>
                                        <i class="ri-notification-3-line fs-3"></i>
                                        <i class="ri-cloud-line fs-3"></i>
                                        <i class="ri-user-line fs-3"></i>
                                    </div>
                                </div>
                                <div class="card-body border-top border-dashed">
                                    <h4 class="mt-0 fs-base mb-1">Colors</h4>
                                    <code>&lt;i class="ri-xxx-line text-xx"&gt;&lt;/i&gt;</code>
                                    <div class="d-flex align-items-center gap-2 mt-3">
                                        <i class="ri-home-4-line fs-3 text-primary"></i>
                                        <i class="ri-settings-3-line fs-3 text-secondary"></i>
                                        <i class="ri-calendar-line fs-3 text-success"></i>
                                        <i class="ri-message-3-line fs-3 text-info"></i>
                                        <i class="ri-flag-line fs-3 text-warning"></i>
                                        <i class="ri-folder-line fs-3 text-danger"></i>
                                        <i class="ri-global-line fs-3 text-light"></i>
                                        <i class="ri-key-2-line fs-3 text-dark"></i>
                                        <i class="ri-stack-line fs-3 text-purple"></i>
                                    </div>
                                </div>
                                <div class="card-body border-top border-dashed">
                                    <h4 class="mt-0 fs-base mb-1">Fill Colors</h4>
                                    <code>&lt;i class="ri-xxx-fill text-xx"&gt;&lt;/i&gt;</code>
                                    <div class="d-flex align-items-center gap-2 mt-3">
                                        <i class="ri-star-fill fs-3 text-primary"></i>
                                        <i class="ri-user-fill fs-3 text-secondary"></i>
                                        <i class="ri-checkbox-circle-fill fs-3 text-success"></i>
                                        <i class="ri-notification-3-fill fs-3 text-info"></i>
                                        <i class="ri-alert-fill fs-3 text-warning"></i>
                                        <i class="ri-file-text-fill fs-3 text-danger"></i>
                                        <i class="ri-tv-fill fs-3 text-light"></i>
                                        <i class="ri-lock-fill fs-3 text-dark"></i>
                                        <i class="ri-database-2-fill fs-3 text-purple"></i>
                                    </div>
                                </div>
                                <div class="card-body border-top border-dashed">
                                    <h4 class="mt-0 fs-base mb-1">Sizes</h4>
                                    <code>&lt;i class="ri-xxxx-line fs-xx"&gt;&lt;/i&gt;</code>
                                    <div class="d-flex align-items-center gap-2 mt-3">
                                        <i class="ri-phone-line fs-1"></i>
                                        <i class="ri-coupon-2-line fs-2"></i>
                                        <i class="ri-macbook-line fs-3"></i>
                                        <i class="ri-tablet-line fs-4"></i>
                                        <i class="ri-gamepad-line fs-5"></i>
                                        <i class="ri-timer-line fs-6"></i>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 mt-3">
                                        <i class="ri-timer-line"></i>
                                        <i class="ri-timer-line fs-sm"></i>
                                        <i class="ri-timer-line fs-lg"></i>
                                        <i class="ri-timer-line fs-xl"></i>
                                        <i class="ri-timer-line fs-xxl"></i>
                                        <i class="ri-timer-line fs-24"></i>
                                        <i class="ri-timer-line fs-32"></i>
                                        <i class="ri-timer-line fs-36"></i>
                                        <i class="ri-timer-line fs-42"></i>
                                        <i class="ri-timer-line fs-60"></i>
                                    </div>
                                </div>
                                <div class="card-body border-top border-dashed">
                                    <h4 class="mt-0 mb-3">Icons</h4>
                                    <div class="d-flex flex-wrap align-items-center text-center gap-2">
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-phone-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Phone</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-percent-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Discount</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-headphone-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Headphones</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-camera-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Camera</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-mic-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Microphone</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-gamepad-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Gamepad</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-printer-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Printer</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-database-2-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Database</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-cloud-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Cloud</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-wifi-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Wi-Fi</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-lock-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Lock</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-key-2-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Key</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-shield-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Shield</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-mail-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Mail</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-user-3-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">User</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-group-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Users</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-shopping-cart-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Cart</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-briefcase-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Briefcase</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-file-text-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">File</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-book-2-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Book</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-search-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Search</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-bell-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Notification</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-settings-3-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Settings</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-calendar-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Calendar</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-flag-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Flag</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-camera-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Camera</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-music-2-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Music</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-movie-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Movie</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-upload-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Upload</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-download-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Download</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-facebook-circle-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Facebook</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-twitter-x-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Twitter X</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-instagram-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Instagram</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-linkedin-box-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">LinkedIn</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-github-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">GitHub</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-youtube-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">YouTube</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-map-pin-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Location</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-send-plane-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Send</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-chat-3-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Chat</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-thumb-up-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Like</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-error-warning-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Warning</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <i class="ri-check-double-line fs-xxl"></i>
                                                <span class="fw-semibold d-block w-100 text-truncate">Done</span>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="text-center mt-3">
                                        <a class="btn btn-danger" href="https://remixicon.com/" target="_blank">View All Icons</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>
    </body>
</html>
