<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Solar Broken Icons')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Icons', 'title' => 'Solar Broken')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header d-block">
                                    <h4 class="card-title mb-1 d-flex align-items-center gap-2">Overview</h4>
                                    <p class="mb-0 text-muted">Solar Broken is a modern set of outline-style SVG icons, free to use and easy to customize with CSS.</p>
                                </div>
                                <div class="card-body">
                                    <h4 class="mt-0 fs-base mb-1">Usage</h4>
                                    <code>&lt;iconify-icon icon="solar:camera-broken"&gt;&lt;/iconify-icon&gt;</code>
                                    <div class="d-flex align-items-center gap-2 mt-3">
                                        <iconify-icon class="fs-3" icon="solar:camera-broken"></iconify-icon>
                                        <iconify-icon class="fs-3" icon="solar:heart-broken"></iconify-icon>
                                        <iconify-icon class="fs-3" icon="solar:star-broken"></iconify-icon>
                                        <iconify-icon class="fs-3" icon="solar:check-circle-broken"></iconify-icon>
                                        <iconify-icon class="fs-3" icon="solar:bell-broken"></iconify-icon>
                                        <iconify-icon class="fs-3" icon="solar:cloud-broken"></iconify-icon>
                                        <iconify-icon class="fs-3" icon="solar:user-broken"></iconify-icon>
                                    </div>
                                </div>
                                <div class="card-body border-top border-dashed">
                                    <h4 class="mt-0 fs-base mb-1">Colors</h4>
                                    <code>&lt;iconify-icon icon="solar:home-broken" class="text-xx"&gt;&lt;/iconify-icon&gt;</code>
                                    <div class="d-flex align-items-center gap-2 mt-3">
                                        <iconify-icon class="fs-3 text-primary" icon="solar:home-broken"></iconify-icon>
                                        <iconify-icon class="fs-3 text-secondary" icon="solar:settings-broken"></iconify-icon>
                                        <iconify-icon class="fs-3 text-success" icon="solar:calendar-broken"></iconify-icon>
                                        <iconify-icon class="fs-3 text-info" icon="solar:chat-round-dots-broken"></iconify-icon>
                                        <iconify-icon class="fs-3 text-warning" icon="solar:flag-broken"></iconify-icon>
                                        <iconify-icon class="fs-3 text-danger" icon="solar:folder-broken"></iconify-icon>
                                        <iconify-icon class="fs-3 text-light" icon="solar:adhesive-plaster-broken"></iconify-icon>
                                        <iconify-icon class="fs-3 text-dark" icon="solar:key-broken"></iconify-icon>
                                        <iconify-icon class="fs-3 text-purple" icon="solar:layers-broken"></iconify-icon>
                                    </div>
                                </div>
                                <div class="card-body border-top border-dashed">
                                    <h4 class="mt-0 fs-base mb-1">Sizes</h4>
                                    <code>&lt;iconify-icon icon="solar:watch-square-broken" class="fs-xx"&gt;&lt;/iconify-icon&gt;</code>
                                    <div class="d-flex align-items-center gap-2 mt-3">
                                        <iconify-icon class="fs-1" icon="solar:phone-broken"></iconify-icon>
                                        <iconify-icon class="fs-2" icon="solar:tag-price-broken"></iconify-icon>
                                        <iconify-icon class="fs-3" icon="solar:laptop-2-broken"></iconify-icon>
                                        <iconify-icon class="fs-4" icon="solar:tablet-broken"></iconify-icon>
                                        <iconify-icon class="fs-5" icon="solar:gamepad-broken"></iconify-icon>
                                        <iconify-icon class="fs-6" icon="solar:alarm-broken"></iconify-icon>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 mt-3">
                                        <iconify-icon icon="solar:watch-square-broken"></iconify-icon>
                                        <iconify-icon class="fs-sm" icon="solar:watch-square-broken"></iconify-icon>
                                        <iconify-icon class="fs-lg" icon="solar:watch-square-broken"></iconify-icon>
                                        <iconify-icon class="fs-xl" icon="solar:watch-square-broken"></iconify-icon>
                                        <iconify-icon class="fs-xxl" icon="solar:watch-square-broken"></iconify-icon>
                                        <iconify-icon class="fs-24" icon="solar:watch-square-broken"></iconify-icon>
                                        <iconify-icon class="fs-32" icon="solar:watch-square-broken"></iconify-icon>
                                        <iconify-icon class="fs-36" icon="solar:watch-square-broken"></iconify-icon>
                                        <iconify-icon class="fs-42" icon="solar:watch-square-broken"></iconify-icon>
                                        <iconify-icon class="fs-60" icon="solar:watch-square-broken"></iconify-icon>
                                    </div>
                                </div>
                                <div class="card-body border-top border-dashed">
                                    <h4 class="mt-0 mb-3">Icons</h4>
                                    <div class="d-flex flex-wrap align-items-center text-center gap-2">
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:phone-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Phone</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:camera-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Camera</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:microphone-2-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Microphone</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:gamepad-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Gamepad</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:printer-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Printer</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:database-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Database</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:cloud-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Cloud</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:lock-keyhole-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Lock</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:key-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Key</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:shield-check-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Shield</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:letter-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Mail</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:user-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">User</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:users-group-two-rounded-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Users</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:cart-3-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Cart</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:file-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">File</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:book-2-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Book</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:bell-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Notification</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:settings-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Settings</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:calendar-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Calendar</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:flag-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Flag</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:music-note-3-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Music</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:upload-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Upload</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:download-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Download</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:home-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Home</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:user-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">User</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:users-group-rounded-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Users</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:settings-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Settings</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:bell-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Notification</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:calendar-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Calendar</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:chat-round-dots-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Chat</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:phone-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Phone</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:camera-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Camera</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:music-note-3-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Music</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:heart-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Heart</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:like-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Like</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:star-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Star</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:map-point-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Location</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:compass-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Compass</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:map-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Map</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:compass-square-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Navigation</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:cart-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Cart</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:wallet-broken"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Wallet</span>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="text-center mt-3">
                                        <a class="btn btn-danger" href="https://icon-sets.iconify.design/solar/?suffixes=Broken" target="_blank">View All Icons</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>
    </body>
</html>
