<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Sign In')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <div class="position-absolute top-0 end-0">
            <img alt="auth-card-bg" class="auth-card-bg-img" src="/images/auth-card-bg.svg" />
        </div>
        <div class="position-absolute bottom-0 start-0" style="transform: rotate(180deg)">
            <img alt="auth-card-bg" class="auth-card-bg-img" src="/images/auth-card-bg.svg" />
        </div>
        <div class="auth-box overflow-hidden align-items-center d-flex">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xxl-5 col-md-6 col-sm-8">
                        <div class="card p-4">
                        <div class="auth-brand text-center mb-2">
                                    <h3><?=env('app.title')?></h3>
                                <h4 class="fw-bold text-dark mt-3">Que bueno verte por aquí 👋</h4>
                                <p class="text-muted w-lg-75 mx-auto">Vamos a empezar, introduce tu correo y contraseña.</p>
                            </div>

                            <?php if (session('error') !== null) : ?>
                                <div class="alert alert-danger" role="alert"><?= esc(session('error')) ?></div>
                            <?php elseif (session('errors') !== null) : ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php if (is_array(session('errors'))) : ?>
                                        <?php foreach (session('errors') as $error) : ?>
                                            <?= esc($error) ?>
                                            <br>
                                        <?php endforeach ?>
                                    <?php else : ?>
                                        <?= esc(session('errors')) ?>
                                    <?php endif ?>
                                </div>
                            <?php endif ?>

                            <?php if (session('message') !== null) : ?>
                                <div class="alert alert-success" role="alert"><?= esc(session('message')) ?></div>
                            <?php endif ?>

                            <form action="<?= url_to('login') ?>" method="post">
                                <?= csrf_field() ?>

                                <!-- Email -->
                                <div class="form-floating mb-3">
                                    <input type="email" class="form-control" id="floatingEmailInput" name="email" inputmode="email" autocomplete="email" placeholder="<?= lang('Auth.email') ?>" value="<?= old('email') ?>" required>
                                    <label for="floatingEmailInput"><?= lang('Auth.email') ?></label>
                                </div>

                                <!-- Password -->
                                <div class="form-floating mb-3">
                                    <input type="password" class="form-control" id="floatingPasswordInput" name="password" inputmode="text" autocomplete="current-password" placeholder="<?= lang('Auth.password') ?>" required>
                                    <label for="floatingPasswordInput"><?= lang('Auth.password') ?></label>
                                </div>

                                <!-- Remember me -->
                                <?php if (setting('Auth.sessionConfig')['allowRemembering']): ?>
                                    <div class="form-check">
                                        <label class="form-check-label">
                                            <input type="checkbox" name="remember" class="form-check-input" <?php if (old('remember')): ?> checked<?php endif ?>>
                                            Recordar mis datos <small>(15 días)</small>
                                        </label>
                                    </div>
                                <?php endif; ?>

                                <div class="d-grid col-12 col-md-8 mx-auto m-3">
                                    <button type="submit" class="btn btn-primary btn-block">Entrar</button>
                                </div>

                                <?php if (setting('Auth.allowMagicLinkLogins')) : ?>
                                    <p class="text-center"><?= lang('Auth.forgotPassword') ?> <a href="<?= url_to('magic-link') ?>"><?= lang('Auth.useMagicLink') ?></a></p>
                                <?php endif ?>

                                <?php if (setting('Auth.allowRegistration')) : ?>
                                    <p class="text-center"><?= lang('Auth.needAccount') ?> <a href="<?= url_to('register') ?>"><?= lang('Auth.register') ?></a></p>
                                <?php endif ?>

                            </form>
                        </div>
                        <p class="text-center text-muted mt-4 mb-0">
                            ©
                            <script>
                                document.write(new Date().getFullYear())
                            </script>
                            LoteManager — desarrollado en
                            <span class="fw-semibold">Sistematlan</span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <!-- end auth-fluid-->
        <?= $this->include('partials/footer-scripts') ?>
    </body>
</html>
